<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="title@diskGrpBean@servletRequest"/>
    </uix:metaContainer>

    <uix:form
      name="diskGrpForm" 
      method="post"
      destinationBinding="defaultControllerURL@diskGrpBean@servletRequest">

      <uix:formValue 
        name="pageName" 
        value="/database/osm/createDG"/>

      <uix:pageLayout>

        <%@ include file="/database/global.jspf" %>

        <oem:messageBox messageType="info" 
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error" 
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>

        <uix:header
          textBinding="header@diskGrpBean@servletRequest"
          >

          <uix:subTabLayout>

            <uix:subTabs>
              <uix:subTabBar selectedIndex="0">
                <uix:contents>

                <uix:link textBinding="GENERAL@rsrcPlanBundle@servletRequest"/>

                <uix:switcher childNameBinding="dbVersionPre10@rsrcplnBean@servletRequest">
                  <%--- Only for Pre 10i ---%>
                  <uix:case name="true">
                    <uix:link textBinding="PARALLELISM@rsrcPlanBundle@servletRequest"
                       onClick="submitForm('planForm', true, {event:'parallelismTab'})"/>
                  </uix:case>
                  <%--- Only for 10i or later ---%>
                  <uix:case name="false">
                    <uix:link textBinding="ADVANCED_FEATURES@rsrcPlanBundle@servletRequest"
                       onClick="submitForm('planForm', true, {event:'cpuAllocationTab'})"/>
                  </uix:case>
                </uix:switcher>

                <%--- Only for 9.0.1 up to, but not including, 10i  ---%>
                <uix:switcher childNameBinding="dbVersion901to10@rsrcplnBean@servletRequest">
                  <uix:case name="true">
                    <uix:link textBinding="SESSION_POOL@rsrcPlanBundle@servletRequest"
                       onClick="submitForm('planForm', true, {event:'sessionPoolTab'})"/>
                  </uix:case>
                </uix:switcher>

                <%--- Only for 9.0.1 up to, but not including, 10i  ---%>
                <uix:switcher childNameBinding="dbVersion901to10@rsrcplnBean@servletRequest">
                  <uix:case name="true">
                    <uix:link textBinding="UNDO_POOL@rsrcPlanBundle@servletRequest"
                       onClick="submitForm('planForm', true, {event:'undoPoolTab'})"/>
                  </uix:case>
                </uix:switcher>

                <%--- Only for 9.0.1 up to, but not including, 10i  ---%>
                <uix:switcher childNameBinding="dbVersion901to10@rsrcplnBean@servletRequest">
                  <uix:case name="true">
                    <uix:link textBinding="EXECUTION_TIME@rsrcPlanBundle@servletRequest"
                       onClick="submitForm('planForm', true, {event:'executionTimeTab'})"/>
                  </uix:case>
                </uix:switcher>

                <%--- Only for 9.0.1 up to, but not including, 10i  ---%>
                <uix:switcher childNameBinding="dbVersion901to10@rsrcplnBean@servletRequest">
                  <uix:case name="true">
                    <uix:link textBinding="GROUP_SWITCHING@rsrcPlanBundle@servletRequest"
                       onClick="submitForm('planForm', true, {event:'groupSwitchingTab'})"/>
                  </uix:case>
                </uix:switcher>

                 </uix:contents>
              </uix:subTabBar> 
            </uix:subTabs>

            <%-------------------------
             -  Labeled Fields
             ---------------------------%>
            <uix:tableLayout cellSpacing="5">

                <%---------------------%>
                <%---  Plan Name    ---%>
                <%---------------------%>
                <uix:rowLayout>

                  <%---  Prompt  ---%>
                  <uix:cellFormat hAlign="right">
                    <uix:styledText labeledNodeId="planName"
                      styleClass="OraPromptText"
                      textBinding="PLAN_PROMPT@rsrcPlanBundle@servletRequest"/>
                  </uix:cellFormat>

                  <%---  Field  ---%>
                  <uix:cellFormat>
                    <%---  group name field is *read-only* in edit mode ---%>
                    <uix:switcher childNameBinding="creating@rsrcplnBean@servletRequest">
                      <%---  CREATE  ---%>
                      <uix:case name="true">
                        <uix:textInput id="planName"
                          name="planName"
                          textBinding="planName@rsrcplnPlanBean@servletRequest"
                          columns="50"/>
                      </uix:case>
                      <%---  EDIT  ---%>
                      <uix:case name="false">
                        <uix:styledText
                          styleClass="OraDataText"
                          textBinding="planName@rsrcplnPlanBean@servletRequest"/>
                      </uix:case>
                    </uix:switcher>
                  </uix:cellFormat>

                </uix:rowLayout>
     
                <%--------------------------%>
                <%---  Plan Description  ---%>
                <%--------------------------%>
                <uix:rowLayout>

                  <%---  Prompt  ---%>
                  <uix:cellFormat hAlign="right">
                    <uix:styledText labeledNodeId="description"
                      styleClass="OraPromptText"
                      textBinding="DESCRIPTION_PROMPT@rsrcPlanBundle@servletRequest"/>
                  </uix:cellFormat>

                  <%---  Field  ---%>
                  <uix:cellFormat>
                    <uix:textInput id="description"
                      name="description"
                      textBinding="description@rsrcplnPlanBean@servletRequest"
                      columns="50"/>
                  </uix:cellFormat>

                </uix:rowLayout>

                <%-------------------------%>
                <%---  Plan Activation  ---%>
                <%-------------------------%>
                <uix:rowLayout>

                  <%---  Prompt  ---%>
                  <uix:cellFormat hAlign="right">
                    <uix:styledText
                      styleClass="OraPromptText"
                      textBinding="ACTIVATE_PLAN_PROMPT@rsrcPlanBundle@servletRequest"/>
                  </uix:cellFormat>

                  <%---  Field  ---%>
                  <uix:cellFormat>
                    <uix:checkBox
                      name="activated"
                      checkedBinding="activated@rsrcplnPlanBean@servletRequest"
                    />
                  </uix:cellFormat>

                </uix:rowLayout>

            </uix:tableLayout>

            <%---------------------------
             -   Directive Table        -
             ---------------------------%>

            <uix:header 
              textBinding="SELECTED_GROUPS_SUBPLANS@rsrcPlanBundle@servletRequest"
              >

              <%---  Modify Button  ---%>
              <uix:tableLayout width="80%"> 
                <uix:rowLayout hAlign="right"> 
                  <uix:cellFormat> 
                    <uix:contents> 
                      <uix:submitButton 
                        textBinding="MODIFY@rsrcPlanBundle@servletRequest"
                        name="event"
                        value="selectButton" 
                        formName="planForm"
                      />
                    </uix:contents> 
                  </uix:cellFormat> 
                </uix:rowLayout> 
              </uix:tableLayout> 

              <%--- User Table ---%>
              <uix:switcher childNameBinding="dbVersionPre10@rsrcplnBean@servletRequest">
                <%--- Only for Pre 10i ---%>
                <uix:case name="true">
                  <oem:table 
                    width="80%" 
                    blockSize="25"
                    formSubmitted="true"
                    name="directiveTable" 
                    dataSourceProp="directiveTable"
                    beanKey="rsrcplnDirectiveTableBean"
                    alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest"
                    >
                  </oem:table>
                </uix:case>
                <%--- Only for 10i or later ---%>
                <uix:case name="false">
                  <oem:table 
                    width="80%"
                    blockSize="25"
                    formSubmitted="true"
                    name="generalTable"
                    dataSourceProp="generalTable"
                    beanKey="rsrcplnGeneralTableBean"
                    alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest"
                    >
                  </oem:table>
                </uix:case>
              </uix:switcher>

            </uix:header>

          </uix:subTabLayout>

        </uix:header>

        <%-------------------------
         -  Footer
         ---------------------------%>
        <uix:contentFooter>
          <uix:pageButtonBar>

            <uix:submitButton
              name="event" 
              textBinding="SHOWSQL@uixDBObjectBundle@servletRequest"
              value="showSql"/>

            <uix:switcher childNameBinding="creating@rsrcplnBean@servletRequest">
              <uix:case name="true">
              <%---  CREATE  ---%>
                <uix:flowLayout>
                  <uix:submitButton 
                    name="event" 
                    textBinding="CANCEL@uixDBObjectBundle@servletRequest"
                    value="cancel"/>  
                  <uix:submitButton
                    name="event" 
                    textBinding="OK@uixDBObjectBundle@servletRequest"
                    value="apply"/>
                </uix:flowLayout>
              </uix:case>
              <uix:case name="false">
              <%---  EDIT  ---%>
                <uix:flowLayout>
                  <uix:submitButton 
                    name="event" 
                    textBinding="REVERT@uixDBObjectBundle@servletRequest"
                    value="revert"/>  
                  <uix:submitButton
                    name="event" 
                    textBinding="APPLY@uixDBObjectBundle@servletRequest"
                    value="apply"/>
                </uix:flowLayout>
              </uix:case>
            </uix:switcher>

          </uix:pageButtonBar>
        </uix:contentFooter>

      </uix:pageLayout>
    </uix:form>

  </uix:document>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>

