<%--
  -- Page:        editFile.jsp
  -- Controller:  oracle.sysman.db.adm.osm.DiskGroupController
  --
  -- Description: ASM disk group edit file page
  --
  --  MODIFIED    (MM/DD/YY)
  --   asubba      02/12/09 - add lov for users
  --   asubba      02/04/09 - oac: fix the alt tags
  --   asubba      01/12/09 - hide ACL info for NT
  --   dchakumk    03/10/08 - XbranchMerge dchakumk_6752_xbmsrc from
  --                          st_emdbsa_11.1
  --   asubba      07/02/07 - filter the usregroup diskgroupwise
  --   asubba      03/08/07 - XbranchMerge asubba_22705_umask_sysoper from
  --                          st_emdbsa_project-22846
  --   gmahaney    02/01/07 - XbranchMerge gmahaney_emdb_pt_main from main
  --   asubba      01/08/07 - uncomment diskzone ui
  --   asubba      10/25/06 - File access permission
  --   qsong       05/30/06 - 
  --   asubba      03/06/06 - Initial entry
  --%>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>


<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>
     <uix:metaContainer> 
    <db:script src="/database/LOV.js" />
      </uix:metaContainer>
    <uix:body>
    <uix:form
      name="editFileForm"
      method="post"
      destinationBinding="defaultURL@servletRequest">

      <uix:formValue
        name="pageName"
        value="/database/osm/editFile"/>
        
      <uix:formValue name="optionChoice" valueBinding="optionChoice@servletRequest"/>         
      <uix:formValue name="mname" valueBinding="mname@servletRequest"/>               
      <uix:formValue name="otype" valueBinding="otype@servletRequest"/>               
      <uix:formValue name="oname" valueBinding="oname@servletRequest"/>    
      <uix:formValue name="index" valueBinding="index@servletRequest"/>            
      <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
       <uix:formValue name="systemLink" valueBinding="systemLink@servletRequest"/>
       
       
       <uix:formValue name="diskgroup" valueBinding="oname@servletRequest"/>


      <uix:pageLayout titleBinding="editFileHeader@memberFile@servletRequest">

        <%@ include file="/database/global.jspf" %>

        <oem:messageBox messageType="info"
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>

        <%-- uix:header
          textBinding="templateHeader@diskGrp@servletRequest"
          --%>

            <%-------------------------
             -  Labeled Fields
             ---------------------------%>
            <uix:tableLayout cellSpacing="5">

                <%---------------------%>
                <%---  General   ---%>
                <%---------------------%>
               
             <uix:rowLayout >
                <%---  Prompt  ---%>
                <uix:cellFormat hAlign="right" vAlign="top" width="50%">
                  <uix:header textBinding="GENERAL@OsmObjectBundle@servletRequest" >
                    <uix:tableLayout>
                    
                   
                     <!-- System Name -->
                      
                         
                          <uix:rowLayout>
                           <uix:cellFormat hAlign="right">
                            <uix:styledText styleClass="OraPromptText" textBinding="NAME@OsmObjectBundle@servletRequest" />
                          </uix:cellFormat>
                          <uix:spacer width="10"/>
                            <uix:styledText styleClass="OraDataText" textBinding="fileName@memberFile@servletRequest"/>
                          
                          </uix:rowLayout>
                      
                           <uix:rowLayout renderedBinding="showSystem@servletRequest">
                           <uix:cellFormat hAlign="right">
                           <uix:styledText styleClass="OraPromptText" textBinding="SYSTEM_NAME@OsmObjectBundle@servletRequest"/>
                           </uix:cellFormat>
                           <uix:spacer width="10"/>
                           <uix:link textBinding="systemName@memberFile@servletRequest" 
                                     destinationBinding="systemLink@servletRequest" />
                         
                           </uix:rowLayout>
                          
                      
  
                      <!-- Type -->
                      <uix:rowLayout>
                        <uix:cellFormat hAlign="right">
                          <uix:styledText styleClass="OraPromptText"
                                          textBinding="TYPE@OsmObjectBundle@servletRequest"/>
                        </uix:cellFormat>
                        <uix:spacer width="10"/>
                        <uix:styledText styleClass="OraDataText"
                                        textBinding="fileType@memberFile@servletRequest"/>
                      </uix:rowLayout>
                      <!-- Redundancy -->
                      <uix:rowLayout>
                        <uix:cellFormat hAlign="right">
                          <uix:styledText styleClass="OraPromptText"
                                          textBinding="REDUNDANCY@OsmObjectBundle@servletRequest"/>
                        </uix:cellFormat>
                        <uix:spacer width="10"/>
                        <uix:styledText styleClass="OraDataText"
                                       textBinding="redundancy@memberFile@servletRequest" />
                      </uix:rowLayout>
                       <!-- Striped -->
                      <uix:rowLayout>
                        <uix:cellFormat hAlign="right">
                          <uix:styledText styleClass="OraPromptText"
                                          textBinding="STRIPED@OsmObjectBundle@servletRequest"/>
                        </uix:cellFormat>
                        <uix:spacer width="10"/>
                        <uix:styledText styleClass="OraDataText"
                                        textBinding="striped@memberFile@servletRequest" />
                      </uix:rowLayout>
                       <!-- Block Size -->
                      <uix:rowLayout>
                        <uix:cellFormat hAlign="right">
                          <uix:styledText styleClass="OraPromptText"
                                          textBinding="BLOCK_SIZE@OsmObjectBundle@servletRequest"/>
                        </uix:cellFormat>
                        <uix:spacer width="10"/>
                        <uix:styledText styleClass="OraDataText"
                                        textBinding="blockSize@memberFile@servletRequest"/>
                      </uix:rowLayout>
                       <!-- Blocks -->
                      <uix:rowLayout>
                        <uix:cellFormat hAlign="right">
                          <uix:styledText styleClass="OraPromptText"
                                          textBinding="BLOCKS@OsmObjectBundle@servletRequest"/>
                        </uix:cellFormat>
                        <uix:spacer width="10"/>
                        <uix:styledText styleClass="OraDataText"
                                        textBinding="blocks@memberFile@servletRequest"/>
                      </uix:rowLayout>
                       <!-- Logical Size -->
                      <uix:rowLayout>
                        <uix:cellFormat hAlign="right">
                          <uix:styledText styleClass="OraPromptText"
                                          textBinding="LOGICAL_SIZE@OsmObjectBundle@servletRequest"/>
                        </uix:cellFormat>
                        <uix:spacer width="10"/>
                        <uix:styledText styleClass="OraDataText"
                                        textBinding="size@memberFile@servletRequest"/>
                      </uix:rowLayout>
                      <!-- Creation Date-->
                      <uix:rowLayout>
                        <uix:cellFormat hAlign="right">
                          <uix:styledText styleClass="OraPromptText"
                                          textBinding="CREATE_DATE@OsmObjectBundle@servletRequest"/>
                        </uix:cellFormat>
                        <uix:spacer width="10"/>
                        <uix:styledText styleClass="OraDataText"
                                        textBinding="creationDate@memberFile@servletRequest"/>
                      </uix:rowLayout>
                       <!-- Modificatio Date-->
                      <uix:rowLayout>
                        <uix:cellFormat hAlign="right">
                          <uix:styledText styleClass="OraPromptText"
                                          textBinding="MODIFY_DATE@OsmObjectBundle@servletRequest"/>
                        </uix:cellFormat>
                        <uix:spacer width="10"/>
                        <uix:styledText styleClass="OraDataText"
                                        textBinding="modificationDate@memberFile@servletRequest"/>
                      </uix:rowLayout>
                    </uix:tableLayout>
                  </uix:header>  
                </uix:cellFormat>

                 

               
              <%-------------------------
                -  Extent Zone
              ---------------------------%>
              <uix:cellFormat renderedBinding="versionGte11gTB@memberFile@servletRequest">
               
             <uix:header textBinding="EXTENT_ZONES@OsmObjectBundle@servletRequest" >
             <uix:rowLayout >
             <uix:spacer width="10"/>
             <uix:stackLayout >
              <uix:messagePrompt 
                              promptBinding="EXTENT_ZONES_INSTR@OsmObjectBundle@servletRequest"/>
              <uix:spacer height="5"/>
            <uix:tableLayout cellSpacing="5">
                  <uix:rowLayout hAlign="left">
                
                      <uix:cellFormat hAlign="right">
                        <uix:styledText
                          styleClass="OraPromptText"
                          textBinding="PRIMARY_EXTENT@@OsmObjectBundle@servletRequest"/>
                      </uix:cellFormat>

                     
                      
                      <uix:cellFormat>
                        <uix:contents>
                          <uix:radioButton
                            name="primaryExtentZone"
                            textBinding="HOT@OsmObjectBundle@servletRequest" value="HOT" selectedValueBinding="primaryExtentZone@memberFile@servletRequest"/>
                          <uix:radioButton
                            name="primaryExtentZone"
                            textBinding="COLD@OsmObjectBundle@servletRequest" value="COLD" selectedValueBinding="primaryExtentZone@memberFile@servletRequest"/>
                        </uix:contents>
                      </uix:cellFormat>
                 </uix:rowLayout>
                  
                 
                  <uix:rowLayout hAlign="left">
                
                      <uix:cellFormat hAlign="right">
                        <uix:styledText
                          styleClass="OraPromptText"
                          textBinding="MIRROR_EXTENT@@OsmObjectBundle@servletRequest"/>
                      </uix:cellFormat>

                     
                      
                      <uix:cellFormat>
                        <uix:contents>
                          <uix:radioButton
                            name="mirrorExtentZone"
                            textBinding="HOT@OsmObjectBundle@servletRequest" 
                            value="HOT" 
                            disabledBinding="disableMirrorExtZone@memberFile@servletRequest"
                            selectedValueBinding="mirrorExtentZone@memberFile@servletRequest"/>
                          <uix:radioButton
                            name="mirrorExtentZone"
                            textBinding="COLD@OsmObjectBundle@servletRequest" 
                            value="COLD" 
                            disabledBinding="disableMirrorExtZone@memberFile@servletRequest"
                            selectedValueBinding="mirrorExtentZone@memberFile@servletRequest"/>
                        </uix:contents>
                      </uix:cellFormat>
                 </uix:rowLayout>
            </uix:tableLayout>
             <uix:spacer height="5"/>
             <uix:rowLayout>
                   <uix:cellFormat columnSpan="2">
                    <uix:tip>
                      <contents>
                         <uix:styledText styleClass="oraTipText"
                              textBinding="EXTENT_ZONES_TIP@OsmObjectBundle@servletRequest"/>
                      </contents>
                  
                     </uix:tip>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  </uix:stackLayout >
                  </uix:rowLayout>
            </uix:header>
         
          </uix:cellFormat>
          </uix:rowLayout>
           
          <uix:rowLayout >
          <%-------------------------
             -  Permission
         ---------------------------%>
         <!-- TRAILBLAZER VERSION -->
           <uix:cellFormat renderedBinding="displayGroup@servletRequest" hAlign="right" vAlign="top" width="50%">
                  <uix:header textBinding="PERMISSIONS@OsmObjectBundle@servletRequest" >
                   <uix:rowLayout >
                    <uix:spacer width="5"/>
                   <uix:messagePrompt 
                              promptBinding="PERMISSIONS_INSTR@OsmObjectBundle@servletRequest"/>
                 </uix:rowLayout >
                 <uix:spacer width="5"/>
                 <uix:rowLayout >
                  <uix:spacer width="20"/>
                    <uix:tableLayout cellSpacing="5">
                     
                      <uix:rowLayout>
                        <uix:cellFormat hAlign="left">
                          <uix:messagePrompt labeledNodeId="ownerPermission"
                            promptBinding="OWNER@OsmObjectBundle@servletRequest"/>
                        </uix:cellFormat>
                         <uix:choice id="ownerPermission" name="ownerPermission"
                                 selectedValueBinding="ownerPermission@memberFile@servletRequest" >
                           <uix:option textBinding="READ_ONLY@OsmObjectBundle@servletRequest" value="Read only"/> 
                           <uix:option textBinding="READ_WRITE@OsmObjectBundle@servletRequest" value="Read write"/> 
                           <uix:option textBinding="NONE@OsmObjectBundle@servletRequest" value="None"/> 
                        </uix:choice>
                        <uix:cellFormat >
                        <uix:stackLayout>
                          <uix:contents>
                          
                          </uix:contents>
                        </uix:stackLayout>
                        </uix:cellFormat>
                     </uix:rowLayout>
                
                 <uix:rowLayout>
                        <uix:cellFormat hAlign="left">
                          <uix:messagePrompt labeledNodeId="groupPermission"
                            promptBinding="GROUP@OsmObjectBundle@servletRequest"/>
                        </uix:cellFormat>
                        <uix:cellFormat >
                        <uix:stackLayout>
                          <uix:contents>
                            <uix:choice id="groupPermission" name="groupPermission"
                                 selectedValueBinding="groupPermission@memberFile@servletRequest" >
                           <uix:option textBinding="READ_ONLY@OsmObjectBundle@servletRequest" value="Read only"/> 
                           <uix:option textBinding="READ_WRITE@OsmObjectBundle@servletRequest" value="Read write"/> 
                           <uix:option textBinding="NONE@OsmObjectBundle@servletRequest" value="None"/> 
                        </uix:choice>
                          </uix:contents>
                        </uix:stackLayout>
                        </uix:cellFormat >
                     </uix:rowLayout>
                     
                 <uix:rowLayout>
                        <uix:cellFormat hAlign="left">
                          <uix:messagePrompt labeledNodeId="otherPermission"
                            promptBinding="OTHER@OsmObjectBundle@servletRequest"/>
                        </uix:cellFormat>
                        <uix:cellFormat >
                        <uix:stackLayout>
                          <uix:contents>
                            <uix:choice id="otherPermission" name="otherPermission"
                                  selectedValueBinding="otherPermission@memberFile@servletRequest"  >
                           <uix:option textBinding="READ_ONLY@OsmObjectBundle@servletRequest" value="Read only"/> 
                           <uix:option textBinding="READ_WRITE@OsmObjectBundle@servletRequest" value="Read write"/> 
                           <uix:option textBinding="NONE@OsmObjectBundle@servletRequest" value="None"/> 
                        </uix:choice>
                          </uix:contents>
                        </uix:stackLayout>
                        </uix:cellFormat >
                     </uix:rowLayout>
                    </uix:tableLayout>
                    </uix:rowLayout>
                  </uix:header>  
                </uix:cellFormat>
            <%-------------------------
             -  Ownership
         ---------------------------%>
           <uix:cellFormat renderedBinding="displayGroup@servletRequest" hAlign="right" vAlign="top" width="50%">
              <uix:header textBinding="OWNERSHIP@OsmObjectBundle@servletRequest" >
                <uix:rowLayout >
                  <uix:spacer width="10"/>
                    <uix:tableLayout cellSpacing="5">
                     
                      <uix:rowLayout>
                        <uix:cellFormat hAlign="left">
                          <uix:messagePrompt labeledNodeId="owner"
                            promptBinding="OWNER@OsmObjectBundle@servletRequest"/>
                        </uix:cellFormat>
                        <uix:cellFormat >
                        <uix:stackLayout>
                          <uix:contents>
                               <uix:lovField name="owner"
                                        id="owner"
                                        searchDescBinding="SEARCH@OsmObjectBundle@servletRequest"
                                        textBinding="owner@memberFile@servletRequest"
                                        onClick="setBindSqlParm('diskgroup');preserveCase();startLov('owner', 'ListAclUser')"
                                        />
                          </uix:contents>
                        </uix:stackLayout>
                        </uix:cellFormat>
                     </uix:rowLayout>
                     <uix:rowLayout>
                   <uix:cellFormat >
                   </uix:cellFormat>
                  <uix:cellFormat>
                      <uix:styledText styleClass="oraTipText"
                              textBinding="OWNER_INSTR@OsmObjectBundle@servletRequest"/>
                  </uix:cellFormat>
                 </uix:rowLayout>
                
                 <uix:rowLayout>
                        <uix:cellFormat hAlign="left">
                          <uix:messagePrompt labeledNodeId="group"
                            promptBinding="GROUP@OsmObjectBundle@servletRequest"/>
                        </uix:cellFormat>
                        <uix:cellFormat >
                        <uix:stackLayout>
                          <uix:contents>
                                        <uix:lovField name="group"
                                        id="group"
                                        searchDescBinding="SEARCH@OsmObjectBundle@servletRequest"
                                        textBinding="group@memberFile@servletRequest"
                                        onClick="setBindSqlParm('diskgroup');preserveCase();startLov('group', 'ListGroup')"
                                        />
                          </uix:contents>
                        </uix:stackLayout>
                        </uix:cellFormat >
                     </uix:rowLayout>
                     <uix:rowLayout>
                   <uix:cellFormat >
                   </uix:cellFormat>            
                  <uix:cellFormat>
                      <uix:styledText styleClass="oraTipText"
                              textBinding="GROUP_INSTR@OsmObjectBundle@servletRequest"/>
                  </uix:cellFormat>
                 </uix:rowLayout>
                    </uix:tableLayout>
                    </uix:rowLayout >
                  </uix:header>  
             </uix:cellFormat> 
          </uix:rowLayout>
          </uix:tableLayout>
         

        <%-- /uix:header --%>

        <%-------------------------
         -  Footer
         ---------------------------%>
         <uix:pageButtons>
          <uix:pageButtonBar>

            <uix:submitButton
              name="event"
              textBinding="SHOWSQL@uixDBObjectBundle@servletRequest"
              value="showSql"/>
            <uix:submitButton
              name="event"
              textBinding="REVERT@uixDBObjectBundle@servletRequest"
              value="revert"/>
            <uix:submitButton
              name="event"
              textBinding="APPLY@uixDBObjectBundle@servletRequest"
              value="apply"/>
          </uix:pageButtonBar>
         </uix:pageButtons>

      </uix:pageLayout>
    </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
