<%--
  -- Page:        editTemplate.jsp
  -- Controller:  oracle.sysman.db.adm.osm.DiskGroupController
  --
  -- Description: ASM disk group edit template page
  --
  --  MODIFIED    (MM/DD/YY)
  --   dchakumk    03/10/08 - XbranchMerge dchakumk_6752_xbmsrc from
  --                          st_emdbsa_11.1
  --   asubba      03/08/07 - XbranchMerge asubba_22705_umask_sysoper from
  --                          st_emdbsa_project-22846
  --   gmahaney    02/01/07 - XbranchMerge gmahaney_emdb_pt_main from main
  --   asubba      01/10/07 - display diskzone related information
  --   qsong       06/22/06 - 
  --   asubba      03/06/06 - 
  --   rajeshar    02/03/05 - using oemTitle for Page Header
  --   rajeshar    08/23/04 - enable redundancy radio button for normal type diskgroup bug 3356473
  --   jochen      07/19/04 - Change Striped options to Fine/Coarse.
  --   many                 - Edits by many people
  --   spanchum    08/22/02 - Initial entry
  --%>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>
    
    <uix:body>
    <uix:form
      name="diskGrpForm"
      method="post"
      destinationBinding="defaultURL@servletRequest">

      <uix:formValue
        name="pageName"
        value="/database/osm/editTemplate"/>

      <uix:formValue
        name="cancelURL"
        valueBinding="cancelURL@servletRequest"/>

      <uix:pageLayout titleBinding="templateHeader@diskGrp@servletRequest">

        <%@ include file="/database/global.jspf" %>

        <oem:messageBox messageType="info"
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>

        <%-- uix:header
          textBinding="templateHeader@diskGrp@servletRequest"
          --%>

            <%-------------------------
             -  Labeled Fields
             ---------------------------%>
            <uix:tableLayout cellSpacing="5">

                <%---------------------%>
                <%---  DG Name    ---%>
                <%---------------------%>
                <uix:rowLayout>

                  <%---  Prompt  ---%>
                  <uix:cellFormat hAlign="right">
                    <uix:messagePrompt
                      promptBinding="TEMPLATE_NAME@OsmObjectBundle@servletRequest"/>
                  </uix:cellFormat>

                  <%---  Field  ---%>
                  <uix:cellFormat hAlign="left">
                      <uix:styledText styleClass="OraDataText" textBinding="name@templateDetails@diskGrp@servletRequest"/>
                 </uix:cellFormat>

                </uix:rowLayout>

                <%-----------------------------------------------------------------%>
                <%---------------------------  Redundancy -------------------------%>
                <%-----------------------------------------------------------------%>
                <%--
                <uix:switcher childNameBinding="normal@diskGrp@servletRequest">
	          <uix:case name="false">
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right">
                        <uix:messagePrompt promptBinding="REDUNDANCY@OsmObjectBundle@servletRequest" />
                      </uix:cellFormat>
                      
                      <uix:cellFormat>
                        <uix:styledText styleClass="OraDataText" textBinding="redundancy@templateDetails@diskGrp@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:case>  
                  
                  <uix:case name="true">
                  --%>
                  <uix:rowLayout>
                
                      <%---  Prompt  ---%>
                      <uix:cellFormat hAlign="right">
                        <uix:styledText
                          styleClass="OraPromptText"
                          textBinding="REDUNDANCY@OsmObjectBundle@servletRequest"/>
                      </uix:cellFormat>

                      <%---  Field  ---%>
                      <uix:cellFormat>
                        <uix:contents>
                          <uix:radioButton
                            name="templateRedundancy"
                            textBinding="HIGH_REDUND@OsmObjectBundle@servletRequest" 
                            value="HIGH" 
                            selectedBinding="high@templateDetails@diskGrp@servletRequest"
                            renderedBinding="versionGte102@diskGrp@servletRequest"
                            disabledBinding="disableTemplateHighRedund@diskGrp@servletRequest"/>
                            <%-- Trailblazer release
                            onChange="submitForm('diskGrpForm', true, {event:'onClickTemplateRedundancy'})"/>
                            --%>
                          <uix:radioButton
                            name="templateRedundancy"
                            textBinding="MIRROR@OsmObjectBundle@servletRequest" 
                            value="MIRROR" 
                            selectedBinding="mirrored@templateDetails@diskGrp@servletRequest"
                            disabledBinding="disableTemplateMirroredRedund@diskGrp@servletRequest"/>
                            <%-- Trailblazer release
                            onChange="submitForm('diskGrpForm', true, {event:'onClickTemplateRedundancy'})"/>
                            --%>
                            
                          <uix:radioButton
                            name="templateRedundancy"
                            textBinding="UNPROTECTED@OsmObjectBundle@servletRequest" 
                            value="UNPROTECTED" 
                            selectedBinding="unprotected@templateDetails@diskGrp@servletRequest"
                            disabledBinding="disableTemplateUnprotRedund@diskGrp@servletRequest"/>
                            <%-- Trailblazer release
                            onChange="submitForm('diskGrpForm', true, {event:'onClickTemplateRedundancy'})"/>
                            --%>
                        </uix:contents>
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <%--
                  </uix:case>
                </uix:switcher>
                --%>
                
                <%-------------------------%>
                <%---  Auto Mount Activation  ---%>
                <%-------------------------%>
                <uix:rowLayout>

                  <%---  Prompt  ---%>
                  <uix:cellFormat hAlign="right">
                    <uix:styledText
                      styleClass="OraPromptText"
                      textBinding="STRIPED@OsmObjectBundle@servletRequest"/>
                  </uix:cellFormat>

                  <%---  Field  ---%>
                  <%---  Field  ---%>
                  <uix:cellFormat>
                   <uix:contents>
                    <uix:radioButton
                      name="templateStriped"
                      textBinding="FINE@OsmObjectBundle@servletRequest" value="FINE" selectedBinding="stripedYes@templateDetails@diskGrp@servletRequest"/>
                    <uix:radioButton
                      name="templateStriped"
                      textBinding="COARSE@OsmObjectBundle@servletRequest" value="COARSE" selectedBinding="stripedNo@templateDetails@diskGrp@servletRequest"/>
                   </uix:contents>
                  </uix:cellFormat>

                </uix:rowLayout>

            </uix:tableLayout>

             <%-- The following are for 11g Trailblazer release --%>
              <%-------------------------
                -  Extent Zone
              ---------------------------%>
              <%-- TO DO swicther for versions --%>
          
            <uix:header renderedBinding="versionGte11gTB@diskGrp@servletRequest" 
                        textBinding="EXTENT_ZONES@OsmObjectBundle@servletRequest" >
             <uix:rowLayout >
             <uix:spacer width="10"/>
             <uix:stackLayout >
              <uix:messagePrompt promptBinding="EXTENT_ZONES_INSTR@OsmObjectBundle@servletRequest"/>
              <uix:spacer height="5"/>
              <uix:tableLayout cellSpacing="5">
                  <uix:rowLayout hAlign="left">
                      <uix:cellFormat hAlign="right">
                        <uix:styledText
                          styleClass="OraPromptText"
                          textBinding="PRIMARY_EXTENT@@OsmObjectBundle@servletRequest"/>
                      </uix:cellFormat>

                      <uix:cellFormat>
                        <uix:contents>
                          <uix:radioButton
                            name="templatePrimaryExtent"
                            textBinding="HOT@OsmObjectBundle@servletRequest" value="HOT" selectedValueBinding="primaryExtentZone@templateDetails@diskGrp@servletRequest"/>
                          <uix:radioButton
                            name="templatePrimaryExtent"
                            textBinding="COLD@OsmObjectBundle@servletRequest" value="COLD" selectedValueBinding="primaryExtentZone@templateDetails@diskGrp@servletRequest"/>
                        </uix:contents>
                      </uix:cellFormat>
                 </uix:rowLayout>
                  
                 
                  <uix:rowLayout hAlign="left">
                      <uix:cellFormat hAlign="right">
                        <uix:styledText
                          styleClass="OraPromptText"
                          textBinding="MIRROR_EXTENT@@OsmObjectBundle@servletRequest"/>
                      </uix:cellFormat>

                      <uix:cellFormat>
                        <uix:contents>
                          <uix:radioButton
                            name="templateMirrorExtent"
                            textBinding="HOT@OsmObjectBundle@servletRequest" 
                            value="HOT" 
                            selectedValueBinding="mirrorExtentZone@templateDetails@diskGrp@servletRequest"
                            disabledBinding="isUnprot@templateDetails@diskGrp@servletRequest"/>
                          <uix:radioButton
                            name="templateMirrorExtent"
                            textBinding="COLD@OsmObjectBundle@servletRequest" 
                            value="COLD" 
                            selectedValueBinding="mirrorExtentZone@templateDetails@diskGrp@servletRequest"
                            disabledBinding="isUnprot@templateDetails@diskGrp@servletRequest"/>
                        </uix:contents>
                      </uix:cellFormat>
                 </uix:rowLayout>
            </uix:tableLayout>
             <uix:spacer height="5"/>
             <uix:rowLayout>
                   <uix:cellFormat columnSpan="2">
                    <uix:tip>
                      <contents>
                         <uix:styledText styleClass="oraTipText"
                              textBinding="EXTENT_ZONES_TIP@OsmObjectBundle@servletRequest"/>
                      </contents>
                  
                     </uix:tip>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  </uix:stackLayout >
                  </uix:rowLayout>
            </uix:header>
          
        <%-- /uix:header --%>

        <%-------------------------
         -  Footer
         ---------------------------%>
         <uix:pageButtons>
          <uix:pageButtonBar>

            <uix:submitButton
              name="event"
              textBinding="SHOWSQL@uixDBObjectBundle@servletRequest"
              value="showSql"/>
            <uix:submitButton
              name="event"
              textBinding="REVERT@uixDBObjectBundle@servletRequest"
              value="revert"/>
            <uix:submitButton
              name="event"
              textBinding="APPLY@uixDBObjectBundle@servletRequest"
              value="apply"/>
          </uix:pageButtonBar>
         </uix:pageButtons>

      </uix:pageLayout>
    </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
