<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
    
    <uix:form
      name="osmForm"
      method="GET"
      destinationBinding="defaultURL@servletRequest">
      <uix:pageLayout titleBinding="editHeader@osmUserBean@servletRequest">
      <%@ include file="/database/global.jspf" %>
      <uix:formValue
        name="pageName"
        value="/database/osm/editUser"/>
      <uix:formValue name="optionChoice" valueBinding="optionChoice@servletRequest"/>
      <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
       <uix:formValue name="pwdchange" value="false" />
        <oem:messageBox messageType="info"
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageTypeBinding="messageType@servletRequest"
                        errorTableBinding="msgBox@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <uix:tableLayout  >
             <uix:messagePrompt 
                        promptBinding="USERS_DESC@OsmObjectBundle@servletRequest"/>
             <uix:spacer height="15"/>
             <uix:header textBinding="LOGIN_CREDS@OsmObjectBundle@servletRequest">
               <uix:rowLayout >
                  <uix:cellFormat hAlign="left" vAlign="top">
                    <uix:stackLayout >
                    <uix:rowLayout>
                    <uix:spacer height="15"/>
                    
                    <uix:tableLayout cellSpacing="10">
                      <uix:rowLayout vAlign="top">
                        <uix:cellFormat hAlign="right">
                          <uix:messagePrompt promptBinding="USER_NAME@OsmObjectBundle@servletRequest"/>
                        </uix:cellFormat>
                        <uix:styledText textBinding="userName@osmUserBean@servletRequest" styleClass="OraDataText" />
                      </uix:rowLayout>
 
                      <uix:rowLayout vAlign="top"
                                     renderedBinding="showOldPwd@osmUserBean@servletRequest">
                        <uix:cellFormat hAlign="right">
                          <uix:messagePrompt  labeledNodeId="secretOldPassword"
                                          promptBinding="OLD_PASSWORD@OsmObjectBundle@servletRequest"/>
                        </uix:cellFormat>
                        <uix:stackLayout>
                          <uix:textInput id="secretOldPassword" 
                                         name="secretOldPassword" secret="true"
                                         textBinding="secretOldPassword@osmUserBean@servletRequest"
                                         noAutoComplete="true"
                                         columns="30"/>
                          <uix:styledText textBinding="HINT_NEED_OLD_PWD@OsmObjectBundle@servletRequest"
                                          styleClass="OraInlineInfoText"/>
                        </uix:stackLayout>
                      </uix:rowLayout>
                      <uix:rowLayout vAlign="top">
                        <uix:cellFormat hAlign="right">
                          <uix:messagePrompt  labeledNodeId="secretPassword"
                                          promptBinding="pwdPrompt@osmUserBean@servletRequest"/>
                        </uix:cellFormat>
                        <uix:textInput id="secretPassword" 
                                       name="secretPassword" secret="true"
                                       textBinding="secretPassword@osmUserBean@servletRequest"
                                       noAutoComplete="true"
                                       columns="30"/>
                      </uix:rowLayout>
                      <uix:rowLayout vAlign="top">
                        <uix:cellFormat hAlign="right">
                          <uix:messagePrompt labeledNodeId="secretConfirmPassword"
                                          promptBinding="confirmPwdPrompt@osmUserBean@servletRequest"/>
                        </uix:cellFormat>
                              <uix:textInput id="secretConfirmPassword"
                                             name="secretConfirmPassword" secret="true"
                                             textBinding="secretConfirmPassword@osmUserBean@servletRequest"
                                             noAutoComplete="true"
                                             columns="30"/>
                      </uix:rowLayout>
                      
                    </uix:tableLayout>
                    </uix:rowLayout>
                 
                  </uix:stackLayout >
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:header>
               
             <uix:header textBinding="PRIVILEGES@OsmObjectBundle@servletRequest" 
                         renderedBinding="editPrivileges@servletRequest">
               <uix:rowLayout >
                   <uix:cellFormat hAlign="left" vAlign="top" >
                       <uix:rowLayout >
                       <uix:spacer width="25"/>
                       <uix:shuttle name="userPrivilege" 
                                    leadingHeaderBinding="AVAILABLE_PRIVILEGES@OsmObjectBundle@servletRequest"
                                    trailingHeaderBinding="GRANTED_PRIVILEGES@OsmObjectBundle@servletRequest" 
                                    reorderable="false" >
                                    <%--disabledBinding="disablePrivsSelection@osmUserBean@servletRequest"--%>
                        <uix:leading >
                         <uix:list name="availablePrivilegeOptions"
                                   multiple="true"
       shortDescBinding="AVAILABLE_PRIVILEGES@OsmObjectBundle@servletRequest">
                           <uix:contents childDataBinding="availablePrivileges@osmUserBean@servletRequest">
                             <uix:option textBinding="text"
                                         valueBinding="value"/>
                           </uix:contents>
                         </uix:list>
                        </uix:leading>
                        <uix:trailing >
                         <uix:list name="selectedPrivilegeOptions"
       multiple="true"
       shortDescBinding="GRANTED_PRIVILEGES@OsmObjectBundle@servletRequest">
                           <uix:contents childDataBinding="selectedPrivileges@osmUserBean@servletRequest">
                             <uix:option textBinding="text"
                                         valueBinding="value"/>
                           </uix:contents>
                         </uix:list>
                        </uix:trailing>
                       </uix:shuttle>
                      </uix:rowLayout>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:header>
              
          </uix:tableLayout>
     
      
       <uix:pageButtons>
          <uix:pageButtonBar>

            <uix:submitButton name="event"
                              textBinding="SHOWSQL@uixDBObjectBundle@servletRequest"
                              value="showSql"/>
            <uix:submitButton name="event"
                              textBinding="REVERT@uixDBObjectBundle@servletRequest"
                              value="revert"/>
            <uix:submitButton
              name="event"
              textBinding="APPLY@uixDBObjectBundle@servletRequest"
              value="apply"/>
          </uix:pageButtonBar>
         </uix:pageButtons>
      </uix:pageLayout>
    </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
