
<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>


<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>

<%-- Message Bundles --%>
  <uix:bundle name="dbObjMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:bundle name="osmMsgs"   class="oracle.sysman.db.rsc.osm.OsmObjectMsg"/>

  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

    <%@ include file="/enablePPR.jspf" %>

    <uix:body>
    <uix:form name="createUGForm"
              method="POST"
              destinationBinding="defaultURL@servletRequest">

      <uix:formValue name="pageName"
                     value="/database/osm/editUserGroup"/>
		     
      <uix:formValue name="optionChoice"
                     valueBinding="optionChoice@servletRequest"/>

      <uix:pageLayout titleBinding="editHeader@userGroup@servletRequest">

        <%@ include file="/database/global.jspf" %>

          <oem:messageBox messageType="info"
                          errorTableBinding="info@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error"
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
                        
          <uix:tableLayout  >
               
             <uix:rowLayout >
                <uix:cellFormat hAlign="left" vAlign="top">
                 <%-- <uix:header textBinding="CREATE_USER_GROUP@OsmObjectBundle@servletRequest"> --%>
                    <uix:stackLayout>
                    <uix:rowLayout>
                      <uix:spacer width="15"/>
                      <uix:messagePrompt 
                              promptBinding="GROUPS_DESC@OsmObjectBundle@servletRequest"/>
                    </uix:rowLayout>
                    <uix:spacer height="30"/>
                      
                  <uix:rowLayout vAlign="top">
                    <uix:spacer width="15"/>
                    <uix:cellFormat hAlign="right">
                      <uix:messagePrompt 
                                      promptBinding="GROUP_NAME@OsmObjectBundle@servletRequest"/>
                    </uix:cellFormat>
                          <uix:spacer width="5"/>
                          <uix:styledText styleClass="OraDataText" textBinding="groupName@userGroup@servletRequest"/>
                  </uix:rowLayout> 
                    
                 
                  </uix:stackLayout >
                 <%-- </uix:header> --%>
                </uix:cellFormat>
              </uix:rowLayout>
               
             <uix:rowLayout>
              <uix:spacer height="15"/>
             </uix:rowLayout>
             
             <uix:rowLayout >
                <uix:cellFormat hAlign="left" vAlign="top" >
                  <uix:header textBinding="MEMBERS@OsmObjectBundle@servletRequest" >
                  <uix:rowLayout>
                      <uix:spacer width="15"/>
                      <uix:messagePrompt 
                              promptBinding="MEMBERS_DESC@OsmObjectBundle@servletRequest"/>
                    </uix:rowLayout>
                    
                    <uix:rowLayout>
                     <uix:spacer height="10"/>
                     </uix:rowLayout>
                    
                    <uix:rowLayout >
                       <uix:spacer width="25"/>
                       <uix:shuttle name="users" 
                                    leadingHeaderBinding="AVAILABLE_USERS@OsmObjectBundle@servletRequest"
                                    trailingHeaderBinding="SELECTED_USERS@OsmObjectBundle@servletRequest" 
                                    reorderable="false">
                         <uix:leading >
                           <uix:list name="availableUsers"
				     multiple="true"
				     shortDescBinding="AVAILABLE_USERS@OsmObjectBundle@servletRequest">
                             <uix:contents childDataBinding="availableUsers@userGroup@servletRequest">
                               <uix:option textBinding="text"
                                           valueBinding="value"/>
                             </uix:contents>
                           </uix:list>
                         </uix:leading>
                         <uix:trailing >
                           <uix:list name="selectedUsers"
				     multiple="true"
				     shortDescBinding="SELECTED_USERS@OsmObjectBundle@servletRequest">
                             <uix:contents childDataBinding="selectedUsers@userGroup@servletRequest">
                               <uix:option textBinding="text"
                                           valueBinding="value"/>
                             </uix:contents>
                           </uix:list>
                         </uix:trailing>
                       </uix:shuttle>
                      </uix:rowLayout>
                      
                     <uix:rowLayout>
                      <uix:spacer height="10"/>
                     </uix:rowLayout>
                      
                  </uix:header>
                </uix:cellFormat>
              </uix:rowLayout>
            
          </uix:tableLayout>
     
      
       <uix:pageButtons>
          <uix:pageButtonBar>

            <uix:submitButton name="event"
                              textBinding="SHOWSQL@uixDBObjectBundle@servletRequest"
                              value="showSql"/>
           <uix:submitButton name="event"
                              textBinding="REVERT@uixDBObjectBundle@servletRequest"
                              value="revert"/>
            <uix:submitButton
              name="event"
              textBinding="OK@uixDBObjectBundle@servletRequest"
              value="apply"/>
          </uix:pageButtonBar>
         </uix:pageButtons>
       </uix:pageLayout>
     </uix:form>
     </uix:body>
  </uix:document>
</uix:renderingContext>

