<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

  <%-- Message Bundles --%>
  <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:bundle name="osmMsgs" class="oracle.sysman.db.rsc.osm.OsmObjectMsg"/>

  <uix:document>

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
     <uix:body>
      
      <uix:pageLayout titleBinding="FGHeader@osmSitemapBean@servletRequest" >
      <%@ include file="/database/global.jspf" %>
       <uix:dataScope currentDataBinding="failgroupsDS@osmSitemapBean@servletRequest">
                 <uix:table id="failgroupsDataSource" 
                                alternateTextBinding="NO_ITEMS_FOUND@dbMsgs"
                                formSubmitted="true" width="70%" 
                                tableDataBinding="rowData" 
                                minValue="1" 
                                valueBinding="startIndex"
                                maxValueBinding="numRows" 
                                blockSizeBinding="blockSize"
                                summaryBinding="FG_TABLE_SUMMARY@OsmObjectBundle@servletRequest">
                      <uix:tableFormat tableBanding="rowBanding"/>
                          <uix:column >
                          <uix:columnHeader >
                              <uix:text textBinding="FAILGROUP@OsmObjectBundle@servletRequest" />
                              </uix:columnHeader>
                           <uix:columnFormat columnDataFormat="textFormat"/>
                          <uix:text textBinding="failgroup" />
                      </uix:column>
                      <uix:column >
                          <uix:columnHeader >
                              <uix:text textBinding="DISKGROUP@OsmObjectBundle@servletRequest" />
                              </uix:columnHeader>
                           <uix:columnFormat columnDataFormat="textFormat"/>
                          <uix:text textBinding="diskgroup" />
                      </uix:column>
                      <uix:column >
                          <uix:columnHeader>
                            <uix:text textBinding="AVAILABILITY@OsmObjectBundle@servletRequest" />
                          </uix:columnHeader>
                            <uix:rowLayout hAlign="center">
                            <uix:image sourceBinding="availability" /> 
                            </uix:rowLayout>
                      </uix:column>
                      <uix:column>
                          <uix:columnHeader>
                             <uix:text textBinding="MEMBER_DISKS@OsmObjectBundle@servletRequest" />
                         </uix:columnHeader>
                         
                           <uix:columnFormat columnDataFormat="numberFormat"/>
                          <uix:link textBinding="memberdisk"  destinationBinding="fgUrl"/>
                       
                      </uix:column>
                    </uix:table>
            </uix:dataScope> 
       
        <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:button   textBinding="OK@dbMsgs"
                          destinationBinding="sitemapDest@servletRequest"/>
          </uix:pageButtonBar>
         </uix:pageButtons>
         
      </uix:pageLayout>
     
     </uix:body>
  </uix:document>
</uix:renderingContext>

