<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.sysman.db.adm.osm.JspConstants" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/enablePPR.jspf" %>    
    
    <uix:body>
    <uix:form
      name="editDGForm" 
      method="POST"
      destinationBinding="defaultURL@servletRequest">

      <uix:formValue 
        name="pageName" 
        value="/database/osm/files"/>

      <uix:pageLayout>

        <%@ include file="/database/global.jspf" %>

        <oem:messageBox messageType="info" 
                        errorTableBinding="confirmation@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error" 
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>

        <uix:header
          textBinding="header@filesAdminBean@servletRequest"
          >

          <uix:subTabLayout>

            <uix:subTabs>
              <jsp:include page="/database/osm/subTabsInclude.jsp" />
              <uix:ref refID="subTabsInclude" />
            </uix:subTabs>

            <%-- ASM access warning message --%>
            <jsp:include page="/database/osm/asmAccessWarningInclude.jsp" />
            <uix:ref refID="asmAccessWarningInclude"/>

          
       <uix:switcher childNameBinding="rollingMigrationStatus@files@servletRequest">
            <uix:case name="true">
              <uix:rowLayout>
                <uix:spacer height="5"/>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat width="15"/>
                <uix:image source="/em/images/infoicon_active.gif"/>
                <uix:cellFormat width="5"/>
                <uix:styledText styleClass="OraPromptText" textBinding="ROLLING_MIGRATION_PERF_MESSAGE@OsmObjectBundle@servletRequest"/>
              </uix:rowLayout>
            </uix:case> 
          </uix:switcher>
            <uix:tableLayout width="100%" >
              <uix:rowLayout  hAlign="right"> 
                <uix:cellFormat>
                  <uix:contents>
                    <uix:tableLayout cellSpacing="5" >
                      <uix:rowLayout>
                        <uix:cellFormat>
                          <uix:styledText styleClass="OraTipText"
                              textBinding="lastUpdatedTimeLabel@filesAdminBean@servletRequest"/>
                        </uix:cellFormat>
                        <uix:cellFormat>
                          <uix:styledText styleClass="OraTipLabel"
                              textBinding="lastUpdatedTime@filesAdminBean@servletRequest"/>
                        </uix:cellFormat>
                        <uix:cellFormat>
                          <uix:image
                              sourceBinding="refreshImage@filesAdminBean@servletRequest"
                              shortDescBinding="REFRESH@OsmObjectBundle@servletRequest"
                              onClick="submitForm('editDGForm', true, {'event':'refreshFiles'})"/>
                        </uix:cellFormat>
                      </uix:rowLayout>
                    </uix:tableLayout>
                  </uix:contents>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
            <uix:tableLayout width="100%" cellPadding="10">
              <uix:rowLayout>
                <uix:cellFormat hAlign="left" vAlign="top" width="100%">
                  <uix:styledText styleClass="OraInstructionText" textBinding="INST_FILE_TAB@OsmObjectBundle@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
    
            <uix:hGrid id="files"
                     width="100%"
                     alternateTextBinding="FILES_ALT_TEXT@OsmObjectBundle@servletRequest"
                     destinationBinding="defaultURL@servletRequest"
                     summaryBinding="FILES_SUMMARY@OsmObjectBundle@servletRequest"
                     columnFormatsBinding="fileColumnFormats@filesAdminBean@servletRequest"
                     columnHeaderDataBinding="fileColumnHeaderData@filesAdminBean@servletRequest"
                     treeDataBinding="fileTree@filesAdminBean@servletRequest"
                     proxyBinding="proxy@servletRequest"
                     formSubmitted="true">
            <uix:nodeStamp>
              <uix:column>
                <uix:columnHeader>
                  <uix:styledText textBinding="NAME@OsmObjectBundle@servletRequest"/>
                </uix:columnHeader>
                <uix:flowLayout>
                <uix:image sourceBinding="source" shortDescBinding="NAME@OsmObjectBundle@servletRequest"/> 
                <uix:spacer width="5"/>                          
                <uix:styledText textBinding="text"
                                destinationBinding="destination"/>
                </uix:flowLayout>
              </uix:column>
            </uix:nodeStamp>

            <uix:columnHeaderStamp>
              <uix:text textBinding="text"/>
            </uix:columnHeaderStamp>

            <uix:styledText textBinding="physicalSize"/>
            <uix:styledText textBinding="logicalSize"/>
           
            <uix:styledText textBinding="primaryExtentZone"
                            renderedBinding="versionGte11gTB@filesAdminBean@servletRequest"/>
            <uix:styledText textBinding="mirrorExtentZone"
                            renderedBinding="showFileMirrorExtInfo@filesAdminBean@servletRequest"/>
                           
            <uix:columnGroup renderedBinding="displayGroup@servletRequest">
              <uix:columnHeader > 
                 <uix:styledText textBinding="PERMISSIONS@OsmObjectBundle@servletRequest"/> 
              </uix:columnHeader>
               <uix:contents >
                 <uix:column >
                 <uix:columnHeader > <uix:styledText textBinding="OWNER@OsmObjectBundle@servletRequest"/> </uix:columnHeader>
                   <uix:styledText textBinding="ownerPermission"/>
                  </uix:column>
                 <uix:column >
                  <uix:columnHeader > <uix:styledText textBinding="GROUP@OsmObjectBundle@servletRequest"/> </uix:columnHeader>
                   <uix:styledText textBinding="groupPermission"/>
                  </uix:column>
                  <uix:column >
                  <uix:columnHeader > <uix:styledText textBinding="OTHER@OsmObjectBundle@servletRequest"/> </uix:columnHeader>
                   <uix:styledText textBinding="otherPermission"/>
                  </uix:column>
                </uix:contents>
              </uix:columnGroup>
              
               <uix:columnGroup renderedBinding="displayGroup@servletRequest">
              <uix:columnHeader > <uix:styledText textBinding="OWNERSHIP@OsmObjectBundle@servletRequest"/> </uix:columnHeader>
               <uix:contents >
                 <uix:column >
                 <uix:columnHeader > <uix:styledText textBinding="OWNER@OsmObjectBundle@servletRequest"/> </uix:columnHeader>
                   <uix:styledText textBinding="owner"/>
                  </uix:column>
                 <uix:column >
                  <uix:columnHeader > <uix:styledText textBinding="GROUP@OsmObjectBundle@servletRequest"/> </uix:columnHeader>
                   <uix:styledText textBinding="group"/>
                  </uix:column>
                </uix:contents>
              </uix:columnGroup>
            
            
            <uix:formValue name="path" valueBinding="path"/>
            <uix:formValue name="isDir" valueBinding="isDir"/>
            <uix:formValue name="isSystem" valueBinding="isSystem"/>  
            <uix:formValue name="fileNum" valueBinding="fileNum"/>
            <uix:tableSelection> 
                  <uix:multipleSelection shortDescBinding="SELECT@uixDBObjectBundle@servletRequest" selectedBinding="select">
                    <uix:submitButton textBinding="CREATE_ALIAS@OsmObjectBundle@servletRequest" 
                                      name="event" 
                                      disabledBinding="disableFileOps@servletRequest"
                                      value="<%= JspConstants.CREATE_ALIAS %>"/>
                    <uix:submitButton textBinding="CREATE_DIRECTORY@OsmObjectBundle@servletRequest" 
                                      name="event" 
                                      disabledBinding="disableFileOps@servletRequest"
                                      value="<%= JspConstants.CREATE_FOLDER %>"/>                          
                    <uix:submitButton textBinding="RENAME@OsmObjectBundle@servletRequest" 
                                      name="event" 
                                      disabledBinding="disableFileOps@servletRequest"
                                      value="<%= JspConstants.RENAME %>"/>                      
                 
                    <uix:submitButton renderedBinding="versionGte112@files@servletRequest" 
                                    textBinding="EDIT_FILE@OsmObjectBundle@servletRequest" 
                                    name="event" 
                                    disabledBinding="disableFileOps@servletRequest"
                                    value="<%= JspConstants.EDIT_FILE %>"/>                      
                    <uix:submitButton textBinding="DELETE@uixDBObjectBundle@servletRequest" 
                                      name="event" 
                                      disabledBinding="disableFileOps@servletRequest"
                                      value="<%= JspConstants.DELETE %>"/>
                  
                  </uix:multipleSelection>
             </uix:tableSelection> 
          </uix:hGrid>
         </uix:subTabLayout>
        </uix:header>
      </uix:pageLayout>
    </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>

