<%--
  -- Page:        mdBackupConfigPage.jsp
  -- Controller:  oracle.sysman.db.adm.osm.OsmMetadataConfigController
  --
  -- Description: ASM metadata backup configuration page
  --
  --  MODIFIED    (MM/DD/YY)
  --     dchakumk 03/10/08 - XbranchMerge dchakumk_6752_xbmsrc from
  --                         st_emdbsa_11.1
  --     gmahaney 02/01/07 - XbranchMerge gmahaney_emdb_pt_main from main
  --     qsong    03/02/06 - Creation
  --%>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>

<%@ page import="oracle.sysman.emo.adm.osm.OsmConst"%>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="osmMsgs" 
              class="oracle.sysman.db.rsc.osm.OsmObjectMsg"/>
  <uix:bundle name="dbMsgs" 
              class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <uix:form
      name="osmForm"
      method="post"
      destinationBinding="mdConfigDest@servletRequest">
      <uix:formValue
        name="pageName"
        value="/database/osm/mdBackupConfigPage"/>
    <uix:pageLayout>
      <%@ include file="/database/global.jspf" %>

        <oem:messageBox messageType="info"
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageTypeBinding="messageType@servletRequest"
                        errorTableBinding="msgBox@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>

      <uix:header textBinding="BACKUP_CONFIGURATION@osmMsgs">
        <uix:stackLayout>
          <uix:tableLayout width="100%">
            <%-- add backup related UI here --%>

	        </uix:tableLayout>
        </uix:stackLayout>
      </uix:header>
    <uix:pageButtons>
      <uix:pageButtonBar>
         <uix:submitButton
              name="event" 
              textBinding="SHOWCMD@dbMsgs"
              value="showCmd"/>
         <uix:submitButton
              name="event" 
              textBinding="SCHEDULE_JOB@dbMsgs"
              value="submitJob"/>
         <uix:submitButton 
              name="event" 
              textBinding="CANCEL@dbMsgs"
              value="cancel"/>  
         <uix:submitButton
              name="event" 
              textBinding="OK@dbMsgs"
              value="<%= OsmConst.EVENT_DO_BACKUP %>"/>
       </uix:pageButtonBar>
     </uix:pageButtons>
    </uix:pageLayout>
    </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>

