<%--
  -- Page:        memberDisks.jsp
  -- Controller:  oracle.sysman.db.adm.osm.DiskGroupController
  --
  -- Description: ASM disk group home page General tab
  --
  --  MODIFIED    (MM/DD/YY)
  --   asubba      05/11/09 - fix hardcoded strings in charts
  --   asubba      02/10/09 - insufficient legend entries
  --   asubba      02/04/09 - oac: fix the alt tags
  --   loliu       01/12/09 - Added Exadata support
  --   yozhang     12/05/08 - Fix bug 7623381: smart scan capability
  --   asubba      09/12/08 - fix logging issues
  --   asubba      08/11/08 - disbale view by failgroup for external redundancy
  --   chanchan    07/29/08 - 
  --   mpawelko    07/16/08 - bind chart colors
  --   chanchan    06/30/08 - Add ADVM Compatibility
  --   asubba      05/05/08 - XbranchMerge asubba_asm_tb_issues from
  --                          st_emdbsa_11.1.0.0.0_project-22846
  --   asubba      04/09/08 - show advanced attributes to akll
  --   asubba      01/14/08 - disbale online offline for nonsyasm
  --   asubba      10/28/07 - XbranchMerge asubba_asm_message_issues from main
  --   asubba      09/12/07 - Add allocation unit information 
  --   asubba      05/31/07 - enable bbr button for non 11.1
  --   chanchan    03/16/07 - Fix ade merge error
  --   qsong       03/06/07 - remove requires rebalance info
  --   asubba      02/26/07 - XbranchMerge asubba_em_review from st_emdbsa_11.1
  --   gmahaney    02/01/07 - XbranchMerge gmahaney_emdb_pt_main from main
  --   qsong       01/19/07 - remove requires rebalance name/value pair
  --   asubba      12/28/06 - 
  --   asubba      02/07/07 - em review changes
  --   yozhang     11/27/06 - fix ADA issues
  --   asubba      11/16/06 - Add user groups link
  --   asubba      10/30/06 - Disable BBR for non sysasm user
  --   qsong       10/27/06 - 
  --   qsong       09/28/06 - change dg history chart title
  --   asubba      09/27/06 - External redundancy disk
  --   qsong       03/06/06 - add bad block recovery button
  --   asubba      09/11/06 - rolling migration
  --   asubba      07/26/06 - -unreserve
  --   qsong       07/26/06 - 
  --   asubba      07/19/06 - 
  --   qsong       06/16/06 - 
  --   asubba      06/11/06 - 
  --   asubba      06/11/06 - 
  --   qsong       03/06/06 - add bad block recovery button
  --   asubba      02/26/06 - fragmentations and disk sync features 
  --   evelur      02/21/06 - bug 5035323 
  --   rajeshar    04/26/05 - put table summary, ADA problem
  --   rajeshar    03/30/05 - bug 4271949 Tip text for Check
  --   rajeshar    12/03/04 - bug 4026845
  --   chanchan    10/21/04 - Add licensing 
  --   jochen      09/15/04 - Deactivate image for disk group usage 
  --   rajeshar    08/18/04 - to enable success messages 
  --   jochen      04/09/04 - Allow multiple select for batch deletes
  --   many                 - Edits by many people
  --   spanchum    08/22/02 - Initial entry
  --%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.osm.JspConstants" %>
<%@ page import="oracle.sysman.db.adm.EventNames" %>
<%@ page import="oracle.sysman.emo.adm.osm.MemberDisksDataSource" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>


<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>

<%-- Message Bundles --%>
<uix:bundle name="osmMsgs"
            class="oracle.sysman.db.rsc.osm.OsmObjectMsg"/>
<uix:bundle name="dbMsgs" 
            class="oracle.sysman.db.rsc.DBObjectMsg"/>

  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

    <%@ include file="/enablePPR.jspf" %>

    <uix:body>
    <uix:form name="editDGForm"
              method="POST"
              destinationBinding="defaultURL@servletRequest">

      <uix:formValue name="pageName"
                     value="<%= JspConstants.DISKS_PAGE %>"/>
		     
      <uix:formValue name="licenseMemberDisk"
                     valueBinding="licenseMemberDisk@servletRequest"/>

      <uix:pageLayout titleBinding="header@diskGrp@servletRequest">

        <%@ include file="/database/global.jspf" %>

          <oem:messageBox messageType="info"
                          errorTableBinding="confirmation@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error"
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>

          <%--                                                          --%>
          <%-- Support pageMsgBox for any apps that return to this page --%>
          <%-- and support it.  This include must be positioned AFTER   --%>
          <%-- any other uix:messages or messageBox tags.               --%>
          <%--                                                          --%>
          <%@ include file="/sdk/page/pageMsgBox.jspf" %>

        <uix:subTabLayout>

          <%-- SubTabs --%>
          <uix:subTabs>
            <jsp:include page="/database/osm/subTabsInclude.jsp" />
            <uix:ref refID="subTabsInclude" />
          </uix:subTabs>

          <%-- ASM access warning message --%>
          <jsp:include page="/database/osm/asmAccessWarningInclude.jsp" />
          <uix:ref refID="asmAccessWarningInclude"/>

          <uix:stackLayout>
        <%-- ASM Rolling Migration Info --%>
       <uix:switcher childNameBinding="rollingMigrationStatus@diskGrp@servletRequest">
            <uix:case name="true">
              <uix:rowLayout>
                <uix:spacer height="5"/>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat width="15"/>
                <uix:image source="/em/images/infoicon_active.gif"/>
                <uix:cellFormat width="5"/>
                <uix:styledText styleClass="OraPromptText" textBinding="ROLLING_MIGRATION_PERF_MESSAGE@OsmObjectBundle@servletRequest"/>
              </uix:rowLayout>
            </uix:case> 
          </uix:switcher>
            <uix:tableLayout width="100%">
            <!-- dg prop + charts table -->
            <uix:rowLayout>

              <!-- dg prop -->
              <uix:cellFormat vAlign="top">
                <uix:header textBinding="GENERAL@osmMsgs">
                <uix:rowLayout >
                <uix:spacer width="28"/>
                  <uix:tableLayout >
                    <uix:rowLayout>
                    <uix:cellFormat wrappingDisabled="true" hAlign="right"> 
                    <uix:messagePrompt promptBinding="NAME@osmMsgs" />
                    </uix:cellFormat>
                     <uix:spacer width="10"/>
                    <uix:styledText styleClass="OraDataText" textBinding="name@diskGrp@servletRequest"/>
                  </uix:rowLayout>
                   <uix:rowLayout>
                    <uix:cellFormat wrappingDisabled="true" hAlign="right">
                    <uix:messagePrompt promptBinding="STATE@osmMsgs" />
                    </uix:cellFormat>
                    <uix:spacer width="1"/>
                    <uix:styledText styleClass="OraDataText" textBinding="state@diskGrp@servletRequest"/>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat wrappingDisabled="true" hAlign="right">
                    <uix:messagePrompt promptBinding="REDUNDANCY@osmMsgs" />
                    </uix:cellFormat>
                     <uix:spacer width="1"/>
                    <uix:styledText styleClass="OraDataText" textBinding="redundancy@diskGrp@servletRequest"/>
                  </uix:rowLayout>
                   <uix:rowLayout>
                    <uix:cellFormat wrappingDisabled="true" hAlign="right">
                    <uix:messagePrompt promptBinding="TOTAL_GB@osmMsgs" />
                    </uix:cellFormat>
                     <uix:spacer width="1"/>
                    <uix:styledText styleClass="OraDataText" textBinding="totalGB@diskGrp@servletRequest"/>
                  </uix:rowLayout>
                  <%-- Server removes the unbalance column from GV$ASM_DISKGROUP, we won't show the 
                  requires rebalance info here anymore ...
                <uix:switcher childNameBinding="rollingMigrationStatus@diskGrp@servletRequest">
                  <uix:case name="false">
                  <uix:rowLayout renderedBinding="versionGte11g@diskGrp@servletRequest">
                    <uix:cellFormat  wrappingDisabled="true" hAlign="right">
                    <uix:messagePrompt promptBinding="REQUIRES_REBALANCE@osmMsgs" />
                    </uix:cellFormat>
                     <uix:spacer width="1"/>
                     <uix:cellFormat  wrappingDisabled="true" hAlign="left">
                       <uix:styledText  styleClass="OraDataText" 
                                        textBinding="rebalanceStatusText@diskGrp@servletRequest"/>
                       <uix:spacer width="10"/>
                       <uix:submitButton  styleClass="OraDataText" 
                                          textBinding="REBALANCE@@osmMsgs"
                                          disabledBinding="disableNonSysAsmOp@servletRequest"
                                          renderedBinding="showRebalanceButton@diskGrp@servletRequest"
                                          name="event" value="REBALANCE"/>
                     </uix:cellFormat>
                   </uix:rowLayout>
                  </uix:case>
                  </uix:switcher>
                  --%>
                   <uix:rowLayout>
                    <uix:cellFormat wrappingDisabled="true" hAlign="right">
                    <uix:messagePrompt promptBinding="PENDING_OPERATIONS@osmMsgs" />
                    </uix:cellFormat>
                     <uix:spacer width="1"/>
                      <uix:switcher childNameBinding="operationsCount@diskGrp@servletRequest">
                       <uix:case name="0">
                         <uix:styledText styleClass="OraDataText" text="0"/>
                       </uix:case>
                       <uix:default>
                        <uix:link textBinding="operationsCount@diskGrp@servletRequest" destinationBinding="operationsUrl@diskGrp@servletRequest"/>
                       </uix:default>
                    </uix:switcher>
                  </uix:rowLayout>
                   <uix:rowLayout>
                    <uix:cellFormat wrappingDisabled="true" hAlign="right">
                    <uix:messagePrompt promptBinding="ALLOCATION_UNIT_MB@osmMsgs" />
                    </uix:cellFormat>
                     <uix:spacer width="1"/>
                    <uix:styledText styleClass="OraDataText" textBinding="allocationUnitSize@diskGrp@servletRequest"/>
                  </uix:rowLayout>
                  </uix:tableLayout>
                  </uix:rowLayout>
                </uix:header>
                <uix:header textBinding="ADVANCED_ATTRIBUTES@osmMsgs">
                   <uix:rowLayout width="100%">
                   <uix:cellFormat hAlign="right">
                  <uix:submitButton textBinding="EDIT@osmMsgs" 
                                    name="event" 
                                    value="<%= JspConstants.EDIT_ADVANCED_ATTRIBUTES %>"
                                    disabledBinding="disableNonSysAsmOp@servletRequest"
                                    renderedBinding="showAdvAttrSecion@servletRequest"/>
                    </uix:cellFormat>
                   </uix:rowLayout>
                <uix:tableLayout  >
                  <uix:rowLayout>
                    <uix:cellFormat wrappingDisabled="true" hAlign="right"> 
                    <uix:messagePrompt promptBinding="DATABASE_COMPATIBILITY@osmMsgs" />
                    </uix:cellFormat>
                     <uix:spacer width="10"/>
                    <uix:styledText styleClass="OraDataText" textBinding="databaseCompatibility@diskGrp@servletRequest"/>
                  </uix:rowLayout>
                   <uix:rowLayout>
                    <uix:cellFormat wrappingDisabled="true" hAlign="right">
                    <uix:messagePrompt promptBinding="ASM_COMPATIBILITY@osmMsgs" />
                    </uix:cellFormat>
                    <uix:spacer width="10"/>
                    <uix:styledText styleClass="OraDataText" textBinding="asmCompatibility@diskGrp@servletRequest"/>
                  </uix:rowLayout>
                   <uix:rowLayout renderedBinding="versionGte11gTB@diskGrp@servletRequest">
                    <uix:cellFormat wrappingDisabled="true" hAlign="right">
                    <uix:messagePrompt promptBinding="ADVM_COMPATIBILITY@osmMsgs" />
                    </uix:cellFormat>
                    <uix:spacer width="10"/>
                    <uix:styledText styleClass="OraDataText" textBinding="advmCompatibility@diskGrp@servletRequest"/>
                  </uix:rowLayout>
                   <uix:rowLayout renderedBinding="showDisRepairTime@diskGrp@servletRequest">
                    <uix:cellFormat wrappingDisabled="true" hAlign="right">
                    <uix:messagePrompt promptBinding="DISK_REPAIR_TIME_HOURS@osmMsgs"/>
                    </uix:cellFormat>
                    <uix:spacer width="10"  renderedBinding="showDisRepairTime@diskGrp@servletRequest"/>
                    <uix:styledText styleClass="OraDataText" 
                                    textBinding="diskRepairTimeHourValue@diskGrp@servletRequest" />
                  </uix:rowLayout>
                  <uix:rowLayout renderedBinding="versionGte11gSmartScan@diskGrp@servletRequest">
                    <uix:cellFormat wrappingDisabled="true" hAlign="right">
                    <uix:messagePrompt promptBinding="SMART_SCAN_CAPABILITY_HEADER@OsmObjectBundle@servletRequest" />
                    </uix:cellFormat>
                    <uix:spacer width="10"/>
                    <uix:styledText styleClass="OraDataText" 
                                    textBinding="smartScanCapabilityValue@diskGrp@servletRequest"/>
                  </uix:rowLayout>
                  <uix:rowLayout renderedBinding="showEditACL@servletRequest">
                    <uix:cellFormat wrappingDisabled="true" hAlign="right">
                    <uix:messagePrompt promptBinding="FILE_ACCESS_CONTROL@OsmObjectBundle@servletRequest" />
                    </uix:cellFormat>
                    <uix:spacer width="10"/>
                    <uix:styledText styleClass="OraDataText" 
                                    textBinding="accessControl@diskGrp@servletRequest"/>
                  </uix:rowLayout>
                </uix:tableLayout>
            </uix:header>
              </uix:cellFormat>
              <uix:cellFormat vAlign="top">

              <oem:chart titleBinding="CURRENT_DISKGROUP_USAGE_IN_GB@osmMsgs"
                         chartType="pieChart"
                         format="svg"
                         orientation="vertical"
                         width="350"
                         height="200"
                         legendVisible="external"
                         pieValuesInLegend="value"
                         yAxisNumberFormatBinding="pieChartLegendFormat@servletRequest"
                         showSlicePercentLabels="true"
                         pieSliceColorsBinding="DGColors@diskGrp@servletRequest"
                         >
                <uix:contents>
                  <oem:boundChartDataSource
                        chartDataSourceBinding="chartDS@servletRequest"
                  />
                  <oem:chartColumn
                    displayLabelBinding="DATABASE@dbMsgs"
                    isKey="true"
                    sourceIndex="0"
                    />
                  <oem:chartColumn
                    displayLabelBinding="USED_SPACE_PCT@dbMsgs"
                    sourceIndex="1"
                    />
                </uix:contents>
              </oem:chart>
              </uix:cellFormat>
              <uix:cellFormat vAlign="top">
                <oem:chart titleBinding="LAST_7DAYS_DISKGROUP_USAGE_HIST_GB@osmMsgs"
                           chartType="timeSeriesChart"
                           format="svg"
                           orientation="vertical"
                           width="300"
                           height="200"
                           legendVisible="external"
                           colorPaletteBinding="histColors@diskGrp@servletRequest"
                           timeGranularity="DAY"
                           fill="cumulative"
                           yAxisLabelBinding="GBYTES@osmMsgs"
                           >
                  <uix:contents>
                    <oem:boundChartDataSource
                          chartDataSourceBinding="histChartDS@servletRequest"
                          />
                    <oem:chartColumn
                      isTimeColumn="true"
                      displayLabelBinding="DAYS@osmMsgs"
                      sourceIndex="0"
                      />

                    <%
                      String[] cols = (String[]) request.getAttribute("clientDBs");
                      int colnum = 1;
                      for(int i=0; i<cols.length; i++, colnum++)
                      {
                    %>
                    <oem:chartColumn
                      displayLabel="<%=cols[i]%>"
                      sourceIndex="<%=colnum%>"
                      />
                    <%
                    }
                    %>
                  </uix:contents>
                </oem:chart>
              </uix:cellFormat>
            </uix:rowLayout> <!-- end dg prop + charts table -->
            
               <!-- Advance Attributes -->
            <uix:rowLayout renderedBinding="versionGte11g@diskGrp@servletRequest">
            
            </uix:rowLayout>
          </uix:tableLayout>  
                  

            <!--member disks table -->
            <uix:header textBinding="MEMBER_DISKS@osmMsgs" 
                        size="1"
                        renderedBinding="showMemberDisksSection@servletRequest">
              <uix:stackLayout>
                <uix:separator>
                  <uix:spacer height="1"/>
                </uix:separator>
                <uix:rowLayout width="100%">
                  <uix:rowLayout hAlign="left" renderedBinding="showFilterCriteria@diskGrp@servletRequest">
                    <uix:styledText labeledNodeId="filterCriteria"
                                    textBinding="VIEW@osmMsgs"
                                    styleClass="OraPromptText" />
                    <uix:spacer width="5"/>
                    <uix:choice id="filterCriteria" name="filterCriteria"
                                selectedValueBinding="filterCriteria@diskGrp@servletRequest">
                      <uix:option textBinding="BY_DISK@osmMsgs" value="OSM_DISK_NAME"/>
                      <uix:option textBinding="FAILURE_GROUP@osmMsgs" value="FAILURE_GROUP"/>
                      <%-- uix:option textBinding="FAILURE_GROUP@osmMsgs" value="FAILURE_GROUP"/ --%>
                                  <%--selectedBinding="failGrpCriteria@diskGrp@servletRequest"/--%>
                    </uix:choice>
                    <uix:spacer width="5"/>
                    <uix:submitButton textBinding="GO@uixDBObjectBundle@servletRequest" name="event" value="filter"/>
                  </uix:rowLayout>

                  <uix:rowLayout hAlign="right">
                    <uix:submitButton
                      textBinding="ADD@osmMsgs"
                      name="event"
                      value="add"
                      formName="editDGForm"
                      disabledBinding="disableNonSysAsmOp@servletRequest"/>
                  </uix:rowLayout>

                </uix:rowLayout>

                <uix:switcher childNameBinding="diskFilterCriteria@diskGrp@servletRequest">
                  <uix:case name="true">
                    <uix:dataScope currentDataBinding="memberDisks@servletRequest">
                      <uix:table summaryBinding="MEMBER_DISKS@osmMsgs"
		      		                   width="100%" 
                                 formSubmitted="true"
                                 id="memberDisksDataSource"
                                 tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                 valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                 maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                                 blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>"
                                 partialRenderMode="self"
                                 alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest">
                        <uix:tableSelection>
                          <uix:multipleSelection shortDescBinding="SELECT@osmMsgs"
                                                 selectedBinding="<%= UIXDataSource.S_SELECT_ATTR %>">
                            <uix:pageButtonBar>
                            <uix:switcher childNameBinding="versionGte11g@diskGrp@servletRequest">
                             <uix:case name="false">
                              <uix:submitButton textBinding="CHECK@osmMsgs"
                                                name="event"
                                                value="<%= JspConstants.CHECK %>"/>
                            </uix:case>
                            </uix:switcher>
                              <uix:submitButton textBinding="RESIZE@osmMsgs"
                                                name="event" 
                                                value="<%= JspConstants.RESIZE %>"
                                                disabledBinding="disableNonSysAsmOp@servletRequest"/>
                              <uix:submitButton textBinding="ONLINE@osmMsgs"
                                                name="event" 
                                                renderedBinding="versionGte11g@diskGrp@servletRequest"
                                                disabledBinding="disableNon11gExt@servletRequest"
                                                value="<%= JspConstants.ONLINE %>"/>
                              <uix:submitButton textBinding="OFFLINE@osmMsgs"
                                                name="event" 
                                                renderedBinding="versionGte11g@diskGrp@servletRequest"
                                                disabledBinding="disableNon11gExt@servletRequest"
                                                value="<%= JspConstants.OFFLINE %>"/>
                              <uix:submitButton textBinding="BAD_BLOCK_RECOVERY@osmMsgs"
                                                name="event"
                                                value="badBlockRecovery"
                                                renderedBinding="versionGte11g@diskGrp@servletRequest" 
                                                disabledBinding="disableNonSysAsmOp@servletRequest"/>
                              <uix:submitButton textBinding="REMOVE@osmMsgs"
                                                name="event"
                                                value="<%= JspConstants.DELETE %>"
                                                disabledBinding="disableNonSysAsmOp@servletRequest"/>
                            </uix:pageButtonBar>
                          </uix:multipleSelection>
                        </uix:tableSelection>

                        <%-- Disk column --%>
                        <uix:column>
                          <uix:columnHeader>
                            <uix:sortableHeader textBinding="DISK@osmMsgs"
                                                sortableBinding="<%= MemberDisksDataSource.S_SORT_DISK_COL %>" />
                          </uix:columnHeader>
                          <uix:columnFormat columnDataFormat="textFormat"/>
                      <uix:switcher childNameBinding="licenseMemberDisk@servletRequest">
                        <uix:case name="true">
                          <uix:link textBinding="<%= MemberDisksDataSource.S_DISK_COL %>"
                                    destinationBinding="<%= MemberDisksDataSource.S_DISK_DEST %>"/>
                        </uix:case>
                        <uix:case name="false">
                          <uix:styledText textBinding="<%= MemberDisksDataSource.S_DISK_COL %>"/>
                        </uix:case>
                      </uix:switcher>
                        </uix:column>

                        <%-- Failure group column --%>
                        <uix:column>
                          <uix:columnHeader>
                            <uix:sortableHeader textBinding="FAILGROUP@osmMsgs"
                                                sortableBinding="<%= MemberDisksDataSource.S_SORT_FAIL_COL %>" />
                          </uix:columnHeader>
                          <uix:columnFormat columnDataFormat="textFormat"/>
                          <uix:styledText textBinding="<%= MemberDisksDataSource.S_FAIL_COL %>"/>
                        </uix:column>

                        <%-- Path column --%>
                        <uix:column>
                          <uix:columnHeader>
                            <uix:sortableHeader textBinding="PATH@osmMsgs"
                                                sortableBinding="<%= MemberDisksDataSource.S_SORT_PATH_COL %>" />
                          </uix:columnHeader>
                          <uix:columnFormat columnDataFormat="textFormat"/>
                          <uix:styledText textBinding="<%= MemberDisksDataSource.S_PATH_COL %>"/>
                        </uix:column>

                        <%-- Library column --%>
                        <uix:column>
                          <uix:columnHeader>
                            <uix:sortableHeader textBinding="LIBRARY@osmMsgs"
                                                sortableBinding="<%= MemberDisksDataSource.S_SORT_LIBRARY_COL %>" />
                          </uix:columnHeader>
                          <uix:columnFormat columnDataFormat="textFormat"/>
                          <uix:styledText textBinding="<%= MemberDisksDataSource.S_LIBRARY_COL %>"/>
                        </uix:column>

                        <%-- Grid disk column --%>
                        <uix:column renderedBinding="showGridDisk@diskGrp@servletRequest" >
                          <uix:columnHeader>
                            <uix:sortableHeader textBinding="GRID_DISK@osmMsgs"
                                                sortableBinding="<%= MemberDisksDataSource.S_SORT_GRID_DISK_COL %>" />
                          </uix:columnHeader>
                          <uix:columnFormat columnDataFormat="textFormat"/>
                          <uix:link textBinding="<%= MemberDisksDataSource.S_GRID_DISK_COL %>"
                                    destinationBinding="<%= MemberDisksDataSource.S_GRID_DISK_DEST %>"/>
                        </uix:column>

                        <%-- Read/Write error column --%>
                        <uix:column>
                          <uix:columnHeader>
                            <uix:sortableHeader textBinding="READ_WRITE_ERR@osmMsgs"
                                                sortableBinding="<%= MemberDisksDataSource.S_SORT_RW_ERRS_COL %>" />
                          </uix:columnHeader>
                          <uix:columnFormat columnDataFormat="numberFormat"/>
                          <uix:styledText textBinding="<%= MemberDisksDataSource.S_RW_ERRS_COL %>"/>
                        </uix:column>

                        <%-- State column --%>
                        <uix:column>
                          <uix:columnHeader>
                            <uix:sortableHeader textBinding="STATE@osmMsgs"
                                                sortableBinding="<%= MemberDisksDataSource.S_SORT_STATE_COL %>" />
                          </uix:columnHeader>
                          <uix:columnFormat columnDataFormat="textFormat"/>
                          <uix:styledText textBinding="<%= MemberDisksDataSource.S_STATE_COL %>"/>
                        </uix:column>
                        
                         <%-- MODE column--%>
                        <uix:column renderedBinding="versionGte11g@diskGrp@servletRequest">
                          <uix:columnHeader>
                            <uix:sortableHeader textBinding="MODE@osmMsgs"
                                                sortableBinding="<%= MemberDisksDataSource.S_SORT_MODE_COL %>" />
                          </uix:columnHeader>
                           <uix:flowLayout>
                              <uix:contents>
                              <uix:spacer width="1"/>
                                  <uix:image sourceBinding="<%=MemberDisksDataSource.S_MODE_COL_ICON%>" shortDescBinding="<%= MemberDisksDataSource.S_MODE_COL %>"/>
                                 <uix:spacer width="5"/>
                                 <uix:columnFormat columnDataFormat="textFormat"/>
                             <%-- <uix:styledText textBinding="<%=MemberDisksDataSource.S_MODE_COL%>"/> --%>
                              </uix:contents>
                             </uix:flowLayout>  
                        </uix:column>
                  
                        <%-- Size column --%>
                        <uix:column>
                          <uix:columnHeader>
                            <uix:sortableHeader textBinding="SIZE_GB@osmMsgs"
                                                sortableBinding="<%= MemberDisksDataSource.S_SORT_SIZE_COL %>" />
                          </uix:columnHeader>
                          <uix:columnFormat columnDataFormat="numberFormat"/>
                          <uix:styledText textBinding="<%= MemberDisksDataSource.S_SIZE_COL %>"/>
                        </uix:column>

                        <%-- Used column --%>
                        <uix:column>
                          <uix:columnHeader>
                            <uix:sortableHeader textBinding="USED_GB@osmMsgs"
                                                sortableBinding="<%= MemberDisksDataSource.S_SORT_USED_COL %>" />
                          </uix:columnHeader>
                          <uix:columnFormat columnDataFormat="numberFormat"/>
                       
                           
                                <uix:styledText textBinding="<%= MemberDisksDataSource.S_USED_COL %>"/>
                             
                        
                        </uix:column>
                      
                        <%-- Used percentage column --%>
                        <uix:column>
                          <uix:columnHeader>
                            <uix:sortableHeader textBinding="USED_PERCENT@osmMsgs"
                                                sortableBinding="<%= MemberDisksDataSource.S_SORT_USED_PCT_COL %>" />
                          </uix:columnHeader>
                          <%--uix:columnFormat columnDataFormat="iconButtonFormat"/--%>
                             <uix:contents>
                               <uix:flowLayout>
                              <uix:separator>
                                  <uix:spacer width="1" height="0"/>
                              </uix:separator>
                              <uix:contents>
                                  <uix:include nodeBinding="<%= MemberDisksDataSource.S_USED_PCT_COL_IMG %>"/>
                                 <uix:styledText textBinding="<%= MemberDisksDataSource.S_USED_PCT_COL %>"/>
                              </uix:contents>
                             </uix:flowLayout>
                          </uix:contents>
                        </uix:column>
                                                <%-- Failgroup type column --%>
                        <uix:column renderedBinding="versionGte11g@diskGrp@servletRequest"> 
                          <uix:columnHeader>
                            <uix:sortableHeader textBinding="FAILGROUP_TYPE@osmMsgs"
                                                sortableBinding="<%= MemberDisksDataSource.S_SORT_FAILGROUP_TYPE_COL %>" />
                          </uix:columnHeader>
                          <%--uix:columnFormat columnDataFormat="iconButtonFormat"/--%>
                             <uix:contents>
                               <uix:flowLayout>
                              <uix:separator>
                                  <uix:spacer width="1" height="0"/>
                              </uix:separator>
                              <uix:contents>
                                 <uix:styledText textBinding="<%= MemberDisksDataSource.S_FAILGROUP_TYPE_COL %>"/>
                              </uix:contents>
                             </uix:flowLayout>
                          </uix:contents>
                        </uix:column>
                        
                        
                        <%-- Fragmentation % --%>
                        <%-- <uix:column renderedBinding="versionGte11g@diskGrp@servletRequest">
                          <uix:columnHeader>
                            <uix:sortableHeader textBinding="FRAGMENTATION@osmMsgs"
                                                sortableBinding="<%= MemberDisksDataSource.S_SORT_FRAG_COL %>" />
                          </uix:columnHeader>
                            <uix:columnFormat columnDataFormat="numberFormat"/>
                            <uix:styledText textBinding="<%= MemberDisksDataSource.S_FRAG_COL %>"/>
                        </uix:column>  --%>                        
                        
                      </uix:table>
                      <uix:spacer height="3"/>
                       <uix:rowLayout>
                        <uix:cellFormat hAlign="right" width="30">
                          <uix:image source="/em/images/ok.gif" shortDesc="ONLINE"/>
                        </uix:cellFormat> 
                        <uix:cellFormat width="40">
                          <uix:messagePrompt promptBinding="ONLINE@dbMsgs"/>
                        </uix:cellFormat> 
                        <uix:cellFormat hAlign="right" width="30">
                          <uix:image source="/em/images/database/storage/off_line.gif" shortDesc="OFFLINE"/>
                        </uix:cellFormat>
                        <uix:cellFormat>
                          <uix:messagePrompt promptBinding="OFFLINE@dbMsgs"/>
                        </uix:cellFormat>
                      </uix:rowLayout>
                    </uix:dataScope>
                   
                  </uix:case>
                  <uix:case name="false">
                    <uix:hGrid id="failgroups"
                               width="100%"
                               alternateTextBinding="DG_IO_ALT_TEXT@osmMsgs"
                               destinationBinding="defaultURL@servletRequest"
                               summaryBinding="DG_IO_SUMMARY@osmMsgs"
                               columnFormatsBinding="columnFormats@diskGrp@servletRequest"
                               columnHeaderDataBinding="columnHeaderData@diskGrp@servletRequest"
                               treeDataBinding="treeData@diskGrp@servletRequest"
                               proxyBinding="proxy@servletRequest"
                               formSubmitted="true">
                    <uix:nodeStamp>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:styledText textBinding="FAILGROUP@osmMsgs"/>
                        </uix:columnHeader>
                        <uix:flowLayout>
                        <uix:image sourceBinding="source"
                                   heightBinding="height"
                                   widthBinding="width"/>
                        <uix:spacer width="5"/>
                        <uix:styledText textBinding="text"
                                        destinationBinding="destination"/>
                        </uix:flowLayout>
                      </uix:column>
                    </uix:nodeStamp>

                    <uix:columnHeaderStamp>
                      <uix:text textBinding="text"/>
                    </uix:columnHeaderStamp>

                    <uix:styledText textBinding="path"/>
                    <uix:styledText textBinding="library"/>
                    <uix:styledText renderedBinding="showGridDisk@diskGrp@servletRequest" textBinding="gridDisk"/>
                    <uix:styledText textBinding="rwerrs"/>
                    <uix:styledText textBinding="state"/>
                    <uix:styledText renderedBinding="versionGte11g@diskGrp@servletRequest" textBinding="mode"/>
                    <uix:styledText textBinding="totalGB"/>
                    <uix:styledText textBinding="usedGB"/>
                    <uix:styledText textBinding="usedPercent"/>
                    <uix:styledText renderedBinding="versionGte11g@diskGrp@servletRequest" textBinding="fgtype"/> 
                    <%-- <uix:styledText renderedBinding="versionGte11g@diskGrp@servletRequest" textBinding="fragmentation"/> --%>
                    <uix:formValue name="rowvalue" valueBinding="text"/>
                    <uix:formValue name="rowtype" valueBinding="rowtype"/>

                    <uix:tableSelection>
                      <uix:singleSelection shortDescBinding="SELECT@osmMsgs"
                                           selectedIndex="0">
                        <uix:pageButtonBar>
                          <uix:switcher childNameBinding="versionGte11g@diskGrp@servletRequest">
                             <uix:case name="false">
                              <uix:submitButton textBinding="CHECK@osmMsgs"
                                                name="event"
                                                value="<%= JspConstants.CHECK %>"/>
                            </uix:case>
                            </uix:switcher>
                          <uix:submitButton textBinding="RESIZE@osmMsgs"
                                            name="event"
                                            value="<%= JspConstants.RESIZE %>"
                                            disabledBinding="disableNonSysAsmOp@servletRequest"/>
                          <uix:submitButton textBinding="ONLINE@osmMsgs"
                                                name="event" 
                                                renderedBinding="versionGte11g@diskGrp@servletRequest"
                                                disabledBinding="disableNon11gExt@servletRequest"
                                                value="<%= JspConstants.ONLINE %>"/>
                          <uix:submitButton textBinding="OFFLINE@osmMsgs"
                                                name="event" 
                                                renderedBinding="versionGte11g@diskGrp@servletRequest"
                                                disabledBinding="disableNon11gExt@servletRequest"
                                                value="<%= JspConstants.OFFLINE %>"/>
                          <uix:submitButton textBinding="BAD_BLOCK_RECOVERY@osmMsgs"
                                                name="event"
                                                value="badBlockRecovery"
                                                disabledBinding="disableNonSysAsmOp@servletRequest"
                                                renderedBinding="versionGte11g@diskGrp@servletRequest"/>
                          <uix:submitButton textBinding="REMOVE@osmMsgs"
                                            name="event"
                                            value="<%= EventNames.DELETE %>"
                                            disabledBinding="disableNonSysAsmOp@servletRequest"/>
                        </uix:pageButtonBar>
                      </uix:singleSelection>
                    </uix:tableSelection>
                  </uix:hGrid>
                </uix:case>
              </uix:switcher>              
            </uix:stackLayout>
            </uix:header>
          </uix:stackLayout>
        </uix:subTabLayout>
      </uix:pageLayout>
    </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>


