<%--
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. 
 * All rights reserved. 
  -- Page:        checkOFS.jsp
  -- Controller:  oracle.sysman.db.adm.osm.ofs.OFSController
  --
  -- Description: Dismount Oracle File System
  --
  --  MODIFIED    (MM/DD/YY)
  --  xchen       06/03/09 - fsck root privilege command ER bug 8553107
  --  chanchan    02/02/09 - Add OAC ADA supports
  --  chanchan    03/16/06 - Creation 
  --%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.osm.ofs.Constant" %>
<%@ page import="oracle.sysman.emo.adm.osm.ofs.OFSbean" %>
<%@ page import="oracle.sysman.db.adm.ParameterNames" %>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="msg" class="oracle.sysman.db.rsc.osm.ofs.OfsObjectMsg" />
  <uix:bundle name="msgDB" class="oracle.sysman.db.rsc.inst.DBMsg"/>
  <uix:bundle name="msgDG" class="oracle.sysman.db.dg.rsc.DGMsg"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <db:form name="pageForm" method="POST" destination="<%= Constant.OFS_CONTROLLER %>" copyParams="target,type">
        <uix:formValue name="<%= ParameterNames.PAGE_NAME %>" value="<%= Constant.CHECK_OFS_PAGE %>" />
        <uix:pageLayout titleBinding="header@ofsBean@servletRequest">
        <%@ include file="/database/global.jspf" %>
        <oem:messageBox messageType="info" errorTableBinding="info@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error" errorTableBinding="error@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
            <uix:tableLayout cellSpacing="5">
              <uix:rowLayout>
                <uix:cellFormat>
                  <uix:spacer height="10" width="10" />
                </uix:cellFormat>
                <uix:cellFormat>
                  <uix:styledText styleClass="OraPromptText" textBinding="INST_CHECK_OFS@msg" renderedBinding="SudoSupport@ofsBean@servletRequest"/>
                  <uix:styledText styleClass="OraPromptText" textBinding="INST_CHECK_OFS_LINUX@msg" renderedBinding="NoSudoSupport@ofsBean@servletRequest" />
		  <uix:tip renderedBinding="NoSudoSupport@ofsBean@servletRequest">
         	    <uix:styledText textBinding="MSG_ROOT_OPERATION@msg"/>
		  </uix:tip>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

            <uix:tableLayout cellSpacing="0">
              <uix:rowLayout>
                <uix:cellFormat>
                  <uix:spacer height="10" width="40" />
                </uix:cellFormat>
                <uix:cellFormat>
                  <uix:tableLayout cellSpacing="5">
      		  <uix:rowLayout>
	                <uix:cellFormat hAlign="right" vAlign="top">
 				<uix:messagePrompt promptBinding="OPTION@msg" />
	                </uix:cellFormat>
	                <uix:cellFormat>
                        <uix:stackLayout>
	                        <uix:contents>
	                          <uix:radioButton name="<%= OFSbean.ATTR_OPTION %>" 
	                                textBinding="CHECK_OPT_FIX_ERRORS@msg" selectedValueBinding="option@ofsBean@servletRequest" value="<%= OFSbean.CHECK_OPTION_FIX_ERRORS %>"/>                          
	                          <uix:radioButton name="<%= OFSbean.ATTR_OPTION %>"
	                                textBinding="CHECK_OPT_REPORT_ERRORS@msg" selectedValueBinding="option@ofsBean@servletRequest" value="<%= OFSbean.CHECK_OPTION_REPORT_ERRORS %>"/>                          
	                        </uix:contents>                      	
                        </uix:stackLayout>
                      </uix:cellFormat>
        		  </uix:rowLayout>
                  </uix:tableLayout>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

            <uix:tableLayout cellSpacing="0" renderedBinding="SudoSupport@ofsBean@servletRequest">
              <uix:rowLayout>
                <uix:cellFormat>
                  <uix:spacer height="10" width="25" />
                </uix:cellFormat>
                <uix:cellFormat>
			<uix:header textBinding="JOB@msg">
	              <uix:tableLayout cellSpacing="5">
        		    <uix:rowLayout>
	                  <uix:cellFormat hAlign="right" vAlign="top">
				  <uix:messagePrompt required="yes" promptBinding="JOB_NAME@msg" labeledNodeId="JOB_NAME"/>
	                  </uix:cellFormat>
	                  <uix:cellFormat hAlign="left">
                          <uix:stackLayout>
                            <uix:textInput name="<%= OFSbean.ATTR_JOB_NAME %>" textBinding="jobName@ofsBean@servletRequest" columns="80" shortDescBinding="JOB_NAME@msg" id="JOB_NAME"/>
                            <uix:messageText messageBinding="(JOB_NAME@msg)@error@servletRequest" messageType="error"/>
                          </uix:stackLayout>
	                  </uix:cellFormat>
        		    </uix:rowLayout>
        		    <uix:rowLayout>
	                  <uix:cellFormat hAlign="right" vAlign="top">
				  <uix:messagePrompt promptBinding="DESCRIPTION@msg" labeledNodeId="DESCRIPTION"/>
	                  </uix:cellFormat>
	                  <uix:cellFormat hAlign="left">
                          <uix:stackLayout>
                            <uix:textInput name="<%= OFSbean.ATTR_DESCRIPTION %>" textBinding="description@ofsBean@servletRequest" columns="80" shortDescBinding="DESCRIPTION@msg" id="DESCRIPTION" />
                          </uix:stackLayout>
	                  </uix:cellFormat>
        		    </uix:rowLayout>
	              </uix:tableLayout>
			</uix:header>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
    	  <%@ include file="ofsRelatedLink.jsp" %>

          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:submitButton textBinding="SHOW_COMMAND@msg" name="event" value="<%= Constant.EVENT_SHOW_COMMAND %>" formName="pageForm" renderedBinding="SudoSupport@ofsBean@servletRequest"/>
              <uix:submitButton textBinding="GENERATE_COMMAND@msg" name="event" value="<%= Constant.EVENT_SHOW_COMMAND %>" formName="pageForm" renderedBinding="NoSudoSupport@ofsBean@servletRequest"/>
              <uix:button textBinding="RETURN@msg" destinationBinding="cancelURL@ofsBean@servletRequest" renderedBinding="NoSudoSupport@ofsBean@servletRequest" />
	      <uix:button textBinding="CANCEL@msg" destinationBinding="cancelURL@ofsBean@servletRequest" renderedBinding="SudoSupport@ofsBean@servletRequest" />
              <uix:submitButton textBinding="OK@msg" name="event" value="<%= Constant.EVENT_OK %>" formName="pageForm" renderedBinding="SudoSupport@ofsBean@servletRequest" />
            </uix:pageButtonBar>
          </uix:pageButtons>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
