<%--
  -- Page:        createOFS.jsp
  -- Controller:  oracle.sysman.db.adm.osm.ofs.OFSController
  --
  -- Description: Create Oracle File System
  --
  --  MODIFIED    (MM/DD/YY)
  --  chanchan    04/03/08 - Add Related Links to Open Telnet Session
  --  chanchan    04/05/06 - 
  --  evelur      03/17/06 - 
  --  chanchan    03/13/06 - Creation 
  --%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<db:script src="/database/remoteBrowser/remoteBrowser.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.osm.ofs.Constant" %>
<%@ page import="oracle.sysman.emo.adm.osm.ofs.OFSbean" %>
<%@ page import="oracle.sysman.db.adm.ParameterNames" %>
<script language="javascript">
function setMountOptions()
{
  var bDisable = (document.forms[0].<%= OFSbean.ATTR_OPTION_MOUNT %>.checked != "1");
  document.forms[0].<%= OFSbean.ATTR_MOUNT_POINT %>.disabled = bDisable;
  document.forms[0].<%= OFSbean.ATTR_HOST_USERNAME %>.disabled = bDisable;
  document.forms[0].<%= OFSbean.ATTR_HOST_PASSWORD %>.disabled = bDisable;
}
</script>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="osmMsg" class="oracle.sysman.db.rsc.osm.OsmObjectMsg" />
  <uix:bundle name="msg" class="oracle.sysman.db.rsc.osm.ofs.OfsObjectMsg" />
  <uix:bundle name="msgDB" class="oracle.sysman.db.rsc.inst.DBMsg"/>
  <uix:bundle name="msgDG" class="oracle.sysman.db.dg.rsc.DGMsg"/>
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:metaContainer>
      <db:script src="/database/LOV.js" />
    </uix:metaContainer>
    <uix:body onLoad="setMountOptions()" >
      <db:form name="pageForm" method="POST" destination="<%= Constant.OFS_CONTROLLER %>" copyParams="target,type">
        <uix:formValue name="<%= ParameterNames.PAGE_NAME %>" value="<%= Constant.CREATE_OFS_PAGE %>" />
        <uix:pageLayout titleBinding="CREATE_OFS@msg">
          <%@ include file="/database/global.jspf" %>          
	  <oem:messageBox messageType="confirmation" errorTableBinding="confirmation@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error" errorTableBinding="error@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
            <uix:tableLayout cellSpacing="5" width="100%">
              <uix:rowLayout>
                <uix:cellFormat hAlign="left">
                  <uix:styledText styleClass="OraPromptText" textBinding="INST_CREATE_OFS@msg"/>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
            <uix:tableLayout cellSpacing="5">
              <uix:rowLayout>
                <uix:cellFormat>
                  <uix:spacer height="10" width="20" />
                  <uix:messagePrompt labeledNodeId="volDevice" promptBinding="VOLUME_DEVICE@msg" required="yes"/>
                </uix:cellFormat>
                <uix:cellFormat>
                    <uix:lovField name="<%= OFSbean.ATTR_VOLUME_DEVICE %>" id="volDevice"
                                  textBinding="volDevice@ofsBean@servletRequest"
                                  columns="45"
                                  searchDescBinding="VOLUME_DEVICE@msg"
  					    shortDescBinding="VOLUME_DEVICE@msg"
                                  onClick="setWindowSize(900,700);preserveCase();startLov('volDevice', 'ListVolumeDevice')"/>
                  <uix:spacer height="10" width="10" />
                  <uix:submitButton textBinding="CREATE_VOLUME@msg" 
                                      shortDescBinding="CREATE_VOLUME@msg" 
                                      name="event" 
                                      value="<%= Constant.EVENT_CREATE_VOLUME %>"/>                                    
                </uix:cellFormat>                                 
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat>
                </uix:cellFormat>
                <uix:cellFormat>
                  <uix:messageText messageBinding="(VOLUME_DEVICE@msg)@error@servletRequest" messageType="error"/>
                </uix:cellFormat>                                 
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" vAlign="top" wrappingDisabled="true">
                  <uix:messagePrompt labeledNodeId="VOLUME_LABEL" promptBinding="VOLUME_LABEL@msg"/>
                </uix:cellFormat>                      
                <uix:cellFormat>
                  <uix:stackLayout>
                    <uix:textInput name="<%= OFSbean.ATTR_VOLUME_LABEL %>" shortDescBinding="VOLUME_LABEL@msg" id="VOLUME_LABEL" 
    	                           columns="70" textBinding="volLabel@ofsBean@servletRequest" maximumLength="64"/>
                    <uix:messageText messageBinding="(VOLUME_LABEL@msg)@error@servletRequest" messageType="error"/>
                  </uix:stackLayout>
                </uix:cellFormat>
              </uix:rowLayout>    
            </uix:tableLayout>
            <uix:spacer height="10" width="10" />

            <uix:tableLayout cellPadding="0" cellSpacing="0" width="100%" renderedBinding="SudoSupport@ofsBean@servletRequest">
              <uix:rowLayout>
                <uix:cellFormat>                                           
                    <uix:checkBox checkedBinding="optionMount@ofsBean@servletRequest" name="<%= OFSbean.ATTR_OPTION_MOUNT %>"
            			    textBinding="HINT_MOUNT_OFS@msg" styleClass="OraHeaderSub" onClick="setMountOptions()" />
                </uix:cellFormat>                                           
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat styleClass="OraBGAccentDark">                                           
                </uix:cellFormat>                                           
              </uix:rowLayout>
            </uix:tableLayout>

            <uix:tableLayout cellSpacing="0" hAlign="center" width="100%" renderedBinding="SudoSupport@ofsBean@servletRequest">
              <uix:rowLayout>
                <uix:cellFormat width="60%" vAlign="top">                
                   <uix:header textBinding="MOUNT_OPTIONS@msg">
                     <uix:tableLayout cellSpacing="5">
                       <uix:rowLayout>
                         <uix:cellFormat vAlign="top" wrappingDisabled="true">
                           <uix:messagePrompt labeledNodeId="mountPoint" promptBinding="MOUNT_POINT@msg"/>
                         </uix:cellFormat>
                         <uix:cellFormat>
                           <uix:stackLayout>
                             <uix:messageLovField name="<%= OFSbean.ATTR_MOUNT_POINT %>" 
                                                  id="mountPoint"
                                                  textBinding="mountPoint@ofsBean@servletRequest"
                                                  columns="70"
                                                  searchDescBinding="MOUNT_POINT@msg"
						  shortDescBinding="MOUNT_POINT@msg"
                                                  onClick = '<%= "if (document.forms[0]."+OFSbean.ATTR_OPTION_MOUNT+".checked == \'1\') startDirectoryBrowser(\'" + OFSbean.ATTR_MOUNT_POINT + "\');" %>' />							
	                       <uix:messageText messageBinding="(MOUNT_POINT@msg)@error@servletRequest" messageType="error"/>
                             <uix:styledText styleClass="OraInlineInfoText" textBinding="HINT_MOUNT_POINT@msg" />                      
                           </uix:stackLayout>                                                                   
                         </uix:cellFormat>                          
	               </uix:rowLayout>  
                  </uix:tableLayout>  
                 </uix:header>               
                </uix:cellFormat>
                <uix:cellFormat width="40%" hAlign="right" vAlign="top" renderedBinding="SudoSupport@ofsBean@servletRequest">                 
      	 	<%@ include file="credentials.jsp" %>
                </uix:cellFormat>
            </uix:rowLayout>
          </uix:tableLayout>

            <uix:tableLayout cellPadding="0" cellSpacing="0" width="100%" renderedBinding="NoSudoSupport@ofsBean@servletRequest">
              <uix:rowLayout>
                <uix:cellFormat>                                           
                <uix:spacer height="10" width="5" />
                </uix:cellFormat>                                           
                <uix:cellFormat>                                           
                    <uix:checkBox checkedBinding="optionMount@ofsBean@servletRequest" name="<%= OFSbean.ATTR_OPTION_MOUNT %>"
            			    textBinding="REGISTER_MOUNT_POINT@msg" styleClass="OraHeaderSub" onClick="setMountOptions()" />
                </uix:cellFormat>                                           
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat>                                           
                </uix:cellFormat>                                           
                <uix:cellFormat styleClass="OraBGAccentDark">                                           
                </uix:cellFormat>                                           
              </uix:rowLayout>
            </uix:tableLayout>

          <uix:tableLayout cellSpacing="0" hAlign="center" width="100%" renderedBinding="NoSudoSupport@ofsBean@servletRequest">
            <uix:rowLayout>
              <uix:cellFormat>                                           
                <uix:spacer height="10" width="15" />
              </uix:cellFormat>                                           
              <uix:cellFormat width="96%" vAlign="top">                
                     <uix:tableLayout cellSpacing="5">
            <uix:rowLayout>
              <uix:cellFormat columnSpan="2">                                           
                 <uix:styledText styleClass="OraPromptText" textBinding="REGISTER_MOUNT_POINT_NONRAC@msg" renderedBinding="isSingleInstance@ofsBean@servletRequest"/>
                 <uix:styledText styleClass="OraPromptText" textBinding="REGISTER_MOUNT_POINT_RAC@msg" renderedBinding="isRac@ofsBean@servletRequest"/>
              </uix:cellFormat>                                           
            </uix:rowLayout>
                        <uix:rowLayout>
                         <uix:cellFormat vAlign="top" hAlign="right" wrappingDisabled="true">
                           <uix:messagePrompt labeledNodeId="mountPoint" promptBinding="MOUNT_POINT@msg"/>
                         </uix:cellFormat>
                         <uix:cellFormat>
                           <uix:stackLayout>
                             <uix:messageLovField name="<%= OFSbean.ATTR_MOUNT_POINT %>" 
                                                  id="mountPoint"
                                                  textBinding="mountPoint@ofsBean@servletRequest"
                                                  columns="70"
                                                  searchDescBinding="MOUNT_POINT@msg"
								  shortDescBinding="MOUNT_POINT@msg"
                                                  onClick = '<%= "if (document.forms[0]."+OFSbean.ATTR_OPTION_MOUNT+".checked == \'1\') startDirectoryBrowser(\'" + OFSbean.ATTR_MOUNT_POINT + "\');" %>' />							
	                     <uix:messageText messageBinding="(MOUNT_POINT@msg)@error@servletRequest" messageType="error"/>
                             <uix:styledText styleClass="OraInlineInfoText" textBinding="HINT_MOUNT_POINT@msg" renderedBinding="SudoSupport@ofsBean@servletRequest"/>                      
                             <uix:styledText styleClass="OraInlineInfoText" textBinding="HINT_MOUNT_POINT_NO_SUDO@msg" renderedBinding="NoSudoSupport@ofsBean@servletRequest"/>                      
                           </uix:stackLayout>                                                                   
                         </uix:cellFormat>                          
	               </uix:rowLayout>  
                  </uix:tableLayout>  
                </uix:cellFormat>
            </uix:rowLayout>
          </uix:tableLayout>


	    <uix:header textBinding="RELATED_LINKS@msgDB">
	      <uix:tableLayout width="100%"> 
		<uix:rowLayout>
		  <uix:cellFormat>
		    <db:link textBinding="OPEN_TELNET_SESSION@msgDG"
			     destinationBinding="telnetURL@servletRequest"/>
		  </uix:cellFormat>
		</uix:rowLayout>
	      </uix:tableLayout>
	    </uix:header>
	    
          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:submitButton textBinding="SHOW_COMMAND@msg" name="event" value="<%= Constant.EVENT_SHOW_COMMAND %>" formName="pageForm" />
		      <uix:button textBinding="CANCEL@msg" destinationBinding="cancelURL@ofsBean@servletRequest"/>
              <uix:submitButton textBinding="OK@msg" name="event" value="<%= Constant.EVENT_OK %>" formName="pageForm" />
            </uix:pageButtonBar>
          </uix:pageButtons>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
