<%--
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates.All rights reserved. 
  -- Page:        createSnapshot.jsp
  -- Controller:  oracle.sysman.db.adm.osm.ofs.OFSController
  --
  -- Description: Mount Oracle File System
  --
  --  MODIFIED    (MM/DD/YY)
  --  chanchan    01/30/09 - Support OAC ADA
  --  chanchan    11/07/07 - Creation 
  --%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<db:script src="/database/remoteBrowser/remoteBrowser.js"/>
<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.osm.ofs.Constant" %>
<%@ page import="oracle.sysman.emo.adm.osm.ofs.OFSbean" %>
<%@ page import="oracle.sysman.db.adm.ParameterNames" %>
<script language="javascript">
function popDirBrowser(dirPath)
{
  setDefaultDirectory(dirPath, '<%= OFSbean.ATTR_FILE_PATH_SEPARATOR %>');
  startDirectoryListing();
  return false;
}
</script>

<uix:renderingContext id="renderingContext">
<db:script src="/database/remoteBrowser/remoteBrowser.js"/>
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="msg" class="oracle.sysman.db.rsc.osm.ofs.OfsObjectMsg" />
  <uix:bundle name="msgDB" class="oracle.sysman.db.rsc.inst.DBMsg"/>
  <uix:bundle name="msgDG" class="oracle.sysman.db.dg.rsc.DGMsg"/>
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <db:form name="pageForm" method="POST" destination="<%= Constant.OFS_CONTROLLER %>" copyParams="target,type,hostName">
        <uix:formValue name="<%= ParameterNames.PAGE_NAME %>" value="<%= Constant.CREATE_SNAPSHOT_PAGE %>" />
        <uix:formValue name="<%= OFSbean.ATTR_MUST_DELETE_OLDEST_SNAPSHOT %>" valueBinding="mustDeleteOldestSnapshot@ofsBean@servletRequest" />
        <uix:pageLayout titleBinding="header@ofsBean@servletRequest">
          <%@ include file="/database/global.jspf" %>
          <oem:messageBox messageType="error" errorTableBinding="error@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
            <uix:tableLayout width="100%" cellSpacing="5">
              <uix:rowLayout width="100%">
                <uix:cellFormat hAlign="center" vAlign="top" width="30%" wrappingDisabled="true">
                  <uix:tableLayout cellSpacing="5">
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right" wrappingDisabled="true">
                        <uix:messagePrompt promptBinding="NUMBER_SNAPSHOT@msg" />
                      </uix:cellFormat>
                      <uix:cellFormat wrappingDisabled="true">
                        <uix:styledText styleClass="OraDataText" textBinding="snapshotCount@ofsBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right" wrappingDisabled="true">
                        <uix:messagePrompt promptBinding="TOTAL_FREE_SPACE@msg" />
                      </uix:cellFormat>
                      <uix:cellFormat wrappingDisabled="true">
                        <uix:styledText styleClass="OraDataText" textBinding="ofsFreeSize@ofsBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:tableLayout>
                </uix:cellFormat>
                <uix:cellFormat vAlign="top" width="70%" wrappingDisabled="true">
                  <uix:tableLayout cellSpacing="5">
                    <uix:rowLayout renderedBinding="hasSnapshot@ofsBean@servletRequest">
                      <uix:cellFormat hAlign="right" wrappingDisabled="true">
                        <uix:messagePrompt promptBinding="LAST_SNAPSHOT_NAME@msg" />
                      </uix:cellFormat>
                      <uix:cellFormat wrappingDisabled="true">
                        <uix:link textBinding="lastSnapshotName@ofsBean@servletRequest" 
				  onClickBinding="lastSnapshotBrowser@ofsBean@servletRequest" />
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout renderedBinding="hasSnapshot@ofsBean@servletRequest">
                      <uix:cellFormat hAlign="right" wrappingDisabled="true">
                        <uix:messagePrompt promptBinding="LAST_SNAPSHOT_TIME@msg" />
                      </uix:cellFormat>
                      <uix:cellFormat wrappingDisabled="true">
                        <uix:styledText styleClass="OraDataText" textBinding="lastSnapshotTime@ofsBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:tableLayout>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

            <uix:separator>
              <uix:spacer height="1"/>
            </uix:separator>

            <uix:tableLayout cellSpacing="5">
              <uix:rowLayout>
                <uix:cellFormat>
                  <uix:spacer height="10" width="10" />
                </uix:cellFormat>
                <uix:cellFormat>
                  <uix:styledText styleClass="OraPromptText" textBinding="CREATE_SNAPSHOT_INST@msg"/>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

            <uix:tableLayout cellSpacing="0">
              <uix:rowLayout>                    
                  <uix:cellFormat wrappingDisabled="true" hAlign="left" vAlign="top">
                    <uix:contents>     
	             <uix:spacer height="10" width="30" />
                      <uix:messagePrompt required="yes" promptBinding="SNAPSHOT_NAME@msg" labeledNodeId="SNAPSHOT_NAME" />               
	                <uix:textInput name="<%= OFSbean.ATTR_SNAPSHOT_NAME %>" id="SNAPSHOT_NAME" columns="60"
	                                 noAutoComplete="true" textBinding="snapshotName@ofsBean@servletRequest" />
                        <uix:messageText messageBinding="(SNAPSHOT_NAME@msg)@error@servletRequest" messageType="error"/>
                      </uix:contents>  
                   </uix:cellFormat>
              </uix:rowLayout>

              <uix:rowLayout renderedBinding="hasSnapshot@ofsBean@servletRequest">                    
                  <uix:cellFormat wrappingDisabled="true" hAlign="left" vAlign="top">
	            <uix:spacer height="10" width="25" />
		    <uix:checkBox name="<%= OFSbean.ATTR_DELETE_OLDEST %>"
		                  textBinding="msgDeleteOldestSnapshot@ofsBean@servletRequest"
				  onClick='if (document.forms[0].mustDeleteOldestSnapshot.value) this.checked="true"'
				  checkedBinding="deleteOldest@ofsBean@servletRequest" />
                  <uix:tableLayout cellSpacing="5">
                    <uix:rowLayout>
	              <uix:cellFormat>
        	        <uix:spacer height="5" width="60" />
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="right" wrappingDisabled="true">
                        <uix:messagePrompt promptBinding="OLDEST_SNAPSHOT_NAME@msg" />
                      </uix:cellFormat>
                      <uix:cellFormat wrappingDisabled="true">
                        <uix:link textBinding="oldestSnapshotName@ofsBean@servletRequest"
				  onClickBinding="oldestSnapshotBrowser@ofsBean@servletRequest" />
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout>
	              <uix:cellFormat>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="right" wrappingDisabled="true">
                        <uix:messagePrompt promptBinding="OLDEST_SNAPSHOT_TIME@msg" />
                      </uix:cellFormat>
                      <uix:cellFormat wrappingDisabled="true">
                        <uix:styledText styleClass="OraDataText" textBinding="oldestSnapshotTime@ofsBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:tableLayout>
                  </uix:cellFormat>
              </uix:rowLayout>

            </uix:tableLayout>

<%-- To be implemented: start 
            <uix:tableLayout cellSpacing="0" width="100%">
              <uix:rowLayout>
                <uix:cellFormat vAlign="top">
                  <uix:header textBinding="EXECUTE_OPTIONS@msg">
		  <uix:stackLayout>
		     <uix:radioButton name="<%= OFSbean.ATTR_EXECUTE_OPTION %>"
	                      textBinding="EXECUTE_IMMEDIATELY@msg"
        	              value="<%= OFSbean.EXECUTE_OPTION_NOW %>"
                     	      selectedValueBinding="executeOption@ofsBean@servletRequest" />
		     <uix:radioButton name="<%= OFSbean.ATTR_EXECUTE_OPTION %>"
	                      textBinding="EXECUTE_AS_JOB@msg"
        	              value="<%= OFSbean.EXECUTE_OPTION_JOB %>"
                     	      selectedValueBinding="executeOption@ofsBean@servletRequest" />

 		 </uix:stackLayout>
	
                  <uix:header textBinding="JOB@msg">
                   <uix:tableLayout cellSpacing="5">
                    <uix:rowLayout>
                      <uix:cellFormat vAlign="top" wrappingDisabled="true" hAlign="right">
                        <uix:messagePrompt required="yes" labeledNodeId="mountPoint" promptBinding="JOB_NAME@msg"/>
                      </uix:cellFormat>
                      <uix:cellFormat>
                        <uix:stackLayout>
	                <uix:textInput name="<%= OFSbean.ATTR_HOST_USERNAME %>" id="<%= OFSbean.ATTR_HOST_USERNAME %>" columns="60"
	                                 noAutoComplete="true" textBinding="jobName@ofsBean@servletRequest" />
                          <uix:messageText messageBinding="(MOUNT_POINT@msg)@error@servletRequest" messageType="error"/>
                        </uix:stackLayout>                                                                   
                      </uix:cellFormat>                          
	              </uix:rowLayout>  
                    <uix:rowLayout>
                      <uix:cellFormat vAlign="top" wrappingDisabled="true" hAlign="right">
                        <uix:messagePrompt labeledNodeId="DESCRIPTION" promptBinding="DESCRIPTION@msg"/>
                      </uix:cellFormat>
                      <uix:cellFormat>
                        <uix:stackLayout>
	                <uix:textInput name="DESCRIPTION" id="<%= OFSbean.ATTR_HOST_USERNAME %>" columns="60"
	                                 noAutoComplete="true" textBinding="description@ofsBean@servletRequest" />
                          <uix:messageText messageBinding="(MOUNT_POINT@msg)@error@servletRequest" messageType="error"/>
                        </uix:stackLayout>                                                                   
                      </uix:cellFormat>                          
	              </uix:rowLayout>  
                  </uix:tableLayout>
                  <uix:header textBinding="SCHEDULE@msg">
                   <uix:tableLayout cellSpacing="5">
                    <uix:rowLayout>
                      <uix:cellFormat vAlign="top" wrappingDisabled="true" hAlign="right">
                        <uix:messagePrompt labeledNodeId="ScheduleType" promptBinding="TYPE@msg"/>
                      </uix:cellFormat>
                      <uix:cellFormat vAlign="top" wrappingDisabled="true" hAlign="left">
		         <uix:radioButton name="ScheduleType"
	                      textBinding="ONE_TIME_IMMEDIATELY@msg"
        	              value="ONE_TIME_IMMEDIATELY" />
                         <uix:spacer height="10" width="15" />
		         <uix:radioButton name="ScheduleType"
	                      textBinding="ONE_TIME_LATER@msg"
        	              value="ONE_TIME_LATER" />
                         <uix:spacer height="10" width="15" />
		         <uix:radioButton name="ScheduleType"
	                      textBinding="REPEATING@msg"
        	              value="REPEATING" />
                      </uix:cellFormat>                          
	            </uix:rowLayout>  
                    <uix:rowLayout>
                      <uix:cellFormat vAlign="top" wrappingDisabled="true" hAlign="right">
                        <uix:messagePrompt labeledNodeId="FREQUENCY_TYPE" promptBinding="FREQUENCY_TYPE@msg"/>
                      </uix:cellFormat>
                      <uix:cellFormat>
                        <uix:stackLayout>
	                <uix:textInput name="FREQUENCY_TYPE" id="<%= OFSbean.ATTR_HOST_USERNAME %>" columns="10"
	                                 noAutoComplete="true" textBinding="repeatEvery@ofsBean@servletRequest" />
                          <uix:messageText messageBinding="(MOUNT_POINT@msg)@error@servletRequest" messageType="error"/>
                        </uix:stackLayout>                                                                   
                      </uix:cellFormat>                          
                    </uix:rowLayout>  
                    <uix:rowLayout>
                      <uix:cellFormat vAlign="top" wrappingDisabled="true" hAlign="right">
                        <uix:messagePrompt labeledNodeId="REPEAT_EVERY" promptBinding="REPEAT_EVERY@msg"/>
                      </uix:cellFormat>
                      <uix:cellFormat>
                        <uix:stackLayout>
	                <uix:textInput name="REPEAT_EVERY" id="<%= OFSbean.ATTR_HOST_USERNAME %>" columns="10"
	                                 noAutoComplete="true" textBinding="repeatEvery@ofsBean@servletRequest" />
                          <uix:messageText messageBinding="(MOUNT_POINT@msg)@error@servletRequest" messageType="error"/>
                        </uix:stackLayout>                                                                   
                      </uix:cellFormat>                          
                    </uix:rowLayout>  
                    <uix:rowLayout>
                      <uix:cellFormat vAlign="top" wrappingDisabled="true" hAlign="right">
                        <uix:messagePrompt labeledNodeId="TIME_ZONE" promptBinding="TIME_ZONE@msg"/>
                      </uix:cellFormat>
                      <uix:cellFormat>
                        <uix:stackLayout>
			  <uix:messageDateField id="TIME_ZONE" shortDescBinding="TIME_ZONE@msg"
			                        name="TIME_ZONE"
						tipBinding="dateTip@ofsBean@servletRequest"
						valueBinding="startDateSB@ofsBean@pageContext"
						columns="24" />
                        </uix:stackLayout>                                                                   
                      </uix:cellFormat>                          
                    </uix:rowLayout>  
                    <uix:rowLayout>
                      <uix:cellFormat vAlign="top" wrappingDisabled="true" hAlign="right">
                        <uix:messagePrompt labeledNodeId="START_DATE" promptBinding="START_DATE@msg"/>
                      </uix:cellFormat>
                      <uix:cellFormat>
                        <uix:stackLayout>
			  <uix:messageDateField id="START_DATE" shortDescBinding="START_DATE@msg"
			                        name="startDateSB"
						tipBinding="dateTip@ofsBean@servletRequest"
						valueBinding="startDateSB@ofsBean@pageContext"
						columns="24">
		            <uix:onSubmitValidater>
			      <uix:date dateStyle="medium" />
			    </uix:onSubmitValidater>
			  </uix:messageDateField>
                        </uix:stackLayout>                                                                   
                      </uix:cellFormat>                          
                    </uix:rowLayout>  
                    <uix:rowLayout>
                      <uix:cellFormat vAlign="top" wrappingDisabled="true" hAlign="right">
                        <uix:messagePrompt labeledNodeId="START_TIME" promptBinding="START_TIME@msg"/>
                      </uix:cellFormat>
                      <uix:cellFormat wrappingDisabled="true">

<oem:radioButton
     name="startAmPmSB" 
     value="AM_VALUE"
     selectedValueBinding="startAmPmSB@ofsBean@servletRequest"
     textBinding="AM@msg"
     styleClass="OraInstructionText" 
/>
<oem:radioButton 
     name="startAmPmSB" 
     value="PM_VALUE"
     selectedValueBinding="startAmPmSB@ofsBean@servletRequest"
     textBinding="PM@msg"
     styleClass="OraInstructionText" 
/>
                      </uix:cellFormat>                          
                    </uix:rowLayout>  

                  </uix:tableLayout>
                 </uix:header>               

               </uix:header>               
              </uix:header>               
                </uix:cellFormat>

              </uix:rowLayout>
            </uix:tableLayout>
To be implemented: END --%>
    	  <%@ include file="ofsRelatedLink.jsp" %>

          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:submitButton textBinding="SHOW_COMMAND@msg" name="event" value="<%= Constant.EVENT_SHOW_COMMAND %>" formName="pageForm" />
		  <uix:button textBinding="CANCEL@msg" destinationBinding="cancelURL@ofsBean@servletRequest"/>
              <uix:submitButton textBinding="OK@msg" name="event" value="<%= Constant.EVENT_OK %>" formName="pageForm" />
            </uix:pageButtonBar>
          </uix:pageButtons>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
