<%--
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates.All rights reserved. 

  -- Page:        createVolume.jsp
  -- Controller:  oracle.sysman.db.adm.osm.ofs.VolumeController
  --
  -- Description: Create ASM Volume page
  --
  --  MODIFIED    (MM/DD/YY)
  --  chanchan    01/29/09 - Support OAC ADA
  --  chanchan    04/08/08 - Set default redundancy to INHERIT_DISK_GROUP
  --  chanchan    02/06/08 - Add ZBR support
  --  chanchan    12/05/07 - Modify redundancy per server API
  --  chanchan    07/18/07 - Show default Stripe Width and Stripe Columns only
  --  chanchan    03/28/06 - Creation 
  --%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.ParameterNames" %>
<%@ page import="oracle.sysman.db.adm.osm.ofs.Constant" %>
<%@ page import="oracle.sysman.emo.adm.osm.ofs.VolumeBean" %>
<%@ page import="oracle.sysman.emo.adm.osm.ofs.Volume" %>
<%@ page import="oracle.sysman.emo.adm.osm.ofs.util" %>
<%@ page import="oracle.sysman.emo.adm.osm.ofs.DiskGroup" %>
<script language="javascript">
function lovCallBack(data)
{
  document.forms[0][callBackLovField()].value=data;
  submitForm('pageForm',1,{'event':'refresh'});
  return false;
}
function updateZone()
{
  redundancy = document.forms[0].redundancy.value;
  if ((redundancy=='UNPROT') || (document.forms[0].mirrorZBR==null))
     submitForm('pageForm',1,{'event':'refresh'});
  return false;
}
</script>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="msg" class="oracle.sysman.db.rsc.osm.ofs.OfsObjectMsg" />
  <uix:bundle name="msgOsm" class="oracle.sysman.db.rsc.osm.OsmObjectMsg" />
  <uix:document>
    <db:script src="/database/LOV.js" />
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <db:form name="pageForm" method="POST" destination="<%= Constant.VOLUME_CONTROLLER %>" copyParams="target,type">
        <uix:formValue name="<%= ParameterNames.PAGE_NAME %>" value="<%= Constant.CREATE_VOLUME_PAGE %>" />
        <uix:formValue name="bShowAdvOption" valueBinding="showAdvOpt@volumeBean@servletRequest" />
        <uix:pageLayout titleBinding="header@volumeBean@servletRequest">
          <%@ include file="/database/global.jspf" %>
          <oem:messageBox messageType="error" errorTableBinding="error@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
	    <uix:switcher childNameBinding="hasDiskGroup@volumeBean@servletRequest">
            <uix:case name="true">
            <uix:tableLayout width="100%" cellSpacing="5">
              <uix:rowLayout width="100%">
                <uix:cellFormat hAlign="center" vAlign="top" width="30%" wrappingDisabled="true">
                  <uix:tableLayout cellSpacing="5">
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right" wrappingDisabled="true">
                        <uix:messagePrompt promptBinding="DISK_GROUP@msg" />
                      </uix:cellFormat>
                      <uix:cellFormat wrappingDisabled="true">
                        <uix:styledText styleClass="OraDataText" textBinding="diskGroup@volumeBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right" wrappingDisabled="true">
                        <uix:messagePrompt promptBinding="VOLUME_ALLOCATION_UNIT@msg" />
                      </uix:cellFormat>
                      <uix:cellFormat wrappingDisabled="true">
                        <uix:styledText styleClass="OraDataText" textBinding="allocationUnit@volumeBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:tableLayout>
                </uix:cellFormat>
                <uix:cellFormat vAlign="top" width="70%" wrappingDisabled="true">
                  <uix:tableLayout cellSpacing="5">
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right" wrappingDisabled="true">
                        <uix:messagePrompt promptBinding="DISK_GRP_FREE_SP@msg" />
                      </uix:cellFormat>
                      <uix:cellFormat wrappingDisabled="true">
                        <uix:styledText styleClass="OraDataText" textBinding="diskGroupSpace@volumeBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:tableLayout>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
           </uix:case>
	    </uix:switcher>

	    <uix:switcher childNameBinding="hasDiskGroup@volumeBean@servletRequest">
            <uix:case name="true">
              <uix:separator />
           </uix:case>
	    </uix:switcher>

            <uix:tableLayout cellSpacing="5">
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" vAlign="top">
                  <uix:messagePrompt promptBinding="VOLUME@msg" required="yes" labeledNodeId="VOLUME" />
                </uix:cellFormat>
                <uix:cellFormat>
                    <uix:textInput name="<%= VolumeBean.ATTR_VOLUME_NAME %>" shortDescBinding="VOLUME@msg" id="VOLUME" 
    	                             columns="40" textBinding="volName@volumeBean@servletRequest" maximumLength="35"/>
                    <uix:messageText messageBinding="(VOLUME@msg)@error@servletRequest" messageType="error"/>
                </uix:cellFormat>
              </uix:rowLayout>

	  <uix:switcher childNameBinding="hasDiskGroup@volumeBean@servletRequest">
      	    <uix:case name="false">
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" vAlign="top">
                  <uix:messagePrompt promptBinding="DISK_GROUP@msg" required="yes" labeledNodeId="DISK_GROUP" />
                </uix:cellFormat>
                <uix:cellFormat>
                    <uix:lovField name="<%= VolumeBean.ATTR_DISK_GROUP  %>" id="DISK_GROUP"
                                  textBinding="diskGroup@volumeBean@servletRequest"
                                  searchDescBinding="DISK_GROUP@msg"
  				  shortDescBinding="DISK_GROUP@msg"
                                  onClick="useCallBack();startLov('diskGroup', 'ListMountedDiskGroup')"/>
                    <uix:messageText messageBinding="(DISK_GROUP@msg)@error@servletRequest" messageType="error"/>
                 </uix:cellFormat>
              </uix:rowLayout>
      	    </uix:case>
	  </uix:switcher>

              <uix:rowLayout>
                <uix:cellFormat hAlign="right" vAlign="top">
                  <uix:messagePrompt promptBinding="SIZE@msg" required="yes" labeledNodeId="SIZE" />
                </uix:cellFormat>
                <uix:cellFormat>
                  <uix:contents>
                    <uix:textInput name="<%= VolumeBean.ATTR_TOTAL_SIZE %>" shortDescBinding="SIZE@msg" id="SIZE" 
    	                           columns="10" textBinding="totalSize@volumeBean@servletRequest" />
                    <uix:choice name="<%= VolumeBean.ATTR_SIZE_UNIT %>" selectedValueBinding="sizeUnit@volumeBean@servletRequest" shortDescBinding="SIZE@msg" >
	              <uix:option textBinding="UNIT_MB@msg" value="<%= util.UNIT_MB %>"/>
	              <uix:option textBinding="UNIT_GB@msg" value="<%= util.UNIT_GB %>"/>
	              <uix:option textBinding="UNIT_TB@msg" value="<%= util.UNIT_TB %>"/>
                    </uix:choice>
                    <uix:messageText messageBinding="(SIZE@msg)@error@servletRequest" messageType="error"/>
                    <uix:tableLayout cellSpacing="0">
                      <uix:rowLayout>
                        <uix:styledText styleClass="OraInlineInfoText" textBinding="HINT_VOLUME_SIZE@msg" />                      
                      </uix:rowLayout>
                    </uix:tableLayout>
		  </uix:contents>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" vAlign="top">
                  <uix:messagePrompt promptBinding="REDUNDANCY@msg" />
                </uix:cellFormat>
                <uix:cellFormat>
		  <uix:switcher childNameBinding="modifyRedundancy@volumeBean@servletRequest">
	            <uix:case name="true">
	              <uix:stackLayout>
                        <uix:choice name="<%= VolumeBean.ATTR_REDUNDANCY %>"
			selectedValueBinding="redundancy@volumeBean@servletRequest" shortDescBinding="REDUNDANCY@msg"
			onChange="updateZone()" >
			  <uix:switcher childNameBinding="hasDiskGroup@volumeBean@servletRequest">
		      	    <uix:case name="false">
  	        	      <uix:option textBinding="INHERIT_DISK_GROUP@msg" value="" />
		      	    </uix:case>
			  </uix:switcher>
  	                  <uix:option textBinding="HIGH@msg" value="<%= Volume.REDUNDANCY_HIGH %>"/>
	                  <uix:option textBinding="NORMAL@msg" value="<%= Volume.REDUNDANCY_NORMAL %>"/>
	                  <uix:option textBinding="EXTERNAL@msg" value="<%= Volume.REDUNDANCY_EXTERNAL %>"/>
	                </uix:choice>
	                <uix:messageText messageBinding="(REDUNDANCY@msg)@error@servletRequest" messageType="error"/>
	              </uix:stackLayout>
	            </uix:case>
	            <uix:case name="false">
                      <uix:styledText styleClass="OraDataText" textBinding="redundancyLocale@volumeBean@servletRequest"/>
	            </uix:case>
		  </uix:switcher>
                </uix:cellFormat>
              </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:messagePrompt promptBinding="STRIPE_WIDTH_KB@msg" />
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:styledText styleClass="OraDataText" textBinding="StripeWidth@volumeBean@servletRequest"/>
                  </uix:cellFormat>
                </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat>
                </uix:cellFormat>
                <uix:cellFormat vAlign="top">
                    <uix:messageText messageBinding="(STRIPE_WIDTH@msg)@error@servletRequest" messageType="error"/>
                </uix:cellFormat>
              </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:messagePrompt promptBinding="STRIPE_COLUMNS@msg" />
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:styledText styleClass="OraDataText" textBinding="StripeCol@volumeBean@servletRequest"/>
                  </uix:cellFormat>
                </uix:rowLayout>
            </uix:tableLayout>

<%-- ZBR --%>
        <uix:header textBinding="EXTENT_ZONES@msgOsm" >
          <uix:rowLayout >
            <uix:spacer width="10"/>
            <uix:stackLayout >
              <uix:messagePrompt promptBinding="EXTENT_ZONES_INSTR@msgOsm"/>
              <uix:spacer height="5"/>
              <uix:tableLayout cellSpacing="5">
                <uix:rowLayout hAlign="left">
                  <uix:cellFormat hAlign="right">
                    <uix:styledText styleClass="OraPromptText" textBinding="PRIMARY_EXTENT@msgOsm" />
                  </uix:cellFormat>

                  <uix:cellFormat>
                    <uix:contents>
                      <uix:radioButton id="ATTR_PRIMARY_ZBR_HOT"
                            name="<%= VolumeBean.ATTR_PRIMARY_ZBR %>"
                            textBinding="HOT@msgOsm" 
                            value="<%= VolumeBean.ATTR_ZBR_HOT %>" 
                            selectedValueBinding="primaryZBR@volumeBean@servletRequest"/>
                      <uix:radioButton id="ATTR_PRIMARY_ZBR_COLD"
                            name="<%= VolumeBean.ATTR_PRIMARY_ZBR %>"
                            textBinding="COLD@msgOsm" 
                            value="<%= VolumeBean.ATTR_ZBR_COLD %>" 
                            selectedValueBinding="primaryZBR@volumeBean@servletRequest"/>
                    </uix:contents>
                  </uix:cellFormat>
                </uix:rowLayout>
                  
                <uix:rowLayout hAlign="left" renderedBinding="showMirrorZBR@volumeBean@servletRequest">
                  <uix:cellFormat hAlign="right">
                    <uix:styledText styleClass="OraPromptText" textBinding="MIRROR_EXTENT@@msgOsm" />
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:contents>
                      <uix:radioButton id="AATTR_MIRROR_ZBR_HOT"
                            name="<%= VolumeBean.ATTR_MIRROR_ZBR %>"
                            textBinding="HOT@msgOsm" 
                            value="<%= VolumeBean.ATTR_ZBR_HOT %>" 
                            selectedValueBinding="mirrorZBR@volumeBean@servletRequest"
                            disabledBinding="hideMirrorZBR@volumeBean@servletRequest"/>
                      <uix:radioButton id="AATTR_MIRROR_ZBR_COLD"
                            name="<%= VolumeBean.ATTR_MIRROR_ZBR %>"
                            textBinding="COLD@msgOsm" 
                            value="<%= VolumeBean.ATTR_ZBR_COLD %>" 
                            selectedValueBinding="mirrorZBR@volumeBean@servletRequest"
                            disabledBinding="hideMirrorZBR@volumeBean@servletRequest"/>
                    </uix:contents>
                  </uix:cellFormat>
                </uix:rowLayout>
             </uix:tableLayout>
             <uix:spacer height="5"/>
             <uix:rowLayout>
               <uix:cellFormat columnSpan="2">
                 <uix:tip>
                   <uix:styledText styleClass="oraTipText" textBinding="EXTENT_ZONES_TIP@msgOsm"/>
                 </uix:tip>
               </uix:cellFormat>
             </uix:rowLayout>
           </uix:stackLayout >
         </uix:rowLayout>
       </uix:header>

          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:submitButton textBinding="SHOW_COMMAND@msg" name="event" value="<%= Constant.EVENT_SHOW_SQL %>" formName="pageForm" shortDescBinding="SHOW_COMMAND@msg" />
		  <uix:button textBinding="CANCEL@msg" destinationBinding="cancelURL@volumeBean@servletRequest" shortDescBinding="CANCEL@msg" />
              <uix:submitButton textBinding="OK@msg" name="event" value="<%= Constant.EVENT_OK %>" formName="pageForm" shortDescBinding="OK@msg" />
            </uix:pageButtonBar>
          </uix:pageButtons>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
