<%--
  -- Page:        deleteOFS.jsp
  -- Controller:  oracle.sysman.db.adm.osm.ofs.OFSController
  --
  -- Description: Delete the selected Oracle File System
  --
  --  MODIFIED    (MM/DD/YY)
  --  chanchan    04/03/06 - Creation 
  --%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.osm.ofs.Constant" %>
<%@ page import="oracle.sysman.db.adm.ParameterNames" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="msg" class="oracle.sysman.db.rsc.osm.ofs.OfsObjectMsg" />
  <uix:bundle name="msgDB" class="oracle.sysman.db.rsc.inst.DBMsg"/>
  <uix:bundle name="msgDG" class="oracle.sysman.db.dg.rsc.DGMsg"/>
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <db:form name="pageForm" method="POST" destination="<%= Constant.OFS_CONTROLLER %>" copyParams="target,type">
        <uix:formValue name="<%= ParameterNames.PAGE_NAME %>" value="<%= Constant.DELETE_OFS_PAGE %>" />
        <uix:pageLayout messageType="confirmation">
          <%@ include file="/database/global.jspf" %>
          <oem:messageBox messageType="error" errorTableBinding="error@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
            <uix:tableLayout cellSpacing="10">
              <uix:rowLayout>
                <uix:cellFormat>
                  <uix:spacer height="10" width="1" />
                </uix:cellFormat>
                <uix:cellFormat>
                  <uix:styledText styleClass="OraPromptText" textBinding="INST_DELETE_OFS@msg"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat>
                </uix:cellFormat>
                <uix:cellFormat>
                  <uix:styledText styleClass="OraDataText" textBinding="deleteOFS@ofsBean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat>
                </uix:cellFormat>
                <uix:cellFormat>
		      <uix:hideShow disclosedBinding="showAdvOpt@ofsBean@servletRequest" 
                          	  formSubmitted="true"
                        	  undisclosedTextBinding="SHOW_COMMAND@msg"
                       		  disclosedTextBinding="HIDE_COMMAND@msg">
	  		  <uix:stackLayout>
			    <db:sqlDisplay sqlListBinding="showInterface@ofsBean@servletRequest"/>
		        </uix:stackLayout>		 
		     </uix:hideShow>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
    	  <%@ include file="ofsRelatedLink.jsp" %>

          <uix:pageButtons>
            <uix:pageButtonBar>
		  <uix:button textBinding="BUTTON_NO@msg" destinationBinding="cancelURL@ofsBean@servletRequest"/>
              <uix:submitButton textBinding="BUTTON_YES@msg" name="event" value="<%= Constant.EVENT_OK %>" formName="pageForm" />
            </uix:pageButtonBar>
          </uix:pageButtons>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
