<%--
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates.All rights reserved. 
  -- Page:        deleteVolume.jsp
  -- Controller:  oracle.sysman.db.adm.osm.ofs.VolumeController
  --
  -- Description: Enable All Volumes in Disk Group page
  --
  --  MODIFIED    (MM/DD/YY)
  --  chanchan    02/02/09 - Add OAC ADA supports
  --  chanchan    07/19/07 - Replace Show SQL with Show Command
  --  chanchan    03/28/06 - Creation 
  --%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.osm.ofs.Constant" %>
<%@ page import="oracle.sysman.db.adm.ParameterNames" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="msg" class="oracle.sysman.db.rsc.osm.ofs.OfsObjectMsg" />
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <db:form name="pageForm" method="POST" destination="<%= Constant.VOLUME_CONTROLLER %>" copyParams="target,type">
        <uix:formValue name="<%= ParameterNames.PAGE_NAME %>" value="<%= Constant.DELETE_VOLUME_PAGE %>" />
        <uix:pageLayout messageType="confirmation">
          <%@ include file="/database/global.jspf" %>
          <oem:messageBox messageType="error" errorTableBinding="error@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
            <uix:tableLayout cellSpacing="10" width="100%">
              <uix:rowLayout hAlign="left">
                <uix:cellFormat>
                  <uix:spacer height="10" width="30" />
                </uix:cellFormat>
                <uix:cellFormat>
                  <uix:styledText styleClass="OraPromptText" textBinding="INST_DELETE_VOL@msg"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout hAlign="left">
                <uix:cellFormat>
                </uix:cellFormat>
                <uix:cellFormat>
                  <uix:styledText styleClass="OraDataText" textBinding="confirmation@volumeBean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat>
                </uix:cellFormat>
                <uix:cellFormat>
		      <uix:hideShow disclosedBinding="showAdvOpt@volumeBean@servletRequest" 
                          	  formSubmitted="true"
                        	  undisclosedTextBinding="SHOW_COMMAND@msg"
                       		  disclosedTextBinding="HIDE_COMMAND@msg">
	  		  <uix:stackLayout>
			    <db:sqlDisplay sqlListBinding="sqlList@volumeBean@servletRequest"/>
		        </uix:stackLayout>		 
		     </uix:hideShow>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
          <uix:pageButtons>
            <uix:pageButtonBar>
		  <uix:button textBinding="BUTTON_NO@msg" destinationBinding="cancelURL@volumeBean@servletRequest"/>
              <uix:submitButton textBinding="BUTTON_YES@msg" name="event" value="<%= Constant.EVENT_OK %>" formName="pageForm" />
            </uix:pageButtonBar>
          </uix:pageButtons>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
