<%--
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates.All rights reserved. 
  -- Page:        registerOFS.jsp
  -- Controller:  oracle.sysman.db.adm.osm.ofs.OFSController
  --
  -- Description: Dismount Oracle File System
  --
  --  MODIFIED    (MM/DD/YY)
  --  chanchan    02/02/09 - Add OAC ADA supports
  --  chanchan    01/22/09 - Add register -m option support
  --  chanchan    04/28/08 - Creation 
  --%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.osm.ofs.Constant" %>
<%@ page import="oracle.sysman.emo.adm.osm.ofs.OFSbean" %>
<%@ page import="oracle.sysman.db.adm.ParameterNames" %>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="msg" class="oracle.sysman.db.rsc.osm.ofs.OfsObjectMsg" />
  <uix:bundle name="msgDB" class="oracle.sysman.db.rsc.inst.DBMsg"/>
  <uix:bundle name="msgDG" class="oracle.sysman.db.dg.rsc.DGMsg"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <db:form name="pageForm" method="POST" destination="<%= Constant.OFS_CONTROLLER %>" copyParams="target,type">
        <uix:formValue name="<%= ParameterNames.PAGE_NAME %>" value="<%= Constant.DEREGISTER_OFS_PAGE %>" />
        <uix:pageLayout titleBinding="header@ofsBean@servletRequest">
        <%@ include file="/database/global.jspf" %>
        <oem:messageBox messageType="info" errorTableBinding="info@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error" errorTableBinding="error@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
            <uix:tableLayout width="100%" cellSpacing="5">
              <uix:rowLayout width="100%">
                <uix:cellFormat hAlign="center" vAlign="top" width="30%" wrappingDisabled="true">
                  <uix:tableLayout cellSpacing="5">
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right" wrappingDisabled="true">
                        <uix:messagePrompt promptBinding="VOLUME_DEVICE@msg" />
                      </uix:cellFormat>
                      <uix:cellFormat wrappingDisabled="true">
                        <uix:styledText styleClass="OraDataText" textBinding="volDevice@ofsBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right" wrappingDisabled="true">
                        <uix:messagePrompt promptBinding="VOLUME@msg" />
                      </uix:cellFormat>
                      <uix:cellFormat wrappingDisabled="true">
                        <uix:styledText styleClass="OraDataText" textBinding="volName@ofsBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout>
                      <uix:cellFormat vAlign="top" hAlign="right" wrappingDisabled="true">
                        <uix:messagePrompt promptBinding="VOLUME_LABEL@msg" />
                      </uix:cellFormat>
                      <uix:cellFormat wrappingDisabled="false">
                        <uix:styledText styleClass="OraDataText" textBinding="volLabel@ofsBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:tableLayout>
                </uix:cellFormat>
                <uix:cellFormat vAlign="top" width="70%" wrappingDisabled="true">
                  <uix:tableLayout cellSpacing="5">
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right" wrappingDisabled="true">
                        <uix:messagePrompt promptBinding="DISK_GROUP@msg" />
                      </uix:cellFormat>
                      <uix:cellFormat wrappingDisabled="true">
                        <uix:styledText styleClass="OraDataText" textBinding="diskGroup@ofsBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right" wrappingDisabled="true">
                        <uix:messagePrompt promptBinding="ACFS_MOUNT_POINT@msg" />
                      </uix:cellFormat>
                      <uix:cellFormat wrappingDisabled="true">
                        <uix:styledText styleClass="OraDataText" textBinding="AcfsMountPoint@ofsBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right" wrappingDisabled="true">
                        <uix:messagePrompt promptBinding="REGISTRY_MOUNT_POINT@msg" />
                      </uix:cellFormat>
                      <uix:cellFormat wrappingDisabled="true">
                        <uix:styledText styleClass="OraDataText" textBinding="mountPoint@ofsBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:tableLayout>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

            <uix:separator>
              <uix:spacer height="1"/>
            </uix:separator>

            <uix:tableLayout cellSpacing="10">
              <uix:rowLayout>
                <uix:cellFormat>
                  <uix:spacer height="10" width="1" />
                </uix:cellFormat>
                <uix:cellFormat>
                  <uix:styledText styleClass="OraPromptText" textBinding="INSTRUCTION_DEREGISTER@msg"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat>
                </uix:cellFormat>
                <uix:cellFormat>
                  <uix:styledText styleClass="OraDataText" textBinding="deregisterOFS@ofsBean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat>
                </uix:cellFormat>
                <uix:cellFormat>
		      <uix:hideShow disclosedBinding="showAdvOpt@ofsBean@servletRequest" 
                          	  formSubmitted="true"
                        	  undisclosedTextBinding="SHOW_COMMAND@msg"
                       		  disclosedTextBinding="HIDE_COMMAND@msg">
	  		  <uix:stackLayout>
			    <db:sqlDisplay sqlListBinding="showInterface@ofsBean@servletRequest"/>
		        </uix:stackLayout>		 
		     </uix:hideShow>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
    	  <%@ include file="ofsRelatedLink.jsp" %>

          <uix:pageButtons>
            <uix:pageButtonBar>
  	      <uix:button textBinding="CANCEL@msg" destinationBinding="cancelURL@ofsBean@servletRequest"/>
              <uix:submitButton textBinding="OK@msg" name="event" value="<%= Constant.EVENT_OK %>" formName="pageForm" />
            </uix:pageButtonBar>
          </uix:pageButtons>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
