<%--
  -- Page:        dismountAllOFS.jsp
  -- Controller:  oracle.sysman.db.adm.osm.ofs.OFSController
  --
  -- Description: Dismount All Oracle File System
  --
  --  MODIFIED    (MM/DD/YY)
  --  chanchan    06/03/06 - Creation 
  --%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.osm.ofs.Constant" %>
<%@ page import="oracle.sysman.emo.adm.osm.ofs.OFSbean" %>
<%@ page import="oracle.sysman.db.adm.ParameterNames" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="msg" class="oracle.sysman.db.rsc.osm.ofs.OfsObjectMsg" />
  <uix:bundle name="msgDB" class="oracle.sysman.db.rsc.inst.DBMsg"/>
  <uix:bundle name="msgDG" class="oracle.sysman.db.dg.rsc.DGMsg"/>
  <uix:document>
    <uix:metaContainer>
      <uix:head titleBinding="DISMOUNT_ALL@msg"/>
    </uix:metaContainer>
    <uix:body>
      <db:form name="pageForm" method="POST" destination="<%= Constant.OFS_CONTROLLER %>" copyParams="target,type">
        <uix:formValue name="<%= ParameterNames.PAGE_NAME %>" value="<%= Constant.DISMOUNT_ALL_OFS_PAGE %>" />
        <uix:pageLayout titleBinding="DISMOUNT_ALL@msg">
          <%@ include file="/database/global.jspf" %>
          <oem:messageBox messageType="error" errorTableBinding="error@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>

            <uix:tableLayout cellSpacing="5">
              <uix:rowLayout>
                <uix:cellFormat>
                  <uix:spacer height="10" width="10" />
                </uix:cellFormat>
                <uix:cellFormat>
                  <uix:styledText styleClass="OraPromptText" textBinding="INST_DISMOUNT_ALL_OFS_LINUX@msg" renderedBinding="isLinux@ofsBean@servletRequest"/>
                  <uix:styledText styleClass="OraPromptText" textBinding="INST_DISMOUNT_ALL_OFS_WIN@msg" renderedBinding="isWindows@ofsBean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout renderedBinding="NoSudoSupport@ofsBean@servletRequest">
                <uix:cellFormat>
                </uix:cellFormat>
                <uix:cellFormat>
		  <uix:tip>
         	    <uix:styledText textBinding="MSG_ROOT_OPERATION_LINK@msg"/>
		  </uix:tip>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout renderedBinding="NoSudoSupport@ofsBean@servletRequest">
                <uix:cellFormat>
                </uix:cellFormat>
                <uix:cellFormat>
		      <uix:hideShow disclosedBinding="showAdvOpt@ofsBean@servletRequest" 
                          	  formSubmitted="true"
                        	  undisclosedTextBinding="SHOW_COMMAND@msg"
                       		  disclosedTextBinding="HIDE_COMMAND@msg">
	  		  <uix:stackLayout>
			    <db:sqlDisplay sqlListBinding="showInterface@ofsBean@servletRequest"/>
		        </uix:stackLayout>		 
		     </uix:hideShow>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

            <uix:tableLayout cellSpacing="5" width="100%" renderedBinding="SudoSupport@ofsBean@servletRequest">
              <uix:rowLayout>
                <uix:cellFormat width="60%" hAlign="right" vAlign="top">                  
      	 	<%@ include file="credentials.jsp" %>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
    	  <%@ include file="ofsRelatedLink.jsp" %>

          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:submitButton textBinding="SHOW_COMMAND@msg" name="event" value="<%= Constant.EVENT_SHOW_COMMAND %>" formName="pageForm" renderedBinding="SudoSupport@ofsBean@servletRequest"/>
	      <uix:button textBinding="RETURN@msg" destinationBinding="cancelURL@ofsBean@servletRequest" renderedBinding="NoSudoSupport@ofsBean@servletRequest"/>
	      <uix:button textBinding="CANCEL@msg" destinationBinding="cancelURL@ofsBean@servletRequest" renderedBinding="SudoSupport@ofsBean@servletRequest"/>
              <uix:submitButton textBinding="OK@msg" name="event" value="<%= Constant.EVENT_OK %>" formName="pageForm" renderedBinding="SudoSupport@ofsBean@servletRequest"/>
            </uix:pageButtonBar>
          </uix:pageButtons>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
