<%--
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates.All rights reserved. 
  -- Page:        dismountOFS.jsp
  -- Controller:  oracle.sysman.db.adm.osm.ofs.OFSController
  --
  -- Description: Dismount Oracle File System
  --
  --  MODIFIED    (MM/DD/YY)
  --  chanchan    02/02/09 - Add OAC ADA supports
  --  chanchan    08/13/07 - Add Selected Hosts for cluster
  --  chanchan    03/16/06 - Creation 
  --%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.osm.ofs.Constant" %>
<%@ page import="oracle.sysman.emo.adm.osm.ofs.OFSbean" %>
<%@ page import="oracle.sysman.db.adm.ParameterNames" %>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="msg" class="oracle.sysman.db.rsc.osm.ofs.OfsObjectMsg" />
  <uix:bundle name="msgDB" class="oracle.sysman.db.rsc.inst.DBMsg"/>
  <uix:bundle name="msgDG" class="oracle.sysman.db.dg.rsc.DGMsg"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <db:form name="pageForm" method="POST" destination="<%= Constant.OFS_CONTROLLER %>" copyParams="target,type">
        <uix:formValue name="<%= ParameterNames.PAGE_NAME %>" value="<%= Constant.DISMOUNT_OFS_PAGE %>" />
        <uix:pageLayout titleBinding="header@ofsBean@servletRequest">
        <%@ include file="/database/global.jspf" %>
        <oem:messageBox messageType="info" errorTableBinding="info@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error" errorTableBinding="error@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
            <uix:tableLayout width="100%" cellSpacing="5">
              <uix:rowLayout width="100%">
                <uix:cellFormat hAlign="center" vAlign="top" width="40%" wrappingDisabled="true">
                  <uix:tableLayout cellSpacing="5">
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right" wrappingDisabled="true">
                        <uix:messagePrompt promptBinding="VOLUME_DEVICE@msg" />
                      </uix:cellFormat>
                      <uix:cellFormat wrappingDisabled="true">
                        <uix:styledText styleClass="OraDataText" textBinding="volDevice@ofsBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right" wrappingDisabled="true">
                        <uix:messagePrompt promptBinding="VOLUME@msg" />
                      </uix:cellFormat>
                      <uix:cellFormat wrappingDisabled="true">
                        <uix:styledText styleClass="OraDataText" textBinding="volName@ofsBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:tableLayout>
                </uix:cellFormat>
                <uix:cellFormat vAlign="top" width="70%" wrappingDisabled="true">
                  <uix:tableLayout cellSpacing="5">
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right" wrappingDisabled="true">
                        <uix:messagePrompt promptBinding="DISK_GROUP@msg" />
                      </uix:cellFormat>
                      <uix:cellFormat wrappingDisabled="true">
                        <uix:styledText styleClass="OraDataText" textBinding="diskGroup@ofsBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right" wrappingDisabled="true">
                        <uix:messagePrompt promptBinding="VOLUME_LABEL@msg" />
                      </uix:cellFormat>
                      <uix:cellFormat wrappingDisabled="true">
                        <uix:styledText styleClass="OraDataText" textBinding="volLabel@ofsBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:tableLayout>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

            <uix:separator>
              <uix:spacer height="1"/>
            </uix:separator>

            <uix:tableLayout cellSpacing="5">
              <uix:rowLayout>
                <uix:cellFormat>
                  <uix:spacer height="10" width="10" />
                </uix:cellFormat>
                <uix:cellFormat>
                  <uix:styledText styleClass="OraPromptText" textBinding="INST_DISMOUNT_OFS_LINUX@msg" renderedBinding="isLinux@ofsBean@servletRequest"/>
                  <uix:styledText styleClass="OraPromptText" textBinding="INST_DISMOUNT_OFS_WINDOWS@msg" renderedBinding="isWindows@ofsBean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout renderedBinding="NoSudoSupport@ofsBean@servletRequest">
                <uix:cellFormat>
                </uix:cellFormat>
                <uix:cellFormat>
		  <uix:tip>
         	    <uix:styledText textBinding="MSG_ROOT_OPERATION_LINK@msg"/>
		  </uix:tip>
                </uix:cellFormat>
              </uix:rowLayout>
	    </uix:tableLayout>

            <uix:tableLayout cellSpacing="5" renderedBinding="isMultipleHost@ofsBean@servletRequest">
              <uix:rowLayout>
                <uix:cellFormat>
                  <uix:spacer height="10" width="30" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="right" wrappingDisabled="true">
                  <uix:messagePrompt promptBinding="SELECTED_HOSTS@msg" />
                </uix:cellFormat>
                <uix:cellFormat wrappingDisabled="true">
                   <uix:styledText styleClass="OraDataText" textBinding="selectedHostsInString@ofsBean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

            <uix:tableLayout cellSpacing="0">
              <uix:rowLayout>
                <uix:cellFormat>
                  <uix:spacer height="10" width="20" />
                </uix:cellFormat>
                <uix:cellFormat>
		<uix:header textBinding="HOST_CREDENTIALS@msg" renderedBinding="SudoSupport@ofsBean@servletRequest">
	              <uix:tableLayout cellSpacing="5">
        		    <uix:rowLayout>
	                  <uix:cellFormat hAlign="right" vAlign="top">
				  <uix:messagePrompt required="yes" promptBinding="USER_NAME@msg" labeledNodeId="USER_NAME"/>
	                  </uix:cellFormat>
	                  <uix:cellFormat hAlign="left">
                          <uix:stackLayout>
                            <uix:textInput name="<%= OFSbean.ATTR_HOST_USERNAME %>" textBinding="userName@ofsBean@servletRequest" columns="25" shortDescBinding="USER_NAME@msg" id="USER_NAME"/>
                            <uix:styledText styleClass="OraInlineInfoText" textBinding="HINT_ROOT_PRIV@msg" renderedBinding="isLinux@ofsBean@servletRequest" />                      
                            <uix:styledText styleClass="OraInlineInfoText" textBinding="HINT_ADMIN_PRIV@msg" renderedBinding="isWindows@ofsBean@servletRequest" />                      
                            <uix:messageText messageBinding="(USER_NAME@msg)@error@servletRequest" messageType="error"/>
                          </uix:stackLayout>
	                  </uix:cellFormat>
        		    </uix:rowLayout>
        		    <uix:rowLayout>
	                  <uix:cellFormat hAlign="right" vAlign="top">
				  <uix:messagePrompt required="yes" promptBinding="PASSWORD@msg" labeledNodeId="PASSWORD"/>
	                  </uix:cellFormat>
	                  <uix:cellFormat hAlign="left">
                          <uix:stackLayout>
                            <uix:textInput name="<%= OFSbean.ATTR_HOST_PASSWORD %>" textBinding="secretPassword@ofsBean@servletRequest" columns="25" shortDescBinding="PASSWORD@msg" id="PASSWORD" secret ="true"/>
                            <uix:messageText messageBinding="(PASSWORD@msg)@error@servletRequest" messageType="error"/>
                          </uix:stackLayout>
	                  </uix:cellFormat>
        		    </uix:rowLayout>
	              </uix:tableLayout>
			  <uix:hideShow disclosedBinding="showAdvOpt@ofsBean@servletRequest" 
                           	    formSubmitted="true"
                        	    undisclosedTextBinding="SHOW_ADV_OPTION@msg"
                       		    disclosedTextBinding="HIDE_ADV_OPTION@msg">
			    <uix:contents>
 			      <uix:spacer height="3" width="10"/>
		            <uix:checkBox checkedBinding="mountAuto@ofsBean@servletRequest" name="<%= OFSbean.ATTR_MOUNT_AUTOMATIC %>"
               	 	    	        textBinding="MOUNT_AUTO_START@msg" />
			    </uix:contents>
			  </uix:hideShow>
		  </uix:header>
                </uix:cellFormat>
                <uix:cellFormat renderedBinding="NoSudoSupport@ofsBean@servletRequest">
                  <uix:contents>
		      <uix:hideShow disclosedBinding="showAdvOpt@ofsBean@servletRequest" 
                          	  formSubmitted="true"
                        	  undisclosedTextBinding="SHOW_COMMAND@msg"
                       		  disclosedTextBinding="HIDE_COMMAND@msg">
	  		  <uix:stackLayout>
			    <db:sqlDisplay sqlListBinding="showInterface@ofsBean@servletRequest"/>
		        </uix:stackLayout>		 
		     </uix:hideShow>
   	          </uix:contents>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
    	  <%@ include file="ofsRelatedLink.jsp" %>

          <uix:pageButtons>
            <uix:pageButtonBar>
	      <uix:button textBinding="RETURN@msg" destinationBinding="cancelURL@ofsBean@servletRequest" renderedBinding="NoSudoSupport@ofsBean@servletRequest"/>
              <uix:submitButton textBinding="SHOW_COMMAND@msg" name="event" value="<%= Constant.EVENT_SHOW_COMMAND %>" formName="pageForm" renderedBinding="SudoSupport@ofsBean@servletRequest"/>
	      <uix:button textBinding="CANCEL@msg" destinationBinding="cancelURL@ofsBean@servletRequest" renderedBinding="SudoSupport@ofsBean@servletRequest"/>
              <uix:submitButton textBinding="OK@msg" name="event" value="<%= Constant.EVENT_OK %>" formName="pageForm" renderedBinding="SudoSupport@ofsBean@servletRequest"/>
            </uix:pageButtonBar>
          </uix:pageButtons>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
