<%--
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates.All rights reserved. 
  -- Page:        editVolume.jsp
  -- Controller:  oracle.sysman.db.adm.osm.ofs.VolumeController
  --
  -- Description: Enable All Volumes in Disk Group page
  --
  --  MODIFIED    (MM/DD/YY)
  --  chanchan    01/29/09 - Support OAC ADA
  --  chanchan    04/04/08 - Add Creation/Modification date
  --  chanchan    02/11/08 - Creation 
  --%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.ParameterNames" %>
<%@ page import="oracle.sysman.db.adm.osm.ofs.Constant" %>
<%@ page import="oracle.sysman.emo.adm.osm.ofs.VolumeBean" %>
<%@ page import="oracle.sysman.emo.adm.osm.ofs.Volume" %>
<%@ page import="oracle.sysman.emo.adm.osm.ofs.util" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="msg" class="oracle.sysman.db.rsc.osm.ofs.OfsObjectMsg" />
  <uix:bundle name="msgOsm" class="oracle.sysman.db.rsc.osm.OsmObjectMsg" />
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <db:form name="pageForm" method="POST" destination="<%= Constant.VOLUME_CONTROLLER %>" copyParams="target,type">
        <uix:formValue name="<%= ParameterNames.PAGE_NAME %>" value="<%= Constant.EDIT_VOLUME_PAGE %>" />
        <uix:pageLayout titleBinding="header@volumeBean@servletRequest">
          <oem:messageBox messageType="error" errorTableBinding="error@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
          <%@ include file="/database/global.jspf" %>
            <uix:tableLayout width="100%" cellSpacing="5">
              <uix:rowLayout width="100%">
                <uix:cellFormat hAlign="center" vAlign="top" width="25%" wrappingDisabled="true">
                  <uix:tableLayout cellSpacing="5">
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right" wrappingDisabled="true">
                        <uix:messagePrompt promptBinding="DISK_GROUP@msg" />
                      </uix:cellFormat>
                      <uix:cellFormat wrappingDisabled="true">
                        <uix:styledText styleClass="OraDataText" textBinding="diskGroup@volumeBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:tableLayout>
                </uix:cellFormat>
                <uix:cellFormat vAlign="top" width="60%" wrappingDisabled="true">
                  <uix:tableLayout cellSpacing="5">
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right" wrappingDisabled="true">
                        <uix:messagePrompt promptBinding="DISK_GRP_FREE_SP@msg" />
                      </uix:cellFormat>
                      <uix:cellFormat wrappingDisabled="true">
                        <uix:styledText styleClass="OraDataText" textBinding="diskGroupSpace@volumeBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:tableLayout>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

            <uix:separator>
              <uix:spacer height="1"/>
            </uix:separator>

<%-- GENERAL --%>
        <uix:header textBinding="GENERAL@msg" >
          <uix:tableLayout width="100%" cellSpacing="5">
            <uix:rowLayout width="100%">
              <uix:cellFormat hAlign="center" vAlign="top" width="20%" wrappingDisabled="true">
                <uix:tableLayout cellSpacing="5">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right" wrappingDisabled="true">
                      <uix:messagePrompt promptBinding="STATE@msg" />
                    </uix:cellFormat>
                    <uix:cellFormat wrappingDisabled="true">
                        <uix:styledText styleClass="OraDataText" textBinding="state@volumeBean@servletRequest"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right" wrappingDisabled="true">
                      <uix:messagePrompt promptBinding="USAGE@msg" />
                    </uix:cellFormat>
                    <uix:cellFormat wrappingDisabled="true">
                      <uix:styledText styleClass="OraDataText" textBinding="usage@volumeBean@servletRequest"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right" wrappingDisabled="true">
                      <uix:messagePrompt promptBinding="REDUNDANCY@msg" />
                    </uix:cellFormat>
                    <uix:cellFormat wrappingDisabled="true">
                      <uix:styledText styleClass="OraDataText" textBinding="redundancyLocale@volumeBean@servletRequest"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right" wrappingDisabled="true">
                      <uix:messagePrompt promptBinding="STRIPE_WIDTH_KB@msg" />
                    </uix:cellFormat>
                    <uix:cellFormat wrappingDisabled="true">
                      <uix:styledText styleClass="OraDataText" textBinding="StripeWidth@volumeBean@servletRequest"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right" wrappingDisabled="true">
                      <uix:messagePrompt promptBinding="STRIPE_COLUMNS@msg" />
                    </uix:cellFormat>
                    <uix:cellFormat wrappingDisabled="true">
                      <uix:styledText styleClass="OraDataText" textBinding="StripeCol@volumeBean@servletRequest"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" wrappingDisabled="true">
                  <uix:messagePrompt promptBinding="CREATION_TIME@msg" />
                </uix:cellFormat>
                <uix:cellFormat wrappingDisabled="true">
                  <uix:styledText styleClass="OraDataText" textBinding="creationTime@volumeBean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" wrappingDisabled="true">
                  <uix:messagePrompt promptBinding="MODIFICATION_TIME@msg" />
                </uix:cellFormat>
                <uix:cellFormat wrappingDisabled="true">
                  <uix:styledText styleClass="OraDataText" textBinding="modificationTime@volumeBean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>

                </uix:tableLayout>
              </uix:cellFormat>
              <uix:cellFormat vAlign="top" width="60%" wrappingDisabled="true">
                <uix:tableLayout cellSpacing="5">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right" wrappingDisabled="true">
                      <uix:messagePrompt promptBinding="VOLUME_DEVICE@msg" />
                    </uix:cellFormat>
                    <uix:cellFormat>
                      <uix:styledText styleClass="OraDataText" textBinding="volDevice@volumeBean@servletRequest"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right" wrappingDisabled="true">
                      <uix:messagePrompt promptBinding="MOUNT_POINT@msg" />
                    </uix:cellFormat>
                    <uix:cellFormat>
 		      <uix:link textBinding="mountPoint@volumeBean@servletRequest" destinationBinding="ofsSitemap@servletRequest" renderedBinding="usageOFS@volumeBean@servletRequest"/>
	              <uix:switcher childNameBinding="usageOFS@volumeBean@servletRequest">
         	        <uix:case name="false"> 
	                  <uix:styledText styleClass="OraDataText" textBinding="mountPoint@volumeBean@servletRequest"/>
                        </uix:case> 
                      </uix:switcher>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right" wrappingDisabled="true">
                      <uix:messagePrompt promptBinding="VOLUME_ALLOCATION_UNIT@msg" />
                    </uix:cellFormat>
                    <uix:cellFormat>
                      <uix:styledText styleClass="OraDataText" textBinding="allocationUnit@volumeBean@servletRequest"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right" wrappingDisabled="true">
                      <uix:messagePrompt promptBinding="DG_ALLOC_SPACE_GB@msg" />
                    </uix:cellFormat>
                    <uix:cellFormat>
                      <uix:styledText styleClass="OraDataText" textBinding="DgAllocatedSpace@volumeBean@servletRequest"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:switcher childNameBinding="usageOFS@volumeBean@servletRequest">
                    <uix:case name="true"> 
                      <uix:rowLayout>
	                <uix:cellFormat hAlign="right" vAlign="top">
	                  <uix:messagePrompt promptBinding="SIZE_GB@msg" />
	                </uix:cellFormat>
	                <uix:cellFormat>
			  <uix:link textBinding="totalSize@volumeBean@servletRequest" destinationBinding="ofsURL@volumeBean@servletRequest" />
	                  <uix:tableLayout cellSpacing="0">
        	            <uix:rowLayout>
                	      <uix:styledText styleClass="OraInlineInfoText" textBinding="INST_WARNING_RESIZE_VOL@msg" />                      
                      	    </uix:rowLayout>
                          </uix:tableLayout>
                	</uix:cellFormat>
	              </uix:rowLayout>
                    </uix:case> 
                    <uix:case name="false"> 
                      <uix:rowLayout>
          		<uix:cellFormat hAlign="right" vAlign="top">
	                  <uix:messagePrompt promptBinding="SIZE@msg" required="yes" labeledNodeId="SIZE" />
        	        </uix:cellFormat>
                	<uix:cellFormat>
	                  <uix:contents>
        	            <uix:textInput name="<%= VolumeBean.ATTR_TOTAL_SIZE %>" shortDescBinding="SIZE@msg" id="SIZE" 
    	        	                   columns="10" textBinding="totalSize@volumeBean@servletRequest" />
	                    <uix:choice name="<%= VolumeBean.ATTR_SIZE_UNIT %>" selectedValueBinding="sizeUnit@volumeBean@servletRequest" shortDescBinding="SIZE@msg" >
		              <uix:option textBinding="UNIT_MB@msg" value="<%= util.UNIT_MB %>"/>
		              <uix:option textBinding="UNIT_GB@msg" value="<%= util.UNIT_GB %>"/>
		              <uix:option textBinding="UNIT_TB@msg" value="<%= util.UNIT_TB %>"/>
        	            </uix:choice>
                	    <uix:messageText messageBinding="(SIZE@msg)@error@servletRequest" messageType="error"/>
	                    <uix:tableLayout cellSpacing="0">
        	              <uix:rowLayout>
                	        <uix:styledText styleClass="OraInlineInfoText" textBinding="HINT_VOLUME_SIZE@msg" />                      
                      	      </uix:rowLayout>
                            </uix:tableLayout>
		  	  </uix:contents>
        	        </uix:cellFormat>
                      </uix:rowLayout>
                    </uix:case> 
                  </uix:switcher>
                  <uix:switcher childNameBinding="usageOFS@volumeBean@servletRequest">
                    <uix:case name="true"> 
                      <uix:rowLayout>
                        <uix:cellFormat hAlign="right" wrappingDisabled="true">
                      	  <uix:messagePrompt promptBinding="OFS_STATE@msg" />
                        </uix:cellFormat>
                        <uix:cellFormat>
                          <uix:styledText styleClass="OraDataText" textBinding="ofsState@volumeBean@servletRequest"/>
                        </uix:cellFormat>
                      </uix:rowLayout>
                    </uix:case> 
                  </uix:switcher>

                </uix:tableLayout>
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:tableLayout>


          <uix:tableLayout cellSpacing="5">
           </uix:tableLayout>

        </uix:header>

<%-- ZBR --%>
        <uix:header textBinding="EXTENT_ZONES@msgOsm" >
          <uix:rowLayout >
            <uix:spacer width="10"/>
            <uix:stackLayout >
              <uix:messagePrompt promptBinding="EXTENT_ZONES_INSTR@msgOsm"/>
              <uix:spacer height="5"/>
              <uix:tableLayout cellSpacing="5">
                <uix:rowLayout hAlign="left">
                  <uix:cellFormat hAlign="right">
                    <uix:styledText styleClass="OraPromptText" textBinding="PRIMARY_EXTENT@msgOsm"/>
                  </uix:cellFormat>

                  <uix:cellFormat>
                    <uix:contents>
                      <uix:radioButton
                            name="<%= VolumeBean.ATTR_PRIMARY_ZBR %>"
                            textBinding="HOT@msgOsm" 
                            value="<%= VolumeBean.ATTR_ZBR_HOT %>" 
                            selectedValueBinding="primaryZBR@volumeBean@servletRequest"/>
                      <uix:radioButton
                            name="<%= VolumeBean.ATTR_PRIMARY_ZBR %>"
                            textBinding="COLD@msgOsm" 
                            value="<%= VolumeBean.ATTR_ZBR_COLD %>" 
                            selectedValueBinding="primaryZBR@volumeBean@servletRequest"/>
                    </uix:contents>
                  </uix:cellFormat>
                </uix:rowLayout>
                  
                <uix:rowLayout hAlign="left" renderedBinding="showMirrorZBR@volumeBean@servletRequest">
                  <uix:cellFormat hAlign="right">
                    <uix:styledText styleClass="OraPromptText" textBinding="MIRROR_EXTENT@@msgOsm"/>
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:contents>
                      <uix:radioButton
                            name="<%= VolumeBean.ATTR_MIRROR_ZBR %>"
                            textBinding="HOT@msgOsm" 
                            value="<%= VolumeBean.ATTR_ZBR_HOT %>" 
                            selectedValueBinding="mirrorZBR@volumeBean@servletRequest"
                            disabledBinding="hideMirrorZBR@volumeBean@servletRequest"/>
                      <uix:radioButton
                            name="<%= VolumeBean.ATTR_MIRROR_ZBR %>"
                            textBinding="COLD@msgOsm" 
                            value="<%= VolumeBean.ATTR_ZBR_COLD %>" 
                            selectedValueBinding="mirrorZBR@volumeBean@servletRequest"
                            disabledBinding="hideMirrorZBR@volumeBean@servletRequest"/>
                    </uix:contents>
                  </uix:cellFormat>
                </uix:rowLayout>
             </uix:tableLayout>
             <uix:spacer height="5"/>
             <uix:rowLayout>
               <uix:cellFormat columnSpan="2">
                 <uix:tip>
                   <uix:styledText styleClass="oraTipText" textBinding="EXTENT_ZONES_TIP@msgOsm"/>
                 </uix:tip>
               </uix:cellFormat>
             </uix:rowLayout>
           </uix:stackLayout >
         </uix:rowLayout>
       </uix:header>

          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:submitButton textBinding="SHOW_COMMAND@msg" name="event" value="<%= Constant.EVENT_SHOW_SQL %>" formName="pageForm" shortDescBinding="SHOW_COMMAND@msg" />
		  <uix:button textBinding="CANCEL@msg" destinationBinding="cancelURL@volumeBean@servletRequest" shortDescBinding="CANCEL@msg" />
              <uix:submitButton textBinding="OK@msg" name="event" value="<%= Constant.EVENT_OK %>" formName="pageForm" shortDescBinding="OK@msg" />
            </uix:pageButtonBar>
          </uix:pageButtons>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
