<%--
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates.All rights reserved. 
  -- Page:        hostCredentials.jsp
  -- Controller:  oracle.sysman.db.adm.osm.ofs.OFSController
  --
  -- Description: Mount Oracle File System
  --
  --  MODIFIED    (MM/DD/YY)
  --  chanchan    02/02/09 - Add OAC ADA supports
  --  chanchan    03/13/06 - Creation 
  --%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.osm.ofs.Constant" %>
<%@ page import="oracle.sysman.emo.adm.osm.ofs.OFSbean" %>
<%@ page import="oracle.sysman.db.adm.ParameterNames" %>
  <script>
      var isNav = (navigator.appName.indexOf("Netscape") != -1);
      if(isNav)
         document.captureEvents(Event.KEYPRESS);
      document.onkeypress = getKey;
      function getKey(keyStroke)
      {
         key = (isNav) ? keyStroke.which : event.keyCode;
         if(key == "13")
           submitForm('pageForm', true, {'event':'<%= Constant.EVENT_CONT_HOST_CREDENTIAL %>'});
      }
  </script>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="msg" class="oracle.sysman.db.rsc.osm.ofs.OfsObjectMsg" />
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <db:form name="pageForm" method="POST" destination="<%= Constant.OFS_CONTROLLER %>" copyParams="target,type">
        <uix:formValue name="<%= ParameterNames.PAGE_NAME %>" value="<%= Constant.HOST_CREDENTIALS_PAGE %>" />
        <uix:pageLayout titleBinding="hostCredentialHeader@servletRequest">
          <%@ include file="/database/global.jspf" %>
          <oem:messageBox messageType="error" errorTableBinding="error@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>

            <uix:tableLayout cellSpacing="5">
              <uix:rowLayout>
                <uix:cellFormat>
                  <uix:spacer height="10" width="10" />
                </uix:cellFormat>
                <uix:cellFormat>
                  <uix:styledText styleClass="OraPromptText" textBinding="INST_OFS_HOST_CREDENTIALS@msg"/>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

      <uix:spacer height="5"/>
      <%@ include file="/credentials.jspf"%>

          <uix:pageButtons>
            <uix:pageButtonBar>
		  <uix:button textBinding="CANCEL@msg" destinationBinding="backURL@servletRequest"/>
              <uix:submitButton textBinding="CONTINUE@msg" name="event" value="<%= Constant.EVENT_CONT_HOST_CREDENTIAL %>" formName="pageForm" />
            </uix:pageButtonBar>
          </uix:pageButtons>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
