<%--
  -- Page:        mountOFS.jsp
  -- Controller:  oracle.sysman.db.adm.osm.ofs.OFSController
  --
  -- Description: Mount Oracle File System
  --
  --  MODIFIED    (MM/DD/YY)
  --  chanchan    04/03/08 - Add Related Links to Open Telnet Session
  --  chanchan    08/13/07 - Add Selected Hosts for cluster
  --  chanchan    03/13/06 - Creation 
  --%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<db:script src="/database/remoteBrowser/remoteBrowser.js"/>
<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.osm.ofs.Constant" %>
<%@ page import="oracle.sysman.emo.adm.osm.ofs.OFSbean" %>
<%@ page import="oracle.sysman.db.adm.ParameterNames" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="msg" class="oracle.sysman.db.rsc.osm.ofs.OfsObjectMsg" />
  <uix:bundle name="msgDB" class="oracle.sysman.db.rsc.inst.DBMsg"/>
  <uix:bundle name="msgDG" class="oracle.sysman.db.dg.rsc.DGMsg"/>
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <db:form name="pageForm" method="POST" destination="<%= Constant.OFS_CONTROLLER %>" copyParams="target,type">
        <uix:formValue name="<%= ParameterNames.PAGE_NAME %>" value="<%= Constant.MOUNT_OFS_PAGE %>" />
        <uix:pageLayout titleBinding="header@ofsBean@servletRequest">
          <%@ include file="/database/global.jspf" %>
          <oem:messageBox messageType="error" errorTableBinding="error@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
            <uix:tableLayout width="100%" cellSpacing="5">
              <uix:rowLayout width="100%">
                <uix:cellFormat hAlign="center" vAlign="top" width="30%" wrappingDisabled="true">
                  <uix:tableLayout cellSpacing="5">
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right" wrappingDisabled="true">
                        <uix:messagePrompt promptBinding="SIZE_GB@msg" />
                      </uix:cellFormat>
                      <uix:cellFormat wrappingDisabled="true">
                        <uix:styledText styleClass="OraDataText" textBinding="volSize@ofsBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right" wrappingDisabled="true">
                        <uix:messagePrompt promptBinding="DG_ALLOC_SPACE_GB@msg" />
                      </uix:cellFormat>
                      <uix:cellFormat wrappingDisabled="true">
                        <uix:styledText styleClass="OraDataText" textBinding="DgAllocatedSpace@ofsBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:tableLayout>
                </uix:cellFormat>
                <uix:cellFormat vAlign="top" width="70%" wrappingDisabled="true">
                  <uix:tableLayout cellSpacing="5">
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right" wrappingDisabled="true">
                        <uix:messagePrompt promptBinding="DISK_GROUP@msg" />
                      </uix:cellFormat>
                      <uix:cellFormat wrappingDisabled="true">
                        <uix:styledText styleClass="OraDataText" textBinding="diskGroup@ofsBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:tableLayout>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

            <uix:separator>
              <uix:spacer height="1"/>
            </uix:separator>

            <uix:tableLayout cellSpacing="5">
              <uix:rowLayout>
                <uix:cellFormat>
                  <uix:spacer height="10" width="10" />
                </uix:cellFormat>
                <uix:cellFormat>
                  <uix:styledText styleClass="OraPromptText" textBinding="INST_MOUNT_OFS_LINUX@msg" renderedBinding="isLinux@ofsBean@servletRequest"/>
		  <uix:tip renderedBinding="NoSudoSupport@ofsBean@servletRequest">
         	    <uix:styledText textBinding="MSG_ROOT_OPERATION@msg"/>
		  </uix:tip>
                  <uix:styledText styleClass="OraPromptText" textBinding="INST_MOUNT_OFS_WINDOWS@msg" renderedBinding="isWindows@ofsBean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

            <uix:tableLayout cellSpacing="5" renderedBinding="isMultipleHost@ofsBean@servletRequest">
              <uix:rowLayout>
                <uix:cellFormat>
                  <uix:spacer height="10" width="18" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="right" wrappingDisabled="true">
                  <uix:messagePrompt promptBinding="SELECTED_HOSTS@msg" />
                </uix:cellFormat>
                <uix:cellFormat wrappingDisabled="true">
                   <uix:styledText styleClass="OraDataText" textBinding="selectedHostsInString@ofsBean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

            <uix:tableLayout cellSpacing="5" width="100%">
              <uix:rowLayout>
                <uix:cellFormat width="60%" vAlign="top">
                  <uix:header textBinding="MOUNT_OPTIONS@msg">
                   <uix:tableLayout cellSpacing="5">
                    <uix:rowLayout>
                      <uix:cellFormat vAlign="top" wrappingDisabled="true">
                        <uix:messagePrompt required="yes" labeledNodeId="mountPoint" promptBinding="MOUNT_POINT@msg"/>
                      </uix:cellFormat>
                      <uix:cellFormat>
                        <uix:stackLayout>
                          <uix:messageLovField name="<%= OFSbean.ATTR_MOUNT_POINT %>" 
                                       id="mountPoint"
                                       textBinding="mountPoint@ofsBean@servletRequest"
                                       columns="70"
                                       searchDescBinding="MOUNT_POINT@msg"
                                       onClick = '<%= "startDirectoryBrowser(\'"+OFSbean.ATTR_MOUNT_POINT+"\');" %>'/>
                          <uix:messageText messageBinding="(MOUNT_POINT@msg)@error@servletRequest" messageType="error"/>
                          <uix:styledText styleClass="OraInlineInfoText" textBinding="HINT_MOUNT_POINT@msg" renderedBinding="SudoSupport@ofsBean@servletRequest"/>                      
                          <uix:styledText styleClass="OraInlineInfoText" textBinding="HINT_MOUNT_POINT_NO_SUDO@msg" renderedBinding="NoSudoSupport@ofsBean@servletRequest"/>                      
                        </uix:stackLayout>                                                                   
                      </uix:cellFormat>                          
	              </uix:rowLayout>  
                  </uix:tableLayout>
                 </uix:header>               
                </uix:cellFormat>
                <uix:cellFormat width="*" hAlign="right" vAlign="top" renderedBinding="SudoSupport@ofsBean@servletRequest">                 
      	 	<%@ include file="credentials.jsp" %>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

	    <uix:header textBinding="RELATED_LINKS@msgDB">
	      <uix:tableLayout width="100%"> 
		<uix:rowLayout>
		  <uix:cellFormat>
		    <db:link textBinding="OPEN_TELNET_SESSION@msgDG"
			     destinationBinding="telnetURL@servletRequest"/>
		  </uix:cellFormat>
		</uix:rowLayout>
	      </uix:tableLayout>
	    </uix:header>
	    
          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:submitButton textBinding="GENERATE_COMMAND@msg" name="event" value="<%= Constant.EVENT_SHOW_COMMAND %>" formName="pageForm" renderedBinding="NoSudoSupport@ofsBean@servletRequest"/>
	      <uix:button textBinding="RETURN@msg" destinationBinding="cancelURL@ofsBean@servletRequest" renderedBinding="NoSudoSupport@ofsBean@servletRequest"/>
              <uix:submitButton textBinding="SHOW_COMMAND@msg" name="event" value="<%= Constant.EVENT_SHOW_COMMAND %>" formName="pageForm" renderedBinding="SudoSupport@ofsBean@servletRequest"/>
	      <uix:button textBinding="CANCEL@msg" destinationBinding="cancelURL@ofsBean@servletRequest" renderedBinding="SudoSupport@ofsBean@servletRequest"/>
              <uix:submitButton textBinding="OK@msg" name="event" value="<%= Constant.EVENT_OK %>" formName="pageForm" renderedBinding="SudoSupport@ofsBean@servletRequest"/>
            </uix:pageButtonBar>
          </uix:pageButtons>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
