<%--
  -- Page:        createOFS.jsp
  -- Controller:  oracle.sysman.db.adm.osm.ofs.OFSController
  --
  -- Description: Create Oracle File System
  --
  --  MODIFIED    (MM/DD/YY)
  --  chanchan    04/27/06 - 
  --  evelur      03/17/06 - 
  --  chanchan    03/13/06 - Creation 
  --%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.osm.ofs.Constant" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="osmMsg" class="oracle.sysman.db.rsc.osm.OsmObjectMsg" />
  <uix:bundle name="msg" class="oracle.sysman.db.rsc.osm.ofs.OfsObjectMsg" />
  <uix:document>
    <uix:metaContainer>
      <uix:head titleBinding="CREATE_OFS@msg"/>
    </uix:metaContainer>
    <uix:body>
      <uix:form name="pageForm" method="POST" destination="viewVolume">
        <uix:pageLayout titleBinding="CREATE_OFS@msg">
          <%@ include file="/database/global.jspf" %>          
            <uix:tableLayout cellSpacing="5">
              <uix:rowLayout>
                <uix:cellFormat>
	    	      <uix:spacer width="8"/>
		          <uix:styledText styleClass="OraPromptText" textBinding="CREATE_OFS_INSTR@OfsObjectBundle@servletRequest"/>
        	    </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout><!-- The LOV starts here -->
                <uix:cellFormat hAlign="right">                   
                  <uix:messagePrompt labeledNodeId="volDevice"
                                   promptBinding="VOLUME_DEVICE@OfsObjectBundle@servletRequest"
                                   required="yes"/>
                </uix:cellFormat>
                <uix:stackLayout>

                  <uix:messageLovField name="volDevice" 
                                       id="volDevice"
                                       text="Hi Volume"
                                       columns="60"
                                       searchDescBinding="VOLUME_DEVICE@OfsObjectBundle@servletRequest"
                                       onClick = "selectVolume();" />

                  <!--uix:messageText messageBinding="filepath@errors@servletRequest"
                                 messageType="error"/-->

                </uix:stackLayout>                     
                <uix:cellFormat>
                    <uix:submitButton textBinding="CREATE_VOLUME@msg" 
                                      shortDescBinding="CREATE_VOLUME@msg" 
                                      name="event" 
                                      value="<%= Constant.EVENT_CREATE_VOLUME %>"/>
              </uix:cellFormat>                                                            
              </uix:rowLayout><!-- LOV ends here -->
              <uix:rowLayout>                
                <uix:cellFormat hAlign="right">
                  <uix:messagePrompt promptBinding="STATE@msg" />
                </uix:cellFormat>
                <uix:cellFormat>                
                  <uix:styledText styleClass="OraDataText" textBinding="state@ofsBean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:messagePrompt promptBinding="USAGE@msg" />
                </uix:cellFormat>
                <uix:cellFormat>
                  <uix:styledText styleClass="OraDataText" textBinding="usage@ofsBean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:messagePrompt promptBinding="VOLUME_DEVICE@msg" />
                </uix:cellFormat>
                <uix:cellFormat>
                  <uix:styledText styleClass="OraDataText" textBinding="volDevice@ofsBean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:messagePrompt promptBinding="SIZE_GB@msg" />
                </uix:cellFormat>
                <uix:cellFormat>
                  <uix:styledText styleClass="OraDataText" textBinding="totalSize@ofsBean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:messagePrompt promptBinding="REDUNDANCY@msg" />
                </uix:cellFormat>
                <uix:cellFormat>
                  <uix:styledText styleClass="OraDataText" textBinding="redundancy@ofsBean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:messagePrompt promptBinding="STRIPE_WIDTH@msg" />
                </uix:cellFormat>
                <uix:cellFormat>
                  <uix:styledText styleClass="OraDataText" textBinding="StripeWidth@ofsBean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:messagePrompt promptBinding="STRIPE_COLUMNS@msg" />
                </uix:cellFormat>
                <uix:cellFormat>
                  <uix:styledText styleClass="OraDataText" textBinding="StripeCol@ofsBean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
            <!-- Oracle File System starts here -->
            <uix:checkBox checked="true" name="mntOfsCreation"
            			  textBinding="HINT_MOUNT_OFS@OfsObjectBundle@servletRequest"
            			  />
            <uix:tableLayout><!-- Tablelayout for OFS -->
              <uix:rowLayout>
                <uix:cellFormat width="65%" hAlign="right">
                  <uix:tableLayout><!-- Tablelayout for Mounting OFS -->
                    <uix:rowLayout>
                      <uix:header textBinding="MOUNT_OPTIONS@OfsObjectBundle@servletRequest"/>
                    </uix:rowLayout>                    
                    <uix:rowLayout>
	                    <uix:messagePrompt labeledNodeId="mountOFS"
                                   promptBinding="MOUNT_POINT@OfsObjectBundle@servletRequest"/>
                    <!-- LOV for Mounting the OFS -->
                      <uix:stackLayout>

		                  <uix:messageLovField name="mountOFS" 
                                       id="mountOFS"
                                       text="Hi OFS"
                                       columns="60"
                                       searchDescBinding="MOUNT_POINT@OfsObjectBundle@servletRequest"
                                       onClick = "mountOFS();" />

        		          <!--uix:messageText messageBinding="filepath@errors@servletRequest"
                                 messageType="error"/-->

                	 </uix:stackLayout>                                           
                    </uix:rowLayout>  
                    <uix:rowLayout>
                      <uix:styledText styleClass="OraInstructionText"
                                    textBinding="HINT_MOUNT_POINT@OsmObjectBundle@servletRequest"/>
                    </uix:rowLayout>                  
                    
                    
                  </uix:tableLayout><!-- TL for Mounting OFS ends here -->                  
                </uix:cellFormat>
                <uix:cellFormat width="35%" hAlign="right">
                  <uix:tableLayout><!-- TL for host creds starts here-->
                    <uix:rowLayout>
                      <uix:header textBinding="HOST_CREDS@OsmObjectBundle@servletRequest"/>
                    </uix:rowLayout>                    
                  </uix:tableLayout><!-- TL for Host Creds ends here -->                  
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout><!-- TL for OFS ends here -->
          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:submitButton textBinding="SHOW_COMMAND@msg" name="event" value="<%= Constant.EVENT_SHOW_COMMAND %>" formName="pageForm" />
		  <uix:button textBinding="CANCEL@msg" destinationBinding="cancelURL@ofsBean@servletRequest"/>
              <uix:submitButton textBinding="OK@msg" name="event" value="<%= Constant.EVENT_OK %>" formName="pageForm" />
            </uix:pageButtonBar>
          </uix:pageButtons>
        </uix:pageLayout>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
