<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>
<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.osm.ofs.Constant" %>
<%@ page import="oracle.sysman.emo.adm.osm.ofs.OFSbean" %>
<%@ page import="oracle.sysman.db.adm.ParameterNames" %>
<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:bundle name="msg" class="oracle.sysman.db.rsc.osm.ofs.OfsObjectMsg" />
  <uix:document> 
    <%@ include file="/oemTitle.jspf" %>    
    <uix:body>
      <uix:contents>
        <db:form name="pageForm" method="POST" destination="<%= Constant.OFS_CONTROLLER %>" copyParams="target,type">
         <uix:formValue name="<%= ParameterNames.PAGE_NAME %>" value="<%= Constant.OFS_PROGRESS_PAGE %>" />

	   <uix:pageLayout titleBinding="header@progressBean@servletRequest" messageType="processing">

            <!-- for breadcrumbs support; plus standard label, links, tabs, etc -->
            <%@ include file="/database/global.jspf" %>           

            <oem:messageBox messageType="info" 
                                 errorTableBinding="info@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
            <oem:messageBox messageType="error"
                                 errorTableBinding="error@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
            
            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:contents>
                  <uix:submitButton textBinding="CANCEL@msg" name="event" value="<%= Constant.EVENT_STOP %>"
		  formName="pageForm" renderedBinding="isRacAsm@progressBean@servletRequest"/> 
                </uix:contents>
              </uix:pageButtonBar>
            </uix:pageButtons>

            <uix:pageStatus>
              <uix:stackLayout>
                <uix:contents>
                  <uix:styledText styleClass="OraInstructionTextStrong" textBinding="pageStatus@progressBean@servletRequest"/>
                </uix:contents>
              </uix:stackLayout>
            </uix:pageStatus>

            <uix:contents>
              <uix:stackLayout>
                <uix:contents>
                  <uix:spacer height="5" />
                  <uix:styledText styleClass="OraInstructionText" textBinding="MSG_IN_PROGRESS_HOST@msg" renderedBinding="isRacAsm@progressBean@servletRequest"/>
                  <uix:spacer height="20" /> 
                  <uix:styledText styleClass="OraInstructionTextStrong" textBinding="completion@progressBean@servletRequest" renderedBinding="isCancel@progressBean@servletRequest"/>
                  <uix:styledText styleClass="OraInstructionTextStrong"
		  textBinding="cancelAtMessage@progressBean@servletRequest" renderedBinding="isCancel@progressBean@servletRequest"/>

                  <uix:processing timeIntervalBinding="timeInterval@progressBean@servletRequest">
                    <uix:contents>
                      <uix:tableLayout cellSpacing="1">
                        <uix:contents childDataBinding="ofsProgressData@progressBean@servletRequest">

                          <uix:rowLayout>
                            <uix:contents >
                              <uix:cellFormat renderedBinding="isRacAsm@progressBean@servletRequest">
                                <uix:contents>
                                  <uix:image source="/em/images/processCheck.gif" 
                                    renderedBinding="renderedDone"/>  
                                  <uix:image source="/em/images/critical.gif" 
                                    renderedBinding="renderedError"/>            
                                  <uix:image source="/em/images/currentStep.gif" 
                                    renderedBinding="current"/>                                         
                                </uix:contents>
                              </uix:cellFormat>
                              <uix:spacer width="3" />
                              <uix:cellFormat vAlign="bottom">
                                <uix:contents >
                                <uix:styledText styleClass="OraFieldText" textBinding="text" /> 
                                </uix:contents>
                              </uix:cellFormat>
                            </uix:contents>
                          </uix:rowLayout>

                        </uix:contents>
                      </uix:tableLayout>
                    </uix:contents>
                  </uix:processing>
  	 	<uix:styledText styleClass="OraHeaderSubSub" textBinding="ICON_KEYS@msg" renderedBinding="isRacAsm@progressBean@servletRequest"/>
             	<uix:tableLayout cellSpacing="5" renderedBinding="isCancel@progressBean@servletRequest">
                  <uix:rowLayout>
                    <uix:contents >
                      <uix:image source="/em/images/processCheck.gif"/>
		      <uix:styledText styleClass="OraInlineInfoText" textBinding="DONE@msg" />
		      <uix:spacer width="10" />
		      <uix:image source="/em/images/critical.gif"/>
		      <uix:styledText styleClass="OraInlineInfoText" textBinding="ERROR@msg" />
		      <uix:spacer width="10" />
		      <uix:image source="/em/images/currentStep.gif" />
		      <uix:styledText styleClass="OraInlineInfoText" textBinding="CURRENT@msg" />
                    </uix:contents >
                  </uix:rowLayout>
                </uix:tableLayout>

                </uix:contents>
              </uix:stackLayout>
            </uix:contents>
          </uix:pageLayout> 
        </db:form>  
      </uix:contents>
    </uix:body>

  </uix:document> 
</uix:renderingContext> 
