<%--
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates.All rights reserved. 
  -- Page:        ofsSitemap.jsp
  -- Controller:  oracle.sysman.db.adm.osm.ofs.OFSSitemapController
  --
  -- Description: Mount Oracle File System
  --
  --  MODIFIED    (MM/DD/YY)
  --  chanchan    02/09/09 - Add space used by snapshot
  --  chanchan    01/30/09 - Support OAC ADA
  --  chanchan    10/30/08 - Add Up Since
  --  chanchan    06/16/08 - Add support for display num host only for RAC
  --  chanchan    05/27/08 - Change Corrupt to Check and Repair
  --  chanchan    11/19/07 - Add snapshot supports
  --  qsong       06/06/07 - add dg alloc space
  --  qsong       04/09/07 - add ofs doesn't exist handler
  --  qsong       11/13/06 - 
  --  chanchan    05/26/06 - 
  --  qsong       04/28/06 - 
  --  chanchan    04/27/06 - 
  --  qsong       04/14/06 - 
  --  chanchan    03/13/06 - Creation 
  --%>

<%@ include file="/sdk/oemTop.jspf" %>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.osm.ofs.Constant" %>
<%@ page import="oracle.sysman.emo.adm.osm.ofs.ServicedHostsInfoDataSource" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.inst.DBMsg" />
  <uix:bundle name="sdkMsgs" class="oracle.sysman.emSDK.eml.SDKUIMsg" />
  <uix:bundle name="dbObjMsgs" class="oracle.sysman.db.rsc.DBObjectMsg" />
  <uix:bundle name="ofsMsg" class="oracle.sysman.db.rsc.osm.ofs.OfsObjectMsg" />
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <db:form name="pageForm" 
            method="POST" 
            destination="<%= Constant.OFS_SITEMAP_CONTROLLER %>"
	    copyParams="target,type,oname,hostName" >
        <uix:formValue name="pageName" value="<%= Constant.OFS_SITEMAP_PAGE %>"/>
        <uix:pageLayout titleBinding="header@ofsSitemapBean@servletRequest">
          <%@ include file="/database/global.jspf" %>

     <oem:messageBox messageType="error" errorTableBinding="error@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
     <uix:subTabLayout>
        <uix:subTabs>
              <uix:subTabBar selectedIndex="0">
                <uix:link textBinding="GENERAL@ofsMsg"/>
                <uix:link textBinding="SNAPSHOTS@ofsMsg" renderedBinding="showSnapshot@servletRequest" destinationBinding="snapshotPath@servletRequest"/>
              </uix:subTabBar>
      </uix:subTabs>


        <uix:dataScope currentDataBinding="servicedHostsInfoDS@defaultBean@servletRequest">

        <uix:tableLayout width="100%" renderedBinding="showNormal@defaultBean@servletRequest">
          <uix:rowLayout hAlign="right">
            <uix:cellFormat>
              <uix:switcher childNameBinding="showTime@defaultBean@servletRequest">
                <uix:case name="true">
                  <uix:rowLayout>
                    <uix:styledText styleClass="OraInlineInfoText"
                                    textBinding="lastUpdatedTime@defaultBean@servletRequest"/>
                    <uix:spacer width="5"/>  
                    <uix:button textBinding="REFRESH@OsmObjectBundle@servletRequest"
                                destinationBinding="sitemapDest@servletRequest" />
                  </uix:rowLayout>
                </uix:case>
              </uix:switcher>
            </uix:cellFormat>
          </uix:rowLayout>
        </uix:tableLayout>


        <uix:tableLayout width="100%" cellSpacing="5" renderedBinding="ofsNoneExisting@defaultBean@servletRequest">
        <uix:rowLayout>
          <uix:spacer height="15"/>
        </uix:rowLayout>
        <uix:rowLayout hAlign="center">
          <uix:tableLayout>
            <uix:rowLayout> 
              <uix:image source="/em/images/warning.gif"/>
              <uix:spacer width="5"/>
              <uix:styledText styleClass="OraInstructionText" 
                              textBinding="NO_OFS_INFO_AVAILABLE@ofsMsg"/>
            </uix:rowLayout> 
          </uix:tableLayout>
          </uix:rowLayout>
        <uix:rowLayout>
          <uix:spacer height="15"/>
        </uix:rowLayout>
        </uix:tableLayout> 

        <uix:tableLayout width="100%" cellSpacing="5" renderedBinding="ofsExisting@defaultBean@servletRequest">

          <uix:rowLayout vAlign="top">
            <!-- ...................  General Section .................. -->
            <uix:cellFormat vAlign="top" width="20%" wrappingDisabled="true">
              <uix:stackLayout>
                <uix:header textBinding="GENERAL@dbMsgs">
                  <uix:rowLayout> <!-- traffic light -->
                    <uix:cellFormat vAlign="top">
                      <!--  Traffic Light... -->
                      <uix:image sourceBinding="trafficImage@servletRequest" shortDescBinding="trafficStatusStr@defaultBean@servletRequest"/>
                    </uix:cellFormat>

                    <uix:cellFormat width="100%">
                      <uix:stackLayout>
                        <uix:spacer height="20"/>

                        <uix:switcher childNameBinding="showNormal@defaultBean@servletRequest">

                          <!------------------------
                            -- Last Known State
                            ------------------------>
                          <uix:case name="false">
                            <uix:rowLayout width="100%">
                            <uix:labeledFieldLayout width="0" labelWidth="0" fieldWidth="0">
                              <!-- Current status -->
                              <uix:styledText styleClass="OraPromptText"
                                textBinding="CURRENT_STATUS@dbMsgs"/>
                              <uix:styledText styleClass="OraDataText"
                                textBinding="trafficStatusStr@defaultBean@servletRequest"/>

                              <!-- Last known state -->
                              <uix:link textBinding="LAST_KNOWN_STATE@mntrMsgs"
                                destinationBinding="showLastDest@servletRequest"/>
                            </uix:labeledFieldLayout>
                            </uix:rowLayout>
                          </uix:case>

                          <!------------------------
                            -- Normal
                            ------------------------>
                          <uix:default>
                            <uix:rowLayout width="100%">
                            <uix:tableLayout>
                              <!-- Current status -->
                              <uix:rowLayout>
                                <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                  <uix:styledText styleClass="OraPromptText"
                                                  textBinding="CURRENT_STATUS@dbMsgs"/>
                                </uix:cellFormat>
                                <uix:spacer width="10"/>
                                <uix:styledText styleClass="OraDataText"
                                  textBinding="trafficStatusStr@defaultBean@servletRequest"/>
                              </uix:rowLayout>

                              <!-- Up since -->
                              <uix:rowLayout>
                                <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                  <uix:styledText styleClass="OraPromptText"
                                                  textBinding="UP_SINCE_TEXT@dbMsgs"/>
                                </uix:cellFormat>
                                <uix:spacer width="10"/>
		                <uix:tableLayout>
                                  <uix:rowLayout>
                                    <uix:cellFormat hAlign="left" wrappingDisabled="true">
	                              <uix:styledText styleClass="OraDataText" textBinding="upSinceTimeLocal@defaultBean@servletRequest"/>
                                    </uix:cellFormat>
                                  </uix:rowLayout>
		                </uix:tableLayout>
                              </uix:rowLayout>

                              <!-- Available on hosts -->
                              <uix:rowLayout renderedBinding="displayTotalHosts@defaultBean@servletRequest">
                                <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                  <uix:styledText styleClass="OraPromptText"
                                                  textBinding="AVAILABLE_ON_HOSTS@ofsMsg"/>
                                </uix:cellFormat>
                                <uix:spacer width="1"/>
                                <uix:cellFormat>
                                  <uix:image source="/em/images/up.gif"
                                             shortDesc="Up"/>
                                  <uix:spacer width="2"/>
                                  <uix:styledText styleClass="OraDataText"
                                                  textBinding="availableOnHosts@defaultBean@servletRequest"/>
                                  <uix:spacer width="2"/>
                                  <uix:styledText styleClass="OraDataText"
                                                  textBinding="totalHostsStr@defaultBean@servletRequest"/>
                                </uix:cellFormat>
                              </uix:rowLayout>

                              <!-- Corrupt -->
                              <uix:rowLayout>
                                <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                  <uix:styledText styleClass="OraPromptText"
                                                  textBinding="CHECK_REPAIR@ofsMsg"/>
                                </uix:cellFormat>
                                <uix:spacer width="10"/>
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="corrupt@defaultBean@servletRequest"/>
                              </uix:rowLayout>

                              <!-- Volume name -->
                              <uix:rowLayout>
                                <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                  <uix:styledText styleClass="OraPromptText"
                                                  textBinding="VOLUME@ofsMsg"/>
                                </uix:cellFormat>
                                <uix:spacer width="10"/>
                                <uix:link textBinding="volumeName@defaultBean@servletRequest"
                                          destinationBinding="volumeNameUrl@defaultBean@servletRequest"/>
                              </uix:rowLayout>

                              <!-- Volume Device name -->
                              <uix:rowLayout>
                                <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                  <uix:styledText styleClass="OraPromptText"
                                                  textBinding="VOLUME_DEVICE@ofsMsg"/>
                                </uix:cellFormat>
                                <uix:spacer width="10"/>
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="volumeDevice@defaultBean@servletRequest"/>
                              </uix:rowLayout>
                            </uix:tableLayout>

                            </uix:rowLayout>
                          </uix:default> <!-- Normal -->
                        </uix:switcher>

                      </uix:stackLayout>
                    </uix:cellFormat>
                  </uix:rowLayout> <!-- traffic light -->

                </uix:header>

              </uix:stackLayout>
            </uix:cellFormat>


            <%-- .................... Current Space Usage .................... --%>
            <uix:cellFormat vAlign="top" width="20%" wrappingDisabled="true">
              <uix:header textBinding="CURRENT_SPACE_USAGE@ofsMsg">
              <uix:tableLayout> 
                <uix:rowLayout>
                  <uix:spacer height="15"/>
                </uix:rowLayout>
                <%-- .. size GB .. --%>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                    <uix:styledText styleClass="OraPromptText"
                                    textBinding="SIZE_GB@ofsMsg"/>
                  </uix:cellFormat>
                  <uix:spacer width="5"/>
                  <uix:styledText styleClass="OraDataText"
                                  textBinding="sizeGB@defaultBean@servletRequest"/>
                </uix:rowLayout>

                <%-- .. used GB .. --%>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                    <uix:styledText styleClass="OraPromptText"
                                    textBinding="USED_GB@ofsMsg"/>
                  </uix:cellFormat>
                  <uix:spacer width="10"/>
                  <uix:styledText styleClass="OraDataText"
                                  textBinding="usedGB@defaultBean@servletRequest"/>
                </uix:rowLayout>

                <%-- .. free GB .. --%>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                    <uix:styledText styleClass="OraPromptText"
                                    textBinding="FREE_GB@ofsMsg"/>
                  </uix:cellFormat>
                  <uix:spacer width="10"/>
                  <uix:styledText styleClass="OraDataText"
                                  textBinding="freeGB@defaultBean@servletRequest"/>
                </uix:rowLayout>

                <%-- .. used Pct .. --%>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                    <uix:styledText styleClass="OraPromptText"
                                    textBinding="USED_PCT@ofsMsg"/>
                  </uix:cellFormat>
                  <uix:spacer width="10"/>
                  <uix:styledText styleClass="OraDataText"
                                  textBinding="usedPct@defaultBean@servletRequest"/>
                </uix:rowLayout>
                
                <%-- .. diskgroup allocated size GB .. --%>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                    <uix:styledText styleClass="OraPromptText"
                                    textBinding="DG_ALLOC_SPACE_GB@ofsMsg"/>
                  </uix:cellFormat>
                  <uix:spacer width="5"/>
                  <uix:styledText styleClass="OraDataText"
                                  textBinding="dgAllocSizeGB@defaultBean@servletRequest"/>
                </uix:rowLayout>

                <%-- .. Total Snapshot Space Used MB .. --%>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                    <uix:styledText styleClass="OraPromptText"
                                    textBinding="SNAPSHOT_TOTAL_USED_SPACE@ofsMsg"/>
                  </uix:cellFormat>
                  <uix:spacer width="10"/>
                  <uix:styledText styleClass="OraDataText"
                                  textBinding="snapshotSpaceUsedMB@defaultBean@servletRequest"/>
                </uix:rowLayout>

              </uix:tableLayout>
              </uix:header>
            </uix:cellFormat>


            <%-- .................... Space Usage History .................... --%>
            <uix:cellFormat vAlign="top" width="40%" >
              <uix:header textBinding="DAILY_SPACE_USAGE_7DAYS@ofsMsg">
                <uix:tableLayout cellSpacing="5">
                <uix:rowLayout>
                <oem:chart
                     chartType="timeSeriesChart"
                     width="400"
                     height="200"
                     timeGranularity="DAY"
                     orientation="vertical"
                     fill="none"
                     yAxisLabelBinding="SIZE_GB@ofsMsg"
                     legendPosition="south">
                
                  <uix:contents>
                    <oem:boundChartDataSource
                         chartDataSourceBinding="spaceUsageChartDS@defaultBean@servletRequest"/>
                    <oem:chartColumn
                         isKey="true"
                         displayLabel=""
                         sourceIndex="0" />
                    <oem:chartColumn
                         isTimeColumn="true"
                         displayLabel="Time"
                         sourceIndex="1"  />
                    <oem:chartColumn
                         displayLabel=""
                         sourceIndex="2"/>
                  </uix:contents>
                </oem:chart>
                
                </uix:rowLayout>
                </uix:tableLayout>
              </uix:header>
            </uix:cellFormat>

          </uix:rowLayout>
        </uix:tableLayout>

        <%-- The serviced hosts table --%>
        <uix:header textBinding="SERVICED_HOSTS@ofsMsg" renderedBinding="ofsExisting@defaultBean@servletRequest" >
        <uix:tableLayout width="100%"> 
          <uix:rowLayout>
            <uix:table summaryBinding="SERVICED_HOSTS@ofsMsg" 
		      		         width="100%" 
                       formSubmitted="true"
                       id="hostsInfo"
                       tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                       valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                       maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                       blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>"
                       partialRenderMode="self"
                       alternateTextBinding="NO_ITEMS_FOUND@dbObjMsgs">

              <%-- Host column --%>
              <uix:column>
                <uix:columnHeader>
                  <uix:sortableHeader textBinding="HOST_NAME@ofsMsg"
                                      sortableBinding="<%= ServicedHostsInfoDataSource.S_SORT_HOST_COL %>" />
                </uix:columnHeader>
                <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                  <uix:contents>
                  <uix:rowLayout>
                    <uix:separator>
                      <uix:spacer width="1" height="0"/>
                    </uix:separator>
                    <uix:contents>
                      <uix:link textBinding="<%= ServicedHostsInfoDataSource.S_HOST_COL %>"
                                destinationBinding="<%= ServicedHostsInfoDataSource.S_HOST_DEST %>"/>
                      <uix:image sourceBinding="<%= ServicedHostsInfoDataSource.HOST_STATUS_IMAGE_SOURCE%>" shortDescBinding="<%= ServicedHostsInfoDataSource.HOST_STATUS%>"/>
                    </uix:contents>
                  </uix:rowLayout>
                </uix:contents>
              </uix:column>

              
              <%-- OFS Status column --%>
              <uix:column>
                <uix:columnHeader>
                  <uix:sortableHeader textBinding="OFS_STATUS@ofsMsg"
                                      sortableBinding="<%= ServicedHostsInfoDataSource.S_SORT_STATUS_COL%>" />
                </uix:columnHeader>
                <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                <%-- uix:styledText textBinding="<%= ServicedHostsInfoDataSource.S_STATUS_COL %>"/--%>
                
                <uix:switcher childNameBinding="<%= ServicedHostsInfoDataSource.S_STATUS_COL%>">
                 <uix:case name="AVAILABLE"> 
                   <uix:image source="<%= request.getContextPath()+\"/images/up_active.gif\"%>" shortDescBinding="UP@ofsMsg"/>
                 </uix:case> 
                 <uix:case name="NOT AVAILABLE"> 
                   <uix:image source="<%= request.getContextPath()+\"/images/down_active.gif\"%>" shortDescBinding="DOWN@ofsMsg"/>
                 </uix:case> 
                </uix:switcher>

              </uix:column>

              <%-- Up time column --%>
              <uix:column>
                <uix:columnHeader>
                  <uix:sortableHeader textBinding="AVAILABLE_SINCE@ofsMsg"
                                      sortableBinding="<%= ServicedHostsInfoDataSource.S_SORT_UPTIME_COL %>" />
                </uix:columnHeader>
                <uix:columnFormat columnDataFormat="textFormat"/>
                <uix:styledText textBinding="<%= ServicedHostsInfoDataSource.S_UPTIME_COL %>"/>
              </uix:column>

              <%-- State column --%>
              <uix:column>
                <uix:columnHeader>
                  <uix:sortableHeader textBinding="STATE@ofsMsg"
                                      sortableBinding="<%= ServicedHostsInfoDataSource.S_SORT_STATE_COL %>" />
                </uix:columnHeader>
                <uix:columnFormat columnDataFormat="textFormat"/>
                <uix:styledText textBinding="<%= ServicedHostsInfoDataSource.S_STATE_COL %>"/>
              </uix:column>

              <%-- ASM column --%>
              <uix:column>
                <uix:columnHeader>
                  <uix:sortableHeader textBinding="ASM_INSTANCE@ofsMsg"
                                      sortableBinding="<%= ServicedHostsInfoDataSource.S_SORT_ASM_COL %>" />
                </uix:columnHeader>
                <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                <uix:contents>
                  <uix:rowLayout>
                    <uix:link textBinding="<%= ServicedHostsInfoDataSource.S_ASM_COL %>"
                              destinationBinding="<%= ServicedHostsInfoDataSource.S_ASM_DEST %>"/>
                    <uix:separator>
                      <uix:spacer width="1" height="0"/>
                    </uix:separator>
                    <uix:image sourceBinding="<%= ServicedHostsInfoDataSource.ASM_STATUS_IMAGE_SOURCE%>" shortDescBinding="<%= ServicedHostsInfoDataSource.ASM_STATUS %>"/>
                  </uix:rowLayout>
                </uix:contents>
              </uix:column>
            </uix:table>
          </uix:rowLayout>
        </uix:tableLayout> 
      </uix:header> 
      <uix:header textBinding="ALERTS_HEADER@dbMsgs"
        renderedBinding="ofsExisting@defaultBean@servletRequest">
          <uix:tableLayout width="100%" >
              <uix:rowLayout vAlign="top">

                <oem:table summaryBinding="ALERTS_HEADER@dbMsgs"
                           name="alertsUIDataSource"
                           partialRenderMode="self"
                           id="alertsTable"
                           alternateTextBinding="NO_ALERTS_ALT@sdkMsgs"

                           width="100%"
                           dataSourceProp="alertsUIDataSource"
                           beanKey="ofsSitemapBean"
                           formSubmitted="true"
                           blockSize="5">
                  </oem:table>

              </uix:rowLayout>
            </uix:tableLayout>
        </uix:header>

          </uix:dataScope>
    </uix:subTabLayout>
        </uix:pageLayout>

      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
