<%--
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates.All rights reserved. 
  -- Page:        ofsSnapshot.jsp
  -- Controller:  oracle.sysman.db.adm.osm.ofs.OFSController
  --
  -- Description: OFS snapshot tab
  --
  --  MODIFIED    (MM/DD/YY)
  --  chanchan    02/05/09 - Add Space Used by Snapshots
  --  chanchan    01/30/09 - Support OAC ADA
  --  chanchan    04/07/08 - Add enhancement
  --  chanchan    12/11/07 - Creation 
  --%>

<%@ include file="/sdk/oemTop.jspf" %>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.osm.ofs.Constant" %>
<%@ page import="oracle.sysman.emo.adm.osm.ofs.OFSbean" %>
<%@ page import="oracle.sysman.emo.adm.osm.ofs.OfsSitemap" %>
<%@ page import="oracle.sysman.emo.adm.osm.ofs.ServicedHostsInfoDataSource" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>

<script language="javascript">
function popDirBrowser(dirPath)
{
  setDefaultDirectory(dirPath, '<%= OFSbean.ATTR_FILE_PATH_SEPARATOR %>');
  startDirectoryListing();
  return false;
}
</script>

<uix:renderingContext id="renderingContext">
<db:script src="/database/remoteBrowser/remoteBrowser.js"/>
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.inst.DBMsg" />
  <uix:bundle name="dbObjMsgs" class="oracle.sysman.db.rsc.DBObjectMsg" />
  <uix:bundle name="ofsMsg" class="oracle.sysman.db.rsc.osm.ofs.OfsObjectMsg" />
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <db:form name="pageForm" 
            method="POST" 
            destination="<%= Constant.OFS_CONTROLLER %>"
	    copyParams="target,type,oname,hostName" >
        <uix:formValue name="pageName" value="<%= Constant.OFS_SNAPSHOT_PAGE %>"/>
        <uix:formValue name="<%= OFSbean.ATTR_MOUNT_POINT %>" valueBinding="mountPoint@ofsBean@servletRequest"/>
        <uix:formValue name="<%= OFSbean.ATTR_VOLUME_DEVICE %>" valueBinding="volDevice@ofsBean@servletRequest"/>
        <uix:pageLayout titleBinding="header@ofsBean@servletRequest">
          <%@ include file="/database/global.jspf" %>
	  <oem:messageBox messageType="confirmation" errorTableBinding="confirmation@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error" errorTableBinding="error@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>

     <uix:subTabLayout>
        <uix:subTabs>
              <uix:subTabBar selectedIndex="1">
                <uix:link textBinding="GENERAL@ofsMsg" destinationBinding="sitemapDest@servletRequest"/>
                <uix:link textBinding="SNAPSHOTS@ofsMsg" />
              </uix:subTabBar>
      </uix:subTabs>
      
      <uix:header textBinding="SUMMARY@ofsMsg">
	<uix:styledText styleClass="OraPromptText" textBinding="SUMMARY_INST@ofsMsg"/>
        <uix:tableLayout width="40%" >
          <uix:rowLayout>
            <uix:spacer height="15"/>
          </uix:rowLayout>
          <uix:rowLayout hAlign="left">
            <uix:cellFormat vAlign="top" hAlign="middle">
              <uix:tableLayout width="30%" cellSpacing="5" >
                <uix:rowLayout hAlign="middle">
                  <uix:cellFormat hAlign="right">
                     <uix:styledText styleClass="OraPromptText" textBinding="NUMBER_SNAPSHOT@ofsMsg"/>
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left">
                     <uix:styledText styleClass="OraDataText" textBinding="snapshotCount@ofsBean@servletRequest"/>
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout hAlign="middle">
                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                     <uix:styledText styleClass="OraPromptText" textBinding="LAST_SNAPSHOT_TIME@ofsMsg"/>
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left" wrappingDisabled="true">
                     <uix:styledText styleClass="OraDataText" textBinding="lastSnapshotTime@ofsBean@servletRequest"/>
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout hAlign="middle">
                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                     <uix:styledText styleClass="OraPromptText" textBinding="SNAPSHOT_TOTAL_USED_SPACE@ofsMsg"/>
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left">
                     <uix:styledText styleClass="OraDataText" textBinding="snapshotSpaceUsage@ofsBean@servletRequest"/>
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout hAlign="middle">
                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                     <uix:styledText styleClass="OraPromptText" textBinding="TOTAL_FILE_FREE_SPACE@ofsMsg"/>
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left">
                     <uix:styledText styleClass="OraDataText" textBinding="ofsFreeSize@ofsBean@servletRequest"/>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:cellFormat>
            <uix:cellFormat vAlign="top" hAlign="left">
              <uix:tableLayout width="80%" cellSpacing="5">
            <uix:spacer height="15"/>
              </uix:tableLayout>
            </uix:cellFormat>
          </uix:rowLayout>
        </uix:tableLayout>
      </uix:header>
      
      <uix:header textBinding="SNAPSHOTS@ofsMsg">
       <uix:header textBinding="SEARCH@ofsMsg">
	<uix:styledText styleClass="OraPromptText" textBinding="SNAPSHOT_SEARCH_INST@ofsMsg"/>
        <uix:tableLayout cellSpacing="5">
          <uix:rowLayout>
            <uix:cellFormat hAlign="right" vAlign="top">
              <uix:messagePrompt promptBinding="NAME@ofsMsg" labeledNodeId="SNAPSHOT_NAME" />
            </uix:cellFormat>
            <uix:cellFormat>
              <uix:textInput name="<%= OFSbean.ATTR_SEARCH_SNAPSHOT %>" shortDescBinding="NAME@msg" id="SNAPSHOT_NAME" disabledBinding="isOffline@ofsBean@servletRequest"
  	                             columns="40" textBinding="searchBySnapshotName@ofsBean@servletRequest" />
            </uix:cellFormat>
            <uix:cellFormat>
              <uix:submitButton textBinding="SEARCH@ofsMsg" name="event" value="<%= Constant.EVENT_SEARCH %>" disabledBinding="isOffline@ofsBean@servletRequest"/>
            </uix:cellFormat>
          </uix:rowLayout>
        </uix:tableLayout>
	  <uix:tip>
            <uix:styledText textBinding="HINT_SEARCH@ofsMsg"/>
	  </uix:tip>

       </uix:header>
	<uix:separator />
        <uix:tableLayout cellSpacing="5" width="100%" renderedBinding="isStatusUp@ofsSitemapBean@servletRequest">
          <uix:rowLayout hAlign="right">
            <uix:cellFormat hAlign="right">
              <uix:submitButton textBinding="CREATE@ofsMsg" name="event" value="<%= Constant.EVENT_CREATE_SNAPSHOT %>" disabledBinding="isOffline@ofsBean@servletRequest"/>
            </uix:cellFormat>
          </uix:rowLayout>
        </uix:tableLayout>

        <uix:table summaryBinding="ORACLE_FILE_SYSTEMS@ofsMsg"
	    		 width="100%" 
                       formSubmitted="true"
                   id="<%= OFSbean.ATTR_TABLE_DATA %>"
                   tableDataBinding="tableData@ofsBean@servletRequest"
                   valueBinding="startIndex@ofsBean@servletRequest"
                   maxValueBinding="length@ofsBean@servletRequest"
                   blockSizeBinding="blockSize@ofsBean@servletRequest"
                   showAllBinding="showAll@ofsBean@servletRequest"
                   alternateTextBinding="NO_OBJECT_FOUND@ofsMsg">
		   
          <uix:tableFormat tableBanding="rowBanding"/>
          <uix:tableSelection >
            <uix:multipleSelection shortDescBinding="SELECT@ofsMsg" renderedBinding="isStatusUp@ofsSitemapBean@servletRequest">
              <uix:pageButtonBar>
                <uix:submitButton textBinding="DELETE@ofsMsg" name="event" value="<%= Constant.EVENT_DELETE_SNAPSHOT %>" shortDescBinding="DELETE@ofsMsg"/>
              </uix:pageButtonBar>
            </uix:multipleSelection>
          </uix:tableSelection>

               <%-- Host column --%>
              <uix:column>
                <uix:columnHeader>
                  <uix:sortableHeader textBinding="NAME@ofsMsg"
                                      sortableBinding="sortColumn0@ofsBean@servletRequest" />
                </uix:columnHeader>
                <uix:columnFormat columnDataFormat="textFormat"/>
                  <uix:contents>
                  <uix:rowLayout>
                    <uix:contents>
                      <uix:link textBinding="<%= OFSbean.ATTR_SNAPSHOT_NAME %>"
				onClickBinding="snapshotBrowser@ofsBean@servletRequest" />
	              <uix:formValue name="selectValue" valueBinding="<%= OFSbean.ATTR_SNAPSHOT_NAME %>"/>
                    </uix:contents>
                  </uix:rowLayout>
                </uix:contents>
              </uix:column>

              
              <%-- CREATION_TIME --%>
              <uix:column>
                <uix:columnHeader>
                  <uix:sortableHeader textBinding="CREATION_TIME@ofsMsg"
                                      sortableBinding="sortColumn1@ofsBean@servletRequest" />
                </uix:columnHeader>
                <uix:columnFormat columnDataFormat="textFormat"/>
                <uix:styledText textBinding="<%= OFSbean.ATTR_CREATION_TIME %>"/>
              </uix:column>
        </uix:table>
      </uix:header>
    </uix:subTabLayout>
        </uix:pageLayout>

      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
