<%--
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates.All rights reserved. 
  -- Page:        resizeOFS.jsp
  -- Controller:  oracle.sysman.db.adm.osm.ofs.OFSController
  --
  -- Description: Dismount Oracle File System
  --
  --  MODIFIED    (MM/DD/YY)
  --  chanchan    01/30/09 - Support OAC ADA
  --  chanchan    05/14/08 - Remove root credentials requirement
  --  chanchan    08/16/06 - Add volume label 
  --  chanchan    03/16/06 - Creation 
  --%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.osm.ofs.Constant" %>
<%@ page import="oracle.sysman.emo.adm.osm.ofs.OFSbean" %>
<%@ page import="oracle.sysman.db.adm.ParameterNames" %>
<%@ page import="oracle.sysman.emo.adm.osm.ofs.OracleFileSystem" %>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="msg" class="oracle.sysman.db.rsc.osm.ofs.OfsObjectMsg" />
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <db:form name="pageForm" method="POST" destination="<%= Constant.OFS_CONTROLLER %>" copyParams="target,type">
        <uix:formValue name="<%= ParameterNames.PAGE_NAME %>" value="<%= Constant.RESIZE_OFS_PAGE %>" />
        <uix:pageLayout titleBinding="header@ofsBean@servletRequest">
        <%@ include file="/database/global.jspf" %>
        <oem:messageBox messageType="info" errorTableBinding="info@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error" errorTableBinding="error@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
            <uix:tableLayout width="100%" cellSpacing="5">
              <uix:rowLayout width="100%">
                <uix:cellFormat hAlign="center" vAlign="top" width="40%" wrappingDisabled="true">
                  <uix:tableLayout cellSpacing="5">
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right" wrappingDisabled="true">
                        <uix:messagePrompt promptBinding="VOLUME_DEVICE@msg" />
                      </uix:cellFormat>
                      <uix:cellFormat wrappingDisabled="true">
                        <uix:styledText styleClass="OraDataText" textBinding="volDevice@ofsBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right" wrappingDisabled="true">
                        <uix:messagePrompt promptBinding="VOLUME@msg" />
                      </uix:cellFormat>
                      <uix:cellFormat wrappingDisabled="true">
                        <uix:styledText styleClass="OraDataText" textBinding="volName@ofsBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right" wrappingDisabled="true">
                        <uix:messagePrompt promptBinding="VOLUME_LABEL@msg" />
                      </uix:cellFormat>
                      <uix:cellFormat wrappingDisabled="true">
                        <uix:styledText styleClass="OraDataText" textBinding="volLabel@ofsBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:tableLayout>
                </uix:cellFormat>
                <uix:cellFormat vAlign="top" width="70%" wrappingDisabled="true">
                  <uix:tableLayout cellSpacing="5">
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right" wrappingDisabled="true">
                        <uix:messagePrompt promptBinding="DISK_GROUP@msg" />
                      </uix:cellFormat>
                      <uix:cellFormat wrappingDisabled="true">
                        <uix:styledText styleClass="OraDataText" textBinding="diskGroup@ofsBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right" wrappingDisabled="true">
                        <uix:messagePrompt promptBinding="DISK_GRP_FREE_SP@msg" />
                      </uix:cellFormat>
                      <uix:cellFormat wrappingDisabled="true">
                        <uix:styledText styleClass="OraDataText" textBinding="diskGroupSpace@ofsBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right" wrappingDisabled="true">
                        <uix:messagePrompt promptBinding="DG_ALLOC_SPACE_GB@msg" />
                      </uix:cellFormat>
                      <uix:cellFormat wrappingDisabled="true">
                        <uix:styledText styleClass="OraDataText" textBinding="DgAllocatedSpace@ofsBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:tableLayout>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

            <uix:separator>
              <uix:spacer height="1"/>
            </uix:separator>

            <uix:tableLayout cellSpacing="5">
              <uix:rowLayout>
                <uix:cellFormat>
                  <uix:spacer height="10" width="10" />
                </uix:cellFormat>
                <uix:cellFormat>
                  <uix:styledText styleClass="OraPromptText" textBinding="INST_RESIZE_OFS_LINUX@msg"/>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

            <uix:tableLayout cellSpacing="0">
              <uix:rowLayout>
                <uix:cellFormat>
                  <uix:spacer height="10" width="50" />
                </uix:cellFormat>
                <uix:cellFormat>
	              <uix:tableLayout cellSpacing="5">
        		    <uix:rowLayout>
	                  <uix:cellFormat hAlign="right">
			    <uix:messagePrompt promptBinding="SIZE@msg" labeledNodeId="SIZE"/>
	                  </uix:cellFormat>
	                  <uix:cellFormat hAlign="left" wrappingDisabled="true">
                            <uix:textInput name="<%= OFSbean.ATTR_OFS_TOTAL_SIZE %>" textBinding="ofsSize@ofsBean@servletRequest" columns="15" shortDescBinding="SIZE@msg" id="SIZE" disabledBinding="isOffline@ofsBean@servletRequest"/>
		              <uix:choice name="<%= OFSbean.ATTR_SIZE_UNIT %>" selectedValueBinding="sizeUnit@ofsBean@servletRequest" shortDescBinding="SIZE@msg" disabledBinding="isOffline@ofsBean@servletRequest">
		                <uix:option textBinding="UNIT_KB@msg" value="<%= OracleFileSystem.UNIT_KB %>"/>
		                <uix:option textBinding="UNIT_MB@msg" value="<%= OracleFileSystem.UNIT_MB %>"/>
		                <uix:option textBinding="UNIT_GB@msg" value="<%= OracleFileSystem.UNIT_GB %>"/>
		                <uix:option textBinding="UNIT_TB@msg" value="<%= OracleFileSystem.UNIT_TB %>"/>
		              </uix:choice>
	                  </uix:cellFormat>
        		    </uix:rowLayout>
        		    <uix:rowLayout>
	                  <uix:cellFormat>
	                  </uix:cellFormat>
	                  <uix:cellFormat hAlign="left">
                          <uix:messageText messageBinding="(SIZE@msg)@error@servletRequest" messageType="error"/>
	                  </uix:cellFormat>
        		    </uix:rowLayout>
	              </uix:tableLayout>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:submitButton textBinding="SHOW_COMMAND@msg" name="event" value="<%= Constant.EVENT_SHOW_COMMAND %>" formName="pageForm" disabledBinding="isOffline@ofsBean@servletRequest"/>
		  <uix:button textBinding="CANCEL@msg" destinationBinding="cancelURL@ofsBean@servletRequest"/>
              <uix:submitButton textBinding="OK@msg" name="event" value="<%= Constant.EVENT_OK %>" formName="pageForm" disabledBinding="isOffline@ofsBean@servletRequest"/>
            </uix:pageButtonBar>
          </uix:pageButtons>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
