<%--
  -- Page:        selectHost.jsp
  -- Controller:  oracle.sysman.db.adm.osm.ofs.OFSController
  --
  -- Description: Select hosts that to be performed operation on
  --
  --  MODIFIED    (MM/DD/YY)
  --  chanchan    01/19/07 - Creation 
  --%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.osm.ofs.Constant" %>
<%@ page import="oracle.sysman.emo.adm.osm.ofs.OFSbean" %>
<%@ page import="oracle.sysman.db.adm.ParameterNames" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="msg" class="oracle.sysman.db.rsc.osm.ofs.OfsObjectMsg" />
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
   
    <uix:body>
    <db:form name="pageForm" method="POST" destination="<%= Constant.OFS_CONTROLLER %>" copyParams="target,type">
    <uix:pageLayout titleBinding="selHostHeader@ofsBean@servletRequest">
     <%@ include file="/database/global.jspf" %>   

       <oem:messageBox messageType="info"
                       errorTableBinding="confirmation@servletRequest"
                       titleTextKey="titleText" mainTextKey="mainText"/>
       <oem:messageBox messageType="error"
                       errorTableBinding="error@servletRequest"
                       titleTextKey="titleText" mainTextKey="mainText"/>

      <uix:formValue name="<%= ParameterNames.PAGE_NAME %>" value="<%= Constant.RAC_SELECT_HOST_PAGE %>" />

      <uix:pageStatus>      
        <uix:styledText styleClass="OraInstructionText" textBinding="INST_SELECT_HOSTS@msg"/>
      </uix:pageStatus>      

         <uix:spacer  height="15"/>
         <oem:shuttle name="<%= OFSbean.ATTR_CLUSTER_HOSTS %>"
                      leadingHeaderBinding="AVAILABLE_HOSTS@msg"
                      trailingHeaderBinding="SELECTED_HOSTS@msg"
                      size="15"
                      reorderable="true">
                    <uix:leading>
                      <oem:list shortDescBinding="AVAILABLE_HOSTS@msg" name="<%= OFSbean.ATTR_AVAIL_HOSTS %>" optionsBinding="availableHosts@ofsBean@servletRequest" multiple="true"/>
                    </uix:leading>
                    <uix:trailing>
                      <oem:list shortDescBinding="SELECTED_HOSTS@msg" name="<%= OFSbean.ATTR_SELECTED_HOSTS %>" optionsBinding="selectedHosts@ofsBean@servletRequest" multiple="true"/>
                    </uix:trailing>
         </oem:shuttle>
                
       <uix:pageButtons>
        <uix:pageButtonBar>
          <uix:contents>
            <uix:button textBinding="CANCEL@msg" destinationBinding="cancelURL@ofsBean@servletRequest"/>
            <uix:submitButton textBinding="CONTINUE@msg" name="event" value="<%= Constant.EVENT_CONTINUE %>" formName="pageForm" />
          </uix:contents>
        </uix:pageButtonBar>
       </uix:pageButtons>

    </uix:pageLayout>
    </db:form>    
  </uix:body>
  </uix:document>
</uix:renderingContext>
