<%--
  -- Page:        selectHost.jsp
  -- Controller:  oracle.sysman.db.adm.osm.ofs.OFSController
  --
  -- Description: Select hosts that to be performed operation on
  --
  --  MODIFIED    (MM/DD/YY)
  --  chanchan    01/19/07 - Creation 
  --%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.osm.ofs.Constant" %>
<%@ page import="oracle.sysman.emo.adm.osm.ofs.VolumeBean" %>
<%@ page import="oracle.sysman.db.adm.ParameterNames" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="msg" class="oracle.sysman.db.rsc.osm.ofs.OfsObjectMsg" />
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
   
    <uix:body>
    <db:form name="pageForm" method="POST" destination="<%= Constant.VOLUME_CONTROLLER %>" copyParams="target,type">
    <uix:pageLayout>
     <%@ include file="/database/global.jspf" %>   

       <oem:messageBox messageType="info"
                       errorTableBinding="confirmation@servletRequest"
                       titleTextKey="titleText" mainTextKey="mainText"/>
       <oem:messageBox messageType="error"
                       errorTableBinding="error@servletRequest"
                       titleTextKey="titleText" mainTextKey="mainText"/>

      <uix:formValue name="<%= ParameterNames.PAGE_NAME %>" value="<%= Constant.RAC_SELECT_INSTANCE_PAGE %>" />
      <uix:header textBinding="selAsmHeader@volumeBean@servletRequest"/> 

            <uix:labeledFieldLayout labelWidth="20%">            
              <uix:messagePrompt promptBinding="DISK_GROUP@msg"/>
              <uix:styledText styleClass="OraDataText" textBinding="diskGroup@volumeBean@servletRequest"/>
            </uix:labeledFieldLayout>
            <uix:labeledFieldLayout labelWidth="20%">            
              <uix:messagePrompt promptBinding="VOLUME@msg"/>
              <uix:styledText styleClass="OraDataText" textBinding="selVolumes@volumeBean@servletRequest"/>
            </uix:labeledFieldLayout>
            <uix:separator/>

        <uix:styledText styleClass="OraInstructionText" textBinding="INST_SELECT_ASM_INSTANCES@msg"/>


         <uix:spacer  height="15"/>
         <oem:shuttle name="<%= VolumeBean.ATTR_CLUSTER_INSTANCES %>"
                      leadingHeaderBinding="AVAILABLE_ASM_INSTANCES@msg"
                      trailingHeaderBinding="SELECTED_ASM_INSTANCES@msg"
                      size="15"
                      reorderable="true">
                    <uix:leading>
                      <oem:list shortDescBinding="AVAILABLE_HOSTS@msg" name="<%= VolumeBean.ATTR_AVAILABLE_INSTANCES %>" optionsBinding="availableInstances@volumeBean@servletRequest" multiple="true"/>
                    </uix:leading>
                    <uix:trailing>
                      <oem:list shortDescBinding="SELECTED_HOSTS@msg" name="<%= VolumeBean.ATTR_SELECTED_INSTANCES %>" optionsBinding="selectedInstances@volumeBean@servletRequest" multiple="true"/>
                    </uix:trailing>
         </oem:shuttle>
              
       <uix:contentFooter>
        <uix:pageButtonBar>
          <uix:contents>
            <uix:button textBinding="CANCEL@msg" destinationBinding="cancelURL@volumeBean@servletRequest"/>
            <uix:submitButton textBinding="CONTINUE@msg" name="event" value="<%= Constant.EVENT_CONTINUE %>" formName="pageForm" />
          </uix:contents>
        </uix:pageButtonBar>
       </uix:contentFooter>

    </uix:pageLayout>
    </db:form>    
  </uix:body>
  </uix:document>
</uix:renderingContext>
