<%--
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates.All rights reserved. 
  -- Page:        viewVolume.jsp
  -- Controller:  oracle.sysman.db.adm.osm.ofs.VolumeController
  --
  -- Description: ASM disk group home page General tab
  --
  --  MODIFIED    (MM/DD/YY)
  --  chanchan    02/02/09 - Add OAC ADA supports
  --  chanchan    04/04/08 - Add Creation/Modification date
  --  chanchan    03/24/08 - Hide Performance tab for beta testing
  --  chanchan    02/12/08 - Add ZBR supports
  --  chanchan    07/26/07 - Add Disk Group Allocated Space
  --  chanchan    03/02/06 - Creation 
  --%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.emo.adm.osm.ofs.VolumeBean" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="msg" class="oracle.sysman.db.rsc.osm.ofs.OfsObjectMsg" />
  <uix:bundle name="msgOsm" class="oracle.sysman.db.rsc.osm.OsmObjectMsg" />
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <uix:form name="pageForm" method="POST" destination="viewVolume">
        <uix:pageLayout titleBinding="header@volumeBean@servletRequest">
          <oem:messageBox messageType="error" errorTableBinding="error@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
          <%@ include file="/database/global.jspf" %>
     <uix:subTabLayout>
        <uix:subTabs>
              <uix:subTabBar selectedIndex="0">
                <uix:link textBinding="GENERAL@msg"/>
                <uix:link textBinding="PERFORMANCE@msg" rendered="false"
                    destinationBinding="perfVolumeUrl@servletRequest"/>
              </uix:subTabBar>
      </uix:subTabs>
          <uix:tableLayout width="100%" cellSpacing="3">
              <uix:cellFormat hAlign="right" vAlign="top" width="100%">
                <uix:pageButtonBar>
	           <uix:button textBinding="EDIT@msg" destinationBinding="editVolumeUrl@servletRequest" renderedBinding="allowToEditVol@servletRequest" />
        	   <uix:button textBinding="OK@msg" destinationBinding="cancelURL@volumeBean@servletRequest"/>
                </uix:pageButtonBar>
              </uix:cellFormat>
          </uix:tableLayout>
            <uix:tableLayout width="100%" cellSpacing="5">
              <uix:rowLayout width="100%">
                <uix:cellFormat hAlign="center" vAlign="top" width="30%" wrappingDisabled="true">
                  <uix:tableLayout cellSpacing="5">
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right" wrappingDisabled="true">
                        <uix:messagePrompt promptBinding="DISK_GROUP@msg" />
                      </uix:cellFormat>
                      <uix:cellFormat wrappingDisabled="true">
                        <uix:styledText styleClass="OraDataText" textBinding="diskGroup@volumeBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:tableLayout>
                </uix:cellFormat>
                <uix:cellFormat vAlign="top" width="70%" wrappingDisabled="true">
                  <uix:tableLayout cellSpacing="5">
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right" wrappingDisabled="true">
                        <uix:messagePrompt promptBinding="DISK_GRP_FREE_SP@msg" />
                      </uix:cellFormat>
                      <uix:cellFormat wrappingDisabled="true">
                        <uix:styledText styleClass="OraDataText" textBinding="diskGroupSpace@volumeBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:tableLayout>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

            <uix:separator>
              <uix:spacer height="1"/>
            </uix:separator>

            <uix:tableLayout cellSpacing="5">
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:messagePrompt promptBinding="STATE@msg" />
                </uix:cellFormat>
                <uix:cellFormat>
                  <uix:styledText styleClass="OraDataText" textBinding="state@volumeBean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:messagePrompt promptBinding="USAGE@msg" />
                </uix:cellFormat>
                <uix:cellFormat>
                  <uix:styledText styleClass="OraDataText" textBinding="usage@volumeBean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:messagePrompt promptBinding="VOLUME_DEVICE@msg" />
                </uix:cellFormat>
                <uix:cellFormat>
                  <uix:styledText styleClass="OraDataText" textBinding="volDevice@volumeBean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:messagePrompt promptBinding="MOUNT_POINT@msg" />
                </uix:cellFormat>
                <uix:cellFormat>
                  <uix:styledText styleClass="OraDataText" textBinding="mountPoint@volumeBean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:messagePrompt promptBinding="SIZE_GB@msg" />
                </uix:cellFormat>
                <uix:cellFormat>
                  <uix:styledText styleClass="OraDataText" textBinding="totalSize@volumeBean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:messagePrompt promptBinding="DG_ALLOC_SPACE_GB@msg" />
                </uix:cellFormat>
                <uix:cellFormat>
                  <uix:styledText styleClass="OraDataText" textBinding="DgAllocatedSpace@volumeBean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:messagePrompt promptBinding="REDUNDANCY@msg" />
                </uix:cellFormat>
                <uix:cellFormat>
                  <uix:styledText styleClass="OraDataText" textBinding="redundancyLocale@volumeBean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:messagePrompt promptBinding="STRIPE_WIDTH_KB@msg" />
                </uix:cellFormat>
                <uix:cellFormat>
                  <uix:styledText styleClass="OraDataText" textBinding="StripeWidth@volumeBean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:messagePrompt promptBinding="STRIPE_COLUMNS@msg" />
                </uix:cellFormat>
                <uix:cellFormat>
                  <uix:styledText styleClass="OraDataText" textBinding="StripeCol@volumeBean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" vAlign="top">
                  <uix:messagePrompt promptBinding="VOLUME_ALLOCATION_UNIT@msg" />
                </uix:cellFormat>
                <uix:cellFormat>
                  <uix:styledText styleClass="OraDataText" textBinding="allocationUnit@volumeBean@servletRequest"/>
                    <uix:tableLayout cellSpacing="0">
      	              <uix:rowLayout>
               	        <uix:styledText styleClass="OraInlineInfoText" textBinding="HINT_VOLUME_ALLOCATION_UNIT@msg" />                      
               	      </uix:rowLayout>
                    </uix:tableLayout>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:messagePrompt promptBinding="PRIMARY_EXTENT_ZONE@msgOsm" />
                </uix:cellFormat>
                <uix:cellFormat>
	          <uix:switcher childNameBinding="primaryZBR@volumeBean@servletRequest">
         	    <uix:case name="<%= VolumeBean.ATTR_ZBR_HOT %>"> 
	               <uix:styledText styleClass="OraDataText" textBinding="HOT@msgOsm"/>
                    </uix:case> 
         	    <uix:case name="<%= VolumeBean.ATTR_ZBR_COLD %>"> 
	               <uix:styledText styleClass="OraDataText" textBinding="COLD@msgOsm"/>
                    </uix:case> 
                  </uix:switcher>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout renderedBinding="showMirrorZBR@volumeBean@servletRequest">
                <uix:cellFormat hAlign="right">
                  <uix:messagePrompt promptBinding="MIRROR_EXTENT_ZONE@msgOsm" />
                </uix:cellFormat>
                <uix:cellFormat>
	          <uix:switcher childNameBinding="mirrorZBR@volumeBean@servletRequest">
         	    <uix:case name="<%= VolumeBean.ATTR_ZBR_HOT %>"> 
	               <uix:styledText styleClass="OraDataText" textBinding="HOT@msgOsm"/>
                    </uix:case> 
         	    <uix:case name="<%= VolumeBean.ATTR_ZBR_COLD %>"> 
	               <uix:styledText styleClass="OraDataText" textBinding="COLD@msgOsm"/>
                    </uix:case> 
                  </uix:switcher>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" wrappingDisabled="true">
                  <uix:messagePrompt promptBinding="CREATION_TIME@msg" />
                </uix:cellFormat>
                <uix:cellFormat wrappingDisabled="true">
                  <uix:styledText styleClass="OraDataText" textBinding="creationTime@volumeBean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" wrappingDisabled="true">
                  <uix:messagePrompt promptBinding="MODIFICATION_TIME@msg" />
                </uix:cellFormat>
                <uix:cellFormat wrappingDisabled="true">
                  <uix:styledText styleClass="OraDataText" textBinding="modificationTime@volumeBean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
          <uix:tableLayout width="100%" cellSpacing="3">
              <uix:cellFormat hAlign="right" vAlign="top" width="100%">
                <uix:pageButtonBar>
	           <uix:button textBinding="EDIT@msg" destinationBinding="editVolumeUrl@servletRequest" renderedBinding="allowToEditVol@servletRequest" />
        	   <uix:button textBinding="OK@msg" destinationBinding="cancelURL@volumeBean@servletRequest"/>
                </uix:pageButtonBar>
              </uix:cellFormat>
          </uix:tableLayout>

    </uix:subTabLayout>
        </uix:pageLayout>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
