<%--
  -- Page:        diskGroups.jsp
  -- Controller:  oracle.sysman.db.adm.osm.OsmAdminController
  --
  -- Description: ASM instance Administration tab - disk groups
  --
  --  MODIFIED    (MM/DD/YY)
  --     chanchan  06/06/08 - Creation
  --%>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>
<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.osm.ofs.Constant" %>

<%@ page import="oracle.sysman.emo.adm.osm.OsmConst" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="ofsMsg" class="oracle.sysman.db.rsc.osm.ofs.OfsObjectMsg" />
  <uix:document>

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <uix:pageLayout>
    <%@ include file="/database/global.jspf" %>
    <uix:form
      name="osmForm"
      method="GET"
      destinationBinding="defaultURL@servletRequest">
      <uix:header textBinding="header@osmConfigBean@servletRequest">
      <uix:formValue
        name="pageName"
        value="/database/osm/diskGroups"/>

        <oem:messageBox messageType="info"
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageTypeBinding="messageType@servletRequest"
                        errorTableBinding="msgBox@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
     <uix:subTabLayout>
        <uix:subTabs>
          <uix:switcher childNameBinding="enterpriseMode@servletRequest">
            <uix:case name="true">
              <uix:subTabBar selectedIndex="4">
                <uix:link textBinding="HOME@DBMsgBundle@servletRequest"
                    destinationBinding="sitemapDest@servletRequest"/>
               <oem:license>
                <uix:link textBinding="PERFORMANCE_HEADER@DBMsgBundle@servletRequest"
                    destinationBinding="healthDest@servletRequest"/>
               </oem:license>
                <uix:link textBinding="ADMINISTRATION@DBMsgBundle@servletRequest"
                    destinationBinding="adminDest@servletRequest"/>
                <uix:link textBinding="CONFIGURATION@DBMsgBundle@servletRequest"
                    destinationBinding="configDest@servletRequest"/>
                <uix:link textBinding="ORACLE_FILE_SYSTEM@ofsMsg"
                    destinationBinding="ofsTab@servletRequest"/>
              </uix:subTabBar>
            </uix:case>

          <uix:case name="false">
            <uix:subTabBar selectedIndex="0">
              <uix:link textBinding="ADMINISTRATION@DBMsgBundle@servletRequest"/>
              <uix:link textBinding="CONFIGURATION@DBMsgBundle@servletRequest"
                  destinationBinding="configDest@servletRequest"/>
            </uix:subTabBar>
          </uix:case>
        </uix:switcher>
      </uix:subTabs>
    </uix:subTabLayout>
    </uix:header>
    </uix:form>
    </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>

