<%--
  -- Page:        osmAlerts.jsp
  -- Controller:  oracle.sysman.db.adm.osm.OsmAlertController
  --
  -- Description: ASM alert page
  --
  --  MODIFIED    (MM/DD/YY)  
  --   rajeshar    07/27/05 - rajeshar_bug-4215288
  --   rajeshar    07/24/05 - Initial entry
  --%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.osm.JspConstants" %>
<%@ page import="oracle.sysman.emo.adm.osm.OsmAlertDataSource" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>


<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/>

    <%-- Message Bundles --%>
    <uix:bundle name="alertMsgs"
            class="oracle.sysman.db.rsc.inst.DBMsg"/>

    <uix:document>

        <%-- Browser title.  Page name from controller getPageHeader() --%>
        <%@ include file="/oemTitle.jspf" %>

        <%@ include file="/enablePPR.jspf" %>

        <uix:body>
            <db:form name="asmAlertPage"
                method="POST"
                destination="/console/database/osm/osmAlert" copyParams="target,type,alertType">

                <uix:formValue name="pageName"
                     value="<%= JspConstants.OSM_ALERT_PAGE %>"/>      
                <uix:contents>
                    <uix:pageLayout titleBinding="pageHeader@servletRequest">
      
                        <%@ include file="/database/global.jspf" %>
      
                        <oem:messageBox messageType="info"
                                errorTableBinding="confirmation@servletRequest"
                                titleTextKey="titleText" mainTextKey="mainText"/>
                        <oem:messageBox messageType="error"
                                errorTableBinding="errors@servletRequest"
                                titleTextKey="titleText" mainTextKey="mainText"/>
                        
                        <%-- The Page Refresh Data   --%>
                        <uix:tableLayout width="100%" >
                            <uix:rowLayout  hAlign="right">
                                <uix:cellFormat>
                                    <uix:contents>
                                        <uix:tableLayout cellSpacing="5" >
                                            <uix:rowLayout>
                                                <uix:cellFormat>
                                                    <uix:styledText styleClass="OraTipText"
                                                        textBinding="lastUpdatedTimeLabel@servletRequest"/>
                                                </uix:cellFormat>
                                                <uix:cellFormat>
                                                    <uix:styledText styleClass="OraTipLabel"
                                                        textBinding="lastUpdatedTime@servletRequest"/>
                                                </uix:cellFormat>
                                                <uix:cellFormat>
                                                    <uix:image sourceBinding="refreshGif@servletRequest"
                                                        destinationBinding="refreshUrl@servletRequest"
                                                        shortDescBinding="REFRESH_LABEL@alertMsgs"/>
                                                </uix:cellFormat>
                                            </uix:rowLayout>
                                        </uix:tableLayout>
                                    </uix:contents>
                                </uix:cellFormat>
                            </uix:rowLayout>
                        </uix:tableLayout>
                        
                        <uix:separator>
                            <uix:spacer width="0" height="10"/>
                        </uix:separator>
                        
                        <uix:tableLayout width="100%">	                          
                            <uix:rowLayout width="100%">                                
                                <uix:dataScope currentDataBinding="osmAlertBean@servletRequest">
                                    <uix:table summaryBinding="header@osmAlertBean@servletRequest"
                                        width="100%" 
                                        formSubmitted="true"
                                        id="osmAlertDataSource"
                                        tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                        valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                        maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                                        blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>"
                                        partialRenderMode="self"
                                        alternateTextBinding="NO_ROWS_FOUND@alertMsgs">
                                        
                                        <%-- Severity column --%>                     
                                        <uix:column>
                                            <uix:columnHeader>
                                                <uix:sortableHeader textBinding="SEVERITY@alertMsgs"
                                                    sortableBinding="<%= OsmAlertDataSource.S_SORT_SEVERITY_COL %>" />
                                            </uix:columnHeader>
                                            <uix:columnFormat columnDataFormat="numberFormat"/>			 
                                            <uix:image sourceBinding="<%= OsmAlertDataSource.S_STATUS_DEST %>" shortDescBinding="SEVERITY@alertMsgs"/>
                                        </uix:column>

                                        <%-- Target Name column --%>
                                        <uix:column>
                                            <uix:columnHeader>
                                                <uix:sortableHeader textBinding="TARGET_NAME@alertMsgs"
                                                    sortableBinding="<%= OsmAlertDataSource.S_SORT_TARGET_COL %>" />
                                            </uix:columnHeader>
                                            <uix:columnFormat columnDataFormat="textFormat"/>
                                            <uix:styledText textBinding="<%= OsmAlertDataSource.S_TARGET_COL %>"/>
                                        </uix:column>

                                        <%-- CATEGORY column --%>
                                        <uix:column>
                                            <uix:columnHeader>
                                                <uix:sortableHeader textBinding="CATEGORY@alertMsgs"
                                                    sortableBinding="<%= OsmAlertDataSource.S_SORT_CATEGORY_COL %>" />
                                            </uix:columnHeader>
                                            <uix:columnFormat columnDataFormat="textFormat"/>
                                            <uix:styledText textBinding="<%= OsmAlertDataSource.S_CATEGORY_COL %>"/>
                                        </uix:column>

                                        <%-- METRIC column --%>
                                        <uix:column>
                                            <uix:columnHeader>
                                                <uix:sortableHeader textBinding="NAME@alertMsgs"
                                                    sortableBinding="<%= OsmAlertDataSource.S_SORT_METRIC_COL %>" />
                                            </uix:columnHeader>
                                            <uix:columnFormat columnDataFormat="textFormat"/>
                                            <uix:styledText textBinding="<%= OsmAlertDataSource.S_METRIC_COL %>"/>
                                        </uix:column>

                                        <%-- MESSAGE column --%>
                                        <uix:column>
                                            <uix:columnHeader>
                                                <uix:sortableHeader textBinding="MESSAGE@alertMsgs"
                                                    sortableBinding="<%= OsmAlertDataSource.S_SORT_MESSAGE_COL %>" />
                                            </uix:columnHeader>
                                            <uix:columnFormat columnDataFormat="textFormat"/>
                                            <uix:styledText textBinding="<%= OsmAlertDataSource.S_MESSAGE_COL %>"/>
                                        </uix:column>

                                        <%-- Date column --%>
                                        <uix:column>
                                            <uix:columnHeader>
                                                <uix:sortableHeader textBinding="ALERT_TRIGGERED@alertMsgs"
                                                    sortableBinding="<%= OsmAlertDataSource.S_SORT_TIME_COL %>" />
                                            </uix:columnHeader>
                                            <uix:columnFormat columnDataFormat="textFormat"/>
                                            <uix:styledText textBinding="<%= OsmAlertDataSource.S_TIME_COL %>"/>
                                        </uix:column>
                                    </uix:table>
                                </uix:dataScope>
                            </uix:rowLayout>	     
                        </uix:tableLayout>                    
                    </uix:pageLayout>
                </uix:contents>
            </db:form>
        </uix:body>
    </uix:document>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>

