<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.inst.DBMsg"/>
  <uix:bundle name="osmMsgs" class="oracle.sysman.db.rsc.osm.OsmObjectMsg"/>
  <uix:bundle name="ofsMsg" class="oracle.sysman.db.rsc.osm.ofs.OfsObjectMsg" />
  <uix:document>

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <uix:pageLayout>
    <%@ include file="/database/global.jspf" %>

    <uix:form
      name="osmConfig" 
      method="post"
      destinationBinding="defaultURL@servletRequest">
      <uix:formValue 
        name="pageName" 
        value="/database/osm/osmConfig"/>

        <uix:header textBinding="header@osmConfigBean@servletRequest">

         <uix:subTabLayout>
            <uix:subTabs>
              <uix:switcher childNameBinding="enterpriseMode@servletRequest">
              <uix:case name="true">            
              <uix:subTabBar selectedIndex="3">
                  <uix:link textBinding="HOME@dbMsgs"
                     destinationBinding="sitemapDest@servletRequest"/>
                  <oem:license>
                  <uix:link textBinding="PERFORMANCE_HEADER@dbMsgs"
                     destinationBinding="healthDest@servletRequest"/>                                
                  </oem:license>
                  <uix:link textBinding="DISKGROUPS@osmMsgs"
                     destinationBinding="adminDest@servletRequest"/>
                  <uix:link textBinding="CONFIGURATION@dbMsgs"/>
                  <uix:link textBinding="USERS@osmMsgs"
                     destinationBinding="usersDest@servletRequest"
                     renderedBinding="versionGE11@osmConfigBean@servletRequest"/>
                  <uix:link textBinding="ORACLE_FILE_SYSTEM@ofsMsg" renderedBinding="showOfs@servletRequest"
                     destinationBinding="ofsDest@servletRequest"/>
              </uix:subTabBar>
              </uix:case>
              
              <uix:case name="false">
              <uix:subTabBar selectedIndex="1">              
                  <uix:link textBinding="ADMINISTRATION@dbMsgs"
                     destinationBinding="adminDest@servletRequest"/>
                  <uix:link textBinding="CONFIGURATION@dbMsgs"/>
              </uix:subTabBar>                  
              </uix:case>
              </uix:switcher>
              
            </uix:subTabs>
        
        <oem:messageBox messageType="info" 
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error" 
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>

        <%-- ASM access warning message --%>
        <jsp:include page="/database/osm/asmAccessWarningInclude.jsp" />
        <uix:ref refID="asmAccessWarningInclude"/>

        <uix:header
          textBinding="CONFIG_PARAMETERS@osmMsgs"
          >

            <uix:rowLayout hAlign="right">
              <uix:submitButton
                name="event" 
                textBinding="REVERT@osmMsgs"
                value="revert"
                disabledBinding="disableNonSysAsmOp@servletRequest"/>
	      <uix:spacer width="4"/>
              <uix:submitButton 
                name="event" 
                textBinding="APPLY@osmMsgs" 
                value="apply"
                disabledBinding="disableNonSysAsmOp@servletRequest"/>
            </uix:rowLayout>

            <%-------------------------
             -  Labeled Fields
             ---------------------------%>
            <uix:tableLayout cellSpacing="5">

                <uix:rowLayout vAlign="top">

                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                    <uix:messagePrompt labeledNodeId="diskString"
                      promptBinding="DISK_STRING@osmMsgs"/>
                  </uix:cellFormat>

                  <%---  Field  ---%>
                  <uix:switcher childNameBinding="disableNonSysAsmOp@servletRequest">
                    <uix:case name="true">
                      <uix:stackLayout>
                        <uix:styledText textBinding="diskString@osmConfigBean@servletRequest"
                                        styleClass="OraDataText"/>
			                  <uix:styledText textBinding="DISK_STRING_DESC@osmMsgs"
                                        styleClass="OraInlineInfoText"/>
                      </uix:stackLayout>
                    </uix:case>
                    <uix:case name="false">
                      <uix:stackLayout>
                        <uix:textInput id="diskString"
                                       name="diskString"
                                       textBinding="diskString@osmConfigBean@servletRequest"
                                       columns="75"/>
			                  <uix:styledText textBinding="DISK_STRING_DESC@osmMsgs"
                                        styleClass="OraInlineInfoText"/>
                      </uix:stackLayout>
                    </uix:case>
                  </uix:switcher>
                </uix:rowLayout>

                <uix:rowLayout vAlign="top">

                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                    <uix:messagePrompt labeledNodeId="autoMountDGs"
                      promptBinding="AUTO_MOUNT_DGS@osmMsgs"/>
                  </uix:cellFormat>

                  <%---  Field  ---%>
                  <uix:switcher childNameBinding="disableNonSysAsmOp@servletRequest">
                    <uix:case name="true">
                      <uix:stackLayout>
                        <uix:styledText textBinding="autoMountDGs@osmConfigBean@servletRequest"
                                        styleClass="OraDataText"/>
			                  <uix:styledText textBinding="AUTO_MOUNT_DGS_DESC@osmMsgs"
                                        styleClass="OraInlineInfoText"/>
                      </uix:stackLayout>
                    </uix:case>
                    <uix:case name="false">
                      <uix:stackLayout>
                        <uix:textInput id="autoMountDGs"
                                       name="autoMountDGs"
                                       textBinding="autoMountDGs@osmConfigBean@servletRequest"
                                       columns="75"/>
			                  <uix:styledText textBinding="AUTO_MOUNT_DGS_DESC@osmMsgs"
                                        styleClass="OraInlineInfoText"/>
                      </uix:stackLayout>
                    </uix:case>
                  </uix:switcher>
                    

                </uix:rowLayout>

            <%-------------------------
                <uix:rowLayout vAlign="top">

                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                    <uix:messagePrompt labeledNodeId="repairTime"
                      promptBinding="REPAIR_TIME@osmMsgs"/>
                  </uix:cellFormat>

                  <uix:stackLayout>
		    <uix:contents>
                        <uix:textInput id="repairTime"
                          name="repairTime"
                          textBinding="repairTime@osmConfigBean@servletRequest"
                          columns="75"/>
			<uix:tip>
			  <uix:styledText textBinding="REPAIR_TIME_DESC@osmMsgs"/>
			</uix:tip>
		    </uix:contents>
                  </uix:stackLayout>

                </uix:rowLayout>
	     -------------%>

                <uix:rowLayout vAlign="top">

                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                    <uix:messagePrompt labeledNodeId="rebalancePower"
                      promptBinding="REBALANCE_POWER@osmMsgs"/>
                  </uix:cellFormat>

                  <%---  Field  ---%>
                  <uix:switcher childNameBinding="disableNonSysAsmOp@servletRequest">
                   <uix:case name="true">
                     <uix:stackLayout>
			                 <uix:styledText textBinding="rebalancePower@osmConfigBean@servletRequest"
                                       styleClass="OraDataText"/>
                       <uix:styledText textBinding="ONLINE_TIP@osmMsgs"
                                       styleClass="OraInlineInfoText"/>
                     </uix:stackLayout>
                  </uix:case>
                  <uix:case name="false">
                    <uix:stackLayout>
                      <uix:choice id="rebalancePower" 
                                  name="rebalancePower"
                                  selectedValueBinding="rebalancePower@osmConfigBean@servletRequest" >
                        <uix:option text="0" value="0"/>
                        <uix:option text="1" value="1"/> 
                        <uix:option text="2" value="2"/> 
                        <uix:option text="3" value="3"/> 
                        <uix:option text="4" value="4"/> 
                        <uix:option text="5" value="5"/> 
                        <uix:option text="6" value="6"/> 
                        <uix:option text="7" value="7"/> 
                        <uix:option text="8" value="8"/> 
                        <uix:option text="9" value="9"/> 
                        <uix:option text="10" value="10"/> 
                        <uix:option text="11" value="11"/> 
                      </uix:choice>
                      <uix:styledText textBinding="ONLINE_TIP@osmMsgs"
                                      styleClass="OraInlineInfoText"/>
                    </uix:stackLayout>
                  </uix:case>
                </uix:switcher>
              </uix:rowLayout>

              <%-- PREFERRED READ DISK GROUP 11G --%>     
              <uix:rowLayout vAlign="top" renderedBinding="versionGE11@osmConfigBean@servletRequest">
                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                    <uix:messagePrompt labeledNodeId="preferredReadFGs"
                                       promptBinding="PREFERRED_READ_FGS@osmMsgs"/>
                  </uix:cellFormat>

                  <%---  Field  ---%>
                  <uix:switcher childNameBinding="disableNonSysAsmOp@servletRequest">
                   <uix:case name="true">
                     <uix:stackLayout>
                       <uix:styledText textBinding="preferredReadFGs@osmConfigBean@servletRequest"
                                       styleClass="OraDataText"/>
			                 <uix:styledText textBinding="PREFERRED_READ_FGS_DESC@osmMsgs"
                                       styleClass="OraInlineInfoText"/>
                     </uix:stackLayout>
                   </uix:case>
                   <uix:case name="false">
                     <uix:stackLayout>
                       <uix:textInput id="preferredReadFGs"
                            name="preferredReadFGs"
                            textBinding="preferredReadFGs@osmConfigBean@servletRequest"
                            columns="75"/>
			                 <uix:styledText textBinding="PREFERRED_READ_FGS_DESC@osmMsgs"
                                       styleClass="OraInlineInfoText"/>
                     </uix:stackLayout>
                   </uix:case>
                 </uix:switcher>
                </uix:rowLayout>
                
            </uix:tableLayout>
            
            <%-- uix:rowLayout hAlign="right">
              <uix:submitButton 
                name="event" 
                textBinding="APPLY@osmMsgs" 
                value="apply"
                disabledBinding="disableNonSysAsmOp@servletRequest"/>
              <uix:submitButton
                name="event" 
                textBinding="REVERT@osmMsgs"
                value="revert"
                disabledBinding="disableNonSysAsmOp@servletRequest"/>
            </uix:rowLayout --%>

        </uix:header>
      </uix:subTabLayout>
    <uix:tableLayout>
      <oem:relatedLinks />
    </uix:tableLayout>

      </uix:header>

              <%--uix:contentFooter>
		<uix:contents>
		  <uix:pageButtonBar>
		    <uix:contents>
         	      <uix:submitButton
                	name="event" 
	                textBinding="REVERT@osmMsgs"
        	        value="revert"
                  disabledBinding="disableNonSysAsmOp@servletRequest"/>
	              <uix:submitButton 
        	        name="event" 
                	textBinding="APPLY@osmMsgs" 
	                value="apply 
                  disabledBinding="disableNonSysAsmOp@servletRequest"/>
		    </uix:contents>
		  </uix:pageButtonBar>
		</uix:contents>
              </uix:contentFooter--%>

    </uix:form>
    </uix:pageLayout>        
    </uix:body>
  </uix:document>
</uix:renderingContext>
