<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>

<%@ page import="oracle.sysman.db.adm.osm.OsmAdminController"%>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    
    <uix:body>
    <uix:form name="foo" destinationBinding="commandURL@servletRequest">
    <uix:pageLayout>   
     <%@ include file="/database/global.jspf" %>  
       <oem:messageBox messageType="info" 
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error" 
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
     
      <uix:formValue name="optionChoice" valueBinding="optionChoice@servletRequest"/>         
      <uix:formValue name="mname" valueBinding="mname@servletRequest"/>               
      <uix:formValue name="otype" valueBinding="otype@servletRequest"/>               
      <uix:formValue name="oname" valueBinding="oname@servletRequest"/>      
      <%--<uix:formValue name="option" valueBinding="option@servletRequest"/>      --%>
      <uix:formValue name="index" valueBinding="index@servletRequest"/>      
      <uix:formValue name="pageName" value="/database/osm/osmConfirmation"/>
      
          <uix:header iconBinding="confirmationIcon@servletRequest" textBinding="CONFIRMATION@OsmObjectBundle@servletRequest"/> 
         <uix:tableLayout > 
         <uix:rowLayout >
         <uix:cellFormat >
         <uix:spacer width="40"/>
         </uix:cellFormat>
         <uix:cellFormat >
         <uix:stackLayout >
    
          <uix:switcher childNameBinding="optionChoice@servletRequest" >
          <uix:case name="MOUNT">
           <contents>
              <uix:messagePrompt 
                              prompt=""/>
              </contents>
            </uix:case>
           <uix:case name="ONLINE">
              <contents>
              <uix:messagePrompt 
                              promptBinding="ONLINE_INSTR@OsmObjectBundle@servletRequest"/>
              </contents>
              
            </uix:case>
            
            <uix:case name="OFFLINE">
              <contents>
              <uix:messagePrompt 
                              promptBinding="OFFLINE_INSTR@OsmObjectBundle@servletRequest"/>
              </contents>
            </uix:case>
            
            <uix:case name="deleteUser">
              <contents>
              <uix:messagePrompt 
                              promptBinding="DELETE_USER_INSTR@OsmObjectBundle@servletRequest"/>
              </contents>
            </uix:case>
            
            <uix:case name="DELETE">
             <uix:switcher childNameBinding="otype@servletRequest" >
              <uix:case name="DISK">
              <contents>
              <uix:messagePrompt 
                              promptBinding="DELETE_INSTR@OsmObjectBundle@servletRequest"/>         
              </contents>
             </uix:case>
             </uix:switcher>
            </uix:case>
            
            <uix:case name="CHECK">
               <uix:switcher childNameBinding="otype@servletRequest" >
                 <uix:case name="DISK">
                  <uix:tip>
                    <contents>
                        <uix:styledText styleClass="oraTipText"
                              textBinding="CHECK_INSTR@OsmObjectBundle@servletRequest"/>
                   </contents>
                  </uix:tip>
                 </uix:case>
                 <uix:case name="DISKGROUP">
                     <uix:messagePrompt 
                              promptBinding="CHECK_DG_INSTR@OsmObjectBundle@servletRequest"/>
                  </uix:case>
                </uix:switcher>
            </uix:case>
            
          <%--
          <uix:default>
            <uix:tip>
              <contents>
                <uix:styledText styleClass="oraTipText"
                              textBinding="CHECK_INSTR@OsmObjectBundle@servletRequest"/>
              </contents>
            </uix:tip>
          </uix:default>
          --%>
          
          </uix:switcher>
          <uix:spacer width="10" height="20"/>
          <uix:styledText styleClass="OraDataText" textBinding="confirmationText@servletRequest"/> 
          <%-- ADVANCED OPTION FOR ONLINE/OFFLINE OPERATION --%>
          <uix:switcher childNameBinding="optionChoice@servletRequest"  >
            <uix:case name="MOUNT"> 
           <uix:stackLayout>
            <uix:spacer width="10" height="20"/>
             <uix:hideShow id="idShowHideMountOption" formSubmitted="true" renderedBinding="verGE11@osmAdminBean@servletRequest"
                           disclosedBinding="showHideOption@osmAdminBean@servletRequest"
                           disclosedTextBinding="HIDE_ADVANCED_OPTIONS@OsmObjectBundle@servletRequest" 
                           undisclosedTextBinding="SHOW_ADVANCED_OPTIONS@OsmObjectBundle@servletRequest">
               <uix:rowLayout >
              <uix:spacer width="10"/>
              <uix:tableLayout  >
                <uix:rowLayout>
                <uix:spacer height="7"/>
                </uix:rowLayout>
                <uix:rowLayout vAlign="top">
                  <uix:contents>
                    <uix:cellFormat>
                      <uix:radioButton name="<%= OsmAdminController.OPTION_ATTR %>" 
                                       id="option1"
                                       value="NOFORCE"
                                       selectedValueBinding="mountOption@osmAdminBean@servletRequest" />
                    </uix:cellFormat>
                    <uix:cellFormat>
                    <uix:stackLayout >
                      <uix:styledText labeledNodeId="option1" textBinding="DO_NOT_FORCE@OsmObjectBundle@servletRequest" styleClass="OraPromptText" />    
                      <uix:styledText styleClass="oraTipText"
                            textBinding="MOUNT_DG_NOFORCE_HINT@OsmObjectBundle@servletRequest"/>
                    </uix:stackLayout>
                  </uix:cellFormat>
                 </uix:contents>
                </uix:rowLayout>
              <uix:rowLayout>
                <uix:spacer height="6"/>
                </uix:rowLayout>
                <uix:rowLayout vAlign="top">
                  <uix:contents>
                    <uix:cellFormat>
                      <uix:radioButton name="<%= OsmAdminController.OPTION_ATTR %>" 
                                       id="option2"
                                       value="FORCE"
                                       selectedValueBinding="mountOption@osmAdminBean@servletRequest" />
                    </uix:cellFormat>
                    <uix:cellFormat>
                    <uix:stackLayout >
                      <uix:styledText labeledNodeId="option2" textBinding="FORCE@OsmObjectBundle@servletRequest" styleClass="OraPromptText" />    
                      <uix:styledText styleClass="oraTipText"
                            textBinding="MOUNT_DG_FORCE_HINT@OsmObjectBundle@servletRequest"/>
                    </uix:stackLayout>
                  </uix:cellFormat>
                 </uix:contents>
                </uix:rowLayout>
                <uix:rowLayout>
                <uix:spacer height="18"/>
                </uix:rowLayout>
                <uix:rowLayout vAlign="top">
                  <uix:contents>
                    <uix:cellFormat>
                      <uix:checkBox name="mountRestricted" 
                                       id="mountRestricted"
                                       value="RESTRICTED"
                                       disabledBinding="multipleNodeSelected@osmAdminBean@servletRequest"
                                       selectedValueBinding="mountRestricted@osmAdminBean@servletRequest" />
                    </uix:cellFormat>
                    <uix:cellFormat>
                    <uix:stackLayout >
                      <uix:styledText labeledNodeId="mountRestricted" textBinding="RESTRICTED@OsmObjectBundle@servletRequest" styleClass="OraPromptText" />    
                      <uix:styledText styleClass="oraTipText"
                            textBinding="MOUNT_DG_RESTRICTED_HINT@OsmObjectBundle@servletRequest"/>
                    </uix:stackLayout>
                  </uix:cellFormat>
                 </uix:contents>
                </uix:rowLayout>
              </uix:tableLayout>
              </uix:rowLayout>
             </uix:hideShow>
             </uix:stackLayout>
           </uix:case>
          <uix:case name="DISMOUNT_ALL"> 
           <uix:stackLayout>
            <uix:spacer width="10" height="20"/>
             <uix:hideShow id="idShowHideMountOption" formSubmitted="true"
                           disclosedBinding="showHideOption@osmAdminBean@servletRequest"
                           disclosedTextBinding="HIDE_ADVANCED_OPTIONS@OsmObjectBundle@servletRequest" 
                           undisclosedTextBinding="SHOW_ADVANCED_OPTIONS@OsmObjectBundle@servletRequest">
               <uix:rowLayout >
              <uix:spacer width="10"/>
              <uix:tableLayout  >
                <uix:rowLayout>
                <uix:spacer height="7"/>
                </uix:rowLayout>
                <uix:rowLayout vAlign="top">
                  <uix:contents>
                    <uix:cellFormat>
                      <uix:radioButton name="<%= OsmAdminController.OPTION_ATTR %>" 
                                       id="option1"
                                       value="NOFORCE"
                                       selectedValueBinding="dismountOption@osmAdminBean@servletRequest" />
                    </uix:cellFormat>
                    <uix:cellFormat>
                    <uix:stackLayout >
                      <uix:styledText labeledNodeId="option1" textBinding="DO_NOT_FORCE@OsmObjectBundle@servletRequest" styleClass="OraPromptText" />    
                      <uix:styledText styleClass="oraTipText"
                            textBinding="MOUNT_DG_NOFORCE_HINT@OsmObjectBundle@servletRequest"/>
                    </uix:stackLayout>
                  </uix:cellFormat>
                 </uix:contents>
                </uix:rowLayout>
              <uix:rowLayout>
                <uix:spacer height="6"/>
                </uix:rowLayout>
                <uix:rowLayout vAlign="top">
                  <uix:contents>
                    <uix:cellFormat>
                      <uix:radioButton name="<%= OsmAdminController.OPTION_ATTR %>" 
                                       id="option2"
                                       value="FORCE"
                                       selectedValueBinding="dismountOption@osmAdminBean@servletRequest" />
                    </uix:cellFormat>
                    <uix:cellFormat>
                    <uix:stackLayout >
                      <uix:styledText labeledNodeId="option2" textBinding="FORCE@OsmObjectBundle@servletRequest" styleClass="OraPromptText" />    
                      <uix:styledText styleClass="oraTipText"
                            textBinding="DISMOUNT_DG_FORCE_HINT@OsmObjectBundle@servletRequest"/>
                    </uix:stackLayout>
                  </uix:cellFormat>
                 </uix:contents>
                </uix:rowLayout>
                <uix:rowLayout>
                <uix:spacer height="6"/>
                </uix:rowLayout>
              </uix:tableLayout>
              </uix:rowLayout>
             </uix:hideShow>
             </uix:stackLayout>
           </uix:case>
           
                     <uix:case name="DISMOUNT"> 
           <uix:stackLayout>
            <uix:spacer width="10" height="20"/>
             <uix:hideShow id="idShowHideMountOption" formSubmitted="true"
                           disclosedBinding="showHideOption@osmAdminBean@servletRequest"
                           disclosedTextBinding="HIDE_ADVANCED_OPTIONS@OsmObjectBundle@servletRequest" 
                           undisclosedTextBinding="SHOW_ADVANCED_OPTIONS@OsmObjectBundle@servletRequest">
               <uix:rowLayout >
              <uix:spacer width="10"/>
              <uix:tableLayout  >
                <uix:rowLayout>
                <uix:spacer height="7"/>
                </uix:rowLayout>
                <uix:rowLayout vAlign="top">
                  <uix:contents>
                    <uix:cellFormat>
                      <uix:radioButton name="<%= OsmAdminController.OPTION_ATTR %>" 
                                       id="option1"
                                       value="NOFORCE"
                                       selectedValueBinding="dismountOption@osmAdminBean@servletRequest" />
                    </uix:cellFormat>
                    <uix:cellFormat>
                    <uix:stackLayout >
                      <uix:styledText labeledNodeId="option1" textBinding="DO_NOT_FORCE@OsmObjectBundle@servletRequest" styleClass="OraPromptText" />    
                      <uix:styledText styleClass="oraTipText"
                            textBinding="MOUNT_DG_NOFORCE_HINT@OsmObjectBundle@servletRequest"/>
                    </uix:stackLayout>
                  </uix:cellFormat>
                 </uix:contents>
                </uix:rowLayout>
              <uix:rowLayout>
                <uix:spacer height="6"/>
                </uix:rowLayout>
                <uix:rowLayout vAlign="top">
                  <uix:contents>
                    <uix:cellFormat>
                      <uix:radioButton name="<%= OsmAdminController.OPTION_ATTR %>" 
                                       id="option2"
                                       value="FORCE"
                                       selectedValueBinding="dismountOption@osmAdminBean@servletRequest" />
                    </uix:cellFormat>
                    <uix:cellFormat>
                    <uix:stackLayout >
                      <uix:styledText labeledNodeId="option2" textBinding="FORCE@OsmObjectBundle@servletRequest" styleClass="OraPromptText" />    
                      <uix:styledText styleClass="oraTipText"
                            textBinding="DISMOUNT_DG_FORCE_HINT@OsmObjectBundle@servletRequest"/>
                    </uix:stackLayout>
                  </uix:cellFormat>
                 </uix:contents>
                </uix:rowLayout>
                <uix:rowLayout>
                <uix:spacer height="6"/>
                </uix:rowLayout>
              </uix:tableLayout>
              </uix:rowLayout>
             </uix:hideShow>
             </uix:stackLayout>
           </uix:case>
           
           <uix:case name="CHECK">
          <uix:switcher childNameBinding="otype@servletRequest" >
          <uix:case name="DISKGROUP"> 
            <uix:stackLayout >
             <uix:spacer width="10" height="20"/>
             <uix:hideShow id="idShowHideCheckOption" formSubmitted="true" renderedBinding="verGE11@osmAdminBean@servletRequest"
             disclosedBinding="showHideOption@osmAdminBean@servletRequest" 
             disclosedTextBinding="HIDE_ADVANCED_OPTIONS@OsmObjectBundle@servletRequest" 
             undisclosedTextBinding="SHOW_ADVANCED_OPTIONS@OsmObjectBundle@servletRequest">
             <uix:rowLayout >
              <uix:spacer width="10"/>
              <uix:tableLayout  >
                <uix:rowLayout>
                <uix:spacer height="7"/>
                </uix:rowLayout>
                <uix:rowLayout vAlign="top">
                  <uix:contents>
                    <uix:cellFormat>
                      <uix:radioButton name="<%= OsmAdminController.OPTION_ATTR %>" 
                                       id="option1"
                                       value="NOREPAIR"
                                       selectedValueBinding="option@osmAdminBean@servletRequest" />
                    </uix:cellFormat>
                    <uix:cellFormat>
                    <uix:stackLayout >
                      <uix:styledText labeledNodeId="option1" textBinding="CHECK_WITHOUT_REPAIR@OsmObjectBundle@servletRequest" styleClass="OraPromptText" />    
                      <uix:styledText styleClass="oraTipText"
                            textBinding="CHECK_WITHOUT_REPAIR_HINT@OsmObjectBundle@servletRequest"/>
                    </uix:stackLayout>
                  </uix:cellFormat>
                 </uix:contents>
                </uix:rowLayout>

                <uix:rowLayout>
                  <uix:spacer height="6"/>
                </uix:rowLayout>

                <uix:rowLayout vAlign="top">
                  <uix:contents>
                    <uix:cellFormat>
                      <uix:radioButton name="<%= OsmAdminController.OPTION_ATTR %>" 
                                       id="option2"
                                       value="REPAIR"
                                       selectedValueBinding="option@osmAdminBean@servletRequest" />
                    </uix:cellFormat>
                    <uix:cellFormat>
                    <uix:stackLayout >
                      <uix:styledText labeledNodeId="option2" textBinding="CHECK_AND_REPAIR@OsmObjectBundle@servletRequest" styleClass="OraPromptText" />    
                      <uix:styledText styleClass="oraTipText"
                            textBinding="CHECK_AND_REPAIR_HINT@OsmObjectBundle@servletRequest"/>
                    </uix:stackLayout>
                  </uix:cellFormat>
                 </uix:contents>
                </uix:rowLayout>
                
                
              </uix:tableLayout>
              </uix:rowLayout>
            </uix:hideShow>
            </uix:stackLayout>
            </uix:case>
            </uix:switcher>
           </uix:case>
          <%-- 
           <uix:case name="ONLINE"> 
           <uix:stackLayout>
            <uix:spacer width="10" height="20"/>
             <uix:hideShow id="idShowHideOnlineOption" formSubmitted="true"
                           disclosedBinding="showHideOption@diskGrp@servletRequest" 
                           disclosedTextBinding="HIDE_ADVANCED_OPTIONS@OsmObjectBundle@servletRequest" undisclosedTextBinding="SHOW_ADVANCED_OPTIONS@OsmObjectBundle@servletRequest">
              <uix:contents>
                <uix:tableLayout cellSpacing="5" >
                 <uix:rowLayout>
                   <uix:cellFormat wrappingDisabled="true"  hAlign="right" vAlign="middle">
                     <uix:spacer height="5" width="12" />
                       <uix:styledText labeledNodeId="idRebalancePower" textBinding="REBALANCE_POWER@OsmObjectBundle@servletRequest" styleClass="OraPromptText" />                      
                   </uix:cellFormat>
                   <uix:cellFormat hAlign="left" vAlign="middle">
                     <uix:choice id="idRebalancePower" 
                                 name="<%= OsmAdminController.REBAL_POWER_ATTR %>"
                                 selectedValueBinding="rebalancePower@diskGrp@servletRequest" >
                       <uix:option text="1" value="1"/> 
                       <uix:option text="2" value="2"/> 
                       <uix:option text="3" value="3"/> 
                       <uix:option text="4" value="4"/> 
                       <uix:option text="5" value="5"/> 
                       <uix:option text="6" value="6"/> 
                       <uix:option text="7" value="7"/> 
                       <uix:option text="8" value="8"/> 
                       <uix:option text="9" value="9"/> 
                       <uix:option text="10" value="10"/> 
                       <uix:option text="11" value="11"/> 
                     </uix:choice>
                   </uix:cellFormat>
                 </uix:rowLayout>
                 <uix:rowLayout>
                   <uix:cellFormat >
                   </uix:cellFormat>
                  <uix:cellFormat>
                      <uix:styledText styleClass="oraTipText"
                              textBinding="ONLINE_TIP@OsmObjectBundle@servletRequest"/>
                  </uix:cellFormat>
                 </uix:rowLayout>
                </uix:tableLayout>
              </uix:contents>
             </uix:hideShow>
             </uix:stackLayout>
           </uix:case>
           --%>
           <uix:case name="OFFLINE">
             <uix:stackLayout>
             <uix:spacer width="10" height="20"/>
             <uix:tableLayout  >
                 <uix:rowLayout>
                   <uix:cellFormat wrappingDisabled="true"  hAlign="right" vAlign="middle">
                       <uix:styledText labeledNodeId="idDiskRepairTime" textBinding="DISK_REPAIR_TIME@OsmObjectBundle@servletRequest" styleClass="OraPromptText" />                      
                      <uix:spacer width="5"/>
                   </uix:cellFormat>
                   <uix:cellFormat hAlign="left" vAlign="middle">
                     <uix:textInput  id="idDiskRepairTime"
                                     name="offlineSqlDiskRepairTimeValue" 
                                     textBinding="offlineSqlDiskRepairTimeValue@diskGrp@servletRequest" 
                                     columns="4"/>
                     <uix:choice name="<%= OsmAdminController.REPAIR_TIMER_ATTR%>" 
                                 shortDescBinding="DISK_REPAIR_TIME@OsmObjectBundle@servletRequest"
                                 selectedValueBinding="diskRepairTimeOption@diskGrp@servletRequest" >
                       <%-- uix:option textBinding="SECONDS@OsmObjectBundle@servletRequest" value="s"/--%>
                       <uix:option textBinding="MINUTES@OsmObjectBundle@servletRequest" value="m"/> 
                       <uix:option textBinding="HOURS@OsmObjectBundle@servletRequest" value="h"/> 
                       <%-- uix:option textBinding="DAYS@OsmObjectBundle@servletRequest" value="d"/--%>
                     </uix:choice>
                   </uix:cellFormat>
                 </uix:rowLayout>
                 <uix:rowLayout>
                   <uix:cellFormat >
                   </uix:cellFormat>
                  <uix:cellFormat >
                      <uix:styledText styleClass="oraTipText"
                              textBinding="OFFLINE_TIP@OsmObjectBundle@servletRequest"/>
                  </uix:cellFormat>
                 </uix:rowLayout>
                </uix:tableLayout>
             </uix:stackLayout>
           </uix:case> 
           
            <uix:case name="REBALANCE">
          <uix:stackLayout >
             <uix:spacer width="10" height="20"/>
             <uix:hideShow id="idShowHideDelete" 
                           formSubmitted="true" 
                           disclosedBinding="showHideOption@osmAdminBean@servletRequest" 
                           disclosedTextBinding="HIDE_ADVANCED_OPTIONS@OsmObjectBundle@servletRequest" 
                           undisclosedTextBinding="SHOW_ADVANCED_OPTIONS@OsmObjectBundle@servletRequest">
              <uix:contents>
             <uix:tableLayout >
             <uix:rowLayout >
             <uix:cellFormat >
             <uix:spacer width="16"/>
             </uix:cellFormat>
             <uix:cellFormat >
                         <uix:header textBinding="REBALANCE_POWER@OsmObjectBundle@servletRequest" >
                <uix:tableLayout cellSpacing="5">
                 <uix:rowLayout>
                   <uix:cellFormat wrappingDisabled="true"  hAlign="right" vAlign="middle">
                       <uix:styledText labeledNodeId="idRebalancePower" textBinding="REBALANCE_POWER@OsmObjectBundle@servletRequest" styleClass="OraPromptText" />                      
                   </uix:cellFormat>
                   <uix:cellFormat hAlign="left" vAlign="middle">
                     <uix:choice id="idRebalancePower" 
                                 name="<%= OsmAdminController.REBAL_POWER_ATTR %>"
                                 selectedValueBinding="rebalancePower@osmAdminBean@servletRequest" >
                       <uix:option text="0" value="0"/>
                       <uix:option text="1" value="1"/> 
                       <uix:option text="2" value="2"/> 
                       <uix:option text="3" value="3"/> 
                       <uix:option text="4" value="4"/> 
                       <uix:option text="5" value="5"/> 
                       <uix:option text="6" value="6"/> 
                       <uix:option text="7" value="7"/> 
                       <uix:option text="8" value="8"/> 
                       <uix:option text="9" value="9"/> 
                       <uix:option text="10" value="10"/> 
                       <uix:option text="11" value="11"/> 
                     </uix:choice>
                   </uix:cellFormat>
                 </uix:rowLayout>
                 <uix:rowLayout>
                   <uix:cellFormat >
                   </uix:cellFormat>
                  <uix:cellFormat>
                      <uix:styledText styleClass="oraTipText"
                              textBinding="ONLINE_TIP@OsmObjectBundle@servletRequest"/>
                  </uix:cellFormat>
                 </uix:rowLayout>
                </uix:tableLayout>
               </uix:header>
               </uix:cellFormat>
               </uix:rowLayout>
               </uix:tableLayout>
               </uix:contents>
               </uix:hideShow>
               </uix:stackLayout>
          </uix:case>
          
          <uix:case name="RESIZE">
             <uix:stackLayout >
             <uix:spacer width="10" height="20"/>
             <uix:hideShow id="idShowHideDelete" 
                           formSubmitted="true" 
                           renderedBinding="showAdvancedOption@servletRequest" 
                           disclosedBinding="showHideOption@diskGrp@servletRequest" 
                           disclosedTextBinding="HIDE_ADVANCED_OPTIONS@OsmObjectBundle@servletRequest" 
                           undisclosedTextBinding="SHOW_ADVANCED_OPTIONS@OsmObjectBundle@servletRequest">
             <uix:contents>
             <uix:tableLayout >
               
               <uix:rowLayout >
               <uix:cellFormat >
                  <uix:spacer width="16"/>
               </uix:cellFormat>
               <uix:cellFormat >
                 <uix:header textBinding="SIZE@OsmObjectBundle@servletRequest" >
                	                
                <uix:tableLayout width="100%">
                 <uix:rowLayout >
                     <uix:spacer width="5"/>
                 </uix:rowLayout>
                 <uix:rowLayout width="100%">
 
	         <uix:contents>
	          <uix:cellFormat>
	            <oem:radioButton name="option"
			    value="DEFAULT"
			    textBinding="DEFAULT_SIZE@OsmObjectBundle@servletRequest" 
			    selectedValueBinding="resizeSpecifiedOption@diskGrp@servletRequest" />	
	          </uix:cellFormat>
	         </uix:contents>
               </uix:rowLayout>

               <uix:rowLayout width="100%">
                <uix:contents>
                 <uix:cellFormat>
                  <uix:styledText styleClass="OraInlineInfoText" textBinding="RESIZE_DEFAULT_DESC@OsmObjectBundle@servletRequest"/>	
                 </uix:cellFormat>
                </uix:contents>
               </uix:rowLayout>
                <uix:rowLayout>
                  <uix:spacer height="5"/>
               </uix:rowLayout>
               <uix:rowLayout width="100%">
                <uix:contents>
                 <uix:cellFormat>
                  <uix:flowLayout>
                   <oem:radioButton name="option"
                                    value="SPECIFIED"
                                    textBinding="SPECIFIED_SIZE@OsmObjectBundle@servletRequest" 
                                    selectedValueBinding="resizeSpecifiedOption@diskGrp@servletRequest" />
                   <uix:textInput shortDescBinding="SPECIFIED_SIZE@OsmObjectBundle@servletRequest" name="size" textBinding="size@diskGrp@servletRequest" columns="15"/>
                   <uix:choice  id="unit" name="unit" selectedValueBinding="unit@diskGrp@servletRequest" shortDescBinding="SIZE_UNIT@OsmObjectBundle@servletRequest">
                                <uix:option value="K" textBinding="KBYTES@OsmObjectBundle@servletRequest" />
                                <uix:option value="M" textBinding="MBYTES@OsmObjectBundle@servletRequest"/>
                                <uix:option value="G" textBinding="GBYTES@OsmObjectBundle@servletRequest"/>
                                <uix:option value="T" textBinding="TBYTES@OsmObjectBundle@servletRequest"/>
                   </uix:choice>
                  </uix:flowLayout>
                 </uix:cellFormat>
                </uix:contents>
               </uix:rowLayout>

               <uix:rowLayout width="100%">
                <uix:contents>
                 <uix:cellFormat>
                  <uix:styledText styleClass="OraInlineInfoText" textBinding="RESIZE_SPECIFIED_DESC@OsmObjectBundle@servletRequest"/>	
                 </uix:cellFormat>
                </uix:contents>
               </uix:rowLayout>
              </uix:tableLayout>
        
              </uix:header>
              <uix:header textBinding="REBALANCE_POWER@OsmObjectBundle@servletRequest" >
                <uix:tableLayout cellSpacing="5">
                 <uix:rowLayout>
                   <uix:cellFormat wrappingDisabled="true"  hAlign="right" vAlign="middle">
                       <uix:styledText labeledNodeId="idRebalancePower" textBinding="REBALANCE_POWER@OsmObjectBundle@servletRequest" styleClass="OraPromptText" />                      
                   </uix:cellFormat>
                   <uix:cellFormat hAlign="left" vAlign="middle">
                     <uix:choice id="idRebalancePower" 
                                 name="<%= OsmAdminController.REBAL_POWER_ATTR %>"
                                 selectedValueBinding="rebalancePower@diskGrp@servletRequest" >
                       <uix:option text="0" value="0"/> 
                       <uix:option text="1" value="1"/> 
                       <uix:option text="2" value="2"/> 
                       <uix:option text="3" value="3"/> 
                       <uix:option text="4" value="4"/> 
                       <uix:option text="5" value="5"/> 
                       <uix:option text="6" value="6"/> 
                       <uix:option text="7" value="7"/> 
                       <uix:option text="8" value="8"/> 
                       <uix:option text="9" value="9"/> 
                       <uix:option text="10" value="10"/> 
                       <uix:option text="11" value="11"/> 
                     </uix:choice>
                   </uix:cellFormat>
                 </uix:rowLayout>
                 <uix:rowLayout>
                   <uix:cellFormat >
                   </uix:cellFormat>
                  <uix:cellFormat>
                      <uix:styledText styleClass="oraTipText"
                              textBinding="ONLINE_TIP@OsmObjectBundle@servletRequest"/>
                  </uix:cellFormat>
                 </uix:rowLayout>
                </uix:tableLayout>
               </uix:header>
            </uix:cellFormat>
           </uix:rowLayout>
              </uix:tableLayout>
              </uix:contents>
              </uix:hideShow>
             </uix:stackLayout>
            </uix:case>
          
           <uix:case name="DELETE">
           
            <uix:switcher childNameBinding="otype@servletRequest" >
                        <uix:case name="DISKGROUP">
             <uix:stackLayout >
              <uix:spacer width="10" height="20"/>
              <uix:hideShow id="idShowHideDeleteOption" formSubmitted="true"
              disclosedBinding="showHideOption@osmAdminBean@servletRequest" 
              disclosedTextBinding="HIDE_ADVANCED_OPTIONS@OsmObjectBundle@servletRequest" 
              undisclosedTextBinding="SHOW_ADVANCED_OPTIONS@OsmObjectBundle@servletRequest">
                <uix:spacer width="5"/>
                <uix:rowLayout >
                <uix:spacer width="15"/>
                      <!--.....  Drop DG Options .....-->	                
                <uix:tableLayout width="100%">
                 
                  <uix:rowLayout >
                     <uix:spacer width="5"/>
                  </uix:rowLayout>
                  <uix:rowLayout width="100%">
                   <uix:contents>
                    <uix:cellFormat>
                    <uix:switcher childNameBinding="refreshForceOption@osmAdminBean@servletRequest">
                     <uix:case name="false">
                     <uix:radioButton name="<%= OsmAdminController.OPTION_ATTR %>" 
                          value="EXCLUDING"
                          onClick="submitForm('foo',true,{'event':'setDeleteForceOption'})"
                          textBinding="EXCLUDE_CONTENTS@OsmObjectBundle@servletRequest" 
                          selectedValueBinding="deleteOption@osmAdminBean@servletRequest" />
                      </uix:case>
                      <uix:default>
                      <uix:radioButton name="<%= OsmAdminController.OPTION_ATTR %>" 
                          value="EXCLUDING"
                          textBinding="EXCLUDE_CONTENTS@OsmObjectBundle@servletRequest" 
                          selectedValueBinding="deleteOption@osmAdminBean@servletRequest" />
                      </uix:default>
                      </uix:switcher>
                    </uix:cellFormat>
                   </uix:contents>
                 </uix:rowLayout>
                <uix:rowLayout width="100%">
                  <uix:contents>
                   <uix:cellFormat>
                    <uix:spacer width="21" height="1"/><uix:styledText styleClass="OraInlineInfoText" textBinding="EXCLUDE_CONTENTS_DESC@OsmObjectBundle@servletRequest"/>	
                   </uix:cellFormat>
                  </uix:contents>
                </uix:rowLayout>
                 
                  <uix:rowLayout width="100%">
                      <uix:contents>
                      <uix:cellFormat>
                      <uix:switcher childNameBinding="refreshForceOption@osmAdminBean@servletRequest">
                      <uix:case name="false">
                        <uix:radioButton name="<%= OsmAdminController.OPTION_ATTR %>" 
                          value="INCLUDING"
                          onClick="submitForm('foo',true,{'event':'setDeleteForceOption'})"
                          textBinding="INCLUDE_CONTENTS@OsmObjectBundle@servletRequest" 
                          selectedValueBinding="deleteOption@osmAdminBean@servletRequest" />
                      </uix:case>
                      <uix:default >
                       <uix:radioButton name="<%= OsmAdminController.OPTION_ATTR %>" 
                          value="INCLUDING"
                          textBinding="INCLUDE_CONTENTS@OsmObjectBundle@servletRequest" 
                          selectedValueBinding="deleteOption@osmAdminBean@servletRequest" />
                        </uix:default>
                        </uix:switcher>
                      </uix:cellFormat>
                      </uix:contents>
                  </uix:rowLayout>
                  <uix:rowLayout width="100%">
                   <uix:contents>
                     <uix:cellFormat>
                      <uix:spacer width="21" height="1"/><uix:styledText styleClass="OraInlineInfoText" textBinding="INCLUDE_CONTENTS_DESC@OsmObjectBundle@servletRequest"/>	
                    </uix:cellFormat>
                   </uix:contents>
                  </uix:rowLayout>
                
                <uix:rowLayout width="100%" renderedBinding="verGE11@osmAdminBean@servletRequest">
                  <uix:contents>
                   <uix:cellFormat>
                    <uix:spacer width="20" height="1"/>
                    <uix:checkBox id="forceDeleteOption" name="forceDeleteOption" 
                                  textBinding="FORCE@OsmObjectBundle@servletRequest" 
                                  disabledBinding="noForceOptionAvailable@osmAdminBean@servletRequest"
                                  checkedBinding="forceDeleteOption@osmAdminBean@servletRequest"/>
                   </uix:cellFormat>
                  </uix:contents>
                </uix:rowLayout>
                 <uix:rowLayout width="100%" renderedBinding="verGE11@osmAdminBean@servletRequest">
                  <uix:contents>
                   <uix:cellFormat>
                     <uix:rowLayout width="100%">
                        <uix:spacer width="45" height="1"/><uix:styledText styleClass="OraInlineInfoText" textBinding="DELETE_FORCE_DESC@OsmObjectBundle@servletRequest"/>	
                      </uix:rowLayout>
                   </uix:cellFormat>
                  </uix:contents>
                </uix:rowLayout>
                
               </uix:tableLayout>
               </uix:rowLayout>
              </uix:hideShow>
             </uix:stackLayout>
            </uix:case>
            
         <uix:case  name="DIRECTORY">
             <uix:stackLayout >
             <uix:spacer width="10" height="20"/>
             <uix:hideShow id="idShowHideDelete" 
                           formSubmitted="true"
                           disclosedBinding="showHideOption@memberFile@servletRequest" 
                           disclosedTextBinding="HIDE_ADVANCED_OPTIONS@OsmObjectBundle@servletRequest" 
                           undisclosedTextBinding="SHOW_ADVANCED_OPTIONS@OsmObjectBundle@servletRequest">
              <uix:contents>
             <uix:tableLayout >
             <uix:rowLayout >
             <uix:cellFormat >
             <uix:spacer width="16"/>
             </uix:cellFormat>
             <uix:cellFormat >
              <uix:header textBinding="OPTIONS@OsmObjectBundle@servletRequest">
              <!-- renderedBinding="versionGte11g@diskGrp@servletRequest" -->
               <uix:tableLayout  >
                  <uix:rowLayout>
                  <uix:spacer height="5"/>
                  </uix:rowLayout>
                  <uix:rowLayout >
                    <uix:contents>
                     <uix:stackLayout>
                        <uix:radioButton name="<%= OsmAdminController.OPTION_ATTR %>" 
                            value="NOFORCE"
                            textBinding="DO_NOT_FORCE@OsmObjectBundle@servletRequest"
                            selectedValueBinding="forceOption@memberFile@servletRequest" 
                            disabledBinding="disableDeleteDiskNoForce@memberFileGrp@servletRequest"/>
                   <uix:styledText styleClass="oraTipText"
                              textBinding="DROP_DIRECTORY_NOFORCE_DESC@OsmObjectBundle@servletRequest"/>
                    </uix:stackLayout>
                    </uix:contents>
                  </uix:rowLayout>
                   <uix:rowLayout>
                  <uix:spacer height="5"/>
                  </uix:rowLayout>
                     <uix:rowLayout width="100%">
                    <uix:contents>
                      <uix:stackLayout>
                        <uix:radioButton name="<%= OsmAdminController.OPTION_ATTR %>" 
                            value="FORCE"
                             textBinding="FORCE@OsmObjectBundle@servletRequest"
                            selectedValueBinding="forceOption@memberFile@servletRequest" 
                            disabledBinding="disableDeleteDiskForce@memberFile@servletRequest"/>
                         <uix:styledText styleClass="oraTipText"
                              textBinding="DROP_DIRECTORY_FORCE_DESC@OsmObjectBundle@servletRequest"/>
                   </uix:stackLayout>
                   </uix:contents>
                  </uix:rowLayout>
                    <uix:rowLayout>
                  <uix:spacer height="5"/>
                  </uix:rowLayout>
                </uix:tableLayout>
              </uix:header>
              </uix:cellFormat>
              </uix:rowLayout>
              </uix:tableLayout>
              </uix:contents>
              </uix:hideShow>
              </uix:stackLayout>
              </uix:case>
            
            
           <uix:default >
             <uix:stackLayout >
             <uix:spacer width="10" height="20"/>
             <uix:hideShow id="idShowHideDelete" 
                           formSubmitted="true" 
                           renderedBinding="showAdvancedOption@servletRequest" 
                           disclosedBinding="showHideOption@diskGrp@servletRequest" 
                           disclosedTextBinding="HIDE_ADVANCED_OPTIONS@OsmObjectBundle@servletRequest" 
                           undisclosedTextBinding="SHOW_ADVANCED_OPTIONS@OsmObjectBundle@servletRequest">
              <uix:contents>
             <uix:tableLayout >
             <uix:rowLayout >
             <uix:cellFormat >
             <uix:spacer width="16"/>
             </uix:cellFormat>
             <uix:cellFormat >
              <uix:header textBinding="OPTIONS@OsmObjectBundle@servletRequest">
              <!-- renderedBinding="versionGte11g@diskGrp@servletRequest" -->
               <uix:tableLayout  >
                  <uix:rowLayout>
                  <uix:spacer height="5"/>
                  </uix:rowLayout>
                  <uix:rowLayout >
                    <uix:contents>
	                    <uix:cellFormat>
                        <uix:radioButton name="<%= OsmAdminController.FORCE_OPTION_ATTR %>" 
                            id="option1"
                            value="NOFORCE"
                            selectedValueBinding="deleteForceOption@diskGrp@servletRequest" 
                            disabledBinding="disableDeleteDiskNoForce@diskGrp@servletRequest"/>
                             
                      </uix:cellFormat>
                      <uix:cellFormat>
                      <uix:styledText labeledNodeId="option1" textBinding="DO_NOT_FORCE@OsmObjectBundle@servletRequest" styleClass="OraPromptText" />    
                      </uix:cellFormat>
                    </uix:contents>
                    </uix:rowLayout>
                    
                    <uix:rowLayout width="100%">
                    <uix:cellFormat >
                   </uix:cellFormat>
                    <uix:cellFormat >
                   <uix:styledText styleClass="oraTipText"
                              textBinding="DELETE_NOFORCE_TIP@OsmObjectBundle@servletRequest"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                   <uix:rowLayout>
                  <uix:spacer height="5"/>
                  </uix:rowLayout>
                     <uix:rowLayout width="100%">
                    <uix:contents>
	                    <uix:cellFormat>
                        <uix:radioButton name="<%= OsmAdminController.FORCE_OPTION_ATTR %>" 
                            id="option2"
                            value="FORCE"
                            selectedValueBinding="deleteForceOption@diskGrp@servletRequest" 
                            disabledBinding="disableDeleteDiskForce@diskGrp@servletRequest"/>
                             
                      </uix:cellFormat>
                      <uix:cellFormat>
                        <uix:styledText labeledNodeId="option2" textBinding="FORCE@OsmObjectBundle@servletRequest" styleClass="OraPromptText" />
                      </uix:cellFormat>
                    </uix:contents>
                    </uix:rowLayout>
                    <uix:rowLayout width="100%">
                    <uix:cellFormat >
                   </uix:cellFormat>
                    <uix:cellFormat >
                   <uix:styledText styleClass="oraTipText"
                              textBinding="DELETE_FORCE_TIP@OsmObjectBundle@servletRequest"/>
                   </uix:cellFormat>
                  </uix:rowLayout>
                    <uix:rowLayout>
                  <uix:spacer height="5"/>
                  </uix:rowLayout>
                </uix:tableLayout>
              </uix:header>
               <uix:header textBinding="REBALANCE_POWER@OsmObjectBundle@servletRequest" >
                <uix:tableLayout cellSpacing="5">
                 <uix:rowLayout>
                   <uix:cellFormat wrappingDisabled="true"  hAlign="right" vAlign="middle">
                       <uix:styledText labeledNodeId="idRebalancePower" textBinding="REBALANCE_POWER@OsmObjectBundle@servletRequest" styleClass="OraPromptText" />
                   </uix:cellFormat>
                   <uix:cellFormat hAlign="left" vAlign="middle">
                     <uix:choice id="idRebalancePower" 
                                 name="<%= OsmAdminController.REBAL_POWER_ATTR %>"
                                 selectedValueBinding="rebalancePower@diskGrp@servletRequest" >
                       <uix:option text="0" value="0"/>
                       <uix:option text="1" value="1"/> 
                       <uix:option text="2" value="2"/> 
                       <uix:option text="3" value="3"/> 
                       <uix:option text="4" value="4"/> 
                       <uix:option text="5" value="5"/> 
                       <uix:option text="6" value="6"/> 
                       <uix:option text="7" value="7"/> 
                       <uix:option text="8" value="8"/> 
                       <uix:option text="9" value="9"/> 
                       <uix:option text="10" value="10"/> 
                       <uix:option text="11" value="11"/> 
                     </uix:choice>
                   </uix:cellFormat>
                 </uix:rowLayout>
                 <uix:rowLayout>
                   <uix:cellFormat >
                   </uix:cellFormat>
                  <uix:cellFormat>
                      <uix:styledText styleClass="oraTipText"
                              textBinding="ONLINE_TIP@OsmObjectBundle@servletRequest"/>
                  </uix:cellFormat>
                 </uix:rowLayout>
                </uix:tableLayout>
               </uix:header>
              </uix:cellFormat>
              </uix:rowLayout>
              </uix:tableLayout>
              </uix:contents>
             </uix:hideShow>
             </uix:stackLayout>
            </uix:default>

          </uix:switcher>
             
             
           </uix:case>  
          </uix:switcher>
          </uix:stackLayout>
          </uix:cellFormat>
          </uix:rowLayout>
          </uix:tableLayout>
          <%-- ADVANCED OPTION FOR ONLINE OPERATION TILL HERE--%>
        
          <%-- oem:messageBox messageType="confirmation" titleTextKey="titleText" mainTextKey="msgText" errorTableBinding="msgTable@servletRequest"/--%>

          <uix:switcher childNameBinding="optionChoice@servletRequest" >
     
          <uix:case name="REPAIR"/>
          
          
          <%-- uix:case name="DELETE">
          <uix:stackLayout>
           <uix:styledText textBinding="cmdOptionInfo@servletRequest"/>
           <uix:spacer height="4"/>
           <uix:checkBox name="cmdOption"
                        textBinding="cmdOptionText@servletRequest"
                        checkedBinding="cmdOptionSelected@servletRequest"/>
          </uix:stackLayout>
          </uix:case --%>  
          </uix:switcher>
          
     
      <uix:pageButtons>
        <uix:pageButtonBar>
          <uix:contents>
	    <%-- Show Sql --%>
	    <uix:switcher childNameBinding="showSQL@servletRequest">
	     <uix:case name="true">
           <uix:submitButton name="event" textBinding="SHOWSQL@uixDBObjectBundle@servletRequest" value="showSql"/>
         </uix:case>
        </uix:switcher>
	    <%-- Advanced options --%>         
	    <uix:switcher childNameBinding="advancedOptionsAvailable@servletRequest">
	     <uix:case name="true">
              <uix:submitButton textBinding="ADVANCED_OPTIONS@OsmObjectBundle@servletRequest"  name="event" value="showAdvancedOptions"/>            
             </uix:case>
            </uix:switcher>
            <uix:button textBinding="NO@uixDBObjectBundle@servletRequest" destinationBinding="backURL@servletRequest" />  
            <uix:submitButton textBinding="YES@uixDBObjectBundle@servletRequest"  name="event" value="doCommand"/>            
          </uix:contents>
        </uix:pageButtonBar>
      </uix:pageButtons>

    </uix:pageLayout>
    </uix:form>    
  </uix:body>
  </uix:document>
</uix:renderingContext>
