<%--
  -- Page:       osmHistPerformanceInclude.jsp
  -- Controller: oracle.sysman.db.adm.osm.OsmHealthController
  --
  -- Description: ASM resource access warning include
  --
  --  MODIFIED    (MM/DD/YY)
  --   mpawelko    02/23/09 - backport 6525227: remove hardcoded thresholds
  --   mpawelko    07/16/08 - use OP_SIZE msg for Operation Size
  --   dchakumk    03/10/08 - XbranchMerge dchakumk_6752_xbmsrc from
  --                          st_emdbsa_11.1
  --   gmahaney    02/01/07 - XbranchMerge gmahaney_emdb_pt_main from main
  --   qsong       06/16/06 - Creation 
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:buildTree nodeID="osmHistPerformanceInclude">
<uix:dataScope>

  <uix:stackLayout renderedBinding="histChartOption@healthBean@servletRequest">

   <oem:chart titleBinding="RESPONSE_TIME@OsmObjectBundle@servletRequest"
               chartType="timeSeriesChart"
               format="svg"
               orientation="vertical"
               width="650"
               height="160"
               legendPosition="east"
               legendVisible="external"
               externalLegendOrientation="vertical"
               svgHighlightLegend="true"
               seriesColorsAutomatic="true"
               yAxisLabelBinding="MS_PER_OPERATION@OsmObjectBundle@servletRequest">
      <uix:contents>
        <oem:boundChartDataSource
             chartDataSourceBinding="responseTimeChartData@histPerfBean@servletRequest"/>
        <oem:imageMap imageMapDataSourceBinding="responseImageDataSource@servletRequest" 
             defaultLabel="true" />
        <oem:chartColumn
                displayLabel=""
                sourceIndex="0"
                isKey="true"/>
          <oem:chartColumn
                displayLabel=""
                sourceIndex="1"
                isTimeColumn="true"/>
          <oem:chartColumn
                displayLabel=""
                sourceIndex="2"/>
       </uix:contents>
     </oem:chart>

     <%--
     ================================
     == Disk Group Throughput
     ================================
     --%>
     <oem:chart titleBinding="THROUGHPUT@OsmObjectBundle@servletRequest"
                chartType="timeSeriesChart"
                format="svg"
                orientation="vertical"
                width="650"
                height="160"
                seriesColorsAutomatic="true"
                yAxisLabelBinding="MB_PER_SECOND@OsmObjectBundle@servletRequest"
                legendPosition="east"
                legendVisible="external"
                externalLegendOrientation="vertical">
       <uix:contents>
         <oem:boundChartDataSource
             chartDataSourceBinding="throughputChartData@histPerfBean@servletRequest"/>
         <oem:imageMap imageMapDataSourceBinding="throughputImageDataSource@servletRequest" 
             defaultLabel="true" />
         <oem:chartColumn
              displayLabel=""
              sourceIndex="0"
              isKey="true"/>
         <oem:chartColumn
              displayLabel=""
              sourceIndex="1"
              isTimeColumn="true"/>
         <oem:chartColumn
              displayLabel=""
              sourceIndex="2"/>
       </uix:contents>
     </oem:chart>


     <%--
     ================================
     == Disk Group I/O Operations
     ================================
     --%>
     <oem:chart titleBinding="OPERATIONS_PS_TITLE@OsmObjectBundle@servletRequest"
                chartType="timeSeriesChart"
                format="svg"
                orientation="vertical"
                width="650"
                height="160"
                legendPosition="east"
                legendVisible="external"
                externalLegendOrientation="vertical"
                seriesColorsAutomatic="true"
                yAxisLabelBinding="OPERATIONS_PS@OsmObjectBundle@servletRequest">
       <uix:contents>
         <oem:boundChartDataSource
             chartDataSourceBinding="IOPerSecondChartData@histPerfBean@servletRequest"/>
         <oem:imageMap imageMapDataSourceBinding="operationsImageDataSource@servletRequest" 
             defaultLabel="true" />
         <oem:chartColumn
              displayLabel=""
              sourceIndex="0"
              isKey="true"/>
         <oem:chartColumn
              displayLabel=""
              sourceIndex="1"
              isTimeColumn="true"/>
         <oem:chartColumn
              displayLabel=""
              sourceIndex="2"/>
       </uix:contents>
     </oem:chart>


     <%--
     ================================
     == Disk Group I/O Size
     ================================
     --%>
     <oem:chart titleBinding="OP_SIZE@OsmObjectBundle@servletRequest"
                chartType="timeSeriesChart"
                format="svg"
                orientation="vertical"
                width="650"
                height="160"
                seriesColorsAutomatic="true"
                yAxisLabelBinding="MB_PER_OPERATION@OsmObjectBundle@servletRequest"
                legendPosition="east"
                legendVisible="external"
                externalLegendOrientation="vertical">
       <uix:contents>
         <oem:boundChartDataSource
             chartDataSourceBinding="IOSizeChartData@histPerfBean@servletRequest"/>
         <oem:imageMap imageMapDataSourceBinding="sizeImageDataSource@servletRequest" 
             defaultLabel="true" />
         <oem:chartColumn
              displayLabel=""
              sourceIndex="0"
              isKey="true"/>
         <oem:chartColumn
              displayLabel=""
              sourceIndex="1"
              isTimeColumn="true"/>
         <oem:chartColumn
              displayLabel=""
              sourceIndex="2"/>
       </uix:contents>
     </oem:chart>

     <%-- End New IO Size Chart --%>

   </uix:stackLayout>
</uix:dataScope>
</uix:buildTree>

