<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="OSM_LOGIN@OsmObjectBundle@servletRequest"/>
    </uix:metaContainer>
    <uix:body>
      <uix:form name="loginForm" method="POST" destinationBinding="defaultURL@servletRequest">
        <uix:formValue 
        name="cancelURL" 
        valueBinding="cancelURL@servletRequest"/>
      
        <uix:pageLayout>
          <%@ include file="/database/global.jspf" %>
          <uix:contents>
            <uix:header textBinding="OSM_LOGIN@OsmObjectBundle@servletRequest"/>

            <oem:messageBox messageType="error" 
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
                             
            <uix:rowLayout hAlign="center">
              <uix:contents>
                <uix:stackLayout>
                  <uix:contents>
                    <uix:tableLayout cellSpacing="5">
                      <uix:contents>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat hAlign="right">
                              <uix:contents>
                                <uix:messagePrompt labeledNodeId="userName" required="yes" promptBinding="userName@LoginMsgBundle@servletRequest"/>
                              </uix:contents>
                            </uix:cellFormat>
                            <uix:stackLayout>
                              <uix:contents>
                                <uix:textInput id="userName" name="userName" textBinding="username@osmLoginBean@servletRequest"/>
                                <uix:messageText messageBinding="userName@errors@servletRequest" 
                                                  messageType="error"/>
                                
                              </uix:contents>
                            </uix:stackLayout>
                          </uix:contents>
                        </uix:rowLayout>

                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat hAlign="right">
                              <uix:contents>
                                <uix:messagePrompt labeledNodeId="password" required="yes" promptBinding="password@LoginMsgBundle@servletRequest"/>
                              </uix:contents>
                            </uix:cellFormat>
                            <uix:stackLayout>
                              <uix:contents>
                                <uix:textInput id= "password" name="password" secret="true" textBinding="password@osmLoginBean@servletRequest"/>
                                <uix:messageText messageBinding="password@errors@servletRequest" 
                                                  messageType="error"/>
                                
                              </uix:contents>
                            </uix:stackLayout>
                          </uix:contents>
                        </uix:rowLayout>

                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat hAlign="right">
                              <uix:contents>
                                <uix:messagePrompt id="connectString" required="yes" promptBinding="connectString@LoginMsgBundle@servletRequest"/>
                              </uix:contents>
                            </uix:cellFormat>
                            <uix:stackLayout>
                              <uix:contents>
                                <uix:textInput id="connectString" name="connectString" textBinding="descriptor@osmLoginBean@servletRequest" readOnlyBinding="isReadOnly@servletRequest"/>
                                <uix:messageText messageBinding="connectString@errors@servletRequest" 
                                                  messageType="error"/>
                              </uix:contents>
                            </uix:stackLayout>
                          </uix:contents>
                        </uix:rowLayout>

                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat hAlign="right">
                              <uix:contents>
                                <uix:messagePrompt labeledNodeId="role" required="yes" promptBinding="role@LoginMsgBundle@servletRequest"/>
                              </uix:contents>
                            </uix:cellFormat>
                            <uix:stackLayout>
                              <uix:contents>
                              <uix:choice id="role" name="role">
                                 <uix:option text="SYSDBA" value="sysdba"/>
                              </uix:choice>
                              </uix:contents>
                            </uix:stackLayout>
                          </uix:contents>
                        </uix:rowLayout>

                      </uix:contents>
                    </uix:tableLayout>

                  </uix:contents>
                </uix:stackLayout>

              </uix:contents>
            </uix:rowLayout>

          </uix:contents>
          <uix:contentFooter>
            <uix:pageButtonBar>
              <uix:contents>
                <uix:submitButton textBinding="CANCEL@uixDBObjectBundle@servletRequest" name="event" value="cancel"/>
                <uix:submitButton  textBinding="LOGIN@uixDBObjectBundle@servletRequest" name="event" value="apply"/>
              </uix:contents>
            </uix:pageButtonBar>
          </uix:contentFooter>
        </uix:pageLayout>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>

