<%--
  -- Page:        osmOfs.jsp
  -- Controller:  oracle.sysman.db.adm.osm.OsmOfsController
  --
  -- Description: ASM instance Administration tab - Oracle File System
  --
  --  MODIFIED    (MM/DD/YY)
  --     chanchan  09/23/08 - 
  --     mnihalan  08/18/08 - Fix bug 7190098
  --     chanchan  04/01/08 - Add View Content
  --     chanchan  11/07/07 - Add Snapshot functions
  --     chanchan  08/16/07 - Add Disk Group Allocated Space (GB)
  --     chanchan  06/13/08 - Creation
  --%>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.osm.ofs.Constant" %>
<%@ page import="oracle.sysman.db.adm.osm.JspConstants" %>
<%@ page import="oracle.sysman.emo.adm.osm.OsmOfs" %>
<%@ page import="oracle.sysman.emo.adm.osm.ofs.OFSbean" %>
<%@ page import="oracle.sysman.db.adm.ParameterNames" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <db:script src="/database/remoteBrowser/remoteBrowser.js"/>
  <uix:bundle name="ofsMsg" class="oracle.sysman.db.rsc.osm.ofs.OfsObjectMsg" />
  <uix:document>
<script language="JavaScript" src="/em/cabo/jsLibs/TableProxy.js"></script> 
<script language="javascript">
function ViewContent()
{
    proxy = new TableProxy('<%= OsmOfs.ATTR_TABLE_DATA %>');
    selectedIndex = proxy.getSelectedRow();
    if (selectedIndex >= 0)
    {
       state = '<%= OsmOfs.ATTR_TABLE_DATA + ":avail:" %>' + selectedIndex;
       mp = '<%= OsmOfs.ATTR_TABLE_DATA + ":mp:" %>' + selectedIndex;
       if (document.forms[0][state].value == "1")
       {
          dirPath = document.forms[0][mp].value;
          setDefaultDirectory(dirPath, '<%= OFSbean.ATTR_FILE_PATH_SEPARATOR %>');
	  startDirectoryListing();
       }
       else
	 alert(document.forms[0].ViewContentErrorMsg.value);
    }
    return false;
}
</script>

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <uix:pageLayout>
    <%@ include file="/database/global.jspf" %>
    <db:form name="pageForm" method="POST" destination="<%= JspConstants.OSM_OFS_CONTROLLER %>" copyParams="target,type">
      <uix:formValue name="<%= ParameterNames.PAGE_NAME %>" value="<%= JspConstants.OSM_OFS_PAGE %>" />
      <uix:formValue name="ViewContentErrorMsg" valueBinding="MSG_OFS_VIEW_CONTENT@ofsMsg" />
      <uix:formValue name="<%= OsmOfs.ATTR_BLOCK_START_INDEX %>" valueBinding="blockSatrtIndex@osmOfsBean@servletRequest" />
<uix:tableLayout width="100%">
 <uix:rowLayout>
   <uix:cellFormat>
      <uix:header textBinding="header@osmOfsBean@servletRequest">
        <oem:messageBox messageType="info"
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error"
                        errorTableBinding="error@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageTypeBinding="messageType@servletRequest"
                        errorTableBinding="msgBox@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <uix:switcher childNameBinding="isRemoteOsJob@servletRequest">
          <uix:case name="false">
	        <oem:messageBox messageType="confirmation" errorTableBinding="confirmation@servletRequest" titleTextKey="titleText" mainTextKey="mainText" />
          </uix:case>
          <uix:case name="true">
            <uix:messageBox messageType="confirmation" messageBinding="confirmationMsg@servletRequest" >
		  <uix:link textBinding="VIEW_JOB_DETAILS@ofsMsg" destinationBinding="viewJobDetailURL@servletRequest" />
            </uix:messageBox>		
          </uix:case>
        </uix:switcher>

     <uix:subTabLayout>
        <uix:subTabs>
          <uix:switcher childNameBinding="enterpriseMode@servletRequest">
            <uix:case name="true">
              <uix:subTabBar selectedIndex="5">
                <uix:link textBinding="HOME@DBMsgBundle@servletRequest"
                    destinationBinding="sitemapDest@servletRequest"/>
               <oem:license>
                <uix:link textBinding="PERFORMANCE_HEADER@DBMsgBundle@servletRequest"
                    destinationBinding="healthDest@servletRequest"/>
               </oem:license>
                <uix:link textBinding="DISKGROUPS@DBMsgBundle@servletRequest"
                    destinationBinding="adminDest@servletRequest"/>
                <uix:link textBinding="CONFIGURATION@DBMsgBundle@servletRequest"
                    destinationBinding="configDest@servletRequest"/>
                <uix:link textBinding="USERS@DBMsgBundle@servletRequest"
                     destinationBinding="usersDest@servletRequest"
                     renderedBinding="versionGte11g@servletRequest"/>
                <uix:link textBinding="ORACLE_FILE_SYSTEM@ofsMsg" 
                    destinationBinding="ofsDest@servletRequest"/>
              </uix:subTabBar>
            </uix:case>

          <uix:case name="false">
            <uix:subTabBar selectedIndex="0">
              <uix:link textBinding="ADMINISTRATION@DBMsgBundle@servletRequest"/>
              <uix:link textBinding="CONFIGURATION@DBMsgBundle@servletRequest"
                  destinationBinding="configDest@servletRequest"/>
            </uix:subTabBar>
          </uix:case>
        </uix:switcher>
      </uix:subTabs>
          <uix:tableLayout width="100%" cellSpacing="3">
              <uix:cellFormat hAlign="right" vAlign="top" width="100%">
                <uix:pageButtonBar>
                  <uix:submitButton textBinding="CREATE@ofsMsg"
                                    name="event" value="<%= Constant.EVENT_CREATE_OFS %>"/>
                  <uix:submitButton textBinding="MOUNT_ALL@OsmObjectBundle@servletRequest" renderedBinding="hasData@osmOfsBean@servletRequest"
                                    name="event" value="<%= Constant.EVENT_MOUNT_ALL_OFS %>"/>
                  <uix:submitButton textBinding="DISMOUNT_ALL@OsmObjectBundle@servletRequest" renderedBinding="hasData@osmOfsBean@servletRequest"
                                    name="event" value="<%= Constant.EVENT_DISMOUNT_ALL_OFS %>"/>
                </uix:pageButtonBar>
              </uix:cellFormat>
          </uix:tableLayout>
        <uix:table summaryBinding="ORACLE_FILE_SYSTEMS@ofsMsg"
	    		 width="100%" 
                   formSubmitted="true"
                   id="<%= OsmOfs.ATTR_TABLE_DATA %>"
                   tableDataBinding="tableData@osmOfsBean@servletRequest"
                   valueBinding="startIndex@osmOfsBean@servletRequest"
                   maxValueBinding="length@osmOfsBean@servletRequest"
                   blockSizeBinding="blockSize@osmOfsBean@servletRequest"
                   showAllBinding="showAll@osmOfsBean@servletRequest"
                   alternateTextBinding="NO_OBJECT_FOUND@ofsMsg">
          <uix:tableFormat tableBanding="rowBanding"/>
          <uix:tableSelection>
            <uix:singleSelection shortDescBinding="volDevice@osmOfsBean@servletRequest" selectedBinding="selectedRow@osmOfsBean@servletRequest">
              <uix:pageButtonBar>
                <uix:submitButton textBinding="MOUNT@ofsMsg" name="event" value="<%= Constant.EVENT_MOUNT_OFS %>" shortDescBinding="MOUNT@ofsMsg"/>
                <uix:submitButton textBinding="DISMOUNT@ofsMsg" name="event" value="<%= Constant.EVENT_DISMOUNT_OFS %>" shortDescBinding="DISMOUNT@ofsMsg"/>
                <uix:submitButton textBinding="DELETE@ofsMsg" name="event" value="<%= Constant.EVENT_DELETE_OFS %>" shortDescBinding="DELETE@ofsMsg"/>
                <uix:submitButton textBinding="CREATE_SNAPSHOT@ofsMsg" name="event" value="<%= Constant.EVENT_CREATE_SNAPSHOT %>" shortDescBinding="CREATE_SNAPSHOT@ofsMsg"/>
                <uix:button textBinding="VIEW_CONTENT@ofsMsg" onClick="ViewContent();" shortDescBinding="VIEW_CONTENT@ofsMsg"/>
                <uix:submitButton textBinding="REGISTER@ofsMsg" name="event" value="<%= Constant.EVENT_REGISTER_OFS %>" shortDescBinding="REGISTER@ofsMsg"/>
                <uix:submitButton textBinding="DEREGISTER@ofsMsg" name="event" value="<%= Constant.EVENT_DEREGISTER_OFS %>" shortDescBinding="DEREGISTER@ofsMsg"/>
                <uix:styledText styleClass="OraPromptText" textBinding="ACTIONS@ofsMsg"/>
                  <uix:choice name="<%= Constant.EVENT_OFS_OPTIONS %>"
                              shortDescBinding="ACTIONS@ofsMsg"
                              selectedValueBinding="selectedOption@osmOfsBean@servletRequest" >
                    <uix:contents>
                      <uix:option textBinding="RESIZE@ofsMsg" value="<%= Constant.EVENT_RESIZE_OFS %>"/>
                      <uix:option textBinding="CHECK_REPAIR@ofsMsg" value="<%= Constant.EVENT_CHECK_OFS %>"/>
                    </uix:contents>
                  </uix:choice>
                <uix:submitButton textBinding="GO@ofsMsg" name="event" value="<%= Constant.EVENT_OFS_OPTIONS %>" shortDescBinding="GO@ofsMsg"/>
              </uix:pageButtonBar>
            </uix:singleSelection>
          </uix:tableSelection>

          <%-- Mount Point --%>
          <uix:column>
            <uix:columnHeader>
              <uix:sortableHeader textBinding="MOUNT_POINT@ofsMsg" sortableBinding="sortColumn0@osmOfsBean@servletRequest" />
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="textFormat"/>
            <uix:link textBinding="<%= OsmOfs.ATTR_MOUNT_POINT %>" destinationBinding="<%= OsmOfs.ATTR_MOUNT_POINT_URL %>" />
            <uix:formValue name="mp" valueBinding="<%= OsmOfs.ATTR_MOUNT_POINT %>"/>
          </uix:column>

          <%-- Availability --%>
          <uix:column>
            <uix:columnHeader>
              <uix:sortableHeader textBinding="AVAILABILITY@ofsMsg" sortableBinding="sortColumn1@osmOfsBean@servletRequest" />
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="iconButtonFormat"/>
            <uix:switcher childNameBinding="<%= OsmOfs.ATTR_AVAILABILITY %>">
	      <uix:case name="true">
 		 <uix:image source="<%= request.getContextPath()+\"/images/up_active.gif\" %>" shortDescBinding="UP@ofsMsg" />
              </uix:case>
              <uix:case name="false">
   	         <uix:image source="<%= request.getContextPath()+\"/images/down_active.gif\" %>" shortDescBinding="DOWN@ofsMsg"/>
              </uix:case>
            </uix:switcher>
            <uix:switcher childNameBinding="<%= OsmOfs.ATTR_AVAILABILITY %>">
	      <uix:case name="true">
                 <uix:formValue name="avail" value="1"/>
              </uix:case>
              <uix:case name="false">
                 <uix:formValue name="avail" value="0"/>
              </uix:case>
            </uix:switcher>
          </uix:column>

          <%-- State column --%>
          <uix:column>
            <uix:columnHeader>
              <uix:sortableHeader textBinding="STATE@ofsMsg" sortableBinding="sortColumn2@osmOfsBean@servletRequest" />
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="textFormat"/>
            <uix:styledText textBinding="<%= OsmOfs.ATTR_STATE %>" />
          </uix:column>

          <%-- SNAPSHOTS --%>
          <uix:column>
            <uix:columnHeader>
              <uix:sortableHeader textBinding="SNAPSHOTS@ofsMsg" sortableBinding="sortColumn3@osmOfsBean@servletRequest" />
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="numberFormat"/>
            <uix:switcher childNameBinding="<%= OsmOfs.ATTR_AVAILABILITY %>">
  	      <uix:case name="true">
                <uix:link textBinding="<%= OsmOfs.ATTR_SNAPSHOT_COUNT %>" destinationBinding="<%= OsmOfs.ATTR_SNAPSHOT_COUNT_URL %>" />
              </uix:case>
              <uix:case name="false">
                <uix:styledText textBinding="<%= OsmOfs.ATTR_SNAPSHOT_COUNT %>" />
              </uix:case>
            </uix:switcher>
          </uix:column>

          <%-- Used Percentage column --%>
          <uix:column>
            <uix:columnHeader>
              <uix:sortableHeader textBinding="USED_PERCENTAGE@ofsMsg" sortableBinding="sortColumn4@osmOfsBean@servletRequest" />
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="textFormat"/>
            <uix:flowLayout>
              <uix:contents>
                <uix:include nodeBinding="<%= OsmOfs.ATTR_USED_PERCENT_IMG %>"/>
                <uix:styledText textBinding="<%= OsmOfs.ATTR_USED_PERCENTAGE %>"/>
              </uix:contents>
            </uix:flowLayout>
          </uix:column>

          <%-- Used GB column --%>
          <uix:column>
            <uix:columnHeader>
              <uix:sortableHeader textBinding="USED_GB@ofsMsg" sortableBinding="sortColumn5@osmOfsBean@servletRequest" />
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="numberFormat"/>
            <uix:styledText textBinding="<%= OsmOfs.ATTR_USED_SPACE %>" />
          </uix:column>

          <%-- Size GB column --%>
          <uix:column>
            <uix:columnHeader>
              <uix:sortableHeader textBinding="SIZE_GB@ofsMsg" sortableBinding="sortColumn6@osmOfsBean@servletRequest" />
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="numberFormat"/>
            <uix:styledText textBinding="<%= OsmOfs.ATTR_OFS_TOTAL_SIZE %>" />
          </uix:column>

          <uix:column>
            <uix:columnHeader>
              <uix:sortableHeader textBinding="DG_ALLOC_SPACE_GB@ofsMsg" sortableBinding="sortColumn7@osmOfsBean@servletRequest"/>
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="numberFormat"/>
            <uix:styledText textBinding="DgAllocatedSpace@osmOfsBean@servletRequest"/>
          </uix:column>

          <%-- Volume Redundancy column --%>
          <uix:column>
            <uix:columnHeader>
              <uix:sortableHeader textBinding="REDUNDANCY@ofsMsg" sortableBinding="sortColumn8@osmOfsBean@servletRequest" />
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="textFormat"/>
            <uix:styledText textBinding="<%= OsmOfs.ATTR_REDUNDANCY_LOCALE %>" />
          </uix:column>

          <%-- Volume column --%>
          <uix:column>
            <uix:columnHeader>
              <uix:sortableHeader textBinding="VOLUME@ofsMsg" sortableBinding="sortColumn9@osmOfsBean@servletRequest" />
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="textFormat"/>
            <uix:link textBinding="<%= OsmOfs.ATTR_VOLUME_NAME %>" destinationBinding="<%= OsmOfs.ATTR_VIEW_VOLUME_URL %>" />
          </uix:column>

          <%-- Disk Group column --%>
          <uix:column>
            <uix:columnHeader>
              <uix:sortableHeader textBinding="DISK_GROUP@ofsMsg" sortableBinding="sortColumn10@osmOfsBean@servletRequest" />
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="textFormat"/>
            <uix:link textBinding="<%= OsmOfs.ATTR_DISK_GROUP %>" destinationBinding="<%= OsmOfs.ATTR_DISK_GROUP_URL %>" />
          </uix:column>

        </uix:table>
        <uix:spacer height="5"/>
        <uix:tip>
           <uix:styledText styleClass="oraTipText" textBinding="HINT_OFS_ALLOCATED_SPACE@ofsMsg"/>
        </uix:tip>

    </uix:subTabLayout>
    <uix:tableLayout>
      <oem:relatedLinks />
    </uix:tableLayout>
    </uix:header>

   </uix:cellFormat>
  </uix:rowLayout>
</uix:tableLayout>

    </db:form>
    </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>

