<%--
  -- Page:        osmPerformance.jsp
  -- Controller:  oracle.sysman.db.adm.osm.OsmHealthController
  --
  -- Description: ASM instance Performance page
  --
  --  MODIFIED    (MM/DD/YY)
  --     mpawelko    02/23/09 - backport 6525227: remove hardcoded thresholds
  --     mpawelko  07/16/08 - use OP_SIZE msg for Operation Size
  --     asubba    05/05/08 - XbranchMerge asubba_asm_tb_issues from
  --                          st_emdbsa_11.1.0.0.0_project-22846
  --     asubba    04/08/08 - always show users tab
  --     chanchan  02/14/08 - Add related links
  --     chanchan  07/16/07 - Hide/show OFS tab
  --     asubba    05/09/07 - remove validation for user link in perf page
  --     gmahaney  02/01/07 - XbranchMerge gmahaney_emdb_pt_main from main
  --     qsong     01/19/07 - 
  --     qsong     10/27/06 - 
  --     qsong     03/06/07 - remove access warning msg
  --     asubba    05/09/07 - remove validation for user link in perf page
  --     qsong     03/06/07 - remove access warning msg
  --     qsong     10/06/06 - add historical refresh choices
  --     chanchan  06/13/06 - add OFS tab
  --     asubba    09/11/06 - rolling migration
  --     qsong     08/31/06 - XbranchMerge qsong_bug-5495729 from main
  --     qsong     02/03/06 - add SIZE (the 4th) chart
  --     rajeshar  07/27/05 - bug 4410193
  --     rajeshar  03/30/05 - UI review changes
  --     jochen    06/26/04 - Make chart layouts vertical, enable
  --                          SVG automatic update
  --     many      ?        - Many edits by many people
  --     spanchum  10/14/02 - Creation
  --%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.db.adm.osm.JspConstants" %>
<%@ include file="/oemNoscript.jspf" %>


<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<%-- Message Bundles --%>
<uix:bundle name="msgs"
            class="oracle.sysman.db.rsc.osm.OsmObjectMsg"/>
<uix:bundle name="DBMsgs"
            class="oracle.sysman.db.rsc.inst.DBMsg"/>
<uix:bundle name="ofsMsg" class="oracle.sysman.db.rsc.osm.ofs.OfsObjectMsg" />

  <uix:document>
    <uix:metaContainer>
      <meta http-equiv="Refresh" content=<%=request.getAttribute("pageRefreshRate") %> >
    </uix:metaContainer>

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body onLoadBinding="focusJavaScript@servletRequest">
    <uix:pageLayout titleBinding="header@osmHealthBean@servletRequest">
    <%@ include file="/database/global.jspf" %>

    <uix:form name="osmHealth" method="get"
              destinationBinding="defaultURL@servletRequest">
      <uix:formValue name="pageName"
                     value="<%= JspConstants.OSM_PERFORMANCE_PAGE %>"/>

      <uix:subTabLayout>
        <uix:subTabs>
          <uix:subTabBar selectedIndex="1">
              <uix:link textBinding="HOME@DBMsgs"
                 destinationBinding="sitemapDest@servletRequest"
                 renderedBinding="showOsmHomePage@servletRequest"/>
              <uix:link textBinding="PERFORMANCE_HEADER@DBMsgs"/>
              <uix:link textBinding="DISKGROUPS@msgs"
                 destinationBinding="adminDest@servletRequest"/>
              <uix:link textBinding="CONFIGURATION@DBMsgs"
                 destinationBinding="configDest@servletRequest"
                 renderedBinding="showOsmConfigPage@servletRequest"/>
              <uix:link textBinding="USERS@msgs"
                 destinationBinding="usersDest@servletRequest"/>
              <uix:link textBinding="ORACLE_FILE_SYSTEM@ofsMsg" renderedBinding="showOfs@servletRequest"
                 destinationBinding="ofsDest@servletRequest"/>
          </uix:subTabBar>
        </uix:subTabs>

        <%--
        ======================
        == Refresh settings
        ======================
        --%>
           <%-- ASM Rolling Migration Info --%>
       <uix:switcher childNameBinding="rollingMigrationStatus@osmHealthBean@servletRequest">
        <uix:case name="true">
        <uix:tableLayout >
          <uix:rowLayout>
            <uix:spacer height="5"/>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:cellFormat width="15"/>
            <uix:cellFormat >
            <uix:image source="/em/images/infoicon_active.gif"/>
             </uix:cellFormat >
             
            <uix:cellFormat width="5"/>
            <uix:cellFormat >
            <uix:styledText styleClass="OraPromptText" textBinding="ROLLING_MIGRATION_PERF_MESSAGE@msgs"/>
             </uix:cellFormat >
          </uix:rowLayout>
           <uix:rowLayout>
            <uix:spacer height="25"/>
          </uix:rowLayout>
          </uix:tableLayout >
        </uix:case> 
       <uix:case name="false"> 
       <uix:stackLayout >
        <uix:tableLayout width="100%">
          <uix:rowLayout hAlign="right">
            <uix:cellFormat>
              <uix:contents>
                <uix:tableLayout cellSpacing="5">
                  <uix:rowLayout>
                    <uix:cellFormat>
                      <uix:styledText styleClass="OraInlineInfoText"
                                      textBinding="lastUpdatedTime@osmHealthBean@servletRequest"/>
                    </uix:cellFormat>

                    <uix:cellFormat>
                      <uix:styledText labeledNodeId="viewChoice"
                                      styleClass="OraPromptText"
                                      textBinding="VIEW@msgs"/>
                    </uix:cellFormat>
                    <uix:cellFormat>
                      <uix:choice id="viewChoice"
                                  name="viewChoice"
                                  selectedValueBinding="viewChoice@osmHealthBean@servletRequest"
                                  onChange="submitForm('osmHealth',true,{'event':'refreshviewChoice'})">
                        <uix:option textBinding="DEFAULT@msgs"
                                    value="<%= JspConstants.IO_SUMMARY_OPT %>" />
                        <uix:option textBinding="READS_UOM@msgs"
                                    value="<%= JspConstants.READS_OPT %>"/>
                        <uix:option textBinding="WRITES_UOM@msgs"
                                    value="<%= JspConstants.WRITES_OPT %>"/>
                        </uix:choice>
                    </uix:cellFormat>

                    <uix:cellFormat>
                      <uix:styledText labeledNodeId="refreshChoice" styleClass="OraPromptText"
                                      textBinding="REFRESH@msgs"/>
                    </uix:cellFormat>
                    <uix:cellFormat>
                      <uix:choice id="refreshChoice"
                                  name="refreshChoice"
                                  selectedValueBinding="refreshChoice@osmHealthBean@servletRequest"
                                  onChange="submitForm('osmHealth',true,{'event':'refreshChoice','pageIndex':'1'})">
                        <uix:option textBinding="REALTIME_MANUAL@msgs"
                                    value="<%= JspConstants.MANUAL_REFRESH %>" />
                        <uix:option textBinding="REALTIME_AUTO15@msgs"
                                    value="15"/>
                        <uix:option textBinding="REALTIME_AUTO30@msgs"
                                    value="30"/>
                        <uix:option textBinding="LAST24@msgs"
                                    value="<%= JspConstants.HIST_LAST_24_HR%>"/>
                        <uix:option textBinding="LAST7@msgs"
                                    value="<%= JspConstants.HIST_LAST_7_DAYS%>"/>
                        <uix:option textBinding="LAST31@msgs"
                                    value="<%= JspConstants.HIST_LAST_31_DAYS%>"/>
                      </uix:choice>
                    </uix:cellFormat>
                    <uix:cellFormat>
                      <uix:submitButton name="event"
                                        textBinding="REFRESH@msgs"
                                        value="refresh"/>
                    </uix:cellFormat>

                  </uix:rowLayout>
                </uix:tableLayout>
              </uix:contents>
            </uix:cellFormat>
          </uix:rowLayout>
        </uix:tableLayout>

        <jsp:include page="/database/osm/osmHistPerformanceInclude.jsp"/>
        <uix:ref refID="osmHistPerformanceInclude"/>

        <uix:stackLayout renderedBinding="summary@osmHealthBean@servletRequest">

          <%--
          ======================================
          == Disk Group I/O Response Time Chart
          ======================================
          --%>
          <oem:chart titleBinding="RESPONSE_TIME@OsmObjectBundle@servletRequest"
                     chartType="timeSeriesChart"
                     svgUpdateFrequencyBinding="refreshChoice@osmHealthBean@servletRequest"
                     format="svg"
                     orientation="vertical"
                     width="650"
                     height="160"
                     legendPosition="east"
                     legendVisible="external"
                     externalLegendOrientation="vertical"
                     svgHighlightLegend="true"
                     timeGranularity="SECOND"
                     seriesColorsAutomatic="true"
                     renderedBinding="realTimeRefreshSelected@osmHealthBean@servletRequest"
                     yAxisLabelBinding="MS_PER_OPERATION@OsmObjectBundle@servletRequest">
            <uix:contents>
              <oem:rtChartDataSource targetBinding="targetName@osmHealthBean@servletRequest"
                                     targetType="osm_instance"
                                     metricId="Single_Instance_DiskGroup_Performance"/>
              <oem:chartColumn
                displayLabelBinding="DISKGROUP@OsmObjectBundle@servletRequest"
                columnName="dg_name"
                isKey="true"
                />
              <oem:chartColumn
                displayLabel=" "
                columnName="io_response_time"
                />
              <oem:chartColumn
                isTimeColumn="true"
                displayLabel="Date"
                sourceIndex="1"
                />
            </uix:contents>
          </oem:chart>

          <%--
          ================================
          == Disk Group Throughput
          ================================
          --%>
          <oem:chart titleBinding="THROUGHPUT@OsmObjectBundle@servletRequest"
                     chartType="timeSeriesChart"
                     format="svg"
                     svgUpdateFrequencyBinding="refreshChoice@osmHealthBean@servletRequest"
                     orientation="vertical"
                     width="650"
                     height="160"
                     timeGranularity="SECOND"
                     seriesColorsAutomatic="true"
                     yAxisLabelBinding="MB_PER_SECOND@OsmObjectBundle@servletRequest"
                     legendPosition="east"
                     legendVisible="external"
                     renderedBinding="realTimeRefreshSelected@osmHealthBean@servletRequest"
                     externalLegendOrientation="vertical">
            <uix:contents>
              <oem:rtChartDataSource
                    targetBinding="targetName@osmHealthBean@servletRequest"
                    targetType="osm_instance"
                    metricId="Single_Instance_DiskGroup_Performance"/>
              <oem:chartColumn
                displayLabelBinding="DISKGROUP@OsmObjectBundle@servletRequest"
                columnName="dg_name"
                isKey="true"
                />
              <oem:chartColumn
                displayLabel=" "
                columnName="io_throughput"
                />
              <oem:chartColumn
                isTimeColumn="true"
                displayLabel="Date"
                sourceIndex="1"
                />
            </uix:contents>
          </oem:chart>


          <%--
          ================================
          == Disk Group I/O Operations
          ================================
          --%>
          <oem:chart titleBinding="OPERATIONS_PS_TITLE@OsmObjectBundle@servletRequest"
                     chartType="timeSeriesChart"
                     format="svg"
                     svgUpdateFrequencyBinding="refreshChoice@osmHealthBean@servletRequest"
                     orientation="vertical"
                     width="650"
                     height="160"
                     legendPosition="east"
                     legendVisible="external"
                     externalLegendOrientation="vertical"
                     timeGranularity="SECOND"
                     seriesColorsAutomatic="true"
                     renderedBinding="realTimeRefreshSelected@osmHealthBean@servletRequest"
                     yAxisLabelBinding="OPERATIONS_PS@OsmObjectBundle@servletRequest">
            <uix:contents>
              <oem:rtChartDataSource
                    targetBinding="targetName@osmHealthBean@servletRequest"
                    targetType="osm_instance"
                    metricId="Single_Instance_DiskGroup_Performance"
              />
              <oem:chartColumn
                displayLabel="DiskGroup"
                columnName="dg_name"
                isKey="true"
                />
              <oem:chartColumn
                displayLabel=" "
                columnName="io_ps"
                />
              <oem:chartColumn
                isTimeColumn="true"
                displayLabel="Date"
                sourceIndex="1"
                />
            </uix:contents>
          </oem:chart>


          <%--
          ================================
          == Disk Group I/O Size
          ================================
          --%>
          <oem:chart titleBinding="OP_SIZE@OsmObjectBundle@servletRequest"
                     chartType="timeSeriesChart"
                     format="svg"
                     svgUpdateFrequencyBinding="refreshChoice@osmHealthBean@servletRequest"
                     orientation="vertical"
                     width="650"
                     height="160"
                     timeGranularity="SECOND"
                     seriesColorsAutomatic="true"
                     yAxisLabelBinding="MB_PER_OPERATION@OsmObjectBundle@servletRequest"
                     legendPosition="east"
                     legendVisible="external"
                     renderedBinding="realTimeRefreshSelected@osmHealthBean@servletRequest"
                     externalLegendOrientation="vertical">
            <uix:contents>
              <oem:rtChartDataSource
                    targetBinding="targetName@osmHealthBean@servletRequest"
                    targetType="osm_instance"
                    metricId="Single_Instance_DiskGroup_Performance"/>
              <oem:chartColumn
                displayLabelBinding="DISKGROUP@OsmObjectBundle@servletRequest"
                columnName="dg_name"
                isKey="true"
                />
              <oem:chartColumn
                displayLabel=" "
                columnName="io_size"
                />
              <oem:chartColumn
                isTimeColumn="true"
                displayLabel="Date"
                sourceIndex="1"
                />
            </uix:contents>
          </oem:chart>

          <%-- End New IO Size Chart --%>

        </uix:stackLayout>

        <%--
        ==================================================================
        == Shown only when READS view selected
        ==================================================================
        --%>
        <uix:stackLayout renderedBinding="reads@osmHealthBean@servletRequest">

          <%--
          =====================================
          == Disk Group Read Response Time
          =====================================
          --%>
          <oem:chart titleBinding="RESPONSE_TIME@OsmObjectBundle@servletRequest"
                     chartType="timeSeriesChart"
                     format="svg"
                     svgUpdateFrequencyBinding="refreshChoice@osmHealthBean@servletRequest"
                     orientation="vertical"
                     width="650"
                     height="160"
                     legendPosition="east"
                     legendVisible="external"
                     externalLegendOrientation="vertical"
                     timeGranularity="SECOND"
                     seriesColorsAutomatic="true"
                     yAxisLabelBinding="MS_PER_OPERATION@OsmObjectBundle@servletRequest"
                     renderedBinding="realTimeRefreshSelected@osmHealthBean@servletRequest">
            <uix:contents>
              <oem:rtChartDataSource
                    targetBinding="targetName@osmHealthBean@servletRequest"
                    targetType="osm_instance"
                    metricId="Single_Instance_DiskGroup_Performance"
              />
              <oem:chartColumn
                displayLabelBinding="DISKGROUP@OsmObjectBundle@servletRequest"
                columnName="dg_name"
                isKey="true"
                />
              <oem:chartColumn
                displayLabel=" "
                columnName="read_response_time"
                />
              <oem:chartColumn
                isTimeColumn="true"
                displayLabel="Date"
                sourceIndex="1"
                />
            </uix:contents>
          </oem:chart>


          <%--
          ================================
          == Disk Group Read Throughput
          ================================
          --%>
          <oem:chart titleBinding="THROUGHPUT@OsmObjectBundle@servletRequest"
                     chartType="timeSeriesChart"
                     format="svg"
                     svgUpdateFrequencyBinding="refreshChoice@osmHealthBean@servletRequest"
                     orientation="vertical"
                     width="650"
                     height="160"
                     legendPosition="east"
                     legendVisible="external"
                     externalLegendOrientation="vertical"
                     timeGranularity="SECOND"
                     seriesColorsAutomatic="true"
                     renderedBinding="realTimeRefreshSelected@osmHealthBean@servletRequest"
                     yAxisLabelBinding="MB_PER_SECOND@OsmObjectBundle@servletRequest">
            <uix:contents>
              <oem:rtChartDataSource
                    targetBinding="targetName@osmHealthBean@servletRequest"
                    targetType="osm_instance"
                    metricId="Single_Instance_DiskGroup_Performance"
              />
              <oem:chartColumn
                displayLabelBinding="DISKGROUP@OsmObjectBundle@servletRequest"
                columnName="dg_name"
                isKey="true"
                />
              <oem:chartColumn
                displayLabel=" "
                columnName="read_throughput"
                />
              <oem:chartColumn
                isTimeColumn="true"
                displayLabel="Date"
                sourceIndex="1"
                />
            </uix:contents>
          </oem:chart>

                    <%--
          ===============================
          == Disk Group Reads Per Second
          ===============================
          --%>
          <oem:chart titleBinding="OPERATIONS_PS_TITLE@OsmObjectBundle@servletRequest"
                     chartType="timeSeriesChart"
                     format="svg"
                     svgUpdateFrequencyBinding="refreshChoice@osmHealthBean@servletRequest"
                     orientation="vertical"
                     width="650"
                     height="160"
                     legendPosition="east"
                     legendVisible="external"
                     externalLegendOrientation="vertical"
                     timeGranularity="SECOND"
                     seriesColorsAutomatic="true"
                     renderedBinding="realTimeRefreshSelected@osmHealthBean@servletRequest"
                     yAxisLabelBinding="OPERATIONS_PS@OsmObjectBundle@servletRequest"
              >
            <uix:contents>
              <oem:rtChartDataSource
                    targetBinding="targetName@osmHealthBean@servletRequest"
                    targetType="osm_instance"
                    metricId="Single_Instance_DiskGroup_Performance"/>
              <oem:chartColumn
                displayLabel="DiskGroup"
                columnName="dg_name"
                isKey="true"
                />
              <oem:chartColumn
                displayLabel=" "
                columnName="reads_ps"
                />
              <oem:chartColumn
                isTimeColumn="true"
                displayLabel="Date"
                sourceIndex="1"
                />
            </uix:contents>
          </oem:chart>

          <%--
          ================================
          == Disk Group Read Size
          ================================
          --%>
          <oem:chart titleBinding="OP_SIZE@OsmObjectBundle@servletRequest"
                     chartType="timeSeriesChart"
                     format="svg"
                     svgUpdateFrequencyBinding="refreshChoice@osmHealthBean@servletRequest"
                     orientation="vertical"
                     width="650"
                     height="160"
                     legendPosition="east"
                     legendVisible="external"
                     externalLegendOrientation="vertical"
                     timeGranularity="SECOND"
                     seriesColorsAutomatic="true"
                     renderedBinding="realTimeRefreshSelected@osmHealthBean@servletRequest"
                     yAxisLabelBinding="MB_PER_OPERATION@OsmObjectBundle@servletRequest">
            <uix:contents>
              <oem:rtChartDataSource
                    targetBinding="targetName@osmHealthBean@servletRequest"
                    targetType="osm_instance"
                    metricId="Single_Instance_DiskGroup_Performance"
              />
              <oem:chartColumn
                displayLabelBinding="DISKGROUP@OsmObjectBundle@servletRequest"
                columnName="dg_name"
                isKey="true"
                />
              <oem:chartColumn
                displayLabel=" "
                columnName="read_size"
                />
              <oem:chartColumn
                isTimeColumn="true"
                displayLabel="Date"
                sourceIndex="1"
                />
            </uix:contents>
          </oem:chart>
          <!-- End Read Size -->

        </uix:stackLayout>

        <%--
        ==================================================================
        == Shown only when WRITES view selected
        ==================================================================
        --%>
        <uix:stackLayout renderedBinding="writes@osmHealthBean@servletRequest">
          <%--
          ====================================
          == Disk Group Write Response Time
          ====================================
          --%>
          <oem:chart titleBinding="RESPONSE_TIME@OsmObjectBundle@servletRequest"
                     chartType="timeSeriesChart"
                     format="svg"
                     svgUpdateFrequencyBinding="refreshChoice@osmHealthBean@servletRequest"
                     orientation="vertical"
                     width="650"
                     height="160"
                     legendPosition="east"
                     legendVisible="external"
                     externalLegendOrientation="vertical"
                     timeGranularity="SECOND"
                     seriesColorsAutomatic="true"
                     yAxisLabelBinding="MS_PER_OPERATION@OsmObjectBundle@servletRequest"
                     renderedBinding="realTimeRefreshSelected@osmHealthBean@servletRequest">
            <uix:contents>
              <oem:rtChartDataSource
                    targetBinding="targetName@osmHealthBean@servletRequest"
                    targetType="osm_instance"
                    metricId="Single_Instance_DiskGroup_Performance"/>
              <oem:chartColumn
                displayLabelBinding="DISKGROUP@OsmObjectBundle@servletRequest"
                columnName="dg_name"
                isKey="true"
                />
              <oem:chartColumn
                displayLabel=" "
                columnName="write_response_time"
                />
              <oem:chartColumn
                isTimeColumn="true"
                displayLabel="Date"
                sourceIndex="1"
                />
            </uix:contents>
          </oem:chart>


          <%--
          ================================
          == Disk Group Write Throughput
          ================================
          --%>
          <oem:chart titleBinding="THROUGHPUT@OsmObjectBundle@servletRequest"
                     chartType="timeSeriesChart"
                     format="svg"
                     svgUpdateFrequencyBinding="refreshChoice@osmHealthBean@servletRequest"
                     orientation="vertical"
                     width="650"
                     height="160"
                     legendPosition="east"
                     legendVisible="external"
                     externalLegendOrientation="vertical"
                     timeGranularity="SECOND"
                     seriesColorsAutomatic="true"
                     renderedBinding="realTimeRefreshSelected@osmHealthBean@servletRequest"
                     yAxisLabelBinding="MB_PER_SECOND@OsmObjectBundle@servletRequest">
            <uix:contents>
              <oem:rtChartDataSource
                    targetBinding="targetName@osmHealthBean@servletRequest"
                    targetType="osm_instance"
                    metricId="Single_Instance_DiskGroup_Performance"/>
              <oem:chartColumn
                displayLabelBinding="DISKGROUP@OsmObjectBundle@servletRequest"
                columnName="dg_name"
                isKey="true"
                />
              <oem:chartColumn
                displayLabel=" "
                columnName="write_throughput"
                />
              <oem:chartColumn
                isTimeColumn="true"
                displayLabel="Date"
                sourceIndex="1"
                />
            </uix:contents>
          </oem:chart>

                    <%--
          ================================
          == Disk Group Writes Per Second
          ================================
          --%>
          <oem:chart titleBinding="OPERATIONS_PS_TITLE@OsmObjectBundle@servletRequest"
                     chartType="timeSeriesChart"
                     format="svg"
                     svgUpdateFrequencyBinding="refreshChoice@osmHealthBean@servletRequest"
                     orientation="vertical"
                     width="650"
                     height="160"
                     legendPosition="east"
                     legendVisible="external"
                     externalLegendOrientation="vertical"
                     timeGranularity="SECOND"
                     seriesColorsAutomatic="true"
                     renderedBinding="realTimeRefreshSelected@osmHealthBean@servletRequest"
                     yAxisLabelBinding="OPERATIONS_PS@OsmObjectBundle@servletRequest">
            <uix:contents>
              <oem:rtChartDataSource
                    targetBinding="targetName@osmHealthBean@servletRequest"
                    targetType="osm_instance"
                    metricId="Single_Instance_DiskGroup_Performance"/>
              <oem:chartColumn
                displayLabel="DiskGroup"
                columnName="dg_name"
                isKey="true"
                />
              <oem:chartColumn
                displayLabel=" "
                columnName="writes_ps"
                />
              <oem:chartColumn
                isTimeColumn="true"
                displayLabel="Date"
                sourceIndex="1"
                />
            </uix:contents>
          </oem:chart>

          <%--
          ================================
          == Disk Group Write Size
          ================================
          --%>
          <oem:chart titleBinding="OP_SIZE@OsmObjectBundle@servletRequest"
                     chartType="timeSeriesChart"
                     format="svg"
                     svgUpdateFrequencyBinding="refreshChoice@osmHealthBean@servletRequest"
                     orientation="vertical"
                     width="650"
                     height="160"
                     legendPosition="east"
                     legendVisible="external"
                     externalLegendOrientation="vertical"
                     timeGranularity="SECOND"
                     seriesColorsAutomatic="true"
                     renderedBinding="realTimeRefreshSelected@osmHealthBean@servletRequest"
                     yAxisLabelBinding="MB_PER_OPERATION@OsmObjectBundle@servletRequest">
            <uix:contents>
              <oem:rtChartDataSource
                    targetBinding="targetName@osmHealthBean@servletRequest"
                    targetType="osm_instance"
                    metricId="Single_Instance_DiskGroup_Performance"
              />
              <oem:chartColumn
                displayLabelBinding="DISKGROUP@OsmObjectBundle@servletRequest"
                columnName="dg_name"
                isKey="true"
                />
              <oem:chartColumn
                displayLabel=" "
                columnName="write_size"
                />
              <oem:chartColumn
                isTimeColumn="true"
                displayLabel="Date"
                sourceIndex="1"
                />
            </uix:contents>
          </oem:chart>
          <!-- End Write Size -->

        </uix:stackLayout>

        <%--
        ================================
        == Additional Monitoring Links
        ================================
        --%>
        <uix:header textBinding="ADDITIONAL_MON_LINKS@DBMsgs"
                    renderedBinding="showAsmDiskRelatedInfo@servletRequest">
          <uix:bulletedList rows="1">
            <uix:contents>
              <uix:link textBinding="DG_IO_CUMULATIVE_SUMMARY@msgs"
                        destinationBinding="ioCumulativeDest@servletRequest"/>
            </uix:contents>
          </uix:bulletedList>
        </uix:header>
         </uix:stackLayout>
         </uix:case>
        </uix:switcher> 
      </uix:subTabLayout>
    <uix:tableLayout>
      <oem:relatedLinks />
    </uix:tableLayout>
     </uix:form>
    </uix:pageLayout>
  </uix:body>
  </uix:document>
</uix:renderingContext>

