<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 

<%@ page import="oracle.cabo.share.config.AccessibilityMode"%>
<%@ page import="oracle.cabo.share.config.Configuration"%>
<%@ page import="oracle.sysman.emo.adm.osm.DiskGroup" %>
<%@ page import="oracle.sysman.emo.adm.osm.OSMAdminDataSource" %>
<%@ page import="oracle.sysman.emo.adm.osm.OsmProcess" %>
<%

  OsmProcess processBean = null;
  Object defaultBean = (Object)(request.getAttribute("defaultBean"));
  if(defaultBean instanceof DiskGroup)
  {
    DiskGroup diskGroup = (DiskGroup)defaultBean;
    processBean = diskGroup.getProcessBean();
  }
  else if(defaultBean instanceof OSMAdminDataSource)
  {
    OSMAdminDataSource osmSdmin = (OSMAdminDataSource)defaultBean;
    processBean = osmSdmin.getProcessBean();
  }
  Configuration adaConfig = renderingContext.getConfiguration();

  // If mode is accessible, tell the bean
  if (!AccessibilityMode.isInaccessibleMode(adaConfig))
  {
      if(processBean != null)
        processBean.setIsAccessible();
  }

%>

  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>    

    <uix:body>
      <uix:contents>
        <db:form name="processForm" destinationBinding="defaultURL@servletRequest" method="post">
          <uix:formValue name="pageName" value="/database/osm/osmProcess"/>

          <uix:pageLayout titleBinding="header@processBean@defaultBean@servletRequest" messageType="processing">

            <!-- for breadcrumbs support; plus standard label, links, tabs, etc -->
            <%@ include file="/database/global.jspf" %>           

            <oem:messageBox messageType="info" 
                                 errorTableBinding="info@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
            <oem:messageBox messageType="error"
                                 errorTableBinding="errors@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
            
            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:contents>
                  <uix:submitButton textBinding="CANCEL@uixDBObjectBundle@servletRequest" 
                      name="event" value="cancelProcess" formName="processForm"
                      renderedBinding="operationCancellable@processBean@defaultBean@servletRequest"/> 
                </uix:contents>
              </uix:pageButtonBar>
            </uix:pageButtons>

            <uix:pageStatus>
              <uix:stackLayout>
                <uix:contents>
                  <uix:styledText styleClass="OraInstructionTextStrong" textBinding="processIsDoingText@processBean@defaultBean@servletRequest"/>
                </uix:contents>
              </uix:stackLayout>
            </uix:pageStatus>

            <uix:contents>
              <uix:stackLayout>
                <uix:contents>
                  <uix:spacer height="5" />
                  <uix:styledText styleClass="OraInstructionText"
                    textBinding="PROCESS_TO_CANCEL@OsmObjectBundle@servletRequest"
                    renderedBinding="operationCancellable@processBean@defaultBean@servletRequest"/>
                  <uix:spacer height="20" /> 
                 <%-- percentCompleteBinding="percentCompleteData@processBean@defaultBean@servletRequest"  --%>
                  <uix:processing timeIntervalBinding="timeInterval@processBean@defaultBean@servletRequest">
                    <uix:contents>
                      <uix:tableLayout cellSpacing="1">
                        <uix:contents childDataBinding="allStepsData@processBean@defaultBean@servletRequest">

                          <uix:rowLayout>
                            <uix:contents >
                              <uix:cellFormat>
                                <uix:contents>
                                  <uix:image source="/em/images/processCheck.gif" 
                                    renderedBinding="renderedDone"/>  
                                  <uix:image source="/em/images/critical.gif" 
                                    renderedBinding="renderedError"/>            
                                  <uix:image source="/em/images/currentStep.gif" 
                                    renderedBinding="current"/>                                         
                                </uix:contents>
                              </uix:cellFormat>
                              <uix:spacer width="3" />
                              <uix:cellFormat vAlign="bottom">
                                <uix:contents >
                                <uix:styledText styleClass="OraFieldText" textBinding="text" /> 
                                </uix:contents>
                              </uix:cellFormat>
                            </uix:contents>
                          </uix:rowLayout>

                        </uix:contents>
                      </uix:tableLayout>
                    </uix:contents>
                  </uix:processing>
                  <%--
                  <uix:spacer width="10"/>
                  <uix:tip>
                    <uix:styledText text="This operation cannot be cancelled." styleClass="OraInstructionText"/>
                  </uix:tip>
                  --%>
                </uix:contents>
              </uix:stackLayout>
            </uix:contents>
          </uix:pageLayout> 
        </db:form>  
      </uix:contents>
    </uix:body>

  </uix:document> 
</uix:renderingContext> 
