<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <uix:metaContainer>
      <uix:head titleBinding="RACSelectionTitle@osmConfirmBean@servletRequest"/>      
    </uix:metaContainer>

    <%@ include file="/enablePPR.jspf" %>
    
    <uix:body>
    <uix:form name="foo" destinationBinding="commandURL@servletRequest">
    <uix:pageLayout>   
     <%@ include file="/database/global.jspf" %>   

       <oem:messageBox messageType="info"
                       errorTableBinding="confirmation@servletRequest"
                       titleTextKey="titleText" mainTextKey="mainText"/>
       <oem:messageBox messageType="error"
                       errorTableBinding="errors@servletRequest"
                       titleTextKey="titleText" mainTextKey="mainText"/>

      <uix:formValue name="optionChoice" valueBinding="optionChoice@servletRequest"/>         
      <uix:formValue name="mname" valueBinding="mname@servletRequest"/>               
      <uix:formValue name="otype" valueBinding="otype@servletRequest"/>               
      <uix:formValue name="oname" valueBinding="oname@servletRequest"/>      
      <uix:formValue name="option" valueBinding="option@servletRequest"/>      
      <uix:formValue name="index" valueBinding="index@servletRequest"/>      
      <uix:formValue 
        name="pageName" 
        value="/database/osm/osmRacSelection"/>

      
          <uix:header textBinding="RACSelectionPageHeader@osmConfirmBean@servletRequest"/> 

          <%
            if(request.getAttribute("diskGroupName") != null){
          %>
            <uix:labeledFieldLayout labelWidth="20%">            
              <uix:messagePrompt promptBinding="DISKGROUP@OsmObjectBundle@servletRequest"/>
              <uix:styledText styleClass="OraDataText"
                        textBinding="diskGroupName@servletRequest"/>
            </uix:labeledFieldLayout>
            <uix:separator/>
          <% } %>

          <uix:styledText styleClass="OraInstructionText" 
                          textBinding="racSelectionInstText@servletRequest"/>

         <uix:spacer  height="15"/>
         <!--uix:header textBinding="CLUSTER_ASM_INSTANCES@OsmObjectBundle@servletRequest"/ -->
         <oem:shuttle name="clusterAsmInstances"
                      leadingHeaderBinding="AVAILABLE_INSTANCES@OsmObjectBundle@servletRequest"
                      trailingHeaderBinding="SELECTED_INSTANCES@OsmObjectBundle@servletRequest"
                      size="5"
                      reorderable="true">
                    <uix:leading>
                      <oem:list shortDescBinding="AVAILABLE_INSTANCES@OsmObjectBundle@servletRequest" name="availableInstances" optionsBinding="availableInstances@osmConfirmBean@servletRequest"
                                multiple="true"/>
                    </uix:leading>
                    <uix:trailing>
                      <oem:list shortDescBinding="SELECTED_INSTANCES@OsmObjectBundle@servletRequest" name="filterInstances" optionsBinding="filterInstances@osmConfirmBean@servletRequest"
                                multiple="true"/>
                    </uix:trailing>
         </oem:shuttle>
         <!-- uix:messageText messageType="error" messageBinding="selectedInstances@errors@servletRequest" / -->
         <!--/uix:header -->
               
      <uix:contentFooter>
        <uix:pageButtonBar>
          <uix:contents>
            <uix:button textBinding="CANCEL@OsmObjectBundle@servletRequest" destinationBinding="backURL@servletRequest" />  
            <uix:submitButton textBinding="OK@OsmObjectBundle@servletRequest"  name="event" value="doOkay"/>            
          </uix:contents>
        </uix:pageButtonBar>
      </uix:contentFooter>

    </uix:pageLayout>
    </uix:form>    
  </uix:body>
  </uix:document>
</uix:renderingContext>
