<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="msg" class="oracle.sysman.db.rsc.osm.OsmObjectMsg" />
  <uix:document>

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    
    <uix:body>
    <uix:form name="foo" destinationBinding="commandURL@servletRequest">
    <uix:pageLayout titleBinding="resizeOptionsTitle@servletRequest">  
     <%@ include file="/database/global.jspf" %>   
      <oem:messageBox messageType="info"
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
      <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
      <uix:formValue name="optionChoice" valueBinding="optionChoice@servletRequest"/>         
      <uix:formValue name="mname" valueBinding="mname@servletRequest"/>               
      <uix:formValue name="otype" valueBinding="otype@servletRequest"/>               
      <uix:formValue name="oname" valueBinding="oname@servletRequest"/>      
      <uix:formValue name="pageName" value="/database/osm/osmResizeOptions"/>

   <uix:header textBinding="SIZE@msg" >
      <!--.....  Resize Options .....-->	                
      <uix:tableLayout width="100%">
       <uix:rowLayout width="100%">
	<uix:contents>
	 <uix:cellFormat>
	   <oem:radioButton name="option"
			    value="DEFAULT"
			    textBinding="DEFAULT_SIZE@OsmObjectBundle@servletRequest" 
			    selectedValueBinding="resizeSpecifiedOption@diskGrp@servletRequest" />	
	 </uix:cellFormat>
	</uix:contents>
       </uix:rowLayout>

       <uix:rowLayout width="100%">
	<uix:contents>
	 <uix:cellFormat>
	  <uix:styledText styleClass="OraInlineInfoText" textBinding="defaultSizeOptionDesc@servletRequest"/>	
	 </uix:cellFormat>
	</uix:contents>
       </uix:rowLayout>

       <uix:rowLayout width="100%">
	<uix:contents>
	 <uix:cellFormat>
	  <uix:flowLayout>
	   <oem:radioButton name="option"
			    value="SPECIFIED"
			    textBinding="SPECIFIED_SIZE@OsmObjectBundle@servletRequest" 
			    selectedValueBinding="resizeSpecifiedOption@diskGrp@servletRequest" />
	   <uix:textInput shortDescBinding="SPECIFIED_SIZE@OsmObjectBundle@servletRequest" name="size" textBinding="size@diskGrp@servletRequest" columns="15"/>
           <uix:choice  id="unit" name="unit" selectedValueBinding="unit@diskGrp@servletRequest" shortDescBinding="SIZE_UNIT@OsmObjectBundle@servletRequest">
 			<uix:option value="K" textBinding="KBYTES@OsmObjectBundle@servletRequest" />
			<uix:option value="M" textBinding="MBYTES@OsmObjectBundle@servletRequest"/>
			<uix:option value="G" textBinding="GBYTES@OsmObjectBundle@servletRequest"/>
			<uix:option value="T" textBinding="TBYTES@OsmObjectBundle@servletRequest"/>
           </uix:choice>
	  </uix:flowLayout>
	 </uix:cellFormat>
	</uix:contents>
       </uix:rowLayout>

       <uix:rowLayout width="100%">
	<uix:contents>
	 <uix:cellFormat>
	  <uix:styledText styleClass="OraInlineInfoText" textBinding="specifiedSizeOptionDesc@servletRequest"/>	
	 </uix:cellFormat>
	</uix:contents>
       </uix:rowLayout>
      </uix:tableLayout>
        
   </uix:header>
      
      <%@ include file="rebalance.jsp" %>

      <uix:pageButtons>
        <uix:pageButtonBar>
          <uix:contents>         
            <uix:submitButton textBinding="CANCEL@uixDBObjectBundle@servletRequest" name="event" value="cancelAdvancedOptions" />  
            <uix:submitButton textBinding="OK@uixDBObjectBundle@servletRequest"  name="event" value="setAdvancedOptions"/>            
          </uix:contents>
        </uix:pageButtonBar>
      </uix:pageButtons>

    </uix:pageLayout>
    </uix:form>    
  </uix:body>
  </uix:document>
</uix:renderingContext>
