<%--
  -- Page:        osmSitemap.jsp
  -- Controller:  oracle.sysman.db.adm.osm.OsmSitemapController
  --
  -- Description: osm_instance (ASM) target sitemap
  --
  --  MODIFIED    (MM/DD/YY)
  --     chanchan  10/16/09 - Hide or show Volume/ACFS functions depending on supporting platforms
  --     chanchan  12/11/08 - Fix bug 7621343: gui specific for Safari Browser on MAC OS
  --     chanchan  06/17/08 - 
  --     dchakumk  03/10/08 - XbranchMerge dchakumk_6752_xbmsrc from
  --                          st_emdbsa_11.1
  --     jsoule    08/28/07 - add Active Incidents (SWB)
  --     chanchan  07/17/07 - Hide/show OFS tab
  --     chanchan  07/10/07 - Move related links below tabs
  --     qsong     05/18/07 - add volume usage column to Other Volumes table
  --     chanchan  03/27/07 - 
  --     gmahaney  02/01/07 - XbranchMerge gmahaney_emdb_pt_main from main
  --     qsong     01/19/07 - remove access warning msg
  --     qsong     01/03/07 - add Corrupt to serviced OFS table
  --     yozhang   11/29/06 - fix ADA issues
  --     qsong     11/02/06 - 
  --     asubba    10/30/06 - 
  --     qsong     09/29/06 - add configure button if there's metric collection error
  --     asubba    09/22/06 - monitoring configuration improvement
  --     chanchan  08/24/06 - 
  --     qsong     06/16/06 - 
  --     qsong     06/16/06 - 
  --     qsong     04/12/06 - 
  --     chanchan  02/28/06 - Add OFS supports
  --     asubba    03/01/06 - Add configure button and message if target not 
  --                          configured 
  --     rajeshar  04/26/05 - ADA fix, put title for chart
  --     xshen     02/08/05 - adding new policy section 
  --     rajeshar  02/03/05 - using button for refresh instead of refresh icon
  --     jochen    12/21/04 - Use Host Alerts instead of Related Alerts 
  --     chanchan  10/18/04 - Add Licensing 
  --     qsong     10/06/04 - add info message box for session timeout msg
  --     qsong     09/22/04 - add renderedBinding to change status button, bug 3886361
  --     jochen    08/02/04 - Add pageName
  --     jochen    07/26/04 - Show Last Known State link and data
  --     jochen    07/21/04 - use dbForm to propagate target
  --     jochen    06/23/04 - Policy status image gets its own column
  --     jochen    06/22/04 - Dont show icon for alert log.  Fix wrapping in
  --                          General section.
  --     many               - many edits by many people
  --     spanchum  10/14/02 - Initial entry
  --%>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.osm.ofs.Constant" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ page import="oracle.sysman.emo.adm.osm.ServicedOFSsDataSource" %>
<%@ page import="oracle.sysman.emo.adm.osm.OtherVolumeDataSource" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

  <%-- Message Bundles --%>
  <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.inst.DBMsg"/>
  <uix:bundle name="osmMsgs" class="oracle.sysman.db.rsc.osm.OsmObjectMsg"/>
  <uix:bundle name="mntrMsgs" class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:bundle name="ofsMsg" class="oracle.sysman.db.rsc.osm.ofs.OfsObjectMsg" />

  <uix:document>

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <uix:pageLayout>
    <%@ include file="/database/global.jspf" %>
    <uix:switcher childNameBinding="stateChange@servletRequest">
      <uix:case name="true">
        <oem:messageBox messageTypeBinding="stateChangeMessageType@servletRequest"
	      errorTableBinding="msgBox@servletRequest"
                             destTableBinding="msgUrls@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>
      </uix:case>
    </uix:switcher>

    <oem:messageBox messageType="info"
	                  errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
    <oem:messageBox messageType="error" errorTableBinding="error@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
    <oem:messageBox messageType="confirmation" errorTableBinding="confirmation@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
    <db:form name="foo"
             method="post"
             destination="/console/database/osm/osmSitemap"
             copyParams="target,type,cancelURL">
    <uix:formValue
      name="pageName"
      value="/database/osm/osmSitemap"/>

    <uix:header textBinding="header@osmSitemapBean@servletRequest">

     <uix:subTabLayout>
        <uix:subTabs>
          <uix:subTabBar selectedIndex="0">
              <uix:link textBinding="HOME@dbMsgs"/>
              <oem:license>
              <uix:link textBinding="PERFORMANCE_HEADER@dbMsgs"
                 destinationBinding="healthDest@servletRequest"/>
              </oem:license>
              <uix:link textBinding="DISKGROUPS@osmMsgs"
                 destinationBinding="adminDest@servletRequest"/>
              <uix:link textBinding="CONFIGURATION@dbMsgs"
                 destinationBinding="configDest@servletRequest"/>
              <uix:link textBinding="USERS@osmMsgs"
                 destinationBinding="usersDest@servletRequest"
                 renderedBinding="versionGte11g@servletRequest"/>
              <uix:link textBinding="ORACLE_FILE_SYSTEM@ofsMsg" renderedBinding="showOfs@servletRequest"
                 destinationBinding="ofsDest@servletRequest"/>

          </uix:subTabBar>
        </uix:subTabs>

      <uix:tableLayout width="100%" renderedBinding="showNormal@osmSitemapBean@servletRequest">
            <uix:rowLayout hAlign="right">
                <uix:cellFormat>
                     <uix:switcher childNameBinding="showTime@osmSitemapBean@servletRequest">
                      <uix:case name="true">
                        <uix:rowLayout>
                            <uix:styledText styleClass="OraInlineInfoText"
                              textBinding="lastUpdatedTime@osmSitemapBean@servletRequest"/>
                            <uix:spacer width="5"/>  
                            <uix:button textBinding="REFRESH@OsmObjectBundle@servletRequest"
                              destinationBinding="sitemapDest@servletRequest" />
                        </uix:rowLayout>
                      </uix:case>
                    </uix:switcher>
                </uix:cellFormat>
            </uix:rowLayout>
        </uix:tableLayout>

        <uix:tableLayout width="100%" cellSpacing="2">

          <uix:rowLayout vAlign="top">

            <!-- ...................  General Section .................. -->
            <uix:cellFormat vAlign="top" width="50%" >
              <uix:stackLayout>
                <uix:header textBinding="GENERAL@dbMsgs">
                  <uix:rowLayout> <!-- traffic light -->
                    <uix:cellFormat vAlign="top">
                      <!--  Traffic Light... -->
                      <uix:image sourceBinding="trafficImage@servletRequest" shortDescBinding="trafficStatusStr@osmSitemapBean@servletRequest" text="trafficStatusStr@osmSitemapBean@servletRequest"/>
                    </uix:cellFormat>

                    <uix:cellFormat width="100%">
                      <uix:stackLayout>
                        <uix:rowLayout hAlign="right">
                          <uix:cellFormat hAlign="right">
                            <uix:button textBinding="CHANGE_STATE@dbMsgs"
                                        destinationBinding="changeStateUrl@servletRequest"
                                        renderedBinding="renderChangeStateButton@osmSitemapBean@servletRequest"/>
                          </uix:cellFormat>
                        </uix:rowLayout>
                        <uix:spacer height="20"/>

                        <uix:switcher childNameBinding="showNormal@osmSitemapBean@servletRequest">

                          <!------------------------
                            -- Last Known State
                            ------------------------>
                          <uix:case name="false">
                          <uix:rowLayout width="100%">
                          <uix:tableLayout hAlign="left">
                            <!-- Current status -->
                            <uix:rowLayout vAlign="bottom">
                              <uix:cellFormat hAlign="right" wrappingDisabled="true" vAlign="bottom">
                                <uix:styledText styleClass="OraPromptText"
                                                textBinding="CURRENT_STATUS@dbMsgs"/>
                              </uix:cellFormat>
                              <uix:spacer width="8"/>
                              <uix:cellFormat wrappingDisabled="true" vAlign="bottom" >
                                <uix:styledText styleClass="OraDataText" 
                                                textBinding="trafficStatusStr@osmSitemapBean@servletRequest"/>
                              </uix:cellFormat>
                            </uix:rowLayout> 
                            
                            <!-- Target Configuration -->
                            <uix:rowLayout renderedBinding="targetNotConfig@osmSitemapBean@servletRequest">
                              <uix:cellFormat hAlign="right" wrappingDisabled="true"/>

                              <uix:spacer width="8"/>

                              <uix:cellFormat hAlign="left" vAlign="center" wrappingDisabled="true">
                                <uix:styledText styleClass="OraPromptText"  
				                             textBinding="ASM_NOT_CONFIGURED_DESC@OsmObjectBundle@servletRequest"/>
                                <uix:spacer width="2"/>
                                <uix:button textBinding="CONFIGURE@dbMsgs" 
                                  destinationBinding="monConfigLink@servletRequest"/>
                              </uix:cellFormat>
                            </uix:rowLayout>
                            
                            <!-- Up since -->
                            <uix:rowLayout> 
                              <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                <uix:styledText styleClass="OraPromptText"
                                                textBinding="sinceText@osmSitemapBean@servletRequest"/>
                              </uix:cellFormat>
                              
                              <uix:spacer width="8"/>

                              <uix:cellFormat hAlign="left" wrappingDisabled="true">
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="sinceTime@osmSitemapBean@servletRequest"/>
                              </uix:cellFormat>
                            </uix:rowLayout> 

                            <!-- Last known state -->
                            <uix:rowLayout> 
                              <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                <uix:link textBinding="LAST_KNOWN_STATE@mntrMsgs"
                                          destinationBinding="showLastDest@servletRequest"/>
                              </uix:cellFormat>
                            </uix:rowLayout> 
                          </uix:tableLayout> 
                          </uix:rowLayout>
                        </uix:case>

                        <!------------------------
                          -- Normal
                          ------------------------>
                        <uix:default>
                            <uix:rowLayout width="100%">
                            <uix:tableLayout>
                              <!-- Current status -->
                              <uix:rowLayout>
                                <uix:cellFormat hAlign="right">
                                  <uix:styledText styleClass="OraPromptText"
                                                  textBinding="CURRENT_STATUS@dbMsgs"/>
                                </uix:cellFormat>
                                <uix:spacer width="1"/>
                                <uix:styledText styleClass="OraDataText"
                                  textBinding="trafficStatusStr@osmSitemapBean@servletRequest"/>
                              </uix:rowLayout>

                              <!-- Up since -->
                              <uix:rowLayout>
                                <uix:cellFormat hAlign="right">
                                  <uix:styledText styleClass="OraPromptText"
                                                  textBinding="sinceText@osmSitemapBean@servletRequest"/>
                                </uix:cellFormat>
                                <uix:spacer width="1"/>
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="sinceTime@osmSitemapBean@servletRequest"/>
                              </uix:rowLayout>

                              <!-- Availability -->
                              <uix:rowLayout>
                                <uix:cellFormat hAlign="right">
                                  <uix:styledText styleClass="OraPromptText"
                                                  textBinding="AVAILABILITY@@dbMsgs"/>
                                </uix:cellFormat>
                                <uix:spacer width="18"/>
                                <oem:license>
                                <uix:link textBinding="trafficAvailStr@osmSitemapBean@servletRequest"
                                          destinationBinding="availDest@servletRequest"/>
                                </oem:license>
                              </uix:rowLayout>
                              <uix:rowLayout>
                                <uix:spacer width="1"/>
                                <uix:spacer width="1"/>
                                <uix:rowLayout>
                                  <uix:styledText styleClass="OraInlineInfoText"
                                    text="(" />
                                  <uix:styledText styleClass="OraInlineInfoText"
                                    textBinding="LAST_DAY@SDKBundle@servletRequest" />
                                  <uix:styledText styleClass="OraInlineInfoText"
                                    text=")" />
                                </uix:rowLayout>
                              </uix:rowLayout>

                              <!-- Instance name -->
                              <uix:rowLayout>
                                <uix:cellFormat hAlign="right">
                                  <uix:styledText styleClass="OraPromptText"
                                                  textBinding="INSTANCE_NAME@dbMsgs"/>
                                </uix:cellFormat>
                                <uix:spacer width="1"/>
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="instanceName@osmSitemapBean@servletRequest"/>
                              </uix:rowLayout>

                              <!-- Version -->
                              <uix:rowLayout>
                                <uix:cellFormat hAlign="right">
                                  <uix:styledText styleClass="OraPromptText"
                                                  textBinding="VERSION@dbMsgs"/>
                                </uix:cellFormat>
                                <uix:spacer width="18"/>
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="instanceVersion@osmSitemapBean@servletRequest"/>
                              </uix:rowLayout>

                              <!-- Host -->
                              <uix:rowLayout>
                                <uix:cellFormat hAlign="right">
                                  <uix:styledText styleClass="OraPromptText"
                                                  textBinding="HOST@dbMsgs" />
                                </uix:cellFormat>
                                <uix:spacer width="1"/>
                                <uix:link destinationBinding="hostDest@servletRequest"
                                                textBinding="hostDetailsLinkLabel@osmSitemapBean@servletRequest"/>
                              </uix:rowLayout>

                              <!-- Oracle Home -->
                              <uix:rowLayout>
                                <uix:cellFormat hAlign="right">
                                  <uix:styledText styleClass="OraPromptText"
                                                  textBinding="ORACLE_HOME@dbMsgs" />
                                </uix:cellFormat>
                                <uix:spacer width="1"/>
                                <oem:license>
                                <uix:link destinationBinding="oracleHomeDest@servletRequest"
                                          textBinding="oracleHome@osmSitemapBean@servletRequest"/>
                                </oem:license>
                              </uix:rowLayout>

                              <%-- Alert Log --%>
                              <uix:rowLayout rendered="swbHomeLinkNotRendered@servletRequest">
                                <uix:cellFormat hAlign="right">
                                  <uix:styledText styleClass="OraPromptText"
                                                  textBinding="ALERT_LOG@dbMsgs" />
                                </uix:cellFormat>
                                <uix:spacer width="1"/>
                                <uix:switcher childNameBinding="alertLogCountIsAvail@osmSitemapBean@servletRequest">
                                  <uix:case name="true">
                                    <uix:styledText styleClass="OraDataText"
                                                    textBinding="alertLogCount@osmSitemapBean@servletRequest" />
                                  </uix:case>
                                  <uix:case name="false">
                                    <uix:link textBinding="alertLogCount@osmSitemapBean@servletRequest"
                                              destinationBinding="alertLogLink@servletRequest" />
                                  </uix:case>
                                </uix:switcher>
                              </uix:rowLayout>

                            </uix:tableLayout>
                            </uix:rowLayout>
                          </uix:default> <!-- Normal -->
                        </uix:switcher>

                      </uix:stackLayout>
                    </uix:cellFormat>
                  </uix:rowLayout> <!-- traffic light -->

                </uix:header>

               <uix:switcher childNameBinding="showNormal@osmSitemapBean@servletRequest">
               <uix:case name="true">
                <%-- Diagnostic Summary --%>
                <uix:header textBinding="DIAGNOSTIC_SUMMARY@dbMsgs"
                            renderedBinding="swbHomeLinkRendered@servletRequest">
                  <uix:tableLayout>

                    <%-- Alert Log --%>
                    <uix:rowLayout>
                     <uix:cellFormat hAlign="right">
                      <uix:styledText styleClass="OraPromptText"
                                      textBinding="ALERT_LOG@dbMsgs" />
                     </uix:cellFormat>
                      <uix:spacer width="1"/>
                     <uix:switcher childNameBinding="alertLogCountIsAvail@osmSitemapBean@servletRequest">
                     <uix:case name="true">
                      <uix:styledText styleClass="OraDataText"
                                      textBinding="alertLogCount@osmSitemapBean@servletRequest" />
                     </uix:case>
                     <uix:case name="false">
                      <uix:link textBinding="alertLogCount@osmSitemapBean@servletRequest"
                                destinationBinding="alertLogLink@servletRequest" />
                     </uix:case>
                     </uix:switcher>
                    </uix:rowLayout>

                    <%-- Active Incidents --%>
                    <uix:rowLayout vAlign="center">
                     <uix:cellFormat hAlign="right">
                      <uix:styledText styleClass="OraPromptText"
                                      textBinding="ACTIVE_INCIDENTS@dbMsgs" />
                     </uix:cellFormat>
                     <uix:cellFormat width="40" hAlign="center">
                      <uix:image sourceBinding="activeIncidentsSeverityImage@osmSitemapBean@servletRequest"
                                 shortDescBinding="activeIncidentsSeverityShortDesc@osmSitemapBean@servletRequest" />
                     </uix:cellFormat>
                      <uix:link textBinding="activeIncidentCount@osmSitemapBean@servletRequest"
                                destinationBinding="swbHomeLink@servletRequest" />
                    </uix:rowLayout>

                  </uix:tableLayout>
                </uix:header> <!-- Diagnostic Summary -->
               </uix:case>
               </uix:switcher> <!-- Normal -->

              </uix:stackLayout>
            </uix:cellFormat>

            <!-- ...................  Disk group usage .................. -->

            <uix:cellFormat vAlign="top" width="50%" >
              <uix:stackLayout>
              
                  <uix:rowLayout renderedBinding="showNormal@osmSitemapBean@servletRequest">

                  <oem:chart titleBinding="DISKGROUP_USAGE_IN_GB@OsmObjectBundle@servletRequest"
                      chartTypeBinding="chartType@osmSitemapBean@servletRequest"
                      orientation="horizontal"
                      width="400"
                      height="200"
                      shadowEffect="3d"
                      stacked="true"
                      xAxisLabelBinding = "SIZE_GB@OsmObjectBundle@servletRequest"
                      pieSlicesFromColumn="true"
                      pieValuesInLegend="value"
                      yAxisNumberFormatBinding="pieChartLegendFormat@servletRequest"
                      showSlicePercentLabels="true"
                      >
                      <uix:contents>
                        <oem:boundChartDataSource
                              chartDataSourceBinding="chartDS@servletRequest"
                              />
                        <oem:imageMap imageMapItemsBinding="imgMapItems@servletRequest"/>
                        <oem:chartColumn
                          displayLabel="DiskGroup"
                          sourceIndex="0"
                          isKey="true"
                          />

                        <%
                          String[] cols = (String[]) request.getAttribute("sizeCol");
                          String[] colIndexes = (String[]) request.getAttribute("colIndexes");
                          for(int i=0; i < cols.length; i++)
                          {
                        %>
                        <oem:chartColumn
                          displayLabel="<%=cols[i]%>"
                          sourceIndex="<%=colIndexes[i]%>"
                          />
                        <%
                        }
                        %>
                      </uix:contents>
                  </oem:chart>
                  </uix:rowLayout>
               </uix:stackLayout>
            </uix:cellFormat>
          </uix:rowLayout>
        </uix:tableLayout>

       <uix:header textBinding="SERVICED_DBS@OsmObjectBundle@servletRequest"
                   renderedBinding="showNormal@osmSitemapBean@servletRequest">
          <uix:tableLayout width="100%" >
              <uix:rowLayout vAlign="top">

                <oem:table summaryBinding="SERVICED_DBS@OsmObjectBundle@servletRequest"
			   name="servicedDBsTableUI"
                           partialRenderMode="self"
                           id="servicedDBs"
                           alternateTextBinding="NO_SERVICED_DBS@OsmObjectBundle@servletRequest"
                           width="100%"
                           dataSourceProp="servicedDBsTableUI"
                           beanKey="osmSitemapBean"
                           formSubmitted="true"
                           blockSize="5">
                  </oem:table>

              </uix:rowLayout>
            </uix:tableLayout>
        </uix:header>
       
          <uix:tableLayout width="100%" >
              <uix:rowLayout vAlign="top">

              <%-- ........... Serviced Oracle File Systems ............... --%>
              <uix:dataScope currentDataBinding="servicedOfsTableUI@osmSitemapBean@servletRequest"
                             renderedBinding="showOfs@servletRequest">
                <uix:header textBinding="SERVICED_OFS@ofsMsg">
                  <uix:tableLayout width="100%"> 
                    <uix:rowLayout>
                      <uix:table summaryBinding="SERVICED_OFS@ofsMsg" 
		      		                   width="100%" 
                                 formSubmitted="true"
                                 id="servicedOfsTableUI"
                                 tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                 valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                 maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                                 blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>"
                                 partialRenderMode="self"
                                 showAll="yes"
                                 alternateTextBinding="NO_OFS@ofsMsg">
      
                        <uix:tableFormat tableBanding="rowBanding"/>
                    
                        <%--  disable mount/dismount options for now ...
                        <uix:tableSelection>
                          <uix:singleSelection shortDescBinding="SELECT@osmMsg"
                                               selectedBinding="<%= UIXDataSource.S_SELECT_ATTR %>">
                            <uix:pageButtonBar>
                              <uix:submitButton textBinding="MOUNT@ofsMsg"
                                                shortDescBinding="MOUNT_OFS_DESC@ofsMsg"
                                                name="event"
                                                value="<%= Constant.EVENT_MOUNT_OFS %>"/>
                              <uix:submitButton textBinding="DISMOUNT@ofsMsg"
                                                shortDescBinding="DISMOUNT_OFS_DESC@ofsMsg"
                                                name="event"
                                                value="<%= Constant.EVENT_DISMOUNT_OFS %>"/>
                            </uix:pageButtonBar>
                          </uix:singleSelection>
                        </uix:tableSelection>
                        --%>

                        <%-- Mount Point --%>
                        <uix:column>
                          <uix:columnHeader>
                            <uix:sortableHeader textBinding="MOUNT_POINT@ofsMsg"
                                                sortableBinding="<%= ServicedOFSsDataSource.S_SORT_MPT_COL %>" />
                          </uix:columnHeader>
                          <uix:columnFormat columnDataFormat="textFormat"/>
                            <uix:link textBinding="<%= ServicedOFSsDataSource.S_MPT_COL %>"
                                      destinationBinding="<%= ServicedOFSsDataSource.S_MOUNT_POINT_DEST %>"/>
                        </uix:column>

                        <%-- Availability --%>
                        <uix:column>
                          <uix:columnHeader>
                            <uix:sortableHeader textBinding="AVAILABILITY@ofsMsg"
                                                sortableBinding="<%= ServicedOFSsDataSource.S_SORT_AVAIL_COL%>">
                            </uix:sortableHeader>
                          </uix:columnHeader>
                          <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                          <%-- uix:styledText textBinding="<%= ServicedOFSsDataSource.S_AVAIL_COL%>"/--%>
                          <uix:switcher childNameBinding="<%= ServicedOFSsDataSource.S_AVAIL_COL%>">
                            <uix:case name="AVAILABLE"> 
                              <uix:image source="<%= request.getContextPath()+\"/images/up_active.gif\"%>" shortDescBinding="UP@ofsMsg"/>
                            </uix:case> 
                            <uix:case name=" "> 
                              <uix:image source="<%= request.getContextPath()+\"/images/down_active.gif\"%>" shortDescBinding="DOWN@ofsMsg"/>
                            </uix:case> 
                          </uix:switcher> 
                        </uix:column>
          
                        <%-- State column --%>
                        <uix:column>
                          <uix:columnHeader>
                            <uix:sortableHeader textBinding="STATE@ofsMsg"
                                                sortableBinding="<%= ServicedOFSsDataSource.S_SORT_STATE_COL %>" />
                          </uix:columnHeader>
                          <uix:columnFormat columnDataFormat="textFormat"/>
                          <uix:styledText textBinding="<%= ServicedOFSsDataSource.S_STATE_COL %>"/>
                        </uix:column>

                        <%-- Used Pct column --%>
                        <uix:column>
                          <uix:columnHeader>
                            <uix:sortableHeader textBinding="USED_PERCENTAGE@ofsMsg"
                                                sortableBinding="<%= ServicedOFSsDataSource.S_SORT_USED_PCT_COL %>" />
                          </uix:columnHeader>
                          <uix:columnFormat columnDataFormat="textFormat"/>
                          <uix:flowLayout>
                            <uix:contents>
                              <uix:include nodeBinding="<%= ServicedOFSsDataSource.S_USED_PCT_COL_IMG %>"/>
                              <uix:styledText textBinding="<%= ServicedOFSsDataSource.S_USED_PCT_COL %>"/>
                            </uix:contents>
                          </uix:flowLayout>
                        </uix:column>

                        <%-- Used GB column --%>
                        <uix:column>
                          <uix:columnHeader>
                            <uix:sortableHeader textBinding="USED_GB@ofsMsg"
                                                sortableBinding="<%= ServicedOFSsDataSource.S_SORT_USED_GB_COL %>" />
                          </uix:columnHeader>
                          <uix:columnFormat columnDataFormat="numberFormat"/>
                          <uix:styledText textBinding="<%= ServicedOFSsDataSource.S_USED_GB_COL %>"/>
                        </uix:column>

                        <%-- Size GB column --%>
                        <uix:column>
                          <uix:columnHeader>
                            <uix:sortableHeader textBinding="SIZE_GB@ofsMsg"
                                                sortableBinding="<%= ServicedOFSsDataSource.S_SORT_SIZE_GB_COL %>" />
                          </uix:columnHeader>
                          <uix:columnFormat columnDataFormat="numberFormat"/>
                          <uix:styledText textBinding="<%= ServicedOFSsDataSource.S_SIZE_GB_COL %>"/>
                        </uix:column>

                        <%-- Diskgroup Allocated Size GB column --%>
                        <uix:column>
                          <uix:columnHeader>
                            <uix:sortableHeader textBinding="DG_ALLOC_SPACE_GB@ofsMsg"
                                                sortableBinding="<%= ServicedOFSsDataSource.S_SORT_DG_ALLOC_GB_COL %>" />
                          </uix:columnHeader>
                          <uix:columnFormat columnDataFormat="numberFormat"/>
                          <uix:styledText textBinding="<%= ServicedOFSsDataSource.S_DG_ALLOC_GB_COL %>"/>
                        </uix:column>

                        <%-- Volume column --%>
                        <uix:column>
                          <uix:columnHeader>
                            <uix:sortableHeader textBinding="VOLUME@ofsMsg"
                                                sortableBinding="<%= ServicedOFSsDataSource.S_SORT_VOL_COL %>" />
                          </uix:columnHeader>
                          <uix:columnFormat columnDataFormat="textFormat"/>
                          <uix:link textBinding="<%= ServicedOFSsDataSource.S_VOL_COL %>"
                                    destinationBinding="<%= ServicedOFSsDataSource.S_VOLUME_DEST %>"/>
                        </uix:column>

                        <%-- Disk Group column --%>
                        <uix:column>
                          <uix:columnHeader>
                            <uix:sortableHeader textBinding="DISK_GROUP@ofsMsg"
                                                sortableBinding="<%= ServicedOFSsDataSource.S_SORT_DISKGROUP_COL %>" />
                          </uix:columnHeader>
                          <uix:columnFormat columnDataFormat="textFormat"/>
                          <uix:link textBinding="<%= ServicedOFSsDataSource.S_DISKGROUP_COL %>"
                                    destinationBinding="<%= ServicedOFSsDataSource.S_DISKGROUP_DEST %>"/>
                        </uix:column>

                    </uix:table>
                  </uix:rowLayout>
                </uix:tableLayout>
              </uix:header>
            </uix:dataScope>
          </uix:rowLayout>
        </uix:tableLayout>


        <%-- ..... Other Volumes Info ..... --%>
        <uix:dataScope currentDataBinding="otherVolumeTableUI@osmSitemapBean@servletRequest">
          <uix:header textBinding="OTHER_VOLUMES@ofsMsg"
                      renderedBinding="showOfs@servletRequest">
            <uix:tableLayout width="100%"> 
              <uix:rowLayout>
                <uix:table summaryBinding="OTHER_VOLUMES@ofsMsg" 
		      		             width="100%" 
                           formSubmitted="true"
                           id="otherVolumeTableUI"
                           tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                           valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                           maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                           blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>"
                           partialRenderMode="self"
                           showAll="yes"
                           alternateTextBinding="NO_OBJECT_FOUND@ofsMsg">
      
                  <uix:tableFormat tableBanding="rowBanding"/>
                    
                  <%-- Volume column --%>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="VOLUME@ofsMsg"
                                          sortableBinding="<%= OtherVolumeDataSource.S_SORT_VOL_COL %>" />
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="textFormat"/>
                    <uix:link textBinding="<%= OtherVolumeDataSource.S_VOL_COL %>"
                              destinationBinding="<%= OtherVolumeDataSource.S_VOLUME_DEST %>"/>
                  </uix:column>

                  <%-- Volume Device column --%>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="VOLUME_DEVICE@ofsMsg"
                                          sortableBinding="<%= OtherVolumeDataSource.S_SORT_VOLDEV_COL %>" />
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="textFormat"/>
                    <uix:styledText textBinding="<%= OtherVolumeDataSource.S_VOLDEV_COL%>"/>
                  </uix:column>

                  <%-- Volume Usage column --%>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="USAGE@ofsMsg"
                                          sortableBinding="<%= OtherVolumeDataSource.S_SORT_VOLUSAGE_COL %>" />
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="textFormat"/>
                    <uix:styledText textBinding="<%= OtherVolumeDataSource.S_VOLUSAGE_COL%>"/>
                  </uix:column>

                  <%-- State column --%>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="STATE@ofsMsg"
                                          sortableBinding="<%= OtherVolumeDataSource.S_SORT_STATE_COL %>" />
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="textFormat"/>
                    <uix:styledText textBinding="<%= OtherVolumeDataSource.S_STATE_COL %>"/>
                  </uix:column>

                  <%-- Disk Group column --%>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="DISK_GROUP@ofsMsg"
                                          sortableBinding="<%= OtherVolumeDataSource.S_SORT_DISKGROUP_COL %>" />
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="textFormat"/>
                    <uix:link textBinding="<%= OtherVolumeDataSource.S_DISKGROUP_COL %>"
                              destinationBinding="<%= OtherVolumeDataSource.S_DISKGROUP_DEST %>"/>
                  </uix:column>

                  <%-- Size (GB) column --%>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="SIZE_GB@ofsMsg"
                                          sortableBinding="<%= OtherVolumeDataSource.S_SORT_SIZE_GB_COL%>" />
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="numberFormat"/>
                    <uix:styledText textBinding="<%= OtherVolumeDataSource.S_SIZE_GB_COL %>"/>
                  </uix:column>

                  <%-- Allocated Size (GB) column --%>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="DG_ALLOC_SPACE_GB@ofsMsg"
                                          sortableBinding="<%= OtherVolumeDataSource.S_SORT_DG_ALLOC_SIZE_GB_COL%>" />
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="numberFormat"/>
                    <uix:styledText textBinding="<%= OtherVolumeDataSource.S_DG_ALLOC_SIZE_COL%>"/>
                  </uix:column>

                  <%-- Redundancy column --%>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="REDUNDANCY@ofsMsg"
                                          sortableBinding="<%= OtherVolumeDataSource.S_SORT_REDUNDANCY_COL %>" />
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="textFormat"/>
                    <uix:styledText textBinding="<%= OtherVolumeDataSource.S_REDUNDANCY_COL %>"/>
                  </uix:column>
                </uix:table>
              </uix:rowLayout>
            </uix:tableLayout>
          </uix:header>
        </uix:dataScope>

       <uix:header textBinding="ALERTS_HEADER@dbMsgs"
        renderedBinding="showNormal@osmSitemapBean@servletRequest">
          <uix:tableLayout width="100%" >
              <uix:rowLayout vAlign="top">

                <oem:table summaryBinding="ALERTS_HEADER@dbMsgs"
			   name="alertsUIDataSource"
                           partialRenderMode="self"
                           id="alertsTable"
                           alternateTextBinding="NO_ALERTS_ALT@SDKBundle@servletRequest"
                           width="100%"
                           dataSourceProp="alertsUIDataSource"
                           beanKey="osmSitemapBean"
                           formSubmitted="true"
                           blockSize="5">
                  </oem:table>

              </uix:rowLayout>
            </uix:tableLayout>
        </uix:header>

      <%-- host alerts header --%>
       <%-- <uix:header textBinding="HOST_ALERTS_HEADER@SDKBundle@servletRequest" --%>
       <uix:header textBinding="21@SDKBundle@servletRequest"
        renderedBinding="showNormal@osmSitemapBean@servletRequest">
          <uix:tableLayout width="100%" >
              <uix:rowLayout vAlign="top">

                <oem:table summaryBinding="21@SDKBundle@servletRequest"
			   name="relatedAlertsUIDataSource"
                           partialRenderMode="self"
                           id="relatedAlertsTable"
                           width="100%"
                           alternateTextBinding="NO_ALERTS_ALT@SDKBundle@servletRequest"
                           dataSourceProp="relatedAlertsUIDataSource"
                           beanKey="osmSitemapBean"
                           formSubmitted="true"
                           blockSize="5">
                  </oem:table>

              </uix:rowLayout>
            </uix:tableLayout>
        </uix:header>

     <%-- New policies section integration --%>
     <uix:switcher childNameBinding="showNormal@osmSitemapBean@servletRequest">
       <uix:case name="true">
        <uix:include nodeBinding="policyNode@servletRequest"/>       
       </uix:case>
     </uix:switcher>
    </uix:subTabLayout>
    <uix:tableLayout renderedBinding="renderRelatedLinks@osmSitemapBean@servletRequest">
      <oem:relatedLinks />
    </uix:tableLayout>
      </uix:header>
      <uix:spacer height="5"/>

     </db:form>
    </uix:pageLayout>
    </uix:body>


  </uix:document>
</uix:renderingContext>

