<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.inst.DBMsg"/>
  <uix:bundle name="dbObjMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:bundle name="osmMsgs" class="oracle.sysman.db.rsc.osm.OsmObjectMsg"/>
  <uix:bundle name="ofsMsg" class="oracle.sysman.db.rsc.osm.ofs.OfsObjectMsg" />
  <uix:document>

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <uix:pageLayout>
    <%@ include file="/database/global.jspf" %>

    <uix:form name="osmUsers" method="get" destinationBinding="defaultURL@servletRequest">
      <uix:header textBinding="header@servletRequest"/>
      <uix:formValue name="pageName" value="/database/osm/osmUsers"/>

         <uix:subTabLayout>
            <uix:subTabs>
              <uix:switcher childNameBinding="enterpriseMode@servletRequest">
              <uix:case name="true">            
              <uix:subTabBar selectedIndex="4">
                  <uix:link textBinding="HOME@dbMsgs"
                     destinationBinding="sitemapDest@servletRequest"/>
                  <oem:license>
                  <uix:link textBinding="PERFORMANCE_HEADER@dbMsgs"
                     destinationBinding="healthDest@servletRequest"/>                                
                  </oem:license>
                  <uix:link textBinding="DISKGROUPS@osmMsgs"
                     destinationBinding="adminDest@servletRequest"/>
                  <uix:link textBinding="CONFIGURATION@dbMsgs"
                     destinationBinding="configDest@servletRequest"/>
                  <uix:link textBinding="USERS@osmMsgs"/>
                  <uix:link textBinding="ORACLE_FILE_SYSTEM@ofsMsg" renderedBinding="showOfs@servletRequest"
                     destinationBinding="ofsDest@servletRequest"/>
              </uix:subTabBar>
              </uix:case>
              
              <uix:case name="false">
              <uix:subTabBar selectedIndex="1">              
                  <uix:link textBinding="ADMINISTRATION@dbMsgs"
                     destinationBinding="adminDest@servletRequest"/>
                  <uix:link textBinding="CONFIGURATION@dbMsgs"/>
              </uix:subTabBar>                  
              </uix:case>
              </uix:switcher>
              
            </uix:subTabs>
        
        <oem:messageBox messageType="info" 
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error" 
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>

        <%-- ASM access warning message --%>
        <jsp:include page="/database/osm/asmAccessWarningInclude.jsp" />
        <uix:ref refID="asmAccessWarningInclude"/>


        
        <!-- ACL -->
        <uix:tableLayout width="100%">
         <uix:rowLayout >
          <uix:spacer width="5"/>
         </uix:rowLayout>
         <uix:rowLayout >
           <uix:messagePrompt promptBinding="USERS_DESC@osmMsgs"/>
         </uix:rowLayout>
         <uix:rowLayout >
          <uix:spacer width="5"/>
         </uix:rowLayout>
         <uix:rowLayout hAlign="right">
           <uix:pageButtonBar>
             <uix:submitButton textBinding="CREATE@dbObjMsgs"
                               name="event" 
                               value="createUser"
                               disabledBinding="disableNonSysAsmOp@servletRequest"/>
           </uix:pageButtonBar>
         </uix:rowLayout>
         <uix:rowLayout >
          <uix:spacer width="5"/>
         </uix:rowLayout>

         <uix:rowLayout>
           <uix:dataScope currentDataBinding="osmUsersDS@usersAdminBean@servletRequest">

             <uix:table id="osmUsersDS" 
                            alternateTextBinding="NO_ITEMS_FOUND@dbObjMsgs" 
                            formSubmitted="true" width="100%" 
                            tableDataBinding="rowData" 
                            minValue="1" 
                            valueBinding="startIndex"
                            maxValueBinding="numRows" 
                            blockSizeBinding="blockSize"
                            summaryBinding="USERS_SUMMARY@osmMsgs">
               <uix:tableFormat tableBanding="rowBanding"/>
               <uix:tableSelection>
               <%--
                 <uix:singleSelection 
                            shortDescBinding="SELECT@dbObjMsgs" 
                            selectedBinding="select">
                            --%>
                 <uix:multipleSelection shortDescBinding="SELECT@dbObjMsgs"
                                        selectedBinding="select">
                   <uix:pageButtonBar>
                     <uix:submitButton textBinding="EDIT@osmMsgs" 
                                       name="event" 
                                       value="editUser" />
                     <uix:submitButton textBinding="DELETE@osmMsgs" 
                                       name="event" 
                                       value="deleteUser"
                                       disabledBinding="disableNonSysAsmOp@servletRequest"/>
                   </uix:pageButtonBar>
                 </uix:multipleSelection>
               </uix:tableSelection>

               <uix:column>
                 <uix:columnHeader>
                   <uix:sortableHeader textBinding="USER_NAME@osmMsgs" 
                                       sortableBinding="sortUser"/>
                 </uix:columnHeader>
                 <uix:columnFormat columnDataFormat="textFormat"/>
                 <uix:text textBinding="user"/>
               </uix:column>

               <uix:column>
                 <uix:columnHeader>
                   <uix:sortableHeader textBinding="PRIVILEGES@osmMsgs" 
                                       sortableBinding="sortPrivilege"/>
                 </uix:columnHeader>
                 <uix:columnFormat columnDataFormat="textFormat"/>
                 <uix:text textBinding="privilege"/>
              </uix:column>
            </uix:table>
          </uix:dataScope>
        </uix:rowLayout>
      </uix:tableLayout>
      <!-- ACL complete -->

      <uix:spacer width="8"/>
            
   </uix:subTabLayout>
    <uix:tableLayout>
      <oem:relatedLinks />
    </uix:tableLayout>

  </uix:form>
  </uix:pageLayout>        
  </uix:body>
  </uix:document>
</uix:renderingContext>
