<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>

<%@ page import="oracle.sysman.emo.adm.osm.OsmConst"%>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="osmMsgs" 
              class="oracle.sysman.db.rsc.osm.OsmObjectMsg"/>
  <uix:bundle name="dbMsgs" 
              class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:bundle name="credsMsgs" 
              class="oracle.sysman.resources.eml.creds.PrefCredsMsg"/>
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <%-- HTML Page Title --%>
 <%--   <uix:metaContainer>
      <uix:head titleBinding="title@defaultBean@servletRequest"/>
    </uix:metaContainer>
--%>
    <uix:body>
    <uix:form
      name="asmOSUserForm"
      method="post"
      destinationBinding="defaultURL@servletRequest">
      <uix:formValue name="pageName" value="/database/osm/removeOsUser"/>
            <uix:formValue name="optionChoice"
                     valueBinding="optionChoice@servletRequest"/>
    <uix:pageLayout titleBinding="REMOVE_USER@osmMsgs">
      <%@ include file="/database/global.jspf" %>

        <oem:messageBox messageType="info"
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageTypeBinding="messageType@servletRequest"
                        errorTableBinding="msgBox@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
             
             <uix:rowLayout hAlign="center">
  
              <uix:spacer width="10"/>
              <uix:messagePrompt 
                              promptBinding="addHeader@defaultBean@servletRequest"/>
             </uix:rowLayout> 
             
             <uix:header text="">
              <uix:rowLayout>
                <uix:spacer width="10"/>
                <uix:tableLayout width="100%">
            
                  <uix:rowLayout>
                   <uix:messagePrompt 
                                  promptBinding="REMOVE_USER_INSTR@OsmObjectBundle@servletRequest"/>
                  </uix:rowLayout>
                  
                  <uix:rowLayout>
                   <uix:spacer height="15"/>
                  </uix:rowLayout>
                  
                   <uix:rowLayout >
                       <uix:shuttle name="users" 
                                    leadingHeaderBinding="AVAILABLE_USERS@OsmObjectBundle@servletRequest"
                                    trailingHeaderBinding="SELECTED_USERS@OsmObjectBundle@servletRequest" 
                                    reorderable="false">
                         <uix:leading >
                           <uix:list name="availableUsers"
				     multiple="true"
				     shortDescBinding="AVAILABLE_USERS@OsmObjectBundle@servletRequest">
                             <uix:contents childDataBinding="availableUsers@asmSystemUser@servletRequest">
                               <uix:option textBinding="text"
                                           valueBinding="value"/>
                             </uix:contents>
                           </uix:list>
                         </uix:leading>
                         <uix:trailing >
                           <uix:list name="selectedUsers"
				     multiple="true"
				     shortDescBinding="SELECTED_USERS@OsmObjectBundle@servletRequest">
                             <uix:contents childDataBinding="selectedUsers@asmSystemUser@servletRequest">
                               <uix:option textBinding="text"
                                           valueBinding="value"/>
                             </uix:contents>
                           </uix:list>
                         </uix:trailing>
                       </uix:shuttle>
                      </uix:rowLayout>
                  
               </uix:tableLayout>
               </uix:rowLayout>

              </uix:header>
              
       <uix:pageButtons>
          <uix:pageButtonBar>

            <uix:submitButton name="event"
                              textBinding="SHOWSQL@uixDBObjectBundle@servletRequest"
                              value="showSql"/>
            <uix:button   textBinding="CANCEL@uixDBObjectBundle@servletRequest"
                          destinationBinding="cancelURL@servletRequest"/>
            <uix:submitButton
              name="event"
              textBinding="OK@uixDBObjectBundle@servletRequest"
              value="apply"/>
          </uix:pageButtonBar>
         </uix:pageButtons>
    </uix:pageLayout>
    </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
  
