<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        samplePage.jsp
  -- Controller:  db/adm/schm/SampleController.java
  --
  -- Description: Short Description of the page.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<uix:renderingContext id="renderingContext">

<%-- Message Bundles --%>
<uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="osmMsgs" class="oracle.sysman.db.rsc.osm.OsmObjectMsg"/>

<oem:setURLEncoder id="renderingContext"/>
<uix:document>
  
<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="OEM_SHOW_CMD@osmMsgs"/>
</uix:metaContainer>
<NOSCRIPT>
A browser with Javascript enabled is required for this page to operate properly.
</NOSCRIPT>

<uix:body>

<%-- HTML Form --%>
<uix:form name="foo" method="post" destinationBinding="backURL@servletRequest">
<uix:pageLayout titleBinding="SHOWCMD@dbMsgs">
  <uix:formValue name="id" valueBinding="id@servletRequest"/>

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

    <%-- START: TAB CONTENTS starts here --%>
      <uix:stackLayout>
        <% 
          if (request.getAttribute("remoteOperationBean") == null) {
        %> 
          <db:sqlDisplay  sqlListBinding="cmdList@servletRequest"/>
        <% } else { %>
          <db:sqlDisplay  sqlListBinding="cmdList@remoteOperationBean@servletRequest"/> 
        <% } %>
      </uix:stackLayout>

    <%-- END: TAB CONTENTS ends here --%>   

  <%-- Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
     <uix:submitButton 
        name="launchExecuteCmd" 
        value="clicked" 
        textBinding="EXECUTE_CMD@osmMsgs"
        shortDescBinding="EXECUTE_CMD@osmMsgs"/>
        <%-- renderedBinding="launchExecuteSQLRendered@mainEmoBean@servletRequest"/ --%>
     <uix:submitButton
        name="doSubmitJob" 
        textBinding="SCHEDULE_JOB@dbMsgs"
        shortDescBinding="SCHEDULE_JOB@dbMsgs"
        value="submitJob"/>
     <uix:submitButton name="ok" 
        textBinding="RETURN@dbMsgs" 
        shortDescBinding="RETURN@dbMsgs" 
        destinationBinding="backURL@servletRequest"/>
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</uix:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




