<%--
  -- Page:       subTabsInclude.jsp
  -- Controller: oracle.sysman.db.adm.osm.DiskGroupController
  --
  -- Description: ASM disk group home page tabs
  --
  --  MODIFIED    (MM/DD/YY)
  --   dchakumk    03/10/08 - XbranchMerge dchakumk_6752_xbmsrc from
  --                          st_emdbsa_11.1
  --   asubba      04/05/07 - change group tab to access control
  --   gmahaney    02/01/07 - XbranchMerge gmahaney_emdb_pt_main from main
  --   qsong       01/02/07 - hide volumes tab if connect through db
  --   asubba      12/28/06 - 
  --   evelur      03/09/06 - Adding the Volume tab as part of the USM 
  --                          incorporation 
  --   qsong       06/16/06 - 
  --   chanchan    10/18/04 - Add ASM licensing 
  --   jochen      06/04/04 - jochen_delete
  --   jochen      04/09/04 - Initial entry
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:buildTree nodeID="subTabsInclude">

<uix:dataScope>

  <%-- Message Bundle --%>
  <uix:bundle name="DBMsgs"
              class="oracle.sysman.db.rsc.inst.DBMsg"/>

  <uix:subTabBar selectedIndexBinding="selectedTab@servletRequest">
    <uix:contents>
      <uix:link textBinding="GENERAL@DBMsgs"
         destinationBinding="disksDest@servletRequest"/>
     <oem:license>
      <uix:link textBinding="PERFORMANCE@OsmObjectBundle@servletRequest"
              destinationBinding="performanceDest@servletRequest"
              renderedBinding="showPerformanceTab@servletRequest"/>
     </oem:license>
      <uix:link textBinding="TEMPLATES@OsmObjectBundle@servletRequest"
              destinationBinding="templatesDest@servletRequest"/>
      <uix:link textBinding="FILES@OsmObjectBundle@servletRequest"
              destinationBinding="filesDest@servletRequest"/>
      <uix:link textBinding="ACCESS_CONTROL@OsmObjectBundle@servletRequest"
              destinationBinding="groupsDest@servletRequest"
              renderedBinding="displayGroup@servletRequest"/>
     <uix:link textBinding="VOLUMES@OsmObjectBundle@servletRequest"
              destinationBinding="volumesDest@servletRequest"
              renderedBinding="showVolumesTab@servletRequest"/>
    </uix:contents>
  </uix:subTabBar>

</uix:dataScope>
</uix:buildTree>

