<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>
    
    <uix:body>
    <uix:form
      name="editDGForm" 
      method="GET"
      destinationBinding="defaultURL@servletRequest">

      <uix:formValue 
        name="pageName" 
        value="/database/osm/templates"/>

      <uix:pageLayout>

        <%@ include file="/database/global.jspf" %>

        <oem:messageBox messageType="info" 
                        errorTableBinding="confirmation@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error" 
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>

        <uix:header
          textBinding="header@diskGrp@servletRequest"
          >

          <uix:subTabLayout>

            <uix:subTabs>
             <jsp:include page="/database/osm/subTabsInclude.jsp" />
              <uix:ref refID="subTabsInclude" /> 
            </uix:subTabs>

            <%-- ASM access warning message --%>
            <jsp:include page="/database/osm/asmAccessWarningInclude.jsp" />
            <uix:ref refID="asmAccessWarningInclude"/>

       <%-- ASM Rolling Migration Info --%>
       <uix:switcher childNameBinding="rollingMigrationStatus@diskGrp@servletRequest">
            <uix:case name="true">
              <uix:rowLayout>
                <uix:spacer height="5"/>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat width="15"/>
                <uix:image source="/em/images/infoicon_active.gif"/>
                <uix:cellFormat width="5"/>
                <uix:styledText styleClass="OraPromptText" textBinding="ROLLING_MIGRATION_PERF_MESSAGE@OsmObjectBundle@servletRequest"/>
              </uix:rowLayout>
            </uix:case> 
          </uix:switcher>

              <uix:tableLayout width="80%"> 
                <uix:rowLayout hAlign="right"> 
                  <uix:cellFormat> 
                    <uix:contents> 
                      <uix:submitButton 
                        textBinding="CREATE@uixDBObjectBundle@servletRequest"
                        name="event"
                        value="createTemplate" 
                        disabledBinding="disableTemplateOps@servletRequest"
                        formName="editDGForm"
                      />
                    </uix:contents> 
                  </uix:cellFormat> 
                </uix:rowLayout> 
              </uix:tableLayout> 
            

             <oem:table copyParams="target,type"
                    summaryBinding="TEMPLATES@OsmObjectBundle@servletRequest"
		    width="80%" 
                    blockSize="25"
                    formSubmitted="true"
                    name="memberTemplatesTableUI" 
                    dataSourceProp="memberTemplatesTableUI"
                    beanKey="diskGrp"
                    alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest"
                    >
              <uix:tableSelection> 
                    <uix:singleSelection shortDescBinding="SELECT@uixDBObjectBundle@servletRequest" selectedIndex="0">
                      <uix:submitButton textBinding="EDIT@uixDBObjectBundle@servletRequest" 
                                        name="event" 
                                        value="editTemplate"
                                        disabledBinding="disableTemplateOps@servletRequest"/>
                      <uix:submitButton textBinding="DELETE@uixDBObjectBundle@servletRequest" 
                                        name="event" 
                                        value="deleteTemplate"
                                        disabledBinding="disableTemplateOps@servletRequest"/>
                    </uix:singleSelection>
               </uix:tableSelection> 
              
            </oem:table>           
         </uix:subTabLayout>

        </uix:header>

      </uix:pageLayout>
    </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>

