
<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>


<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>

<%-- Message Bundles --%>
  <uix:bundle name="dbObjMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:bundle name="osmMsgs"   class="oracle.sysman.db.rsc.osm.OsmObjectMsg"/>

  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

    <%@ include file="/enablePPR.jspf" %>

    <uix:body>
    <uix:form name="editDGForm"
              method="POST"
              destinationBinding="defaultURL@servletRequest">

      <uix:formValue name="pageName"
                     value="/database/osm/userGroups"/>
		     
      <uix:formValue name="licenseMemberDisk"
                     valueBinding="licenseMemberDisk@servletRequest"/>

      <uix:pageLayout titleBinding="header@userGroups@servletRequest">

        <%@ include file="/database/global.jspf" %>

          <oem:messageBox messageType="info"
                          errorTableBinding="info@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error"
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>

          <%--                                                          --%>
          <%-- Support pageMsgBox for any apps that return to this page --%>
          <%-- and support it.  This include must be positioned AFTER   --%>
          <%-- any other uix:messages or messageBox tags.               --%>
          <%--                                                          --%>
          <%@ include file="/sdk/page/pageMsgBox.jspf" %>

        <uix:subTabLayout>

          <%-- SubTabs --%>
          <uix:subTabs>
            <jsp:include page="/database/osm/subTabsInclude.jsp" />
            <uix:ref refID="subTabsInclude" />
          </uix:subTabs>
          
          <%-- ASM access warning message --%>
          <jsp:include page="/database/osm/asmAccessWarningInclude.jsp" />
          <uix:ref refID="asmAccessWarningInclude"/>
          
          
           
        <!--OS User -->
        <uix:header textBinding="USERS@osmMsgs">
        <uix:rowLayout >
          <uix:spacer width="5"/>
          </uix:rowLayout>
        <uix:rowLayout>
         <uix:spacer width="8"/>
            <uix:messagePrompt promptBinding="ACCESS_CONTROL_USER_INSTR@osmMsgs"/>
         </uix:rowLayout>
         <uix:rowLayout>
            <uix:spacer height="20"/>
         </uix:rowLayout>
         <uix:rowLayout>
           <uix:spacer width="8"/>
           <uix:tableLayout>
            <uix:rowLayout>
              <uix:cellFormat>
                <uix:messagePrompt promptBinding="CURRENT_USERS@osmMsgs" />
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:spacer width="10"/>
               <uix:styledText styleClass="OraDataText" textBinding="currentUsers@userGroups@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout>
                <uix:spacer width="8"/>
            </uix:rowLayout>
            <uix:rowLayout>
              <uix:cellFormat/>
              <uix:cellFormat>
                <uix:pageButtonBar>
                 <uix:submitButton textBinding="ADD@dbObjMsgs"
                       name="event" 
                       value="add"
                        disabledBinding="disableGroupOp@servletRequest"/>
                 <uix:submitButton textBinding="REMOVE@dbObjMsgs"
                       name="event" 
                       value="remove"
                       disabledBinding="disableGroupOp@servletRequest"/>
                </uix:pageButtonBar>
               </uix:cellFormat>
            </uix:rowLayout>
           </uix:tableLayout>
         </uix:rowLayout>
         </uix:header>
         
         <!-- ACL Groups-->
         <uix:header textBinding="GROUPS@osmMsgs">
         <uix:rowLayout>
         <uix:spacer width="8"/>
         <uix:tableLayout>
         <uix:rowLayout>
           <uix:messagePrompt promptBinding="GROUPS_DESC@osmMsgs"/>
         </uix:rowLayout>
         <uix:rowLayout >
          <uix:spacer width="5"/>
         </uix:rowLayout>
         <uix:rowLayout hAlign="right">
           <uix:pageButtonBar>
             <uix:submitButton textBinding="CREATE@dbObjMsgs"
                               name="event" 
                               value="create"
                               disabledBinding="disableGroupOp@servletRequest"/>
           </uix:pageButtonBar>
         </uix:rowLayout>
         <uix:rowLayout >
          <uix:spacer height="5"/>
         </uix:rowLayout>
         <uix:rowLayout>
           <uix:dataScope currentDataBinding="userGroupsDS@userGroups@servletRequest">

             <uix:table id="userGroupsDS" 
                            alternateTextBinding="NO_ITEMS_FOUND@dbObjMsgs" 
                            formSubmitted="true" width="100%" 
                            tableDataBinding="rowData" 
                            minValue="1" 
                            valueBinding="startIndex"
                            maxValueBinding="numRows" 
                            blockSizeBinding="blockSize"
                            summaryBinding="USERS_SUMMARY@osmMsgs">
               <uix:tableFormat tableBanding="rowBanding"/>
               <uix:tableSelection>

                 <uix:multipleSelection shortDescBinding="SELECT@dbObjMsgs"
                                        selectedBinding="select" disabledBinding="disableGroupOp@servletRequest">
                   <uix:pageButtonBar>
                     <uix:submitButton textBinding="DELETE@osmMsgs" 
                                       name="event" 
                                       value="delete" 
                                       disabledBinding="disableGroupOp@servletRequest"/>
                   </uix:pageButtonBar>
                 </uix:multipleSelection>
               </uix:tableSelection>

               <uix:column>
                 <uix:columnHeader>
                   <uix:sortableHeader textBinding="NAME@osmMsgs" 
                                       sortableBinding="sortGroup"/>
                 </uix:columnHeader>
                 <uix:columnFormat columnDataFormat="textFormat"/>
                 <uix:text textBinding="group"/>
               </uix:column>

               <uix:column>
                 <uix:columnHeader>
                   <uix:sortableHeader textBinding="OWNER@osmMsgs" 
                                       sortableBinding="sortOwner"/>
                 </uix:columnHeader>
                 <uix:columnFormat columnDataFormat="textFormat"/>
                 <uix:text textBinding="owner"/>
              </uix:column>
              
              <uix:column>
                 <uix:columnHeader>
                   <uix:sortableHeader textBinding="MEMBERS@osmMsgs" 
                                       sortableBinding="sortMembers"/>
                 </uix:columnHeader>
                 <uix:columnFormat columnDataFormat="textFormat"/>
                 <uix:text textBinding="members"/>
              </uix:column>
               
              <uix:column>
                <uix:columnHeader>
                  <uix:styledText textBinding="EDIT@osmMsgs"/>
                </uix:columnHeader>
                <uix:image sourceBinding="editImage@servletRequest" shortDescBinding="EDIT@osmMsgs" destinationBinding="editLink"/> 
             </uix:column>
            
            </uix:table>
          </uix:dataScope>
          
        </uix:rowLayout>
         
      </uix:tableLayout>
      </uix:rowLayout>
       </uix:header>
      <!-- ACL Group complete -->

      <uix:spacer width="8"/>
          
          
        </uix:subTabLayout>
        
    </uix:pageLayout>
  </uix:form>
</uix:body>
</uix:document>
</uix:renderingContext>
