<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        remoteOperationCred.jsp
  -- Controller:  OsmMetadataConfigController.java
  -- Description: Remote operation host credentials page
  -- 
  -- MODIFIED    (MM/DD/YY)
  --   dchakumk  03/10/08 - XbranchMerge dchakumk_6752_xbmsrc from
  --                        st_emdbsa_11.1
  --   gmahaney  02/01/07 - XbranchMerge gmahaney_emdb_pt_main from main
  --   qsong     02/27/06 - created
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.emo.adm.osm.OsmConst" %>

<% oracle.cabo.share.util.CaboHttpUtils.setNoCacheHeaders(response); %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">

  <uix:bundle name="osmMsgs" 
              class="oracle.sysman.db.rsc.osm.OsmObjectMsg"/>
  <uix:bundle name="dbMsgs" 
              class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>

  <uix:metaContainer>
    <uix:head titleBinding="header@servletRequest"/>
  </uix:metaContainer>

  <uix:body>

    <db:form name="remoteOperationCred" 
             destinationBinding="<%= OsmConst.DESTINATION %>"
             copyParams="target,type">
    <uix:pageLayout titleBinding="title@servletRequest" >


      <%-- Hidden Form Values --%>
      <uix:formValue name="pageName" value="<%= OsmConst.PAGE_RO_CRED %>" />
      <uix:formValue name="<%= OsmConst.PARAM_CANCEL_CHANGE_CONNECTION %>" 
                     valueBinding="<%= OsmConst.PARAM_CANCEL_CHANGE_CONNECTION %>"/>


      <%-- Remote Browser Host Credentials: START --%>

      <%-- ====================================== --%>
      <%-- Page Status: Info Text                 --%>
      <%-- ====================================== --%>
      <uix:pageStatus>
        <uix:styledText styleClass="OraPromptText" 
                        textBinding="HOST_LOGIN_INST@osmMsgs" />
      </uix:pageStatus>


      <%-- ====================================== --%>
      <%-- Error and Info Display                 --%>
      <%-- ====================================== --%>
      <uix:messages>
        <oem:messageBox messageTypeBinding="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="rbTitleText" mainTextKey="rbMainText"/>
      </uix:messages>

      <%-- ====================================== --%>
      <%-- Host Connection UI                     --%>
      <%-- ====================================== --%>

      <uix:spacer height="5"/>
      <%@ include file="/credentials.jspf"%>

      <%-- ====================================== --%>
      <%-- Page Buttons                           --%>
      <%-- ====================================== --%>

      <uix:pageButtons>
        <uix:pageButtonBar>
          <uix:submitButton textBinding="CANCEL@dbMsgs" 
                      name="event"
                      value="cancel"
                      shortDescBinding="CANCEL@dbMsgs" />
          <uix:submitButton textBinding="CONTINUE@dbMsgs" 
                      name="event" 
                      value="<%= OsmConst.TEST_CONNECTION %>"
                      shortDescBinding="CONTINUE@dbMsgs" />
       </uix:pageButtonBar>
      </uix:pageButtons>

      <%-- Remote Browser Host Credentials: END --%>

     </uix:pageLayout>
     </db:form>
   </uix:body>
  </uix:document>
</uix:renderingContext>
