<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <meta http-equiv="Refresh" content=<%=request.getAttribute("refreshChoice") %> >      
    </uix:metaContainer>
    <%@ include file="/oemTitle.jspf" %>    
    <uix:body>
    <uix:form
      name="osmForm" 
      method="GET"
      destinationBinding="defaultURL@servletRequest">

      <uix:formValue 
        name="pageName" 
        value="/database/osm/viewOperations"/>
      <uix:formValue 
        name="oname" 
        valueBinding="oname@servletRequest"/>
      <uix:formValue 
        name="cancelURL" 
        valueBinding="cancelURL@servletRequest"/>

      <uix:pageLayout  titleBinding="operationsHeader@servletRequest">

        <%@ include file="/database/global.jspf" %>

        <oem:messageBox messageType="info" 
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error" 
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
                        
            <uix:tableLayout width="100%" >
              <uix:rowLayout  hAlign="right"> 
                    <uix:cellFormat>
                    <uix:contents>
                     <uix:tableLayout cellSpacing="5" >
                      <uix:rowLayout>
                          <uix:cellFormat>
                                <uix:styledText styleClass="OraInlineInfoText"
                                  textBinding="lastUpdatedTime@osmAdminBean@servletRequest"/>
                          </uix:cellFormat>
                          <uix:cellFormat>
                          <uix:styledText labeledNodeId="refreshChoice" styleClass="OraPromptText"
                            textBinding="REFRESH@OsmObjectBundle@servletRequest"/>
                          </uix:cellFormat>                          
                          <uix:cellFormat>                        
                          <uix:choice id="refreshChoice" name="refreshChoice" 
                                selectedValueBinding="refreshChoice@osmAdminBean@servletRequest"
                                onChange="submitForm('osmForm',true,{'event':'refresh'})"> 
                            <uix:option
                              textBinding="REALTIME_MANUAL@OsmObjectBundle@servletRequest"
                              value="100000000" />
                            <uix:option
                              textBinding="REALTIME_AUTO30@OsmObjectBundle@servletRequest"
                              value="30"/>
                          </uix:choice>
                          </uix:cellFormat>
                          <uix:cellFormat>                                                
                            <uix:submitButton
                            name="event" 
                            textBinding="REFRESH@OsmObjectBundle@servletRequest"
                            value="refresh"/>
                          </uix:cellFormat>                        
                      </uix:rowLayout>
                     </uix:tableLayout>
                  </uix:contents>
                </uix:cellFormat>
            </uix:rowLayout>                                                  
            </uix:tableLayout>



            <uix:tableLayout width="100%">
              
            <uix:rowLayout>                                  
                  <oem:table summaryBinding="operationsHeader@servletRequest"
                    width="100%"
                    blockSize="25"                    
                    formSubmitted="true"
                    name="operationsTableUI"
                    dataSourceProp="operationsTableUI"
                    beanKey="osmAdminBean"
                    alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest"
                    >
               </oem:table>
            </uix:rowLayout>
            </uix:tableLayout>
      </uix:pageLayout>
    </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>

