<!---->
<%--
  - FILE
  -   searchSoftComp.jsp
  -
  - DESCRIPTION
  -   The Screen to select oracle software update component.
  -
  - MODIFIED   (MM/DD/YY)
  -   amroy     09/14/06 - 
  -   shgangul  09/14/06 - 
  -   amroy     08/17/06   - 
  -   tasingh   12/30/05   - bug:4918810 Change popup to embedded page. 
  -   nitijain  09/25/05  -  Modifications for metalink search 
  -   tasingh   07/22/05  - created
    --%>

<%@ page contentType="text/html; charset=UTF-8" %>
<%@ include file="/oemNoscript.jspf" %>

<%--uix Tag Library--%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder  id="renderingContext"/>

  <%--Common UI messages --%>
  <uix:bundle
    name="sdkUIMsg"
    class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

  <%--ResourceBundle for common labels/headers etc--%>
  <uix:bundle
    name="commonResourceBundle"
    class="oracle.sysman.resources.CommonResourceBundle"/>

  <%--ResourceBundle for labels/headers specific to Patch Advisor Project--%>
  <uix:bundle
    name="patchAdvisorRB"
    class="oracle.sysman.db.pa.ui.rb.PatchAdvisorRB"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:form
        name="pageForm"
        method="post">

        <uix:pageLayout titleBinding="pageHeader@servletRequest">

          <%--To display GlobalTabs, Buttons, Footer, Copyright etc--%>
          <%@ include file="/oemGlobal.jspf" %>

          <%--To display the cancel and select buttons--%>
          <uix:pageButtons>
            <uix:pageButtonBar>

              <%--Cancel button--%>
              <uix:submitButton
                textBinding="CANCEL@sdkUIMsg"
                shortDescBinding="CANCEL@sdkUIMsg"
                name="event"
                value="cancel">
              </uix:submitButton>

              <%--Select Button--%>
              <uix:submitButton
                textBinding="SELECT@commonResourceBundle"
                name="event"
                value="select">
              </uix:submitButton>

            </uix:pageButtonBar>
          </uix:pageButtons>

          <%-- The message box to show error/info messge etc--%>

          <uix:messageBox messageTypeBinding="msgType@msgInfo@servletRequest"
               messageBinding="msg@msgInfo@servletRequest"
               rendered="false"
               renderedBinding="rendered@msgInfo@servletRequest">
           <uix:contents>
               <uix:hideShow
               id="hideShow"
               rendered="false"
               renderedBinding="hideShowRendered@msgInfo@servletRequest"
               disclosedBinding="hideShowDisclosed@msgInfo@servletRequest"
               disclosedTextBinding="hideShowDisclosedText@msgInfo@servletRequest"
               formNameBinding="formName@msgInfo@servletRequest"
               formSubmitted="true"
               partialRenderMode="self"
               undisclosedTextBinding="hideShowUndisclosedText@msgInfo@servletRequest">
              <uix:contents>
<%--
         <uix:table
          width="100%"
          partialRenderMode="self"
          formSubmitted="true"
          tableDataBinding="rows@pageSegmentBean@"
          valueBinding="currentValue@pageSegmentBean@"
          minValueBinding="minValue@pageSegmentBean@"
          blockSizeBinding="blockSize@pageSegmentBean@"
          maxValueBinding="maxValue@pageSegmentBean@"
          columnHeaderDataBinding="columnHeaders@pageSegmentBean@">
<%--
          <uix:tableSelection>
            <uix:multipleSelection
              shortDescBinding="SELECT@commonResourceBundle">


            </uix:multipleSelection>
          </uix:tableSelection>
--%>
<%--
          <uix:tableFormat tableBanding="rowBanding"/>
           <uix:styledText textBinding="componentName"/>
        </uix:table>
             
<%-- 
              <uix:formattedText
                 textBinding="hideShowDetailText@msgInfo@servletRequest"
                 styleClass="OraDataText">
             </uix:formattedText>
--%>
                 <uix:ref refID="softCompSegment"/>

             </uix:contents>
             </uix:hideShow>
         </uix:contents>
       </uix:messageBox> 

<%--
          <uix:styledText
            textBinding="SEARCH_SOFT_COMP_INST_TXT@patchAdvisorRB"
            styleClass="oraInstructionText">
          </uix:styledText>
--%>

            <uix:stackLayout>
              <uix:messageRadioButton name="metalinkOrLibrary"
                 textBinding="PA_METALINK@patchAdvisorRB"
                 selectedBinding="metalinkSelected@dbSearchSoftCompBean@servletRequest"
                 value="metalink"/>

              <uix:messageRadioButton name="metalinkOrLibrary"
                 textBinding="PA_LIBRARY@patchAdvisorRB"
                 selectedBinding="librarySelected@dbSearchSoftCompBean@servletRequest"
                 value="library"/>

            </uix:stackLayout>

          <uix:header textBinding="SEARCH@commonResourceBundle"> 
            <uix:labeledFieldLayout
              width="60%"
              labelWidth="0%"
              fieldWidth="100%"
              columns="1">

              <uix:messageTextInput
                name="patchNumber"
                promptBinding="PATCH_NUMBER@patchAdvisorRB"
                textBinding="patchNumberSelVal@servletRequest"
                maximumLength="255">
              </uix:messageTextInput>

              <uix:messageChoice
                name="prodFamily"
                promptBinding="PRODUCT_FAMILY@patchAdvisorRB"
                shortDescBinding="PRODUCT_FAMILY@patchAdvisorRB"
                selectedValueBinding="prodFamilySelVal@servletRequest"
                primaryClientActionBinding="onChangeProdFamily@servletRequest">
                <uix:contents
                  childDataBinding="prodFamilyList@dbSearchSoftCompBean@servletRequest">
                  <uix:option
                    textBinding="optionTxt"
                    valueBinding="optionVal">
                  </uix:option>
                </uix:contents>
              </uix:messageChoice>

              <uix:messageChoice
                name="product"
                id="productID"
                promptBinding="PRODUCT@patchAdvisorRB"
                shortDescBinding="PRODUCT@patchAdvisorRB"
                selectedValueBinding="productSelVal@servletRequest"
                primaryClientActionBinding="onChangeProduct@servletRequest">
                <uix:contents
                  childDataBinding="productList@dbSearchSoftCompBean@servletRequest">
                  <uix:option
                    textBinding="optionTxt"
                    valueBinding="optionVal">
                  </uix:option>
                </uix:contents>
              </uix:messageChoice>

              <uix:messageChoice
                name="release"
                id="releaseID"
                promptBinding="RELEASE@patchAdvisorRB"
                shortDescBinding="RELEASE@patchAdvisorRB"
                selectedValueBinding="releaseSelVal@servletRequest">
                <uix:contents
                  childDataBinding="releaseList@dbSearchSoftCompBean@servletRequest">
                  <uix:option
                    textBinding="optionTxt"
                    valueBinding="optionVal">
                  </uix:option>
                </uix:contents>
              </uix:messageChoice>

              <uix:messageChoice
                name="patchType"
                promptBinding="PATCH_TYPE@patchAdvisorRB"
                shortDescBinding="PATCH_TYPE@patchAdvisorRB"
                selectedValueBinding="patchTypeSelVal@servletRequest">
                <uix:contents
                  childDataBinding="patchTypeList@dbSearchSoftCompBean@servletRequest">
                  <uix:option
                    textBinding="optionTxt"
                    valueBinding="optionVal">
                  </uix:option>
                </uix:contents>
              </uix:messageChoice>

              <uix:messageChoice
                name="platform"
                promptBinding="PLATFORM@patchAdvisorRB"
                shortDescBinding="PLATFORM@patchAdvisorRB"
                selectedValueBinding="platformSelVal@servletRequest">
                <uix:contents
                  childDataBinding="platformList@dbSearchSoftCompBean@servletRequest">
                  <uix:option
                    textBinding="optionTxt"
                    valueBinding="optionVal">
                  </uix:option>
                </uix:contents>
              </uix:messageChoice>

              <uix:messageChoice
                name="language"
                promptBinding="LANGUAGE@patchAdvisorRB"
                shortDescBinding="LANGUAGE@patchAdvisorRB"
                selectedValueBinding="languageSelVal@servletRequest">
                <uix:contents
                  childDataBinding="languageList@dbSearchSoftCompBean@servletRequest">
                  <uix:option
                    textBinding="optionTxt"
                    valueBinding="optionVal">
                  </uix:option>
                </uix:contents>
              </uix:messageChoice>

            </uix:labeledFieldLayout>

            <uix:submitButton
              id="go"
              textBinding="GO@sdkUIMsg"
              name="event"
              value="go">
            </uix:submitButton>

            <uix:separator/>
            <uix:ref refID="softCompSegment"/>

<%--
	     <uix:checkBox
              name="overWriteOrNot"
              textBinding="PA_OVERWRITE@patchAdvisorRB"
              checked="false" />
--%>	
          </uix:header>


        </uix:pageLayout>
      </uix:form>

    </uix:body>
  </uix:document>
</uix:renderingContext>
